/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.admin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.BaseAdminPlugin;
import org.blojsom.util.BlojsomUtils;

public class EditBlogPropertiesPlugin
extends BaseAdminPlugin {
    private static Log _logger = LogFactory.getLog((Class)EditBlogPropertiesPlugin.class);
    private static final String EDIT_BLOG_PROPERTIES_PAGE = "/org/blojsom/plugin/admin/templates/admin-edit-blog-properties";
    private static final String FAILED_EDIT_PROPERTIES_PERMISSION_KEY = "failed.edit.properties.permission.text";
    private static final String UPDATED_BLOG_PROPERTIES_KEY = "updated.blog.properties.text";
    private static final String FAILED_SAVE_BLOG_PROPERTIES_KEY = "failed.save.blog.properties.text";
    private static final String BLOG_PROPERTY_HAS_VALUE_KEY = "blog.property.has.value.text";
    private static final String BLOG_PROPERTY_NOT_FOUND_KEY = "blog.property.not.found.text";
    private static final String EDIT_BLOG_PROPERTIES_ACTION = "edit-blog-properties";
    private static final String CHECK_BLOG_PROPERTY_ACTION = "check-blog-property";
    private static final String SET_BLOG_PROPERTY_ACTION = "set-blog-property";
    private static final String BLOJSOM_PLUGIN_EDIT_BLOG_PROPERTIES_CATEGORY_MAP = "BLOJSOM_PLUGIN_EDIT_BLOG_PROPERTIES_CATEGORY_MAP";
    private static final String BLOJSOM_INSTALLED_LOCALES = "BLOJSOM_INSTALLED_LOCALES";
    private static final String BLOJSOM_JVM_LANGUAGES = "BLOJSOM_JVM_LANGUAGES";
    private static final String BLOJSOM_JVM_COUNTRIES = "BLOJSOM_JVM_COUNTRIES";
    private static final String BLOJSOM_JVM_TIMEZONES = "BLOJSOM_JVM_TIMEZONES";
    private static final String EDIT_BLOG_PROPERTIES_PERMISSION = "edit_blog_properties";
    private static final String INDIVIDUAL_BLOG_PROPERTY = "individual-blog-property";
    private static final String INDIVIDUAL_BLOG_PROPERTY_VALUE = "individual-blog-property-value";

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        String blogProperty;
        Iterator flavorKeys;
        Map flavorMap;
        if (!this.authenticateUser(httpServletRequest, httpServletResponse, context, user)) {
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin-login");
            return entries;
        }
        String username = this.getUsernameFromSession(httpServletRequest, user.getBlog());
        if (!this.checkPermission(user, null, username, EDIT_BLOG_PROPERTIES_PERMISSION)) {
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
            this.addOperationResultMessage(context, this.getAdminResource(FAILED_EDIT_PROPERTIES_PERMISSION_KEY, FAILED_EDIT_PROPERTIES_PERMISSION_KEY, user.getBlog().getBlogAdministrationLocale()));
            return entries;
        }
        Blog blog = user.getBlog();
        String action = BlojsomUtils.getRequestValue((String)"action", (HttpServletRequest)httpServletRequest);
        if (BlojsomUtils.checkNullOrBlank((String)action)) {
            _logger.debug((Object)"User did not request edit action");
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
        } else if ("page".equals(action)) {
            _logger.debug((Object)"User requested edit page");
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_PROPERTIES_PAGE);
        } else if (EDIT_BLOG_PROPERTIES_ACTION.equals(action)) {
            _logger.debug((Object)"User requested edit action");
            String blogPropertyValue = BlojsomUtils.getRequestValue((String)"blog-name", (HttpServletRequest)httpServletRequest);
            blog.setBlogName(blogPropertyValue);
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"blog-description", (HttpServletRequest)httpServletRequest);
            blog.setBlogDescription(blogPropertyValue);
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"blog-country", (HttpServletRequest)httpServletRequest);
            blog.setBlogCountry(blogPropertyValue);
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"blog-language", (HttpServletRequest)httpServletRequest);
            blog.setBlogLanguage(blogPropertyValue);
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"blog-administration-locale", (HttpServletRequest)httpServletRequest);
            blog.setBlogAdministrationLocale(blogPropertyValue);
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"blog-timezone-id", (HttpServletRequest)httpServletRequest);
            blog.setBlogProperty("blog-timezone-id", blogPropertyValue);
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"blog-directory-depth", (HttpServletRequest)httpServletRequest);
            try {
                int blogDepth = Integer.parseInt(blogPropertyValue);
                blog.setBlogDepth(blogDepth);
            }
            catch (NumberFormatException e) {
                _logger.error((Object)"Blog depth parameter invalid.", (Throwable)e);
            }
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"blog-display-entries", (HttpServletRequest)httpServletRequest);
            try {
                int blogDisplayEntries = Integer.parseInt(blogPropertyValue);
                blog.setBlogDisplayEntries(blogDisplayEntries);
            }
            catch (NumberFormatException e) {
                _logger.error((Object)"Blog display entries parameter invalid.", (Throwable)e);
            }
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"blog-owner", (HttpServletRequest)httpServletRequest);
            blog.setBlogOwner(blogPropertyValue);
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"blog-owner-email", (HttpServletRequest)httpServletRequest);
            blog.setBlogOwnerEmail(blogPropertyValue);
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"blog-comments-enabled", (HttpServletRequest)httpServletRequest);
            blog.setBlogCommentsEnabled(Boolean.valueOf(blogPropertyValue));
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"blog-trackbacks-enabled", (HttpServletRequest)httpServletRequest);
            blog.setBlogTrackbacksEnabled(Boolean.valueOf(blogPropertyValue));
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"blog-email-enabled", (HttpServletRequest)httpServletRequest);
            blog.setBlogEmailEnabled(Boolean.valueOf(blogPropertyValue));
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"blog-file-encoding", (HttpServletRequest)httpServletRequest);
            blog.setBlogFileEncoding(blogPropertyValue);
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"blog-file-extensions", (HttpServletRequest)httpServletRequest);
            blog.setBlogFileExtensions(blogPropertyValue);
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"blog-default-flavor", (HttpServletRequest)httpServletRequest);
            blog.setBlogDefaultFlavor(blogPropertyValue);
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"linear-navigation-enabled", (HttpServletRequest)httpServletRequest);
            blog.setLinearNavigationEnabled(Boolean.valueOf(blogPropertyValue));
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"blog-url", (HttpServletRequest)httpServletRequest);
            blog.setBlogURL(blogPropertyValue);
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"blog-base-url", (HttpServletRequest)httpServletRequest);
            blog.setBlogBaseURL(blogPropertyValue);
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"blojsom-plugin-internal-aggegator-opt-out", (HttpServletRequest)httpServletRequest);
            blog.setBlogProperty("blojsom-plugin-internal-aggegator-opt-out", blogPropertyValue);
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"plugin-comment-autoformat", (HttpServletRequest)httpServletRequest);
            blog.setBlogProperty("plugin-comment-autoformat", blogPropertyValue);
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"plugin-comment-email-prefix", (HttpServletRequest)httpServletRequest);
            blog.setBlogProperty("plugin-comment-email-prefix", blogPropertyValue);
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"plugin-comment-expiration-duration", (HttpServletRequest)httpServletRequest);
            blog.setBlogProperty("plugin-comment-expiration-duration", blogPropertyValue);
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"plugin-comment-throttle", (HttpServletRequest)httpServletRequest);
            blog.setBlogProperty("plugin-comment-throttle", blogPropertyValue);
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"plugin-comment-days-expiration", (HttpServletRequest)httpServletRequest);
            blog.setBlogProperty("plugin-comment-days-expiration", blogPropertyValue);
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"comment-moderation-enabled", (HttpServletRequest)httpServletRequest);
            blog.setBlogProperty("comment-moderation-enabled", blogPropertyValue);
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"plugin-trackback-throttle", (HttpServletRequest)httpServletRequest);
            blog.setBlogProperty("plugin-trackback-throttle", blogPropertyValue);
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"plugin-trackback-email-prefix", (HttpServletRequest)httpServletRequest);
            blog.setBlogProperty("plugin-trackback-email-prefix", blogPropertyValue);
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"plugin-trackback-days-expiration", (HttpServletRequest)httpServletRequest);
            blog.setBlogProperty("plugin-trackback-days-expiration", blogPropertyValue);
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"trackback-moderation-enabled", (HttpServletRequest)httpServletRequest);
            blog.setBlogProperty("trackback-moderation-enabled", blogPropertyValue);
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"blog-pingbacks-enabled", (HttpServletRequest)httpServletRequest);
            blog.setBlogPingbacksEnabled(Boolean.valueOf(blogPropertyValue));
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"blog-ping-urls", (HttpServletRequest)httpServletRequest);
            String[] pingURLs = BlojsomUtils.parseDelimitedList((String)blogPropertyValue, (String)" \t\n\f\r");
            if (pingURLs != null && pingURLs.length > 0) {
                blog.setBlogProperty("blog-ping-urls", BlojsomUtils.arrayOfStringsToString((String[])pingURLs, (String)" "));
            } else {
                blog.setBlogProperty("blog-ping-urls", "");
            }
            blogPropertyValue = BlojsomUtils.getRequestValue((String)"xmlrpc-enabled", (HttpServletRequest)httpServletRequest);
            blog.setXmlrpcEnabled(Boolean.valueOf(blogPropertyValue));
            flavorMap = user.getFlavors();
            flavorKeys = flavorMap.keySet().iterator();
            while (flavorKeys.hasNext()) {
                String key = (String)flavorKeys.next();
                String flavorCategoryMapping = BlojsomUtils.getRequestValue((String)(key + "." + "blog-default-category-mapping"), (HttpServletRequest)httpServletRequest);
                if (flavorCategoryMapping == null) continue;
                flavorCategoryMapping = BlojsomUtils.normalize((String)flavorCategoryMapping);
                blog.setBlogDefaultCategoryMappingForFlavor(key + "." + "blog-default-category-mapping", flavorCategoryMapping);
            }
            String categoryMapping = BlojsomUtils.getRequestValue((String)"blog-default-category-mapping", (HttpServletRequest)httpServletRequest);
            categoryMapping = BlojsomUtils.normalize((String)categoryMapping);
            blog.setBlogDefaultCategoryMappings(BlojsomUtils.parseCommaList((String)categoryMapping));
            user.setBlog(blog);
            Properties blogProperties = BlojsomUtils.mapToProperties((Map)blog.getBlogProperties(), (String)"UTF-8");
            File propertiesFile = new File(this._blojsomConfiguration.getInstallationDirectory() + BlojsomUtils.removeInitialSlash((String)this._blojsomConfiguration.getBaseConfigurationDirectory()) + "/" + user.getId() + "/" + "blog.properties");
            _logger.debug((Object)("Writing blog properties to: " + propertiesFile.toString()));
            try {
                FileOutputStream fos = new FileOutputStream(propertiesFile);
                blogProperties.store(fos, null);
                fos.close();
                this.addOperationResultMessage(context, this.getAdminResource(UPDATED_BLOG_PROPERTIES_KEY, UPDATED_BLOG_PROPERTIES_KEY, user.getBlog().getBlogAdministrationLocale()));
            }
            catch (IOException e) {
                _logger.error((Object)e);
                this.addOperationResultMessage(context, this.getAdminResource(FAILED_SAVE_BLOG_PROPERTIES_KEY, FAILED_SAVE_BLOG_PROPERTIES_KEY, user.getBlog().getBlogAdministrationLocale()));
            }
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_PROPERTIES_PAGE);
        } else if (SET_BLOG_PROPERTY_ACTION.equals(action)) {
            _logger.debug((Object)"User requested set blog property action");
            blogProperty = BlojsomUtils.getRequestValue((String)INDIVIDUAL_BLOG_PROPERTY, (HttpServletRequest)httpServletRequest);
            if (!BlojsomUtils.checkNullOrBlank((String)blogProperty)) {
                String blogPropertyValue = BlojsomUtils.getRequestValue((String)INDIVIDUAL_BLOG_PROPERTY_VALUE, (HttpServletRequest)httpServletRequest);
                if (blogPropertyValue == null) {
                    blogPropertyValue = "";
                }
                blog.setBlogProperty(blogProperty, blogPropertyValue);
                user.setBlog(blog);
                Properties blogProperties = BlojsomUtils.mapToProperties((Map)blog.getBlogProperties(), (String)"UTF-8");
                File propertiesFile = new File(this._blojsomConfiguration.getInstallationDirectory() + BlojsomUtils.removeInitialSlash((String)this._blojsomConfiguration.getBaseConfigurationDirectory()) + "/" + user.getId() + "/" + "blog.properties");
                _logger.debug((Object)("Writing blog properties to: " + propertiesFile.toString()));
                try {
                    FileOutputStream fos = new FileOutputStream(propertiesFile);
                    blogProperties.store(fos, null);
                    fos.close();
                    this.addOperationResultMessage(context, this.getAdminResource(UPDATED_BLOG_PROPERTIES_KEY, UPDATED_BLOG_PROPERTIES_KEY, user.getBlog().getBlogAdministrationLocale()));
                }
                catch (IOException e) {
                    _logger.error((Object)e);
                    this.addOperationResultMessage(context, this.getAdminResource(FAILED_SAVE_BLOG_PROPERTIES_KEY, FAILED_SAVE_BLOG_PROPERTIES_KEY, user.getBlog().getBlogAdministrationLocale()));
                }
            }
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_PROPERTIES_PAGE);
        } else if (CHECK_BLOG_PROPERTY_ACTION.equals(action)) {
            _logger.debug((Object)"User requested check blog property action");
            blogProperty = BlojsomUtils.getRequestValue((String)INDIVIDUAL_BLOG_PROPERTY, (HttpServletRequest)httpServletRequest);
            if (!BlojsomUtils.checkNullOrBlank((String)blogProperty)) {
                if (blog.getBlogProperty(blogProperty) != null) {
                    this.addOperationResultMessage(context, this.formatAdminResource(BLOG_PROPERTY_HAS_VALUE_KEY, BLOG_PROPERTY_HAS_VALUE_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogProperty, blog.getBlogProperty(blogProperty)}));
                } else {
                    this.addOperationResultMessage(context, this.formatAdminResource(BLOG_PROPERTY_NOT_FOUND_KEY, BLOG_PROPERTY_NOT_FOUND_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogProperty}));
                }
            }
            httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_PROPERTIES_PAGE);
        }
        flavorMap = user.getFlavors();
        flavorKeys = flavorMap.keySet().iterator();
        TreeMap<String, String> categoryMapping = new TreeMap<String, String>();
        while (flavorKeys.hasNext()) {
            String key = (String)flavorKeys.next();
            if (blog.getBlogProperty(key + "." + "blog-default-category-mapping") != null) {
                categoryMapping.put(key, blog.getBlogProperty(key + "." + "blog-default-category-mapping"));
                continue;
            }
            categoryMapping.put(key, "");
        }
        context.put(BLOJSOM_PLUGIN_EDIT_BLOG_PROPERTIES_CATEGORY_MAP, categoryMapping);
        context.put(BLOJSOM_INSTALLED_LOCALES, this._blojsomConfiguration.getInstalledLocalesAsStrings());
        context.put(BLOJSOM_JVM_LANGUAGES, BlojsomUtils.getLanguagesForSystem((Locale)blog.getBlogAdministrationLocale()));
        context.put(BLOJSOM_JVM_COUNTRIES, BlojsomUtils.getCountriesForSystem((Locale)blog.getBlogAdministrationLocale()));
        context.put(BLOJSOM_JVM_TIMEZONES, BlojsomUtils.getTimeZonesForSystem((Locale)blog.getBlogAdministrationLocale()));
        return entries;
    }
}

