/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.admin;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.event.BlojsomEvent;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.BaseAdminPlugin;
import org.blojsom.plugin.admin.event.AddAuthorizationEvent;
import org.blojsom.plugin.admin.event.DeleteAuthorizationEvent;
import org.blojsom.util.BlojsomUtils;

public class EditBlogAuthorizationPlugin
extends BaseAdminPlugin {
    private Log _logger = LogFactory.getLog((Class)EditBlogAuthorizationPlugin.class);
    private static final String FAILED_AUTHORIZATION_PERMISSION_KEY = "failed.authorization.permission.text";
    private static final String FAILED_OTHER_AUTHORIZATION_PERMISSION_KEY = "failed.other.authorization.permission.text";
    private static final String SUCCESSFUL_AUTHORIZATION_UPDATE_KEY = "successful.authorization.update.key";
    private static final String SUCCESSFUL_AUTHORIZATION_DELETE_KEY = "successful.authorization.delete.key";
    private static final String UNSUCCESSFUL_AUTHORIZATION_UPDATE_KEY = "unsuccessful.authorization.update.key";
    private static final String UNSUCCESSFUL_AUTHORIZATION_DELETE_KEY = "unsuccessful.authorization.delete.key";
    private static final String PASSWORD_CHECK_FAILED_KEY = "password.check.failed.text";
    private static final String MISSING_PARAMETERS_KEY = "missing.parameters.text";
    private static final String MISSING_BLOG_ID_KEY = "no.blog.id.delete.text";
    private static final String EDIT_BLOG_AUTHORIZATION_PAGE = "/org/blojsom/plugin/admin/templates/admin-edit-blog-authorization";
    private static final String BLOJSOM_PLUGIN_EDIT_BLOG_AUTHORIZATION_MAP = "BLOJSOM_PLUGIN_EDIT_BLOG_AUTHORIZATION_MAP";
    private static final String ADD_BLOG_AUTHORIZATION_ACTION = "add-blog-authorization";
    private static final String MODIFY_BLOG_AUTHORIZATION_ACTION = "modify-blog-authorization";
    private static final String DELETE_BLOG_AUTHORIZATION_ACTION = "delete-blog-authorization";
    private static final String BLOG_USER_ID = "blog-user-id";
    private static final String BLOG_USER_PASSWORD = "blog-user-password";
    private static final String BLOG_USER_PASSWORD_CHECK = "blog-user-password-check";
    private static final String BLOG_USER_EMAIL = "blog-user-email";
    private static final String EDIT_BLOG_AUTHORIZATION_PERMISSION = "edit_blog_authorization";
    private static final String EDIT_OTHER_USERS_AUTHORIZATION_PERMISSION = "edit_other_users_authorization";
    private String _authorizationConfiguration;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        super.init(servletConfig, blojsomConfiguration);
        this._authorizationConfiguration = servletConfig.getInitParameter("blog-authorization");
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        if (!this.authenticateUser(httpServletRequest, httpServletResponse, context, user)) {
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin-login");
            return entries;
        }
        String username = this.getUsernameFromSession(httpServletRequest, user.getBlog());
        if (!this.checkPermission(user, null, username, EDIT_BLOG_AUTHORIZATION_PERMISSION)) {
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
            this.addOperationResultMessage(context, this.getAdminResource(FAILED_AUTHORIZATION_PERMISSION_KEY, FAILED_AUTHORIZATION_PERMISSION_KEY, user.getBlog().getBlogAdministrationLocale()));
            return entries;
        }
        String action = BlojsomUtils.getRequestValue((String)"action", (HttpServletRequest)httpServletRequest);
        if (BlojsomUtils.checkNullOrBlank((String)action)) {
            this._logger.debug((Object)"User did not request edit authorization action");
            httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin");
        } else if ("page".equals(action)) {
            this._logger.debug((Object)"User requested edit blog authorization page");
        } else if (ADD_BLOG_AUTHORIZATION_ACTION.equals(action) || MODIFY_BLOG_AUTHORIZATION_ACTION.equals(action)) {
            if (ADD_BLOG_AUTHORIZATION_ACTION.equals(action)) {
                this._logger.debug((Object)"User requested add authorization action");
            } else {
                this._logger.debug((Object)"User requested modify authorization action");
            }
            String blogUserID = BlojsomUtils.getRequestValue((String)BLOG_USER_ID, (HttpServletRequest)httpServletRequest);
            String blogUserPassword = BlojsomUtils.getRequestValue((String)BLOG_USER_PASSWORD, (HttpServletRequest)httpServletRequest);
            String blogUserPasswordCheck = BlojsomUtils.getRequestValue((String)BLOG_USER_PASSWORD_CHECK, (HttpServletRequest)httpServletRequest);
            String blogUserEmail = BlojsomUtils.getRequestValue((String)BLOG_USER_EMAIL, (HttpServletRequest)httpServletRequest);
            if (!(BlojsomUtils.checkNullOrBlank((String)blogUserID) || BlojsomUtils.checkNullOrBlank((String)blogUserPassword) || BlojsomUtils.checkNullOrBlank((String)blogUserPasswordCheck))) {
                if (blogUserPassword.equals(blogUserPasswordCheck)) {
                    if (BlojsomUtils.checkNullOrBlank((String)blogUserEmail)) {
                        blogUserEmail = "";
                    }
                    if (!username.equals(blogUserID) && !this.checkPermission(user, null, username, EDIT_OTHER_USERS_AUTHORIZATION_PERMISSION)) {
                        httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_AUTHORIZATION_PAGE);
                        this.addOperationResultMessage(context, this.getAdminResource(FAILED_OTHER_AUTHORIZATION_PERMISSION_KEY, FAILED_OTHER_AUTHORIZATION_PERMISSION_KEY, user.getBlog().getBlogAdministrationLocale()));
                        return entries;
                    }
                    if (user.getBlog().getUseEncryptedPasswords().booleanValue()) {
                        blogUserPassword = BlojsomUtils.digestString((String)blogUserPassword, (String)user.getBlog().getDigestAlgorithm());
                    }
                    Blog blog = user.getBlog();
                    blog.setAuthorizedUserPassword(blogUserID, blogUserPassword);
                    blog.setAuthorizedUserEmail(blogUserID, blogUserEmail);
                    user.setBlog(blog);
                    Map authorizationMap = user.getBlog().getAuthorization();
                    if (ADD_BLOG_AUTHORIZATION_ACTION.equals(action)) {
                        this._logger.debug((Object)("Added user: " + blogUserID + " to authorization map"));
                    } else {
                        this._logger.debug((Object)("Modified user: " + blogUserID + " to authorization map"));
                    }
                    try {
                        this.writeAuthorizationConfiguration(authorizationMap, user.getId());
                        this.addOperationResultMessage(context, this.formatAdminResource(SUCCESSFUL_AUTHORIZATION_UPDATE_KEY, SUCCESSFUL_AUTHORIZATION_UPDATE_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogUserID}));
                        this._logger.debug((Object)("Wrote new authorization configuration for user: " + user.getId()));
                        this._blojsomConfiguration.getEventBroadcaster().processEvent((BlojsomEvent)new AddAuthorizationEvent(this, new Date(), httpServletRequest, httpServletResponse, user, context, blogUserID));
                    }
                    catch (IOException e) {
                        this.addOperationResultMessage(context, this.formatAdminResource(UNSUCCESSFUL_AUTHORIZATION_UPDATE_KEY, UNSUCCESSFUL_AUTHORIZATION_UPDATE_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogUserID}));
                        this._logger.error((Object)e);
                    }
                } else {
                    this.addOperationResultMessage(context, this.getAdminResource(PASSWORD_CHECK_FAILED_KEY, PASSWORD_CHECK_FAILED_KEY, user.getBlog().getBlogAdministrationLocale()));
                    this._logger.debug((Object)"Password and password check not equal for add/modify authorization action");
                }
            } else {
                this.addOperationResultMessage(context, this.getAdminResource(MISSING_PARAMETERS_KEY, MISSING_PARAMETERS_KEY, user.getBlog().getBlogAdministrationLocale()));
                this._logger.debug((Object)"Missing parameters from the request to complete add/modify authorization action");
            }
        } else if (DELETE_BLOG_AUTHORIZATION_ACTION.equals(action)) {
            this._logger.debug((Object)"User requested delete authorization action");
            String blogUserID = BlojsomUtils.getRequestValue((String)BLOG_USER_ID, (HttpServletRequest)httpServletRequest);
            if (!BlojsomUtils.checkNullOrBlank((String)blogUserID)) {
                if (!username.equals(blogUserID) && !this.checkPermission(user, null, username, EDIT_OTHER_USERS_AUTHORIZATION_PERMISSION)) {
                    httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_AUTHORIZATION_PAGE);
                    this.addOperationResultMessage(context, this.getAdminResource(FAILED_OTHER_AUTHORIZATION_PERMISSION_KEY, FAILED_OTHER_AUTHORIZATION_PERMISSION_KEY, user.getBlog().getBlogAdministrationLocale()));
                    return entries;
                }
                Map authorizationMap = user.getBlog().getAuthorization();
                authorizationMap.remove(blogUserID);
                user.getBlog().setAuthorization(authorizationMap);
                this._logger.debug((Object)("Removed user: " + blogUserID + " from authorization map"));
                try {
                    this.writeAuthorizationConfiguration(authorizationMap, user.getId());
                    this.addOperationResultMessage(context, this.formatAdminResource(SUCCESSFUL_AUTHORIZATION_DELETE_KEY, SUCCESSFUL_AUTHORIZATION_DELETE_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogUserID}));
                    this._logger.debug((Object)("Wrote new authorization configuration for user: " + user.getId()));
                    this._blojsomConfiguration.getEventBroadcaster().processEvent((BlojsomEvent)new DeleteAuthorizationEvent(this, new Date(), httpServletRequest, httpServletResponse, user, context, blogUserID));
                }
                catch (IOException e) {
                    this.addOperationResultMessage(context, this.formatAdminResource(UNSUCCESSFUL_AUTHORIZATION_DELETE_KEY, UNSUCCESSFUL_AUTHORIZATION_DELETE_KEY, user.getBlog().getBlogAdministrationLocale(), new Object[]{blogUserID}));
                    this._logger.error((Object)e);
                }
            } else {
                this.addOperationResultMessage(context, this.getAdminResource(MISSING_BLOG_ID_KEY, MISSING_BLOG_ID_KEY, user.getBlog().getBlogAdministrationLocale()));
                this._logger.debug((Object)"No blog user id to delete from authorization");
            }
        }
        context.put(BLOJSOM_PLUGIN_EDIT_BLOG_AUTHORIZATION_MAP, Collections.unmodifiableMap(new TreeMap(user.getBlog().getAuthorization())));
        httpServletRequest.setAttribute("page", (Object)EDIT_BLOG_AUTHORIZATION_PAGE);
        return entries;
    }

    private void writeAuthorizationConfiguration(Map authorizationMap, String user) throws IOException {
        File authorizationFile = new File(this._blojsomConfiguration.getInstallationDirectory() + this._blojsomConfiguration.getBaseConfigurationDirectory() + user + "/" + this._authorizationConfiguration);
        this._logger.debug((Object)("Writing authorization file: " + authorizationFile.toString()));
        Properties authorizationProperties = BlojsomUtils.mapToProperties((Map)authorizationMap);
        FileOutputStream fos = new FileOutputStream(authorizationFile);
        authorizationProperties.store(fos, null);
        fos.close();
    }
}

