/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.admin;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogCategory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.event.BlojsomEvent;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.EditBlogEntriesPlugin;
import org.blojsom.plugin.admin.event.AddBlogEntryEvent;
import org.blojsom.util.BlojsomUtils;

public class BookmarkletPlugin
extends EditBlogEntriesPlugin {
    private Log _logger = LogFactory.getLog((Class)BookmarkletPlugin.class);
    private static final String UNABLE_TO_AUTHENTICATE_KEY = "unable.to.authenticate.text";
    private static final String FAILED_PERMISSION_KEY = "failed.bookmarklet.permission.text";
    private static final String ADDED_BLOG_ENTRY_KEY = "added.blog.entry.bookmarklet.text";
    private static final String FAILED_BLOG_ENTRY_KEY = "failed.blog.entry.text";
    protected static final String BOOKMARKLET_PAGE = "/org/blojsom/plugin/admin/templates/admin-bookmarklet-entry";
    protected static final String BOOKMARKLET_PLUGIN_SELECTION = "BOOKMARKLET_PLUGIN_SELECTION";
    protected static final String BOOKMARKLET_BLOG_ENTRY_ACTION = "bookmarklet-blog-entry";
    protected static final String SELECTION_PARAM = "selection";
    protected static final String USE_BOOKMARKLET_PERMISSION = "use_bookmarklet";

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        String action = BlojsomUtils.getRequestValue((String)"action", (HttpServletRequest)httpServletRequest);
        String selection = BlojsomUtils.getRequestValue((String)SELECTION_PARAM, (HttpServletRequest)httpServletRequest);
        context.put(BOOKMARKLET_PLUGIN_SELECTION, selection);
        if (BlojsomUtils.checkNullOrBlank((String)action)) {
            this._logger.debug((Object)"User did not request action");
            httpServletRequest.setAttribute("page", (Object)BOOKMARKLET_PAGE);
        } else if ("page".equals(action)) {
            this._logger.debug((Object)"User requested bookmarklet blog entry page");
            httpServletRequest.setAttribute("page", (Object)BOOKMARKLET_PAGE);
        } else if (BOOKMARKLET_BLOG_ENTRY_ACTION.equals(action)) {
            if (!this.authenticateUser(httpServletRequest, httpServletResponse, context, user)) {
                httpServletRequest.setAttribute("page", (Object)BOOKMARKLET_PAGE);
                this.addOperationResultMessage(context, this.getAdminResource(UNABLE_TO_AUTHENTICATE_KEY, UNABLE_TO_AUTHENTICATE_KEY, user.getBlog().getBlogAdministrationLocale()));
            } else {
                this._logger.debug((Object)"User requested bookmarklet add blog entry action");
                String username = this.getUsernameFromSession(httpServletRequest, user.getBlog());
                if (!this.checkPermission(user, null, username, USE_BOOKMARKLET_PERMISSION)) {
                    httpServletRequest.setAttribute("page", (Object)"/org/blojsom/plugin/admin/templates/admin-login");
                    this.addOperationResultMessage(context, this.getAdminResource(FAILED_PERMISSION_KEY, FAILED_PERMISSION_KEY, user.getBlog().getBlogAdministrationLocale()));
                    return entries;
                }
                Blog blog = user.getBlog();
                String blogCategoryName = BlojsomUtils.getRequestValue((String)"blog-category-name", (HttpServletRequest)httpServletRequest);
                if (!(blogCategoryName = BlojsomUtils.normalize((String)blogCategoryName)).endsWith("/")) {
                    blogCategoryName = blogCategoryName + "/";
                }
                String blogEntryDescription = BlojsomUtils.getRequestValue((String)"blog-entry-description", (HttpServletRequest)httpServletRequest);
                String blogEntryTitle = BlojsomUtils.getRequestValue((String)"blog-entry-title", (HttpServletRequest)httpServletRequest);
                if (BlojsomUtils.checkNullOrBlank((String)blogEntryTitle)) {
                    blogEntryDescription = BlojsomUtils.LINE_SEPARATOR + blogEntryDescription;
                }
                String allowComments = BlojsomUtils.getRequestValue((String)"blog-entry-comments-disabled", (HttpServletRequest)httpServletRequest);
                String allowTrackbacks = BlojsomUtils.getRequestValue((String)"blog-entry-trackbacks-disabled", (HttpServletRequest)httpServletRequest);
                String blogTrackbackURLs = BlojsomUtils.getRequestValue((String)"blog-trackback-urls", (HttpServletRequest)httpServletRequest);
                String proposedBlogFilename = BlojsomUtils.getRequestValue((String)"blog-entry-proposed-name", (HttpServletRequest)httpServletRequest);
                String pingBlogURLS = BlojsomUtils.getRequestValue((String)"ping-blog-urls", (HttpServletRequest)httpServletRequest);
                BlogCategory category = this._fetcher.newBlogCategory();
                category.setCategory(blogCategoryName);
                category.setCategoryURL(user.getBlog().getBlogURL() + BlojsomUtils.removeInitialSlash((String)blogCategoryName));
                BlogEntry entry = this._fetcher.newBlogEntry();
                entry.setTitle(blogEntryTitle);
                entry.setCategory(blogCategoryName);
                entry.setDescription(blogEntryDescription);
                entry.setBlogCategory(category);
                HashMap<String, String> entryMetaData = new HashMap<String, String>();
                username = (String)httpServletRequest.getSession().getAttribute(user.getBlog().getBlogURL() + "_" + "org.blojsom.plugin.admin.Username");
                entryMetaData.put("blog-entry-author", username);
                String entryPublishDateTime = httpServletRequest.getParameter("blog-entry-publish-datetime");
                if (!BlojsomUtils.checkNullOrBlank((String)entryPublishDateTime)) {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
                    try {
                        Date publishDateTime = simpleDateFormat.parse(entryPublishDateTime);
                        this._logger.debug((Object)("Publishing blog entry at: " + publishDateTime.toString()));
                        entryMetaData.put("blog-entry-metadata-timestamp", new Long(publishDateTime.getTime()).toString());
                    }
                    catch (ParseException e) {
                        this._logger.error((Object)e);
                        entryMetaData.put("blog-entry-metadata-timestamp", new Long(new Date().getTime()).toString());
                    }
                } else {
                    entryMetaData.put("blog-entry-metadata-timestamp", new Long(new Date().getTime()).toString());
                }
                if (!BlojsomUtils.checkNullOrBlank((String)allowComments)) {
                    entryMetaData.put("blog-entry-comments-disabled", "y");
                }
                if (!BlojsomUtils.checkNullOrBlank((String)allowTrackbacks)) {
                    entryMetaData.put("blog-entry-trackbacks-disabled", "y");
                }
                if (BlojsomUtils.checkNullOrBlank((String)pingBlogURLS)) {
                    entryMetaData.put("no-ping-weblogs", "true");
                }
                entry.setMetaData(entryMetaData);
                try {
                    entry.save(user);
                    entry.load(user);
                    StringBuffer entryLink = new StringBuffer();
                    entry.setLink(user.getBlog().getBlogURL() + BlojsomUtils.removeInitialSlash((String)entry.getCategory()) + "?" + "permalink" + "=" + entry.getPermalink());
                    entryLink.append("<a href=\"").append(entry.getLink()).append("\">").append(entry.getTitle()).append("</a>");
                    this.addOperationResultMessage(context, this.formatAdminResource(ADDED_BLOG_ENTRY_KEY, ADDED_BLOG_ENTRY_KEY, blog.getBlogAdministrationLocale(), new Object[]{entryLink.toString()}));
                    AddBlogEntryEvent addEvent = new AddBlogEntryEvent(this, new Date(), entry, user);
                    this._blojsomConfiguration.getEventBroadcaster().broadcastEvent((BlojsomEvent)addEvent);
                }
                catch (BlojsomException e) {
                    this._logger.error((Object)e);
                    this.addOperationResultMessage(context, this.formatAdminResource(FAILED_BLOG_ENTRY_KEY, FAILED_BLOG_ENTRY_KEY, blog.getBlogAdministrationLocale(), new Object[]{blogCategoryName}));
                }
                if (!BlojsomUtils.checkNullOrBlank((String)blogTrackbackURLs)) {
                    this.sendTrackbackPings(blog, entry, blogTrackbackURLs);
                }
                httpServletRequest.setAttribute("page", (Object)BOOKMARKLET_PAGE);
                context.put("BLOJSOM_PLUGIN_EDIT_BLOG_ENTRIES_ENTRY", entry);
                context.put("BLOJSOM_PLUGIN_EDIT_BLOG_ENTRIES_CATEGORY", blogCategoryName);
            }
        }
        return entries;
    }
}

