/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.plugin.admin;

import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.authorization.AuthorizationProvider;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.blog.BlojsomConfigurationException;
import org.blojsom.plugin.BlojsomPlugin;
import org.blojsom.plugin.BlojsomPluginException;
import org.blojsom.plugin.admin.PermissionedPlugin;
import org.blojsom.plugin.permission.PermissionChecker;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.util.BlojsomMetaDataConstants;
import org.blojsom.util.BlojsomUtils;
import org.blojsom.util.resources.ResourceManager;

public class BaseAdminPlugin
implements BlojsomPlugin,
BlojsomConstants,
BlojsomMetaDataConstants,
PermissionedPlugin {
    protected static final Log _logger = LogFactory.getLog((Class)BaseAdminPlugin.class);
    protected static final String BLOJSOM_ADMIN_PLUGIN_AUTHENTICATED_KEY = "org.blojsom.plugin.admin.Authenticated";
    protected static final String BLOJSOM_ADMIN_PLUGIN_USERNAME_KEY = "org.blojsom.plugin.admin.Username";
    protected static final String BLOJSOM_ADMIN_PLUGIN_USERNAME = "BLOJSOM_ADMIN_PLUGIN_USERNAME";
    protected static final String BLOJSOM_ADMIN_PLUGIN_USERNAME_PARAM = "username";
    protected static final String BLOJSOM_ADMIN_PLUGIN_PASSWORD_PARAM = "password";
    protected static final String ACTION_PARAM = "action";
    protected static final String BLOJSOM_ADMIN_PLUGIN_OPERATION_RESULT = "BLOJSOM_ADMIN_PLUGIN_OPERATION_RESULT";
    protected static final String BLOJSOM_USER_AUTHENTICATED = "BLOJSOM_USER_AUTHENTICATED";
    protected static final String BLOJSOM_ADMIN_MESSAGES_RESOURCE = "org.blojsom.plugin.admin.resources.messages";
    protected static final String BLOJSOM_PERMISSION_CHECKER = "BLOJSOM_PERMISSION_CHECKER";
    protected static final String LOGIN_ERROR_TEXT_KEY = "login.error.text";
    protected static final String ADMIN_ADMINISTRATION_PAGE = "/org/blojsom/plugin/admin/templates/admin";
    protected static final String ADMIN_LOGIN_PAGE = "/org/blojsom/plugin/admin/templates/admin-login";
    protected static final String LOGIN_ACTION = "login";
    protected static final String LOGOUT_ACTION = "logout";
    protected static final String PAGE_ACTION = "page";
    protected ServletConfig _servletConfig;
    protected BlojsomConfiguration _blojsomConfiguration;
    protected AuthorizationProvider _authorizationProvider;
    protected ResourceManager _resourceManager;
    protected Map _ignoreParams;

    public void init(ServletConfig servletConfig, BlojsomConfiguration blojsomConfiguration) throws BlojsomPluginException {
        this._blojsomConfiguration = blojsomConfiguration;
        this._servletConfig = servletConfig;
        try {
            Class<?> authorizationProviderClass = Class.forName(this._blojsomConfiguration.getAuthorizationProvider());
            this._authorizationProvider = (AuthorizationProvider)authorizationProviderClass.newInstance();
            this._authorizationProvider.init(servletConfig, blojsomConfiguration);
        }
        catch (ClassNotFoundException e) {
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (BlojsomConfigurationException e) {
            throw new BlojsomPluginException((Throwable)e);
        }
        String resourceManagerClass = this._blojsomConfiguration.getResourceManager();
        try {
            Class<?> resourceManagerClazz = Class.forName(resourceManagerClass);
            this._resourceManager = (ResourceManager)resourceManagerClazz.newInstance();
            this._resourceManager.init(this._blojsomConfiguration);
        }
        catch (InstantiationException e) {
            _logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            _logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            _logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        catch (BlojsomException e) {
            _logger.error((Object)e);
            throw new BlojsomPluginException((Throwable)e);
        }
        this._ignoreParams = new HashMap();
        this._ignoreParams.put(BLOJSOM_ADMIN_PLUGIN_USERNAME_PARAM, BLOJSOM_ADMIN_PLUGIN_USERNAME_PARAM);
        this._ignoreParams.put(BLOJSOM_ADMIN_PLUGIN_PASSWORD_PARAM, BLOJSOM_ADMIN_PLUGIN_PASSWORD_PARAM);
        this._ignoreParams.put("submit", "submit");
        this._ignoreParams.put("reset", "reset");
    }

    protected boolean authenticateUser(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Map context, BlogUser blogUser) {
        Blog blog = blogUser.getBlog();
        BlojsomUtils.setNoCacheControlHeaders((HttpServletResponse)httpServletResponse);
        HttpSession httpSession = httpServletRequest.getSession();
        boolean logout = false;
        String action = BlojsomUtils.getRequestValue((String)ACTION_PARAM, (HttpServletRequest)httpServletRequest);
        if (action != null && LOGOUT_ACTION.equals(action)) {
            httpSession.removeAttribute(blog.getBlogAdminURL() + "_" + BLOJSOM_ADMIN_PLUGIN_AUTHENTICATED_KEY);
            httpSession.removeAttribute(BLOJSOM_USER_AUTHENTICATED);
            httpSession.removeAttribute("redirect_to");
            logout = true;
        }
        StringBuffer redirectURL = new StringBuffer();
        redirectURL.append(httpServletRequest.getRequestURI());
        if (!redirectURL.toString().endsWith("/")) {
            redirectURL.append("/");
        }
        if (httpServletRequest.getParameterMap().size() > 0) {
            redirectURL.append("?");
            redirectURL.append(BlojsomUtils.convertRequestParams((HttpServletRequest)httpServletRequest, (Map)this._ignoreParams));
        }
        if (httpSession.getAttribute(blog.getBlogAdminURL() + "_" + BLOJSOM_ADMIN_PLUGIN_AUTHENTICATED_KEY) == null) {
            String username = httpServletRequest.getParameter(BLOJSOM_ADMIN_PLUGIN_USERNAME_PARAM);
            String password = httpServletRequest.getParameter(BLOJSOM_ADMIN_PLUGIN_PASSWORD_PARAM);
            if (username == null || password == null || "".equals(username) || "".equals(password)) {
                _logger.debug((Object)"No username/password provided or username/password was empty");
                _logger.debug((Object)("Setting redirect_to attribute to: " + redirectURL.toString()));
                if (!logout) {
                    httpServletRequest.getSession().setAttribute("redirect_to", (Object)redirectURL.toString());
                }
                return false;
            }
            try {
                this._authorizationProvider.loadAuthenticationCredentials(blogUser);
                this._authorizationProvider.authorize(blogUser, null, username, password);
                httpSession.setAttribute(blog.getBlogAdminURL() + "_" + BLOJSOM_ADMIN_PLUGIN_AUTHENTICATED_KEY, (Object)Boolean.TRUE);
                httpSession.setAttribute(blog.getBlogAdminURL() + "_" + BLOJSOM_ADMIN_PLUGIN_USERNAME_KEY, (Object)username);
                httpSession.setAttribute(BLOJSOM_ADMIN_PLUGIN_USERNAME, (Object)username);
                httpSession.setAttribute(BLOJSOM_USER_AUTHENTICATED, (Object)Boolean.TRUE);
                _logger.debug((Object)("Passed authentication for username: " + username));
                return true;
            }
            catch (BlojsomException e) {
                _logger.debug((Object)("Failed authentication for username: " + username));
                this.addOperationResultMessage(context, this.formatAdminResource(LOGIN_ERROR_TEXT_KEY, LOGIN_ERROR_TEXT_KEY, blog.getBlogAdministrationLocale(), new Object[]{username}));
                _logger.debug((Object)("Setting redirect_to attribute to: " + redirectURL.toString()));
                if (!logout) {
                    httpServletRequest.getSession().setAttribute("redirect_to", (Object)redirectURL.toString());
                }
                return false;
            }
        }
        context.put(BLOJSOM_PERMISSION_CHECKER, new PermissionChecker(blogUser, this._authorizationProvider, context));
        return (Boolean)httpSession.getAttribute(blog.getBlogAdminURL() + "_" + BLOJSOM_ADMIN_PLUGIN_AUTHENTICATED_KEY);
    }

    protected String getUsernameFromSession(HttpServletRequest httpServletRequest, Blog blog) {
        return (String)httpServletRequest.getSession().getAttribute(blog.getBlogAdminURL() + "_" + BLOJSOM_ADMIN_PLUGIN_USERNAME_KEY);
    }

    public boolean checkPermission(BlogUser blogUser, Map permissionContext, String username, String permission) {
        try {
            this._authorizationProvider.checkPermission(blogUser, permissionContext, username, permission);
        }
        catch (BlojsomException e) {
            _logger.error((Object)e);
            return false;
        }
        return true;
    }

    protected void addOperationResultMessage(Map context, String message) {
        context.put(BLOJSOM_ADMIN_PLUGIN_OPERATION_RESULT, message);
    }

    protected String getAdminResource(String resourceID, String fallbackText, Locale locale) {
        return this._resourceManager.getString(resourceID, BLOJSOM_ADMIN_MESSAGES_RESOURCE, fallbackText, locale);
    }

    protected String formatAdminResource(String resourceID, String fallbackText, Locale locale, Object[] arguments) {
        String resourceText = this.getAdminResource(resourceID, fallbackText, locale);
        String formattedText = this._resourceManager.format(resourceText, arguments);
        if (formattedText == null) {
            formattedText = fallbackText;
        }
        return formattedText;
    }

    public BlogEntry[] process(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, BlogUser user, Map context, BlogEntry[] entries) throws BlojsomPluginException {
        if (!this.authenticateUser(httpServletRequest, httpServletResponse, context, user)) {
            httpServletRequest.setAttribute(PAGE_ACTION, (Object)ADMIN_LOGIN_PAGE);
        } else {
            String page = BlojsomUtils.getRequestValue((String)PAGE_ACTION, (HttpServletRequest)httpServletRequest);
            if (!BlojsomUtils.checkNullOrBlank((String)page)) {
                httpServletRequest.setAttribute(PAGE_ACTION, (Object)page);
            } else {
                httpServletRequest.setAttribute(PAGE_ACTION, (Object)ADMIN_ADMINISTRATION_PAGE);
            }
            if (httpServletRequest.getSession().getAttribute("redirect_to") != null) {
                String redirectURL = (String)httpServletRequest.getSession().getAttribute("redirect_to");
                try {
                    httpServletRequest.getSession().removeAttribute("redirect_to");
                    httpServletResponse.sendRedirect(redirectURL);
                }
                catch (IOException e) {
                    _logger.error((Object)e);
                }
            }
        }
        return entries;
    }

    public void cleanup() throws BlojsomPluginException {
    }

    public void destroy() throws BlojsomPluginException {
    }
}

