/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.extension.xmlrpc.handlers;

import java.io.File;
import java.util.HashMap;
import javax.servlet.ServletConfig;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.xmlrpc.XmlRpcException;
import org.blojsom.BlojsomException;
import org.blojsom.authorization.AuthorizationProvider;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfiguration;
import org.blojsom.extension.xmlrpc.BlojsomXMLRPCConstants;
import org.blojsom.fetcher.BlojsomFetcher;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.util.BlojsomMetaDataConstants;
import org.blojsom.util.BlojsomUtils;

public abstract class AbstractBlojsomAPIHandler
implements BlojsomConstants,
BlojsomMetaDataConstants,
BlojsomXMLRPCConstants {
    public static final int AUTHORIZATION_EXCEPTION = 1;
    public static final String AUTHORIZATION_EXCEPTION_MSG = "Invalid username and/or password";
    public static final int UNKNOWN_EXCEPTION = 1000;
    public static final String UNKNOWN_EXCEPTION_MSG = "An error occured processing your request";
    public static final int UNSUPPORTED_EXCEPTION = 1001;
    public static final String UNSUPPORTED_EXCEPTION_MSG = "Unsupported method";
    public static final int INVALID_POSTID = 2000;
    public static final String INVALID_POSTID_MSG = "The entry postid you submitted is invalid";
    public static final int NOBLOGS_EXCEPTION = 3000;
    public static final String NOBLOGS_EXCEPTION_MSG = "There are no categories defined";
    public static final int PERMISSION_EXCEPTION = 4000;
    public static final String PERMISSION_EXCEPTION_MSG = "User does not have permission to use this XML-RPC method";
    protected Blog _blog;
    protected BlogUser _blogUser;
    protected BlojsomFetcher _fetcher;
    protected BlojsomConfiguration _configuration;
    protected String _blogEntryExtension;
    protected AuthorizationProvider _authorizationProvider;
    protected ServletConfig _servletConfig;
    protected HttpServletRequest _httpServletRequest;
    protected HttpServletResponse _httpServletResponse;

    public abstract void setBlogUser(BlogUser var1) throws BlojsomException;

    public void setAuthorizationProvider(AuthorizationProvider authorizationProvider) {
        this._authorizationProvider = authorizationProvider;
    }

    public abstract String getName();

    public void setFetcher(BlojsomFetcher fetcher) throws BlojsomException {
        this._fetcher = fetcher;
    }

    public void setConfiguration(BlojsomConfiguration configuration) throws BlojsomException {
        this._configuration = configuration;
    }

    public void setServletConfig(ServletConfig servletConfig) {
        this._servletConfig = servletConfig;
    }

    public void setHttpServletRequest(HttpServletRequest httpServletRequest) {
        this._httpServletRequest = httpServletRequest;
    }

    public void setHttpServletResponse(HttpServletResponse httpServletResponse) {
        this._httpServletResponse = httpServletResponse;
    }

    protected File getBlogCategoryDirectory(String categoryName) {
        File blogCategory = new File(this._blog.getBlogHome() + BlojsomUtils.removeInitialSlash((String)categoryName));
        if (blogCategory.exists() && blogCategory.isDirectory()) {
            return blogCategory;
        }
        return new File(this._blog.getBlogHome() + "/");
    }

    protected void checkXMLRPCPermission(String username, String permission) throws XmlRpcException {
        try {
            this._authorizationProvider.checkPermission(this._blogUser, new HashMap(), username, permission);
        }
        catch (BlojsomException e) {
            throw new XmlRpcException(4000, PERMISSION_EXCEPTION_MSG);
        }
    }
}

