/*
 * Decompiled with CFR 0.152.
 */
package org.blojsom.extension.atomapi;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.blojsom.BlojsomException;
import org.blojsom.authorization.AuthorizationProvider;
import org.blojsom.blog.Blog;
import org.blojsom.blog.BlogCategory;
import org.blojsom.blog.BlogEntry;
import org.blojsom.blog.BlogUser;
import org.blojsom.blog.BlojsomConfigurationException;
import org.blojsom.event.BlojsomEvent;
import org.blojsom.extension.atomapi.AtomAPIConstants;
import org.blojsom.extension.atomapi.AtomUtils;
import org.blojsom.fetcher.BlojsomFetcherException;
import org.blojsom.plugin.admin.event.AddBlogEntryEvent;
import org.blojsom.plugin.admin.event.DeletedBlogEntryEvent;
import org.blojsom.plugin.admin.event.UpdatedBlogEntryEvent;
import org.blojsom.servlet.BlojsomBaseServlet;
import org.blojsom.util.BlojsomConstants;
import org.blojsom.util.BlojsomMetaDataConstants;
import org.blojsom.util.BlojsomProperties;
import org.blojsom.util.BlojsomUtils;
import org.intabulas.sandler.Sandler;
import org.intabulas.sandler.SyndicationFactory;
import org.intabulas.sandler.api.impl.SearchResultsImpl;
import org.intabulas.sandler.authentication.AtomAuthentication;
import org.intabulas.sandler.authentication.AuthenticationException;
import org.intabulas.sandler.builders.SyndicationBuilder;
import org.intabulas.sandler.builders.XPPBuilder;
import org.intabulas.sandler.elements.Entry;
import org.intabulas.sandler.elements.Feed;
import org.intabulas.sandler.elements.Link;
import org.intabulas.sandler.elements.impl.LinkImpl;
import org.intabulas.sandler.exceptions.MarshallException;
import org.intabulas.sandler.serialization.SerializationException;

public class AtomAPIServlet
extends BlojsomBaseServlet
implements BlojsomConstants,
BlojsomMetaDataConstants,
AtomAPIConstants {
    private Log _logger = LogFactory.getLog((Class)AtomAPIServlet.class);
    private static final String ATOM_API_PERMISSION = "post_via_atom_api";
    private AuthorizationProvider _authorizationProvider;
    private ServletConfig _servletConfig;

    protected void configureAuthorization(ServletConfig servletConfig) throws ServletException {
        try {
            Class<?> authorizationProviderClass = Class.forName(this._blojsomConfiguration.getAuthorizationProvider());
            this._authorizationProvider = (AuthorizationProvider)authorizationProviderClass.newInstance();
            this._authorizationProvider.init(servletConfig, this._blojsomConfiguration);
        }
        catch (ClassNotFoundException e) {
            this._logger.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (InstantiationException e) {
            this._logger.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            this._logger.error((Object)e);
            throw new ServletException((Throwable)e);
        }
        catch (BlojsomConfigurationException e) {
            this._logger.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    public void init(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
        this._servletConfig = servletConfig;
        this.configureBlojsom(servletConfig);
        this.configureAuthorization(servletConfig);
        this._logger.info((Object)"AtomAPI initialized");
    }

    protected void configureFlavorsForUser(ServletConfig servletConfig, BlogUser blogUser) throws ServletException {
        String flavorConfiguration = servletConfig.getInitParameter("flavor-configuration");
        if (BlojsomUtils.checkNullOrBlank((String)flavorConfiguration)) {
            flavorConfiguration = "flavor.properties";
        }
        HashMap<String, String> flavors = new HashMap<String, String>();
        HashMap<String, String> flavorToTemplateMap = new HashMap<String, String>();
        HashMap<String, String> flavorToContentTypeMap = new HashMap<String, String>();
        String user = blogUser.getId();
        Properties flavorProperties = new Properties();
        InputStream is = servletConfig.getServletContext().getResourceAsStream(this._baseConfigurationDirectory + user + '/' + flavorConfiguration);
        try {
            flavorProperties.load(is);
            is.close();
            this._logger.debug((Object)("Loaded flavor information for user: " + user));
            Iterator<Object> flavorIterator = flavorProperties.keySet().iterator();
            while (flavorIterator.hasNext()) {
                String flavor = (String)flavorIterator.next();
                String[] flavorMapping = BlojsomUtils.parseCommaList((String)flavorProperties.getProperty(flavor));
                flavors.put(flavor, flavor);
                flavorToTemplateMap.put(flavor, flavorMapping[0]);
                flavorToContentTypeMap.put(flavor, flavorMapping[1]);
            }
            blogUser.setFlavors(flavors);
            blogUser.setFlavorToTemplate(flavorToTemplateMap);
            blogUser.setFlavorToContentType(flavorToContentTypeMap);
        }
        catch (IOException e) {
            this._logger.error((Object)e);
            throw new ServletException((Throwable)e);
        }
    }

    protected BlogUser loadBlogUser(String userID) {
        BlogUser blogUser = new BlogUser();
        blogUser.setId(userID);
        try {
            BlojsomProperties userProperties = new BlojsomProperties();
            InputStream is = this._servletConfig.getServletContext().getResourceAsStream(this._baseConfigurationDirectory + userID + '/' + "blog.properties");
            if (is == null) {
                return null;
            }
            userProperties.load(is);
            is.close();
            Blog userBlog = null;
            if (!BlojsomUtils.checkNullOrBlank((String)this._blojsomConfiguration.getGlobalBlogHome()) && !userProperties.containsKey("blog-home")) {
                String usersBlogHome = this._blojsomConfiguration.getGlobalBlogHome() + userID + "/";
                File blogHomeDirectory = new File(usersBlogHome);
                if (!blogHomeDirectory.exists()) {
                    this._logger.error((Object)("Unable to use blog-home directory for user: " + blogHomeDirectory.toString()));
                    throw new BlojsomConfigurationException("Unable to use blog-home directory for user: " + blogHomeDirectory.toString());
                }
                userProperties.setProperty("blog-home", usersBlogHome);
                this._logger.debug((Object)("Setting user blog-home directory: " + usersBlogHome));
            }
            userBlog = new Blog((Properties)userProperties);
            blogUser.setBlog(userBlog);
            this.configureFlavorsForUser(this._servletConfig, blogUser);
            this._logger.debug((Object)("Configured blojsom user: " + blogUser.getId()));
        }
        catch (BlojsomConfigurationException e) {
            this._logger.error((Object)e);
            return null;
        }
        catch (IOException e) {
            this._logger.error((Object)e);
            return null;
        }
        catch (ServletException e) {
            this._logger.error((Object)e);
            return null;
        }
        return blogUser;
    }

    private boolean isAuthorized(BlogUser blogUser, HttpServletRequest httpServletRequest) {
        Blog blog = blogUser.getBlog();
        try {
            this._authorizationProvider.loadAuthenticationCredentials(blogUser);
        }
        catch (BlojsomException e) {
            this._logger.error((Object)e);
            return false;
        }
        boolean result = false;
        if (httpServletRequest.getHeader("X-WSSE") != null) {
            AtomAuthentication auth = new AtomAuthentication(httpServletRequest.getHeader("X-WSSE"));
            Map authMap = blog.getAuthorization();
            if (authMap.containsKey(auth.getUsername())) {
                try {
                    this._authorizationProvider.checkPermission(blogUser, new HashMap(), auth.getUsername(), ATOM_API_PERMISSION);
                    result = auth.authenticate(BlojsomUtils.parseCommaList((String)((String)authMap.get(auth.getUsername())))[0]);
                }
                catch (AuthenticationException e) {
                    this._logger.error((Object)e.getMessage(), (Throwable)e);
                }
                catch (BlojsomException e) {
                    this._logger.error((Object)e);
                }
            } else {
                this._logger.info((Object)("Unable to locate user [" + auth.getUsername() + "] in authorization table"));
            }
            if (!result) {
                this._logger.info((Object)("Unable to authenticate user [" + auth.getUsername() + "]"));
            }
        }
        return result;
    }

    private void sendAuthenticationRequired(HttpServletResponse httpServletResponse, BlogUser user) {
        httpServletResponse.setContentType("text/html");
        httpServletResponse.setHeader("WWW-Authenticate", "WSSE realm=\"blojsom\", profile=\"UsernameToken\"");
        httpServletResponse.setStatus(401);
    }

    private boolean isSearchRequest(HttpServletRequest request) {
        Map paramMap = request.getParameterMap();
        return paramMap.containsKey("atom-all") || paramMap.containsKey("atom-last") || paramMap.containsKey("start-range") || request.getQueryString().indexOf("atom-all") != -1;
    }

    private String processSearchRequest(HttpServletRequest request, String category, Blog blog, BlogUser blogUser) {
        String result = null;
        Map paramMap = request.getParameterMap();
        int numPosts = -1;
        if (paramMap.containsKey("atom-last")) {
            try {
                numPosts = Integer.parseInt(((String[])paramMap.get("atom-last"))[0]);
                if (numPosts < -1 || numPosts == 0) {
                    numPosts = -1;
                }
            }
            catch (NumberFormatException e) {
                numPosts = -1;
            }
        }
        HashMap<String, Object> fetchMap = new HashMap<String, Object>();
        BlogCategory blogCategory = this._fetcher.newBlogCategory();
        blogCategory.setCategory(category);
        blogCategory.setCategoryURL(blog.getBlogURL() + category);
        fetchMap.put("FETCHER_CATEGORY", blogCategory);
        fetchMap.put("FETCHER_NUM_POSTS_INTEGER", new Integer(numPosts));
        try {
            BlogEntry[] entries = this._fetcher.fetchEntries(fetchMap, blogUser);
            if (entries != null && entries.length > 0) {
                SearchResultsImpl searchResult = new SearchResultsImpl();
                for (int x = 0; x < entries.length; ++x) {
                    BlogEntry entry = entries[x];
                    Entry atomentry = AtomUtils.fromBlogEntrySearch(blog, blogUser, entry, request.getServletPath());
                    searchResult.addEntry(atomentry);
                }
                result = searchResult.toString();
            }
        }
        catch (BlojsomFetcherException e) {
            this._logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return result;
    }

    protected void doDelete(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletRequest.setCharacterEncoding("UTF-8");
        Blog blog = null;
        BlogUser blogUser = null;
        String permalink = BlojsomUtils.getRequestValue((String)"permalink", (HttpServletRequest)httpServletRequest);
        String category = BlojsomUtils.getCategoryFromPath((String)httpServletRequest.getPathInfo());
        category = BlojsomUtils.urlDecode((String)category);
        String user = BlojsomUtils.getUserFromPath((String)httpServletRequest.getPathInfo());
        this._logger.info((Object)"AtomAPI Delete Called ================================================");
        this._logger.info((Object)("       Path: " + httpServletRequest.getPathInfo()));
        this._logger.info((Object)("       User: " + user));
        this._logger.info((Object)("   Category: " + category));
        this._logger.info((Object)("  Permalink: " + permalink));
        if (BlojsomUtils.checkNullOrBlank((String)user)) {
            user = this._blojsomConfiguration.getDefaultUser();
        }
        if ((blogUser = this.loadBlogUser(user)) == null) {
            this._logger.error((Object)("Unable to configure user: " + user));
            httpServletResponse.setStatus(404);
            return;
        }
        blog = blogUser.getBlog();
        if (this.isAuthorized(blogUser, httpServletRequest)) {
            this._logger.info((Object)("Fetching " + permalink));
            HashMap<String, Object> fetchMap = new HashMap<String, Object>();
            BlogCategory blogCategory = this._fetcher.newBlogCategory();
            blogCategory.setCategory(category);
            blogCategory.setCategoryURL(blog.getBlogURL() + category);
            fetchMap.put("FETCHER_CATEGORY", blogCategory);
            fetchMap.put("FETCHER_PERMALINK", permalink);
            try {
                BlogEntry[] entries = this._fetcher.fetchEntries(fetchMap, blogUser);
                if (entries != null && entries.length > 0) {
                    BlogEntry entry = entries[0];
                    entry.delete(blogUser);
                }
                httpServletResponse.setStatus(200);
                this._blojsomConfiguration.getEventBroadcaster().broadcastEvent((BlojsomEvent)new DeletedBlogEntryEvent((Object)this, new Date(), entries[0], blogUser));
            }
            catch (BlojsomFetcherException e) {
                this._logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                httpServletResponse.setStatus(404);
            }
            catch (BlojsomException e) {
                this._logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                httpServletResponse.setStatus(404);
            }
        } else {
            this.sendAuthenticationRequired(httpServletResponse, blogUser);
        }
    }

    private String createIntrospectionResponse(Blog blog, BlogUser user, String servletPath) {
        String atomuri = blog.getBlogBaseURL() + servletPath + "/" + user.getId() + "/";
        String atomuri2 = blog.getBlogURL() + "?flavor=atom";
        Feed feed = SyndicationFactory.newSyndicationFeed();
        LinkImpl link = new LinkImpl();
        link.setHref(atomuri);
        link.setRelationship("service.post");
        link.setType("application/atom+xml");
        link.setTitle(blog.getBlogDescription());
        feed.addLink((Link)link);
        LinkImpl link3 = new LinkImpl();
        link3.setHref(atomuri);
        link3.setRelationship("service.edit");
        link3.setType("application/atom+xml");
        link3.setTitle(blog.getBlogDescription());
        feed.addLink((Link)link3);
        LinkImpl link2 = new LinkImpl();
        link2.setHref(atomuri2);
        link2.setRelationship("service.feed");
        link2.setType("application/atom+xml");
        link2.setTitle(blog.getBlogDescription());
        feed.addLink((Link)link2);
        String result = "";
        try {
            result = Sandler.marshallFeed((Feed)feed);
        }
        catch (MarshallException e) {
            this._logger.error((Object)e);
        }
        catch (SerializationException e) {
            this._logger.error((Object)e);
        }
        return result;
    }

    protected void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletRequest.setCharacterEncoding("UTF-8");
        Blog blog = null;
        BlogUser blogUser = null;
        String permalink = BlojsomUtils.getRequestValue((String)"permalink", (HttpServletRequest)httpServletRequest);
        String category = BlojsomUtils.getCategoryFromPath((String)httpServletRequest.getPathInfo());
        category = BlojsomUtils.urlDecode((String)category);
        String user = BlojsomUtils.getUserFromPath((String)httpServletRequest.getPathInfo());
        if (BlojsomUtils.checkNullOrBlank((String)user)) {
            user = this._blojsomConfiguration.getDefaultUser();
        }
        if ((blogUser = this.loadBlogUser(user)) == null) {
            this._logger.error((Object)("Unable to configure user: " + user));
            httpServletResponse.setStatus(404);
            return;
        }
        blog = blogUser.getBlog();
        BlojsomUtils.resolveDynamicBaseAndBlogURL((HttpServletRequest)httpServletRequest, (Blog)blog, (String)user);
        String blogEntryExtension = blog.getBlogProperty("blog-atomapi-entry-extension");
        if (BlojsomUtils.checkNullOrBlank((String)blogEntryExtension)) {
            blogEntryExtension = ".html";
        }
        this._logger.info((Object)"AtomAPI GET Called ==================================================");
        this._logger.info((Object)("       Path: " + httpServletRequest.getPathInfo()));
        this._logger.info((Object)("       User: " + user));
        this._logger.info((Object)("   Category: " + category));
        this._logger.info((Object)("  Permalink: " + permalink));
        this._logger.info((Object)("      Query: " + httpServletRequest.getQueryString()));
        this._logger.info((Object)(" Params Cnt: " + httpServletRequest.getParameterMap().size()));
        boolean hasParams = httpServletRequest.getParameterMap().size() > 0 || httpServletRequest.getQueryString() != null;
        String content = null;
        if (this.isAuthorized(blogUser, httpServletRequest)) {
            if (!hasParams) {
                content = this.createIntrospectionResponse(blog, blogUser, httpServletRequest.getServletPath());
                httpServletResponse.setContentType("application/x.atom+xml");
            } else if (this.isSearchRequest(httpServletRequest)) {
                httpServletResponse.setContentType("application/xml");
                if (this.isSearchRequest(httpServletRequest)) {
                    content = this.processSearchRequest(httpServletRequest, category, blog, blogUser);
                }
            } else {
                this._logger.info((Object)("Fetching " + permalink));
                HashMap<String, Object> fetchMap = new HashMap<String, Object>();
                BlogCategory blogCategory = this._fetcher.newBlogCategory();
                blogCategory.setCategory(category);
                blogCategory.setCategoryURL(blog.getBlogURL() + category);
                fetchMap.put("FETCHER_CATEGORY", blogCategory);
                if (permalink != null) {
                    fetchMap.put("FETCHER_PERMALINK", permalink);
                }
                try {
                    BlogEntry[] entries = this._fetcher.fetchEntries(fetchMap, blogUser);
                    if (entries != null && entries.length > 0) {
                        BlogEntry entry = entries[0];
                        Entry atomentry = AtomUtils.fromBlogEntry(blog, blogUser, entry, httpServletRequest.getServletPath());
                        String edituri = blog.getBlogBaseURL() + httpServletRequest.getServletPath() + "/" + blogUser.getId() + entry.getId();
                        LinkImpl link = new LinkImpl();
                        link.setHref(edituri);
                        link.setRelationship("service.edit");
                        link.setType("application/atom+xml");
                        atomentry.addLink((Link)link);
                        content = Sandler.marshallEntry((Entry)atomentry);
                        httpServletResponse.setContentType("application/x.atom+xml");
                    }
                }
                catch (MarshallException e) {
                    this._logger.error((Object)e);
                    httpServletResponse.setStatus(404);
                }
                catch (SerializationException e) {
                    this._logger.error((Object)e);
                    httpServletResponse.setStatus(404);
                }
                catch (BlojsomFetcherException e) {
                    this._logger.error((Object)e);
                    httpServletResponse.setStatus(404);
                }
            }
            if (content != null) {
                httpServletResponse.setStatus(200);
                httpServletResponse.setContentLength(content.length());
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)httpServletResponse.getOutputStream(), "UTF-8");
                osw.write(content);
                osw.flush();
            } else {
                httpServletResponse.setStatus(404);
            }
        } else {
            this.sendAuthenticationRequired(httpServletResponse, blogUser);
        }
    }

    protected void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        httpServletRequest.setCharacterEncoding("UTF-8");
        if (httpServletRequest.getHeader("Soapaction") != null) {
            this.handleSOAPRequest(httpServletRequest, httpServletResponse);
            return;
        }
        Blog blog = null;
        BlogUser blogUser = null;
        String blogEntryExtension = ".html";
        String permalink = BlojsomUtils.getRequestValue((String)"permalink", (HttpServletRequest)httpServletRequest);
        String category = BlojsomUtils.getCategoryFromPath((String)httpServletRequest.getPathInfo());
        category = BlojsomUtils.urlDecode((String)category);
        String user = BlojsomUtils.getUserFromPath((String)httpServletRequest.getPathInfo());
        this._logger.info((Object)"AtomAPI POST Called =================================================");
        this._logger.info((Object)("       Path: " + httpServletRequest.getPathInfo()));
        this._logger.info((Object)("       User: " + user));
        this._logger.info((Object)("   Category: " + category));
        this._logger.info((Object)("  Permalink: " + permalink));
        if (BlojsomUtils.checkNullOrBlank((String)user)) {
            user = this._blojsomConfiguration.getDefaultUser();
        }
        if ((blogUser = this.loadBlogUser(user)) == null) {
            this._logger.error((Object)("Unable to configure user: " + user));
            httpServletResponse.setStatus(404);
            return;
        }
        blog = blogUser.getBlog();
        BlojsomUtils.resolveDynamicBaseAndBlogURL((HttpServletRequest)httpServletRequest, (Blog)blog, (String)user);
        blogEntryExtension = blog.getBlogProperty("blog-atomapi-entry-extension");
        if (BlojsomUtils.checkNullOrBlank((String)blogEntryExtension)) {
            blogEntryExtension = ".html";
        }
        if (this.isAuthorized(blogUser, httpServletRequest)) {
            try {
                Entry atomEntry = Sandler.unmarshallEntry((InputStream)httpServletRequest.getInputStream(), (SyndicationBuilder)new XPPBuilder());
                BlogEntry entry = this._fetcher.newBlogEntry();
                HashMap<String, String> blogEntryMetaData = new HashMap<String, String>();
                entry.setCategory(category);
                entry.setDescription(atomEntry.getContent(0).getBody());
                entry.setDate(atomEntry.getCreated());
                entry.setTitle(atomEntry.getTitle().getBody());
                if (atomEntry.getAuthor() != null) {
                    blogEntryMetaData.put("blog-entry-author", atomEntry.getAuthor().getName());
                } else {
                    blogEntryMetaData.put("blog-entry-author", blog.getBlogOwner());
                }
                blogEntryMetaData.put("blog-entry-metadata-timestamp", new Long(new Date().getTime()).toString());
                entry.setMetaData(blogEntryMetaData);
                entry.save(blogUser);
                entry.load(blogUser);
                entry.setLink(blog.getBlogURL() + BlojsomUtils.removeInitialSlash((String)entry.getId()));
                this._blojsomConfiguration.getEventBroadcaster().broadcastEvent((BlojsomEvent)new AddBlogEntryEvent((Object)this, new Date(), entry, blogUser));
                httpServletResponse.setContentType("application/x.atom+xml");
                httpServletResponse.setStatus(201);
                atomEntry = AtomUtils.fromBlogEntry(blog, blogUser, entry, httpServletRequest.getServletPath());
                Collection links = atomEntry.getLinks();
                Iterator linksIterator = links.iterator();
                while (linksIterator.hasNext()) {
                    Link link = (Link)linksIterator.next();
                    if (!"service.edit".equals(link.getRelationship())) continue;
                    httpServletResponse.setHeader("Location", link.getEscapedHref());
                    break;
                }
                OutputStreamWriter osw = new OutputStreamWriter((OutputStream)httpServletResponse.getOutputStream(), "UTF-8");
                osw.write(Sandler.marshallEntry((Entry)atomEntry, (boolean)true));
                osw.flush();
            }
            catch (SerializationException e) {
                this._logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                httpServletResponse.setStatus(404);
            }
            catch (MarshallException e) {
                this._logger.error((Object)e.getLocalizedMessage(), (Throwable)e);
                httpServletResponse.setStatus(404);
            }
            catch (BlojsomException e) {
                this._logger.error((Object)e);
                httpServletResponse.setStatus(404);
            }
        } else {
            this.sendAuthenticationRequired(httpServletResponse, blogUser);
        }
    }

    protected void doPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        block9: {
            httpServletRequest.setCharacterEncoding("UTF-8");
            Blog blog = null;
            BlogUser blogUser = null;
            String permalink = BlojsomUtils.getRequestValue((String)"permalink", (HttpServletRequest)httpServletRequest);
            String category = BlojsomUtils.getCategoryFromPath((String)httpServletRequest.getPathInfo());
            category = BlojsomUtils.urlDecode((String)category);
            String user = BlojsomUtils.getUserFromPath((String)httpServletRequest.getPathInfo());
            this._logger.info((Object)"AtomAPI PUT Called ==================================================");
            this._logger.info((Object)("       Path: " + httpServletRequest.getPathInfo()));
            this._logger.info((Object)("       User: " + user));
            this._logger.info((Object)("   Category: " + category));
            this._logger.info((Object)("  Permalink: " + permalink));
            if (BlojsomUtils.checkNullOrBlank((String)user)) {
                user = this._blojsomConfiguration.getDefaultUser();
            }
            if ((blogUser = this.loadBlogUser(user)) == null) {
                this._logger.error((Object)("Unable to configure user: " + user));
                httpServletResponse.setStatus(404);
                return;
            }
            blog = blogUser.getBlog();
            BlojsomUtils.resolveDynamicBaseAndBlogURL((HttpServletRequest)httpServletRequest, (Blog)blog, (String)user);
            if (this.isAuthorized(blogUser, httpServletRequest)) {
                HashMap<String, Object> fetchMap = new HashMap<String, Object>();
                BlogCategory blogCategory = this._fetcher.newBlogCategory();
                blogCategory.setCategory(category);
                blogCategory.setCategoryURL(blog.getBlogURL() + category);
                fetchMap.put("FETCHER_CATEGORY", blogCategory);
                fetchMap.put("FETCHER_PERMALINK", permalink);
                try {
                    BlogEntry[] entries = this._fetcher.fetchEntries(fetchMap, blogUser);
                    if (entries != null && entries.length > 0) {
                        Entry atomEntry = Sandler.unmarshallEntry((InputStream)httpServletRequest.getInputStream(), (SyndicationBuilder)new XPPBuilder());
                        BlogEntry entry = entries[0];
                        Map blogEntryMetaData = entry.getMetaData();
                        entry.setCategory(category);
                        entry.setDescription(atomEntry.getContent(0).getBody());
                        entry.setTitle(atomEntry.getTitle().getBody());
                        if (atomEntry.getAuthor() != null) {
                            blogEntryMetaData.put("blog-entry-author", atomEntry.getAuthor().getName());
                        }
                        entry.setMetaData(blogEntryMetaData);
                        entry.save(blogUser);
                        httpServletResponse.setStatus(204);
                        this._blojsomConfiguration.getEventBroadcaster().broadcastEvent((BlojsomEvent)new UpdatedBlogEntryEvent((Object)this, new Date(), entry, blogUser));
                        break block9;
                    }
                    this._logger.info((Object)("Unable to fetch " + permalink));
                }
                catch (BlojsomFetcherException e) {
                    this._logger.error((Object)e);
                    httpServletResponse.setStatus(404);
                }
                catch (BlojsomException e) {
                    this._logger.error((Object)e);
                    httpServletResponse.setStatus(404);
                }
            } else {
                this.sendAuthenticationRequired(httpServletResponse, blogUser);
            }
        }
    }

    protected void handleSOAPRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        String soapAction = httpServletRequest.getHeader("Soapaction");
        if ("\"http://schemas.xmlsoap.org/wsdl/http/PUT\"".equalsIgnoreCase(soapAction)) {
            this.handleSOAPPut(httpServletRequest, httpServletResponse);
        } else {
            try {
                httpServletResponse.sendError(404, "Unable to process SOAP request for unknown action: " + soapAction);
            }
            catch (IOException e) {
                this._logger.error((Object)e);
                httpServletResponse.setStatus(404);
            }
        }
    }

    protected String retrieveEntryBody(String content) {
        String entryStart = "<entry";
        String entryEnd = "</entry>";
        int entryIndexStart = content.indexOf(entryStart);
        int entryIndexEnd = content.indexOf(entryEnd);
        if (entryIndexStart != -1 && entryIndexEnd != -1 && entryIndexEnd > entryIndexStart) {
            return content.substring(entryIndexStart, entryIndexEnd + entryEnd.length());
        }
        return null;
    }

    protected String readContentFromInputStream(InputStream is, int length) {
        char[] buffer = new char[]{};
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(is, "UTF-8");
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            buffer = new char[length];
            bufferedReader.read(buffer, 0, length);
            bufferedReader.close();
        }
        catch (IOException e) {
            this._logger.error((Object)e);
            return null;
        }
        return new String(buffer);
    }

    protected void handleSOAPPut(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        block17: {
            Blog blog = null;
            BlogUser blogUser = null;
            String blogEntryExtension = ".html";
            String permalink = BlojsomUtils.getRequestValue((String)"permalink", (HttpServletRequest)httpServletRequest);
            String category = BlojsomUtils.getCategoryFromPath((String)httpServletRequest.getPathInfo());
            category = BlojsomUtils.urlDecode((String)category);
            String user = BlojsomUtils.getUserFromPath((String)httpServletRequest.getPathInfo());
            this._logger.info((Object)"AtomAPI SOAP PUT Called =================================================");
            this._logger.info((Object)("       Path: " + httpServletRequest.getPathInfo()));
            this._logger.info((Object)("       User: " + user));
            this._logger.info((Object)("   Category: " + category));
            this._logger.info((Object)("  Permalink: " + permalink));
            if (BlojsomUtils.checkNullOrBlank((String)user)) {
                user = this._blojsomConfiguration.getDefaultUser();
            }
            if ((blogUser = this.loadBlogUser(user)) == null) {
                this._logger.error((Object)("Unable to configure user: " + user));
                httpServletResponse.setStatus(404);
                return;
            }
            blog = blogUser.getBlog();
            BlojsomUtils.resolveDynamicBaseAndBlogURL((HttpServletRequest)httpServletRequest, (Blog)blog, (String)user);
            blogEntryExtension = blog.getBlogProperty("blog-atomapi-entry-extension");
            if (BlojsomUtils.checkNullOrBlank((String)blogEntryExtension)) {
                blogEntryExtension = ".html";
            }
            if (this.isAuthorized(blogUser, httpServletRequest)) {
                try {
                    String content = this.readContentFromInputStream((InputStream)httpServletRequest.getInputStream(), httpServletRequest.getContentLength());
                    if (content != null) {
                        String entryContent = this.retrieveEntryBody(content);
                        if (entryContent != null && entryContent.length() > 0) {
                            HashMap<String, Object> fetchMap = new HashMap<String, Object>();
                            BlogCategory blogCategory = this._fetcher.newBlogCategory();
                            blogCategory.setCategory(category);
                            blogCategory.setCategoryURL(blog.getBlogURL() + category);
                            fetchMap.put("FETCHER_CATEGORY", blogCategory);
                            fetchMap.put("FETCHER_PERMALINK", permalink);
                            try {
                                BlogEntry[] entries = this._fetcher.fetchEntries(fetchMap, blogUser);
                                if (entries != null && entries.length > 0) {
                                    Entry atomEntry = Sandler.unmarshallEntry((String)entryContent, (SyndicationBuilder)new XPPBuilder());
                                    BlogEntry entry = entries[0];
                                    Map blogEntryMetaData = entry.getMetaData();
                                    entry.setCategory(category);
                                    entry.setDescription(atomEntry.getContent(0).getBody());
                                    entry.setTitle(atomEntry.getTitle().getBody());
                                    if (atomEntry.getAuthor() != null) {
                                        blogEntryMetaData.put("blog-entry-author", atomEntry.getAuthor().getName());
                                    }
                                    entry.setMetaData(blogEntryMetaData);
                                    entry.save(blogUser);
                                    entry.load(blogUser);
                                    entry.setLink(blog.getBlogURL() + BlojsomUtils.removeInitialSlash((String)entry.getId()));
                                    httpServletResponse.setContentType("application/x.atom+xml");
                                    httpServletResponse.setStatus(201);
                                    this._blojsomConfiguration.getEventBroadcaster().broadcastEvent((BlojsomEvent)new AddBlogEntryEvent((Object)this, new Date(), entry, blogUser));
                                    atomEntry = AtomUtils.fromBlogEntry(blog, blogUser, entry, httpServletRequest.getServletPath());
                                    Collection links = atomEntry.getLinks();
                                    Iterator linksIterator = links.iterator();
                                    while (linksIterator.hasNext()) {
                                        Link link = (Link)linksIterator.next();
                                        if (!"service.edit".equals(link.getRelationship())) continue;
                                        httpServletResponse.setHeader("Location", link.getEscapedHref());
                                        break;
                                    }
                                    OutputStreamWriter osw = new OutputStreamWriter((OutputStream)httpServletResponse.getOutputStream(), "UTF-8");
                                    osw.write(Sandler.marshallEntry((Entry)atomEntry, (boolean)true));
                                    osw.flush();
                                    break block17;
                                }
                                this._logger.info((Object)("Unable to fetch " + permalink));
                            }
                            catch (BlojsomFetcherException e) {
                                this._logger.error((Object)e);
                                httpServletResponse.setStatus(404);
                            }
                            catch (BlojsomException e) {
                                this._logger.error((Object)e);
                                httpServletResponse.setStatus(404);
                            }
                            catch (SerializationException e) {
                                this._logger.error((Object)e);
                                httpServletResponse.setStatus(404);
                            }
                            catch (MarshallException e) {
                                this._logger.error((Object)e);
                                httpServletResponse.setStatus(404);
                            }
                            break block17;
                        }
                        httpServletResponse.setStatus(404);
                        break block17;
                    }
                    httpServletResponse.setStatus(404);
                }
                catch (IOException e) {
                    this._logger.error((Object)e);
                    httpServletResponse.setStatus(404);
                }
            } else {
                this.sendAuthenticationRequired(httpServletResponse, blogUser);
            }
        }
    }

    public void destroy() {
        try {
            this._fetcher.destroy();
        }
        catch (BlojsomFetcherException e) {
            this._logger.error((Object)e);
        }
    }
}

