/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.stringgroup.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.stringgroup.BlancoStringGroupConstants;
import blanco.stringgroup.BlancoStringGroupMeta2Xml;
import blanco.stringgroup.BlancoStringGroupXml2SourceFile;
import blanco.stringgroup.message.BlancoStringGroupMessage;
import blanco.stringgroup.task.valueobject.BlancoStringGroupProcessInput;

/**
 * uO[v`vExcell當O[vNXE\[XR[h𐶐B
 * 
 * @author IGA Tosiki
 */
public class BlancoStringGroupProcessImpl implements BlancoStringGroupProcess {
    /**
     * bZ[W`B
     */
    private final BlancoStringGroupMessage fMsg = new BlancoStringGroupMessage();

    public int execute(final BlancoStringGroupProcessInput input)
            throws IOException, IllegalArgumentException {
        System.out.println("- " + BlancoStringGroupConstants.PRODUCT_NAME
                + " (" + BlancoStringGroupConstants.VERSION + ")");

        try {
            final File fileMetadir = new File(input.getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException(fMsg.getMbsga001(input
                        .getMetadir()));
            }

            // e|fBNg쐬B
            new File(input.getTmpdir()
                    + BlancoStringGroupConstants.TARGET_SUBDIRECTORY).mkdirs();

            // w肳ꂽ^fBNg܂B
            new BlancoStringGroupMeta2Xml().processDirectory(fileMetadir, input
                    .getTmpdir()
                    + BlancoStringGroupConstants.TARGET_SUBDIRECTORY);

            // XMLꂽԃt@C\[XR[h𐶐
            final File[] fileMeta2 = new File(input.getTmpdir()
                    + BlancoStringGroupConstants.TARGET_SUBDIRECTORY)
                    .listFiles();
            for (int index = 0; index < fileMeta2.length; index++) {
                if (fileMeta2[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                final BlancoStringGroupXml2SourceFile xml2source = new BlancoStringGroupXml2SourceFile();
                xml2source.setEncoding(input.getEncoding());
                xml2source.process(fileMeta2[index], input.getTargetlang(),
                        new File(input.getTargetdir()));
            }

            return BlancoStringGroupBatchProcess.END_SUCCESS;
        } catch (TransformerException ex) {
            throw new IOException("XMLϊ̉ߒŗO܂: " + ex.toString());
        }
    }
}
