/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.transformer.delphi;

import java.util.ArrayList;
import java.util.List;

import blanco.cg.BlancoCgSupportedLang;
import blanco.cg.util.BlancoCgLineUtil;
import blanco.cg.valueobject.BlancoCgException;
import blanco.cg.valueobject.BlancoCgLangDoc;
import blanco.cg.valueobject.BlancoCgLocalVariable;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgParameter;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.cg.valueobject.BlancoCgType;
import blanco.commons.util.BlancoStringUtil;

/**
 * BlancoCgMethod\[XR[hɓWJ܂B
 * 
 * ̃NXblancoCg̃o[IuWFNg\[XR[hgXtH[}[̌ʂ̓WJ@\łB
 * 
 * @author IGA Tosiki
 */
class BlancoCgMethodDelphiSourceExpander {
    /**
     * ̃NXΏۂƂvO~OB
     */
    protected static final int TARGET_LANG = BlancoCgSupportedLang.DELPHI;

    /**
     * Ń\bhWJ܂B
     * 
     * @param cgMethod
     *            ΏۂƂȂ郁\bhB
     * @param argSourceFile
     *            \[Xt@CB
     * @param argSourceLines
     *            o͐sXgB
     * @param argIsInterface
     *            C^tF[XǂBNX̏ꍇɂfalseBC^tF[X̏ꍇɂtrueB
     */
    public void transformMethodDeclaration(final BlancoCgMethod cgMethod,
            final BlancoCgSourceFile argSourceFile,
            final List<java.lang.String> argSourceLines,
            final boolean argIsInterface) {
        if (BlancoStringUtil.null2Blank(cgMethod.getName()).length() == 0) {
            throw new IllegalArgumentException("\bh̖OɓK؂Ȓlݒ肳Ă܂B");
        }
        if (cgMethod.getReturn() == null) {
            // ͂肦܂Bvoid̏ꍇɂnullw肳̂łB
        }

        // st^B
        argSourceLines.add("");

        prepareExpand(cgMethod, argSourceFile);

        // 񂪈ꎮ̂ŁA\[XR[h̎ۂ̓WJs܂B

        //  LangDoc\[XR[h`ɓWJB
        // new BlancoCgLangDocCsSourceExpander().transformLangDoc(cgMethod
        // .getLangDoc(), argSourceLines);

        // Ame[VWJB
        expandAnnotationList(cgMethod, argSourceLines);

        // \bh̐錾WJB
        expandMethodDeclaration(cgMethod, argSourceFile, argSourceLines,
                argIsInterface);
    }

    /**
     * Ń\bhWJ܂B
     * 
     * @param typeName
     * 
     * @param cgMethod
     *            ΏۂƂȂ郁\bhB
     * @param argSourceFile
     *            \[Xt@CB
     * @param argSourceLines
     *            o͐sXgB
     * @param argIsInterface
     *            C^tF[XǂBNX̏ꍇɂfalseBC^tF[X̏ꍇɂtrueB
     */
    public void transformMethod(String typeName, final BlancoCgMethod cgMethod,
            final BlancoCgSourceFile argSourceFile,
            final List<java.lang.String> argSourceLines,
            final boolean argIsInterface) {

        if (BlancoStringUtil.null2Blank(cgMethod.getName()).length() == 0) {
            throw new IllegalArgumentException("\bh̖OɓK؂Ȓlݒ肳Ă܂B");
        }
        if (cgMethod.getReturn() == null) {
            // ͂肦܂Bvoid̏ꍇɂnullw肳̂łB
        }

        // st^B
        argSourceLines.add("");

        prepareExpand(cgMethod, argSourceFile);

        // 񂪈ꎮ̂ŁA\[XR[h̎ۂ̓WJs܂B

        //  LangDoc\[XR[h`ɓWJB
        // new BlancoCgLangDocCsSourceExpander().transformLangDoc(cgMethod
        // .getLangDoc(), argSourceLines);

        // Ame[VWJB
        expandAnnotationList(cgMethod, argSourceLines);

        // \bh̖{̕WJB
        expandMethodBody(typeName, cgMethod, argSourceFile, argSourceLines,
                argIsInterface);
    }

    /**
     * \[XR[hWJɐ旧AKvȏ̎Ws܂B
     * 
     * @param cgMethod
     *            \bhIuWFNgB
     * @param argSourceFile
     *            \[Xt@CB
     */
    private void prepareExpand(final BlancoCgMethod cgMethod,
            final BlancoCgSourceFile argSourceFile) {
        // ŏɃ\bhLangDocɓWJB
        if (cgMethod.getLangDoc() == null) {
            // LangDocw̏ꍇɂ͂瑤ŃCX^X𐶐B
            cgMethod.setLangDoc(new BlancoCgLangDoc());
        }
        if (cgMethod.getLangDoc().getParameterList() == null) {
            cgMethod.getLangDoc().setParameterList(
                    new ArrayList<blanco.cg.valueobject.BlancoCgParameter>());
        }
        if (cgMethod.getLangDoc().getThrowList() == null) {
            cgMethod.getLangDoc().setThrowList(
                    new ArrayList<blanco.cg.valueobject.BlancoCgException>());
        }
        if (cgMethod.getLangDoc().getTitle() == null) {
            cgMethod.getLangDoc().setTitle(cgMethod.getDescription());
        }

        for (int indexParameter = 0; indexParameter < cgMethod
                .getParameterList().size(); indexParameter++) {
            final BlancoCgParameter cgParameter = cgMethod.getParameterList()
                    .get(indexParameter);

            // importɌ^ǉB
//            argSourceFile.getImportList().add(cgParameter.getType().getName());

            // hLgɃp[^ǉB
            cgMethod.getLangDoc().getParameterList().add(cgParameter);
        }

        if (cgMethod.getReturn() != null) {
            // importɌ^ǉB
//            argSourceFile.getImportList().add(
//                    cgMethod.getReturn().getType().getName());

            // hLgreturnǉB
            cgMethod.getLangDoc().setReturn(cgMethod.getReturn());
        }

        // OɂLangDoc\̂ɓWJ
        for (int index = 0; index < cgMethod.getThrowList().size(); index++) {
            final BlancoCgException cgException = cgMethod.getThrowList().get(
                    index);

            // importɌ^ǉB
//            argSourceFile.getImportList().add(cgException.getType().getName());

            // hLgɗOǉB
            cgMethod.getLangDoc().getThrowList().add(cgException);
        }
    }

    private void expandMethodLocalVariableDeclaration(BlancoCgMethod cgMethod,
            List<String> argSourceLines) {
        
        if (cgMethod.getLocalVariableList().size() > 0){
            argSourceLines.add("var");
        }
        
        for (int index = 0; index < cgMethod.getLocalVariableList().size(); index++) {
            final StringBuffer buf = new StringBuffer();
            final BlancoCgLocalVariable cgLocalVariable = cgMethod.getLocalVariableList()
                    .get(index);
            if (cgLocalVariable.getType() == null) {
                throw new IllegalArgumentException("\bh[" + cgMethod.getName()
                        + "]̃[Jϐ[" + cgLocalVariable.getName()
                        + "]Ɍ^null^܂B");
            }

            buf.append(cgLocalVariable.getName());
            buf.append(": ");
            buf.append(BlancoCgTypeDelphiSourceExpander
                    .toTypeString(cgLocalVariable.getType()));
            buf.append(";");
            argSourceLines.add(buf.toString());
        }
    }


            /**
     * \bh̖{̕WJ܂B
     * 
     * @param typeName
     * 
     * @param cgMethod
     *            \bhIuWFNgB
     * @param argSourceLines
     *            \[XR[hB
     * @param argIsInterface
     *            C^tF[XƂēWJ邩ǂB
     */
    private void expandMethodBody(String typeName,
            final BlancoCgMethod cgMethod,
            final BlancoCgSourceFile argSourceFile,
            final List<java.lang.String> argSourceLines,
            final boolean argIsInterface) {
        final StringBuffer buf = new StringBuffer();

        // if (BlancoStringUtil.null2Blank(cgMethod.getAccess()).length() > 0) {
        // if (argIsInterface && cgMethod.getAccess().equals("public")) {
        // // C^tF[Xpublic̏ꍇɂ͏o͂}܂B
        // // JavaƓl C#ło͂͗}܂B
        // } else {
        // buf.append(cgMethod.getAccess() + " ");
        // }
        // }

        if (cgMethod.getAbstract() && argIsInterface == false) {
            // C^tF[X̏ꍇɂ abstract͕t^܂B
            buf.append("abstract ");
        }
        if (cgMethod.getOverride()) {
            // C#.NETɂ override C݂܂B
            buf.append("override ");
        }
        // if (isVirtual(cgMethod, argIsInterface)) {
        // // koyak ̍vӏB
        // // C#.NET ł́ApNXŃ\bhI[o[Chɂ͕KNX̃\bh virtual
        // // CĂKv܂B
        // // ̂߁A\bh override łȂ virtual Ƃ܂B
        // buf.append("virtual ");
        // }
        if (cgMethod.getStatic()) {
            buf.append("static ");
        }
        if (cgMethod.getFinal() && argIsInterface == false) {
            // C^tF[X̏ꍇɂ final͕t^܂B
            buf.append("final ");
        }

        if (cgMethod.getConstructor()) {
            // RXgN^̏ꍇɂ́A߂l݂͑܂B
            // ̂߁Ał͉o͂܂B
        } else {
            if (cgMethod.getReturn() != null
                    && cgMethod.getReturn().getType() != null) {
                buf.append("function ");
            } else {
                buf.append("procedure ");
            }
        }

        buf.append(typeName + "." + cgMethod.getName());

        // ȂꍇAʂ͕svłB
        if (cgMethod.getParameterList().size() > 0) {
            buf.append("(");
        }

        for (int index = 0; index < cgMethod.getParameterList().size(); index++) {
            final BlancoCgParameter cgParameter = cgMethod.getParameterList()
                    .get(index);
            if (cgParameter.getType() == null) {
                throw new IllegalArgumentException("\bh[" + cgMethod.getName()
                        + "]̃p[^[" + cgParameter.getName()
                        + "]Ɍ^null^܂B");
            }

            if (index != 0) {
                buf.append("; ");
            }

            // p[^̃Ame[VWJB
            // if (cgParameter.getAnnotationList() != null) {
            // for (int indexAnnotation = 0; indexAnnotation < cgParameter
            // .getAnnotationList().size(); indexAnnotation++) {
            // // C#.NETAnnotation []ŋLq܂B
            // final String strAnnotation = cgParameter
            // .getAnnotationList().get(indexAnnotation);
            //	
            // // C#.NETAnnotation []ŋLq܂B
            // buf.append("[" + strAnnotation + "] ");
            // }
            // }

            if (cgParameter.getFinal()) {
                // C#.NETɂfinalreadonly\ƂȂ܂BIȂ̂ŁA_ł͓WJ}܂B
                // buf.append("readonly ");
            }
            buf.append(cgParameter.getName());
            buf.append(": ");
            buf.append(BlancoCgTypeDelphiSourceExpander
                    .toTypeString(cgParameter.getType()));
        }

        if (cgMethod.getParameterList().size() > 0) {
            buf.append(")");
        }

        // ߂^͂ŏo͂邱
        if (cgMethod.getReturn() != null
                && cgMethod.getReturn().getType() != null) {
            buf.append(": " + BlancoCgTypeDelphiSourceExpander.toTypeString(cgMethod
                    .getReturn().getType()));
        }
        

        //
        buf.append(";");

        // C#.NETɂ base()Lq݂܂B
        // if (BlancoStringUtil.null2Blank(cgMethod.getSuperclassInvocation())
        // .length() > 0) {
        // // getSuperclassInvocationɂ base(message)Ȃǂ̂悤ȋLڂȂ܂B
        // // TODO C#.NETł̋Lڂ\Ȃ̂̓RXgN^ł͗lłB
        // buf.append(" : " + cgMethod.getSuperclassInvocation());
        // }

        // C#.NETɂ͗OX[̃\bhC͂܂B
        // TODO OX[ hLgɏo͂邱Ƃɂ͈Ӌ`ƍl܂B

        if (cgMethod.getAbstract() || argIsInterface) {
            // ۃ\bh܂̓C^tF[X̏ꍇɂ́A\bh̖{̂WJ܂B
            buf.append(BlancoCgLineUtil.getTerminator(TARGET_LANG));
            argSourceLines.add(buf.toString());
        } else {
            // łAsmB
            argSourceLines.add(buf.toString());

            // [Jϐ`WJ܂B 
            expandMethodLocalVariableDeclaration(cgMethod, argSourceLines);
            
            // \bhubN̊JnB
            argSourceLines.add("begin");

            // p[^̔null̓WJB
            expandParameterCheck(cgMethod, argSourceFile, argSourceLines);

            // sWJ܂B
            expandLineList(cgMethod, argSourceLines);

            // \bhubN̏IB
            argSourceLines.add("end;");
        }
    }

    /**
     * \bh̖{̕WJ܂B
     * 
     * @param cgMethod
     *            \bhIuWFNgB
     * @param argSourceLines
     *            \[XR[hB
     * @param argIsInterface
     *            C^tF[XƂēWJ邩ǂB
     */
    private void expandMethodDeclaration(final BlancoCgMethod cgMethod,
            final BlancoCgSourceFile argSourceFile,
            final List<java.lang.String> argSourceLines,
            final boolean argIsInterface) {
        final StringBuffer buf = new StringBuffer();

        // if (BlancoStringUtil.null2Blank(cgMethod.getAccess()).length() > 0) {
        // if (argIsInterface && cgMethod.getAccess().equals("public")) {
        // // C^tF[Xpublic̏ꍇɂ͏o͂}܂B
        // // JavaƓl C#ło͂͗}܂B
        // } else {
        // buf.append(cgMethod.getAccess() + " ");
        // }
        // }

        if (cgMethod.getAbstract() && argIsInterface == false) {
            // C^tF[X̏ꍇɂ abstract͕t^܂B
            buf.append("abstract ");
        }
        if (cgMethod.getOverride()) {
            // C#.NETɂ override C݂܂B
            buf.append("override ");
        }
        // if (isVirtual(cgMethod, argIsInterface)) {
        // // koyak ̍vӏB
        // // C#.NET ł́ApNXŃ\bhI[o[Chɂ͕KNX̃\bh virtual
        // // CĂKv܂B
        // // ̂߁A\bh override łȂ virtual Ƃ܂B
        // buf.append("virtual ");
        // }
        if (cgMethod.getStatic()) {
            buf.append("static ");
        }
        if (cgMethod.getFinal() && argIsInterface == false) {
            // C^tF[X̏ꍇɂ final͕t^܂B
            buf.append("final ");
        }

        if (cgMethod.getConstructor()) {
            // RXgN^̏ꍇɂ́A߂l݂͑܂B
            // ̂߁Ał͉o͂܂B
        } else {
            if (cgMethod.getReturn() != null
                    && cgMethod.getReturn().getType() != null) {
                buf.append("function ");
            } else {
                buf.append("procedure ");
            }
        }

        buf.append(cgMethod.getName());

        // ȂꍇAʂ͕svłB
        if (cgMethod.getParameterList().size() > 0) {
            buf.append("(");
        }

        for (int index = 0; index < cgMethod.getParameterList().size(); index++) {
            final BlancoCgParameter cgParameter = cgMethod.getParameterList()
                    .get(index);
            if (cgParameter.getType() == null) {
                throw new IllegalArgumentException("\bh[" + cgMethod.getName()
                        + "]̃p[^[" + cgParameter.getName()
                        + "]Ɍ^null^܂B");
            }

            if (index != 0) {
                buf.append("; ");
            }

            // p[^̃Ame[VWJB
            if (cgParameter.getAnnotationList() != null) {
                for (int indexAnnotation = 0; indexAnnotation < cgParameter
                        .getAnnotationList().size(); indexAnnotation++) {
                    // C#.NETAnnotation []ŋLq܂B
                    final String strAnnotation = cgParameter
                            .getAnnotationList().get(indexAnnotation);

                    // C#.NETAnnotation []ŋLq܂B
                    buf.append("[" + strAnnotation + "] ");
                }
            }

            if (cgParameter.getFinal()) {
                // C#.NETɂfinalreadonly\ƂȂ܂BIȂ̂ŁA_ł͓WJ}܂B
                // buf.append("readonly ");
            }
            buf.append(cgParameter.getName());
            buf.append(": ");
            buf.append(BlancoCgTypeDelphiSourceExpander
                    .toTypeString(cgParameter.getType()));
        }

        if (cgMethod.getParameterList().size() > 0) {
            buf.append(")");
        }

        // ߂^͂ŏo͂邱
        if (cgMethod.getReturn() != null
                && cgMethod.getReturn().getType() != null) {
            buf.append(": " + BlancoCgTypeDelphiSourceExpander.toTypeString(cgMethod
                    .getReturn().getType()));
        }
        
        //
        buf.append(";");

        // C#.NETɂ base()Lq݂܂B
        // if (BlancoStringUtil.null2Blank(cgMethod.getSuperclassInvocation())
        // .length() > 0) {
        // // getSuperclassInvocationɂ base(message)Ȃǂ̂悤ȋLڂȂ܂B
        // // TODO C#.NETł̋Lڂ\Ȃ̂̓RXgN^ł͗lłB
        // buf.append(" : " + cgMethod.getSuperclassInvocation());
        // }

        // C#.NETɂ͗OX[̃\bhC͂܂B
        // TODO OX[ hLgɏo͂邱Ƃɂ͈Ӌ`ƍl܂B

        if (cgMethod.getAbstract() || argIsInterface) {
            // ۃ\bh܂̓C^tF[X̏ꍇɂ́A\bh̖{̂WJ܂B
            buf.append(BlancoCgLineUtil.getTerminator(TARGET_LANG));
            argSourceLines.add(buf.toString());
        } else {
            // łAsmB
            argSourceLines.add(buf.toString());
        }
    }

    /**
     * Ame[VWJ܂B
     * 
     * @param cgMethod
     *            \bhB
     * @param argSourceLines
     *            \[XR[hB
     */
    private void expandAnnotationList(final BlancoCgMethod cgMethod,
            final List<java.lang.String> argSourceLines) {
        for (int index = 0; index < cgMethod.getAnnotationList().size(); index++) {
            final String strAnnotation = cgMethod.getAnnotationList()
                    .get(index);

            // C#.NETAnnotation []ŋLq܂B
            argSourceLines.add("[" + strAnnotation + "]");
        }
    }

    /**
     * p[^̔null̓WJB
     * 
     * @param cgMethod
     *            \bhB
     * @param argSourceLines
     *            \[XR[hB
     */
    private void expandParameterCheck(final BlancoCgMethod cgMethod,
            final BlancoCgSourceFile argSourceFile,
            final List<java.lang.String> argSourceLines) {
        boolean isProcessed = false;
        for (int index = 0; index < cgMethod.getParameterList().size(); index++) {
            final BlancoCgParameter cgParameter = cgMethod.getParameterList()
                    .get(index);
            if (cgParameter.getNotnull() && isNullableType(cgParameter.getType())) {
                isProcessed = true;
//                argSourceFile.getImportList().add("System.ArgumentException");

                argSourceLines.add(BlancoCgLineUtil.getIfBegin(TARGET_LANG,
                        cgParameter.getName() + " = nil"));
                argSourceLines.add("throw new ArgumentException(\"\bh["
                        + cgMethod.getName() + "]̃p[^["
                        + cgParameter.getName()
                        + "]null^܂BÃp[^null^邱Ƃ͂ł܂B\");");
                argSourceLines.add(BlancoCgLineUtil.getIfEnd(TARGET_LANG));
            }
        }

        if (isProcessed) {
            // p[^`FbNWJꂽꍇɂ͋s}܂B
            argSourceLines.add("");
        }
    }

    private boolean isNullableType(BlancoCgType type) {
        if("string".equals(type.getName().toLowerCase())){
            // Delphił́AStringnilƂ܂B
            return false;
        }
        return true;
    }

    /**
     * sWJ܂B
     * 
     * @param cgMethod
     *            \bhB
     * @param argSourceLines
     *            o͍sXgB
     */
    private void expandLineList(final BlancoCgMethod cgMethod,
            final List<java.lang.String> argSourceLines) {
        for (int indexLine = 0; indexLine < cgMethod.getLineList().size(); indexLine++) {
            final String strLine = cgMethod.getLineList().get(indexLine);
            argSourceLines.add(strLine);
        }
    }

    /**
     * \bh virtual C邩ǂ𔻒fB
     * 
     * @param cgMethod
     *            \bhB
     * @param argIsInterface
     *            C^tF[XǂB
     * @return truȅꍇɂ virtual CȂB
     */
    private boolean isVirtual(final BlancoCgMethod cgMethod,
            final boolean argIsInterface) {
        if (cgMethod.getAbstract() == false && cgMethod.getOverride() == false
                && cgMethod.getFinal() == false
                && cgMethod.getConstructor() == false
                && cgMethod.getStatic() == false && argIsInterface == false) {
            return true;
        }
        return false;
    }
}
