/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.transformer.delphi;

import java.util.ArrayList;
import java.util.List;

import blanco.cg.BlancoCgSupportedLang;
import blanco.cg.util.BlancoCgLineUtil;
import blanco.cg.util.BlancoCgSourceFileUtil;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgEnum;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoStringUtil;

/**
 * BlancoCgSourceFile\[XR[hɓWJ܂B
 * 
 * ̃NXblancoCg̃o[IuWFNg\[XR[hgXtH[}[̌ʂ̓WJ@\łB
 * 
 * @author IGA Tosiki
 */
class BlancoCgSourceFileDelphiSourceExpander {
    /**
     * ̃NXΏۂƂvO~OB
     */
    protected static final int TARGET_LANG = BlancoCgSupportedLang.CS;

    /**
     * ͂ƂȂ\[XR[h\B
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * ԓIɗp\[XR[h킷ListBjava.lang.StringXgɊi[܂B(BlancoCgLineł͂܂B
     * )
     * 
     * ł͐`O\[XR[hԓIɂ킦܂B
     */
    private List<java.lang.String> fSourceLines = null;

    /**
     * SourceFile琮`O\[XR[hXg𐶐܂B
     * 
     * @param argSourceFile
     *            \[XR[h킷o[IuWFNgB
     * @return \[XR[hɓWJ̃XgB
     */
    public List<java.lang.String> transformSourceFile(
            final BlancoCgSourceFile argSourceFile) {
        // mɃ\[Xs̃Xg܂B
        fSourceLines = new ArrayList<java.lang.String>();

        fCgSourceFile = argSourceFile;

        // \[Xt@C̃t@Cwb_[o͏܂B
        expandSourceFileHeader();

        //unitwfBO̐
        fSourceLines.add("unit " + fCgSourceFile.getName() + ";");
        fSourceLines.add("");
        
        // interface̐B
        if (BlancoStringUtil.null2Blank(fCgSourceFile.getPackage()).length() > 0) {
            fSourceLines.add("interface");
        }

        // ̌㔼usesҐȂ܂A̍ۂɎQƂAJ[ǉĂ܂B
        BlancoCgImportDelphiSourceExpander.insertAnchorString(fSourceLines);


        if (fCgSourceFile.getImportList() == null) {
            throw new IllegalArgumentException("import̃Xgnull^܂B");
        }

        // 񋓑̂̓WJ{܂B
        for (BlancoCgEnum cgEnum : fCgSourceFile.getEnumList()) {
            new BlancoCgEnumDelphiSourceExpander().transformEnum(cgEnum,
                    argSourceFile, fSourceLines);
        }

        // C^tF[X̓WJ{܂B
//        if (fCgSourceFile.getInterfaceList() == null) {
//            throw new IllegalArgumentException("C^tF[X̃Xgnull^܂B");
//        }
//        for (BlancoCgInterface cgInterface : fCgSourceFile.getInterfaceList()) {
//            new BlancoCgInterfaceCsSourceExpander().transformInterface(
//                    cgInterface, fCgSourceFile, fSourceLines);
//        }

        // NX̓WJ{܂B
        if (fCgSourceFile.getClassList() == null) {
            throw new IllegalArgumentException("NX̃Xgnull^܂B");
        }
        // typeZNV̊Jn
        fSourceLines.add("type");
        // typeZNV̊Jn
        for (BlancoCgClass cgClass : fCgSourceFile.getClassList()) {
            new BlancoCgClassDelphiSourceExpander().transformClass(cgClass,
                    fCgSourceFile, fSourceLines);
        }
        // typȅIBŝݏóB
        if (BlancoStringUtil.null2Blank(fCgSourceFile.getPackage()).length() > 0) {
            fSourceLines.add("");
        }

        
        // import̓WJ܂B
        // ̏ANXWJɎ{Ă̂ɂ͈Ӗ܂B
        // NXWJȂǂoāA߂ăC|[g̈ꗗm肷邩łB
        new BlancoCgImportDelphiSourceExpander().transformImport(fCgSourceFile,
                fSourceLines);

        return fSourceLines;
    }

    /**
     * \[Xt@C̃t@Cwb_[o͏܂B
     */
    private void expandSourceFileHeader() {
        // \[Xt@Cwb_[̃Rg XbVQÓƍl܂B

        if (BlancoStringUtil.null2Blank(fCgSourceFile.getDescription())
                .length() > 0) {
            fSourceLines.add(BlancoCgLineUtil
                    .getSingleLineCommentPrefix(TARGET_LANG)
                    + fCgSourceFile.getDescription());
        } else {
            // w肪ꍇɂ̓ftHg̃Rg𗘗p܂B
            for (String line : BlancoCgSourceFileUtil.getDefaultFileComment()) {
                fSourceLines.add(BlancoCgLineUtil
                        .getSingleLineCommentPrefix(TARGET_LANG)
                        + line);
            }
        }

        // hLg̒ԕ𐶐܂B
        new BlancoCgLangDocDelphiSourceExpander().transformLangDocBody(
                fCgSourceFile.getLangDoc(), fSourceLines, true);
    }
}
