/*
 * Decompiled with CFR 0.152.
 */
package jxl.biff.formula;

import jxl.WorkbookSettings;
import jxl.biff.StringHelper;
import jxl.biff.formula.Operand;
import jxl.biff.formula.ParsedThing;
import jxl.biff.formula.Token;
import jxl.common.Logger;

class StringValue
extends Operand
implements ParsedThing {
    private static final Logger logger = Logger.getLogger(StringValue.class);
    private String value;
    private WorkbookSettings settings;

    public StringValue(WorkbookSettings ws) {
        this.settings = ws;
    }

    public StringValue(String s) {
        this.value = s;
    }

    public int read(byte[] data, int pos) {
        int length = data[pos] & 0xFF;
        int consumed = 2;
        if ((data[pos + 1] & 1) == 0) {
            this.value = StringHelper.getString(data, length, pos + 2, this.settings);
            consumed += length;
        } else {
            this.value = StringHelper.getUnicodeString(data, length, pos + 2);
            consumed += length * 2;
        }
        return consumed;
    }

    byte[] getBytes() {
        byte[] data = new byte[this.value.length() * 2 + 3];
        data[0] = Token.STRING.getCode();
        data[1] = (byte)this.value.length();
        data[2] = 1;
        StringHelper.getUnicodeBytes(this.value, data, 3);
        return data;
    }

    public void getString(StringBuffer buf) {
        buf.append("\"");
        buf.append(this.value);
        buf.append("\"");
    }

    void handleImportedCellReferences() {
    }
}

