/*******************************************************************************
 * Blanco2g
 * Copyright (C) 2011 NTT DATA Business Brains
 * 
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *******************************************************************************/
/*******************************************************************************
 * Copyright (c) 2011 NTT DATA Business Brains and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *      NTT DATA Business Brains - initial API and implementation
 *******************************************************************************/
package blanco.struts;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * Annotation for Apache Struts Logic.
 * 
 * @author Toshiki IGA
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface BlancoStrutsLogic {
    /**
     * 結びつけられるフォーム。デフォルトだとロジックのクラス名から導出。
     * 
     * TODO execute の第二引数から導出可能なのでは?
     * 
     * @return
     */
    String form() default "";

    /**
     * ex: /hello
     * 
     * @return
     */
    String path();
}
