/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.transformer.delphi;

import java.util.List;

import blanco.cg.BlancoCgSupportedLang;
import blanco.cg.util.BlancoCgLineUtil;
import blanco.cg.util.BlancoCgSourceUtil;
import blanco.cg.valueobject.BlancoCgLangDoc;
import blanco.cg.valueobject.BlancoCgParameter;
import blanco.commons.util.BlancoStringUtil;

/**
 * BlancoCgLangDoc(hLg)\[XR[hɓWJ܂B
 * 
 * ̃NXblancoCg̃o[IuWFNg\[XR[hgXtH[}[̌ʂ̓WJ@\łB<br>
 * NXA\bhAtB[hȂǁAe팾hLgWJ鋤ʏłB
 * 
 * @author IGA Tosiki
 */
class BlancoCgLangDocDelphiSourceExpander {
    /**
     * ̃NXΏۂƂvO~OB
     */
    protected static final int TARGET_LANG = BlancoCgSupportedLang.CS;

    /**
     * hLgɃ\[XR[hWJ܂B
     * 
     * @param langDoc
     *            hLgB
     * @param argSourceLines
     *            \[XR[hB
     */
    public void transformLangDoc(final BlancoCgLangDoc langDoc,
            final List<java.lang.String> argSourceLines) {
        // JnEI{̂WJ܂B
        transformLangDocBody(langDoc, argSourceLines, false);
    }

    /**
     * hLĝA{̕WJ܂B
     * 
     * ̃\bh̓\[Xt@C̃t@Cwb_[WJpĂ܂B
     * 
     * @param langDoc
     * @param argSourceLines
     * @param isFileHeader
     *            t@Cwb_ǂB
     */
    public void transformLangDocBody(final BlancoCgLangDoc langDoc,
            final List<java.lang.String> argSourceLines,
            final boolean isFileHeader) {
        boolean isLangDocTitleStarted = false;

        String commentString = BlancoCgLineUtil
                .getSingleLineCommentPrefix(TARGET_LANG);

        if (BlancoStringUtil.null2Blank(langDoc.getTitle()).length() > 0) {
            isLangDocTitleStarted = true;
            argSourceLines.add(commentString
                    + BlancoCgSourceUtil.escapeStringAsLangDoc(TARGET_LANG,
                            langDoc.getTitle()));
        }

        // s}ς݂ǂ`FbN邽߂̃tOB
        boolean isLangDocDescriptionStarted = false;

        for (int indexDescription = 0; indexDescription < langDoc
                .getDescriptionList().size(); indexDescription++) {
            final String strDescrption = langDoc.getDescriptionList().get(
                    indexDescription);

            if (isLangDocDescriptionStarted == false) {
                if (isLangDocTitleStarted == false) {
                    isLangDocTitleStarted = true;
                    argSourceLines.add(commentString
                            + BlancoCgSourceUtil.escapeStringAsLangDoc(
                                    TARGET_LANG, strDescrption));
                } else {
                    isLangDocDescriptionStarted = true;
                    // argSourceLines.add(commentString + "<remarks>");
                    // argSourceLines.add(commentString + "<newpara>"
                    // + strDescrption + "</newpara>");
                }
            } else {
                argSourceLines.add(commentString + "@param " + strDescrption);
            }
        }

        // if (isLangDocDescriptionStarted) {
        // argSourceLines.add(commentString + "</remarks>");
        // }

        // TODO authorWJB

        // TODO authorȊO̓WJ邱ƁB

        // \bhp[^WJB
        for (int indexParameter = 0; indexParameter < langDoc
                .getParameterList().size(); indexParameter++) {
            final BlancoCgParameter cgParameter = langDoc.getParameterList()
                    .get(indexParameter);

            final StringBuffer bufParameter = new StringBuffer();
            bufParameter.append(commentString + "@param "
                    + cgParameter.getName());
            if (BlancoStringUtil.null2Blank(cgParameter.getDescription())
                    .length() > 0) {
                bufParameter.append(BlancoCgSourceUtil.escapeStringAsLangDoc(
                        TARGET_LANG, cgParameter.getDescription()));
            }
            argSourceLines.add(bufParameter.toString());
        }

        if (langDoc.getReturn() != null
                && langDoc.getReturn().getType().getName().equals("void") == false) {

            final StringBuffer bufReturn = new StringBuffer();
            bufReturn.append(commentString + "@return ");
            if (BlancoStringUtil.null2Blank(
                    langDoc.getReturn().getDescription()).length() > 0) {
                bufReturn.append(BlancoCgSourceUtil.escapeStringAsLangDoc(
                        TARGET_LANG, langDoc.getReturn().getDescription()));
            }
            argSourceLines.add(bufReturn.toString());
        }

        // throwsXgWJ C#.NETɂ݂͑܂B
        // TODO throwXgWJɂāAhLg̐ւƓWJ邱ƁB
    }
}
