package blanco.eclipseast2cg;

import java.util.ArrayList;
import java.util.List;

import junit.framework.TestCase;

import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.SimpleType;

import blanco.commons.util.BlancoNameUtil;

public class SimpleASTTest extends TestCase {
    public void testAst() throws Exception {
        List<String> importList = new ArrayList<String>();
        importList.add("java.util.Map");

        System.out.println("結果: " + toFullyQualifiedClassName("String", "sample", importList));

        System.out.println("結果: " + toFullyQualifiedClassName("Map<String, String>", "sample", importList));
        System.out.println("結果: "
                + toFullyQualifiedClassName("Map<String, Map<String, Integer>>", "sample", importList));

        System.out.println("結果: " + toFullyQualifiedClassName("String[]", "sample", importList));
        System.out.println("結果: " + toFullyQualifiedClassName("Integer[][]", "sample", importList));
    }

    public static String toFullyQualifiedClassName(final String localClassName, final String currentPackage,
            final List<String> importList) {
        final StringBuilder fqcnName = new StringBuilder();
        toFullyQualifiedClassName(localClassName, currentPackage, importList, fqcnName);
        return fqcnName.toString();
    }

    private static void toFullyQualifiedClassName(final String localClassName, final String currentPackage,
            final List<String> importList, final StringBuilder resultFqcnBuilder) {
        final String sourceCode = "public class ToFullyQualifiedClassName {public " + localClassName + " dummyField;}";

        final ASTParser parser = ASTParser.newParser(AST.JLS3);
        parser.setSource(sourceCode.toCharArray());
        final CompilationUnit unit = (CompilationUnit) parser.createAST(new NullProgressMonitor());

        unit.accept(new ASTVisitor() {
            @Override
            public boolean visit(final FieldDeclaration node) {

                if (node.getType() instanceof SimpleType) {
                    final SimpleType type = (SimpleType) node.getType();
                    // FQCN に加工
                    resultFqcnBuilder.append(getFullyQualifiedTypeName(type.getName().toString(), currentPackage,
                            importList));
                } else if (node.getType() instanceof ParameterizedType) {
                    final ParameterizedType t = (ParameterizedType) node.getType();
                    // FQCN に加工
                    resultFqcnBuilder.append(getFullyQualifiedTypeName(t.getType().toString(), currentPackage,
                            importList));
                    resultFqcnBuilder.append("<");
                    boolean isFirst = true;
                    for (Object obj : t.typeArguments()) {
                        if (isFirst) {
                            isFirst = false;
                        } else {
                            resultFqcnBuilder.append(", ");
                        }
                        // 再帰呼出
                        toFullyQualifiedClassName(obj.toString(), currentPackage, importList, resultFqcnBuilder);
                    }
                    resultFqcnBuilder.append(">");
                } else if (node.getType() instanceof ArrayType) {
                    final ArrayType t = (ArrayType) node.getType();
                    // TODO ここで FQCN に加工
                    resultFqcnBuilder.append(getFullyQualifiedTypeName(t.getElementType().toString(), currentPackage,
                            importList));
                    for (int index = 0; index < t.getDimensions(); index++)
                        resultFqcnBuilder.append("[]");
                } else {
                    System.out.println("サポート外: " + node.getType().getClass());
                }

                return super.visit(node);
            }
        });
    }

    /**
     * Java プログラミング言語の予約語一覧。
     */
    private static final String[] LANGUAGE_RESERVED_KEYWORD = { "void", "byte", "short", "int", "long", "char",
            "float", "double", "boolean" };

    private static String getFullyQualifiedTypeName(final String localName, final String currentPackage,
            final List<String> importList) {

        for (String importValue : importList) {
            if (BlancoNameUtil.trimJavaPackage(importValue).equals(localName)) {
                return BlancoNameUtil.trimFileExtension(importValue) + "." + localName;
            }
        }

        try {
            Class.forName("java.lang." + localName);
            // java.lang 以下のパッケージ名省略に該当します。
            return "java.lang." + localName;
        } catch (ClassNotFoundException ex) {
            for (String keyword : LANGUAGE_RESERVED_KEYWORD) {
                if (keyword.equals(localName))
                    return localName;
            }

            return currentPackage + "." + localName;
        }
    }
}
