/*******************************************************************************
 * blanco Framework
 * Copyright (C) 2012 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *******************************************************************************/
/*******************************************************************************
 * Copyright (c) 2012 NTT DATA BUSINESS BRAINS CORPORATION and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *      NTT DATA BUSINESS BRAINS CORPORATION - initial API and implementation
 *******************************************************************************/
package blanco.db.tableaccessor;

import java.util.ArrayList;
import java.util.List;

import blanco.gettersetter.BlancoGetterSetter;
import blanco.noop.BlancoNoop;

/**
 * DB テーブルアクセサが内部的に利用する出力先クラス情報。
 * 
 * @author Toshiki Iga
 */
@BlancoNoop
public class AbstractBlancoDbTableAccessorTargetInfo {
	/**
	 * SQL 定義 ID
	 */
	@BlancoGetterSetter
	protected String sqldefid;

	/**
	 * パッケージ名。
	 */
	@BlancoGetterSetter
	protected String packageName;

	@BlancoGetterSetter
	protected String description;

	/**
	 * 表の名称
	 */
	@BlancoGetterSetter
	protected String tableName;

	/**
	 * SQL 種類
	 */
	@BlancoGetterSetter
	protected String sqlType;

	/**
	 * 除外列 (加工後)
	 */
	@BlancoGetterSetter(setter = false)
	protected List<String> excludeColumnList = new ArrayList<String>();

	/**
	 * 楽観的ロックのためのフィールド名。
	 */
	@BlancoGetterSetter
	protected String fieldNameForOptimisticLock = null;
}
