/*******************************************************************************
 * blanco Framework
 * Copyright (C) 2004-2012 Toshiki IGA
 * 
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *******************************************************************************/
/*******************************************************************************
 * Copyright (c) 2004-2012 Toshiki IGA and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 * 
 * Contributors:
 *      Toshiki IGA - initial API and implementation
 *******************************************************************************/
/*******************************************************************************
 * Copyright 2004-2012 Toshiki IGA and others.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 * 
 *     http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *******************************************************************************/
package blanco.mail.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Properties;

import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeUtility;

import blanco.commons.util.BlancoStringUtil;
import blanco.mail.core.resourcebundle.BlancoMailCoreMessageResourceBundle;
import blanco.mail.core.valueobject.BlancoMailAddress;
import blanco.mail.core.valueobject.BlancoMailSetting;
import blanco.unicode.util.BlancoUnicodeUtil;

/**
 * [MA[MŋʓIɗp@\B
 * 
 * IȋʃNX̂߁ApublicNXƂ܂B
 * 
 * @author IGA Tosiki
 */
class BlancoMailCoreUtil {
    /**
     * RXgN^͉B܂B
     */
    private BlancoMailCoreUtil() {
    }

    /**
     * [T[oڑ̂߂̃ZbVIuWFNgECX^X擾܂B
     * 
     * Kvȃ[UEpX[h̐ݒɂĂÃ\bhŎ{܂B
     * 
     * @param argSetting
     *            blancoMail̊eݒ킷o[IuWFNgBT[oڑݒ⑗M̃ftHglȂǂi[܂B()̃NX̃CX^X
     *            BlancoMailSettingFactory NX擾ĂB
     * @param argProps
     *            ڑ̂߂ɗpvpeBݒlBJavaMail API̎dlɂ́B
     * @return ZbVIuWFNgB
     */
    static Session getSendSession(final BlancoMailSetting argSetting,
            final Properties argProps) {
    	if (argSetting.getSendUserName() == null || argSetting.getSendUserName().length() == 0) {
    		// [U[F؂̎w肪ꍇB
            return Session.getInstance(argProps);
    	}

    	// [U[F؂̎w肪ꍇB
        return Session.getInstance(argProps, new Authenticator() {
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(argSetting.getSendUserName(),
                        argSetting.getSendPassword());
            }
        });
    }

    /**
     * [T[oڑ̂߂̃ZbVIuWFNgECX^X擾܂B
     * 
     * Kvȃ[UEpX[h̐ݒɂĂÃ\bhŎ{܂B
     * 
     * @param argSetting
     *            blancoMail̊eݒ킷o[IuWFNgBT[oڑݒ⑗M̃ftHglȂǂi[܂B()̃NX̃CX^X
     *            BlancoMailSettingFactory NX擾ĂB
     * @param argProps
     *            ڑ̂߂ɗpvpeBݒlBJavaMail API̎dlɂ́B
     * @return ZbVIuWFNgB
     */
    static Session getReceiveSession(final BlancoMailSetting argSetting,
            final Properties argProps) {
        return Session.getInstance(argProps, new Authenticator() {
            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(argSetting
                        .getReceiveUserName(), argSetting.getReceivePassword());
            }
        });
    }

    /**
     * ZbVOJnāȀo̓Xg[擾܂B
     * 
     * ̃\bhĂяoꂽꍇɂ́AɃZbVfobOONɐݒ肵܂B[Session.setDebug(true)]
     * ÃZbVfobO  Iɕێ (Ė߂lƂĖ߂)
     * ByteArrayOutputStreamɃ_CNg܂BWo͂ɂ̓ZbVfobO͏o͂܂B
     * ByteArrayOutputStreamɃ_CNgꂽZbVfobOeZbVOt@Cɏo͂邩ǂ́AĂяoŌ肷邱ƂłB
     * 
     * ȂA\bh̖߂lƂĖ߂̂ SessionIuWFNg ZbVfobOł PrintStreamł͂ȂAI
     * ByteArrayOutputStream IuWFNgłB
     * 
     * @param argSetting
     *            blancoMail̊eݒ킷o[IuWFNgBT[oڑݒ⑗M̃ftHglȂǂi[܂B()̃NX̃CX^X
     *            BlancoMailSettingFactory NX擾ĂB
     * @param argSession
     *            JavaMail APĨZbVIuWFNgB
     * @return IɌѕtɗpPrintStreamɗ^ByteArrayOutputStream߂܂BnullȊO߂Ăꍇɂ́AŌɃOt@Cւ̏ݏ{ĂB
     * @throws IOException
     *             o͗OꍇB
     */
    static ByteArrayOutputStream beginSessionLogOutputStream(
            final BlancoMailSetting argSetting, final Session argSession)
            throws IOException {
        // ɃZbVfobOoCgXg[Ƀ_CNg܂B
        final ByteArrayOutputStream resultOutStream = new ByteArrayOutputStream(
                8192);

        final PrintStream logStream = new PrintStream(resultOutStream, false,
                argSetting.getSendEncoding());
        argSession.setDebugOut(logStream);

        // Wo͂ւ̃fobOoONݒ Ŏ{܂B
        // ̃^C~OŃfobOoONݒŝɂ͗R܂B
        // OXg[ZbgĂfobOONɂȂƁAWo͂ɂPso[W񂪏oĂ܂̂łB
        // ̂߁ȀꏊɃfobOoONݒ̋LqĂ͕̂KvȂƂłB
        argSession.setDebug(true);

        return resultOutStream;
    }

    /**
     * BlancoMailAddress  InternetAddress 쐬܂B
     * 
     * @param argSetting
     *            blancoMail̊eݒ킷o[IuWFNgBT[oڑݒ⑗M̃ftHglȂǂi[܂B()̃NX̃CX^X
     *            BlancoMailSettingFactory NX擾ĂB
     * @param argAddress
     *            blancoMailCore API ̃AhXIuWFNgB
     * @return JavaMail API ̃C^[lbgAhXIuWFNgB
     * @throws UnsupportedEncodingException
     *             T|[gȂGR[fBO^ꂽꍇB̓Iɂ̓\[Xoh̕GR[fBO̎w~XȂǂ̏ꍇɔ邱Ƃl܂B
     * @throws AddressException
     *             AhXɊւOꍇB
     */
    static InternetAddress toInternetAddress(
            final BlancoMailSetting argSetting,
            final BlancoMailAddress argAddress)
            throws UnsupportedEncodingException, AddressException {
        if (argAddress.getPersonal() != null) {
            // [UꍇB
        	String userName = argAddress.getPersonal();
        	if (argSetting.getSendEncodingNormalizeUnicode()) {
        		// Unicode KsȂꍇ
        		userName = BlancoUnicodeUtil.normalizeUnicode(userName);
        	}
            return new InternetAddress(argAddress.getAddress(), userName, argSetting.getSendEncoding());
        } else {
            // [UꍇB
            return new InternetAddress(argAddress.getAddress());
        }
    }

    /**
     * InternetAddress  BlancoMailAddress 쐬܂B
     * 
     * @param argAddress
     *            JavaMail API ̃C^[lbgAhXIuWFNgB
     * @return blancoMailCore API ̃AhXIuWFNgB
     */
    static BlancoMailAddress toBlancoMailAddress(
            final InternetAddress argAddress) {
        final BlancoMailAddress address = new BlancoMailAddress();
        address.setAddress(argAddress.getAddress());
        if (argAddress.getPersonal() != null
                && argAddress.getPersonal().length() > 0) {
            try {
                // [UZbgB
                address.setPersonal(MimeUtility.decodeText(argAddress
                        .getPersonal()));
            } catch (UnsupportedEncodingException e) {
                // [ŨfR[hɎsꍇA̗O͖邱ƂƂ܂B
                // ́A[ŨfR[hsƂĂA{Iȏɂ͉eȂ̂ƍlĂ邩łB

                // TODO ÕVXeꂽA̗Oe̓Oɏo͂悤ɕύXĂB܂ł͖܂B
            }
        }

        return address;
    }

    /**
     * [Mŋʂ BlancoMailSetting̐ݒe`FbNB
     * 
     * @param argSetting
     *            blancoMail̊eݒ킷o[IuWFNgBT[oڑݒ⑗M̃ftHglȂǂi[܂B()̃NX̃CX^X
     *            BlancoMailSettingFactory NX擾ĂB
     */
    static void checkSetting(final BlancoMailSetting argSetting) {
        if (argSetting == null) {
            throw new IllegalArgumentException(
                    "BlancoMailCoreUtil#checkSetting: \bh̃p[^(argSetting) nulln܂B̃IuWFNg nullłĂ͂Ȃ܂B");
        }

        final BlancoMailCoreMessageResourceBundle msg = new BlancoMailCoreMessageResourceBundle();

        // OfBNg֘Ã`FbN
        // SESSION_LOG_DIRECTORY_ERROR
        if (BlancoStringUtil.null2Blank(
                argSetting.getSessionLogDirectoryError()).length() > 0) {
            final File fileCheck = new File(argSetting
                    .getSessionLogDirectoryError());
            if (fileCheck.exists() == false) {
                if (fileCheck.mkdirs() == false) {
                    throw new IllegalArgumentException(msg
                            .getMbmcz101(argSetting
                                    .getSessionLogDirectoryError()));
                }
            } else {
                if (fileCheck.isDirectory() == false) {
                    throw new IllegalArgumentException(msg
                            .getMbmcz102(argSetting
                                    .getSessionLogDirectoryError()));
                }
            }
        }

        // SESSION_LOG_DIRECTORY_SUCCESS
        if (BlancoStringUtil.null2Blank(
                argSetting.getSessionLogDirectorySuccess()).length() > 0) {
            final File fileCheck = new File(argSetting
                    .getSessionLogDirectorySuccess());
            if (fileCheck.exists() == false) {
                if (fileCheck.mkdirs() == false) {
                    throw new IllegalArgumentException(msg
                            .getMbmcz103(argSetting
                                    .getSessionLogDirectorySuccess()));
                }
            } else {
                if (fileCheck.isDirectory() == false) {
                    throw new IllegalArgumentException(msg
                            .getMbmcz104(argSetting
                                    .getSessionLogDirectorySuccess()));
                }
            }
        }

        if (argSetting.getTestMode()) {
            // eXg[h̏ꍇɂ̂݃fBNgݒl`FbN܂B
            if (BlancoStringUtil.null2Blank(
                    argSetting.getTestModeLogDirectorySend()).length() > 0) {
                final File fileCheck = new File(argSetting
                        .getTestModeLogDirectorySend());
                if (fileCheck.exists() == false) {
                    if (fileCheck.mkdirs() == false) {
                        throw new IllegalArgumentException(msg
                                .getMbmcz105(argSetting
                                        .getTestModeLogDirectorySend()));
                    }
                } else {
                    if (fileCheck.isDirectory() == false) {
                        throw new IllegalArgumentException(msg
                                .getMbmcz106(argSetting
                                        .getTestModeLogDirectorySend()));
                    }
                }
            }

            if (BlancoStringUtil.null2Blank(
                    argSetting.getTestModeLogDirectoryReceive()).length() > 0) {
                final File fileCheck = new File(argSetting
                        .getTestModeLogDirectoryReceive());
                if (fileCheck.exists() == false) {
                    if (fileCheck.mkdirs() == false) {
                        throw new IllegalArgumentException(msg
                                .getMbmcz107(argSetting
                                        .getTestModeLogDirectoryReceive()));
                    }
                } else {
                    if (fileCheck.isDirectory() == false) {
                        throw new IllegalArgumentException(msg
                                .getMbmcz108(argSetting
                                        .getTestModeLogDirectoryReceive()));
                    }
                }
            }
        }
    }
}
