package blanco.valueobjectfactory.task;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;

import javax.xml.transform.TransformerException;

import blanco.resourcebundle.BlancoResourceBundleMeta2Xml;
import blanco.valueobject.BlancoValueObjectMeta2Xml;
import blanco.valueobjectfactory.BlancoValueObjectFactoryConstants;
import blanco.valueobjectfactory.BlancoValueObjectFactoryMeta2Xml;
import blanco.valueobjectfactory.BlancoValueObjectFactoryXml2SourceFile;
import blanco.valueobjectfactory.resourcebundle.BlancoValueObjectFactoryResourceBundle;
import blanco.valueobjectfactory.task.valueobject.BlancoValueObjectFactoryProcessInput;

public class BlancoValueObjectFactoryProcessImpl implements
		BlancoValueObjectFactoryProcess {

	/**
	 * ̃v_Ng̃\[Xohւ̃ANZXIuWFNgB
	 */
	private final BlancoValueObjectFactoryResourceBundle fBundle = new BlancoValueObjectFactoryResourceBundle();

	/**
	 * `(XLS)\[XR[hApache Ant^XÑGg|CgłB
	 */
	@Override
	public int execute(final BlancoValueObjectFactoryProcessInput input)
			throws IOException, IllegalArgumentException {
		System.out.println("- "
				+ BlancoValueObjectFactoryConstants.PRODUCT_NAME + " ("
				+ BlancoValueObjectFactoryConstants.VERSION + ")");

		try {
			final File fileMetadir = new File(input.getMetadir());
			if (fileMetadir.exists() == false) {
				throw new IllegalArgumentException(
						fBundle.getAnttaskErr001(input.getMetadir()));
			}

			// e|fBNg쐬B
			new File(input.getTmpdir()
					+ BlancoValueObjectFactoryConstants.TARGET_SUBDIRECTORY)
					.mkdirs();

			final HashMap valueObjectMap = new HashMap();
			final HashMap resourceBundleMap = new HashMap();

			{
				// ̉ߒŕKvƂȂValueObjectNX̃e|B
				new File(input.getTmpdir()
						+ BlancoValueObjectFactoryConstants.TARGET_SUBDIRECTORY
						+ "/valueobject").mkdirs();

				// Ƀo[IuWFNg`͂܂B
				new BlancoValueObjectMeta2Xml()
						.processDirectory(
								fileMetadir,
								input.getTmpdir()
										+ BlancoValueObjectFactoryConstants.TARGET_SUBDIRECTORY
										+ "/valueobject");

				// o[IuWFNg`WJ
				// nbVɋLĂ
				BlancoValueObjectFactoryXml2SourceFile
						.processBlancoValueObjectXmlDirectory(
								new File(
										input.getTmpdir()
												+ BlancoValueObjectFactoryConstants.TARGET_SUBDIRECTORY
												+ "/valueobject"),
								valueObjectMap);
			}

			{
				// ̉ߒŕKvƂȂResourceBundleNX̃e|B
				new File(input.getTmpdir()
						+ BlancoValueObjectFactoryConstants.TARGET_SUBDIRECTORY
						+ "/resourcebundle").mkdirs();

				// Ƀ\[Xoh`͂܂B
				new BlancoResourceBundleMeta2Xml()
						.processDirectory(
								fileMetadir,
								input.getTmpdir()
										+ BlancoValueObjectFactoryConstants.TARGET_SUBDIRECTORY
										+ "/resourcebundle");

				// \[Xoh`WJ
				// nbVɋLĂ
				BlancoValueObjectFactoryXml2SourceFile
						.processBlancoResourceBundleXmlDirectory(
								new File(
										input.getTmpdir()
												+ BlancoValueObjectFactoryConstants.TARGET_SUBDIRECTORY
												+ "/resourcebundle"),
								resourceBundleMap);
			}

			// w肳ꂽ^fBNg܂B
			new BlancoValueObjectFactoryMeta2Xml()
					.processDirectory(
							fileMetadir,
							input.getTmpdir()
									+ BlancoValueObjectFactoryConstants.TARGET_SUBDIRECTORY);

			// XMLꂽԃt@C\[XR[h𐶐
			final File[] fileMeta2 = new File(input.getTmpdir()
					+ BlancoValueObjectFactoryConstants.TARGET_SUBDIRECTORY)
					.listFiles();
			for (int index = 0; index < fileMeta2.length; index++) {
				if (fileMeta2[index].getName().endsWith(".xml") == false) {
					continue;
				}

				new BlancoValueObjectFactoryXml2SourceFile().process(
						fileMeta2[index], valueObjectMap, resourceBundleMap,
						new File(input.getTargetdir()));
			}
		} catch (IOException ex) {
			throw new IllegalArgumentException(ex.toString());
		} catch (TransformerException ex) {
			throw new IllegalArgumentException(ex.toString());
		} catch (IllegalArgumentException ex) {
			ex.printStackTrace();
			throw ex;
		}

		return 0;
	}

	@Override
	public boolean progress(String argProgressMessage) {
		// TODO Auto-generated method stub
		return false;
	}

}
