/*
 * blancoDb
 * Copyright (C) 2004-2006 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.util;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.db.common.stringgroup.BlancoDbDriverNameStringGroup;
import blanco.db.common.stringgroup.BlancoDbLoggingModeStringGroup;
import blanco.db.common.util.BlancoDbUtil;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.expander.query.BlancoPerfomanceCommonUtil;

/**
 * blancoDbʓIɗp郆[eBeBNXB
 * 
 * ̃NXNXblancoDb\[XR[hŗp܂
 * 
 * @since 2006.03.02
 * @author IGA Tosiki
 */
public class BlancoDbUtilClassJava {
    /**
     * ̃NXg̃NX
     */
    public static final String CLASS_NAME = "BlancoDbUtil";

    /**
     * blancoCg IuWFNgt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * ̃NX܂܂\[XR[hB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    private BlancoDbSetting fDbSetting = null;

    public BlancoDbUtilClassJava(final BlancoCgObjectFactory cgFactory,
            final String argPackage, final BlancoDbSetting argDbSetting) {
        fCgFactory = cgFactory;
        fCgSourceFile = fCgFactory.createSourceFile(argPackage,
                "This code is generated by blanco Framework.");

        this.fDbSetting = argDbSetting;
    }

    public BlancoCgSourceFile expand() {
        final BlancoCgClass cgClass = fCgFactory.createClass(CLASS_NAME, null);
        fCgSourceFile.getClassList().add(cgClass);

        {
            final List<String> listDesc = cgClass.getLangDoc()
                    .getDescriptionList();

            listDesc.add("blancoDbʓIɗp郆[eBeBNXB");
            listDesc.add("");
            listDesc.add("̃NXblancoDb\[XR[hŗp܂ <br>");
            listDesc
                    .add("̃NX blancoDb\[XR[h痘p܂BڌĂяoƂ͐܂B");
            listDesc.add("");
            listDesc.add("@since 2006.03.02");
            listDesc.add("@author blanco Framework");
        }

        {
            boolean fIsSQLServer = false;
            final boolean IS_DEBUG = false;

            fCgSourceFile.getImportList().add(
                    BlancoDbUtil.getRuntimePackage(fDbSetting)
                            + ".exception.IntegrityConstraintException");
            fCgSourceFile.getImportList().add(
                    BlancoDbUtil.getRuntimePackage(fDbSetting)
                            + ".exception.DeadlockException");
            fCgSourceFile.getImportList().add(
                    BlancoDbUtil.getRuntimePackage(fDbSetting)
                            + ".exception.TimeoutException");
            fCgSourceFile.getImportList().add("java.sql.SQLException");

            switch (fDbSetting.getDriverName()) {
            case BlancoDbDriverNameStringGroup.SQLSERVER_2000:
            case BlancoDbDriverNameStringGroup.SQLSERVER_2005:
                fIsSQLServer = true;
                if (IS_DEBUG) {
                    System.out.println("TRACE: SQL ServerłB");
                }
                break;
            default:
                if (IS_DEBUG) {
                    System.out.println("TRACE: SQL ServerłBhCol("
                            + fDbSetting.getDriverName() + "]");
                }
                break;
            }

            final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                    "convertToBlancoException", null);
            cgClass.getMethodList().add(cgMethod);

            cgMethod.setStatic(true);

            final List<String> listDesc = cgMethod.getLangDoc()
                    .getDescriptionList();

            listDesc.add("SQLOblanco FrameworkOIuWFNgɕϊ܂B<br>");
            listDesc.add("");

            if (fIsSQLServer) {
                listDesc
                        .add("Microsoft SQL Server 2000/2005p̔ǉĐĂ܂B<br>");
            }
            listDesc
                    .add("SQLÔȂŁAblanco Framework̗OIuWFNgɕϊׂ̂ɂĕϊ܂B<br>");
            listDesc.add("ϊׂ悪ꍇɂ́Â܂܌̃IuWFNgԋp܂B");

            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("ex", "java.sql.SQLException",
                            "JDBCԋpꂽOIuWFNgB"));
            cgMethod
                    .setReturn(fCgFactory
                            .createReturn(
                                    "java.sql.SQLException",
                                    "ϊSQLOIuWFNgBSQLException܂͂̌pNXł IntegrityConstraintException, DeadlockException, TimeoutException߂܂B"));

            final List<String> listLine = cgMethod.getLineList();

            listLine.add("if (ex.getSQLState() != null) {");
            listLine.add("if (ex.getSQLState().startsWith(\"23\")) {");
            listLine
                    .add("final IntegrityConstraintException exBlanco = new IntegrityConstraintException(\"f[^x[XᔽɂύXs܂B\" + ex.toString(), ex.getSQLState(), ex.getErrorCode());");
            listLine.add("exBlanco.initCause(ex);");
            listLine.add("return exBlanco;");
            listLine.add("} else if (ex.getSQLState().equals(\"40001\")) {");
            listLine
                    .add("final DeadlockException exBlanco = new DeadlockException(\"f[^x[XfbhbNɂύXs܂B\" + ex.toString(), ex.getSQLState(), ex.getErrorCode());");
            listLine.add("exBlanco.initCause(ex);");
            listLine.add("return exBlanco;");
            listLine.add("} else if (ex.getSQLState().equals(\"HYT00\")) {");
            listLine
                    .add("final TimeoutException exBlanco = new TimeoutException(\"f[^x[X^CAEgɂύXs܂B\" + ex.toString(), ex.getSQLState(), ex.getErrorCode());");
            listLine.add("exBlanco.initCause(ex);");
            listLine.add("return exBlanco;");

            if (fIsSQLServer) {
                // bN^CAEgŗL̔B
                // ̏ SQL Server 2000/2005ɂĂ̂ݗLłB
                // SQL Server 2000/2005̏ꍇɂ̂݁ALockTimeoutException܂B
                fCgSourceFile.getImportList().add(
                        BlancoDbUtil.getRuntimePackage(fDbSetting)
                                + ".exception.LockTimeoutException");
                listLine
                        .add("} else if (ex.getSQLState().equals(\"HY000\") && ex.getErrorCode() == 1222) {");
                listLine.add("// SQL ServerŗL̃bN^CAEgOR[h̔s܂B");
                listLine
                        .add("final LockTimeoutException exBlanco = new LockTimeoutException(\"f[^x[XbN^CAEgɂύXs܂B\" + ex.toString(), ex.getSQLState(), ex.getErrorCode());");
                listLine.add("exBlanco.initCause(ex);");
                listLine.add("return exBlanco;");
            }
            listLine.add("}");
            listLine.add("}");
            listLine.add("return ex;");
        }

        {
            final BlancoCgMethod cgMethod = fCgFactory.createMethod(
                    "convertTimestampToDate", "JDBCTimestampDate^ɕϊ܂B");
            cgClass.getMethodList().add(cgMethod);

            cgMethod.setStatic(true);
            cgMethod.setFinal(true);
            cgMethod.getLangDoc().getDescriptionList().add(
                    "java.sql.Timestamp^java.util.Date^ւƕϊ܂B<br>");
            cgMethod.getLangDoc().getDescriptionList().add(
                    "̃\bh blancoDb\[XR[h痘p܂BڌĂяoƂ͐܂B");

            cgMethod.getParameterList().add(
                    fCgFactory.createParameter("argTimestamp",
                            "java.sql.Timestamp", "JDBCTimestamp^^܂B"));
            cgMethod.setReturn(fCgFactory.createReturn("java.util.Date",
                    "ϊjava.util.Date^߂܂B"));

            final List<String> listLine = cgMethod.getLineList();

            listLine.add("if (argTimestamp == null) {");
            listLine.add("return null;");
            listLine.add("}");
            listLine.add("return new Date(argTimestamp.getTime());");
        }

        if (fDbSetting.getLogging()) {
            switch (fDbSetting.getLoggingMode()) {
            case BlancoDbLoggingModeStringGroup.PERFORMANCE:
            case BlancoDbLoggingModeStringGroup.SQLID:
                BlancoPerfomanceCommonUtil.addPerfomanceFieldMethod(fCgFactory,
                        fCgSourceFile, cgClass);
                break;
            }
        }

        return fCgSourceFile;
    }
}
