/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
/*******************************************************************************
 * Copyright (c) 2009 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
package blanco.xml.bind;

import java.util.Stack;

import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

import blanco.xml.bind.valueobject.BlancoXmlAttribute;
import blanco.xml.bind.valueobject.BlancoXmlCdata;
import blanco.xml.bind.valueobject.BlancoXmlCharacters;
import blanco.xml.bind.valueobject.BlancoXmlComment;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlDtd;
import blanco.xml.bind.valueobject.BlancoXmlElement;
import blanco.xml.bind.valueobject.BlancoXmlIgnorableWhitespace;
import blanco.xml.bind.valueobject.BlancoXmlLocator;
import blanco.xml.bind.valueobject.BlancoXmlNode;
import blanco.xml.bind.valueobject.BlancoXmlPrefixMapping;

/**
 * XML  blancoXmlBinding ̃o[IuWFNg\𐶐邽߂̃RecnhłB
 * 
 * ̃NX XML/o[IuWFNg}bsO (X/O}bsO) blancoXmlBinding ̈ꕔłB
 * 
 * javax.xml.transform.sax.TransformerHandler ̗ԂɂȂ܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoXmlUnmarshallerContentHandler implements ContentHandler,
        LexicalHandler, DTDHandler {
    /**
     * ̂߂Ȃǂɕ̃LbVȂǂ܂Aނ눫܂B<br>
     * _ł͏׍H͂ɁẢPɒ͂邱ƂƂ܂B
     * 
     * ʂ̂Ȃ́Aȉ̂悤 Map 񋤗LB // private Map<String, String>
     * fStringMap = new HashMap<String, String>();
     */

    /**
     * [ghLgL܂B
     */
    protected final BlancoXmlDocument fDocument = new BlancoXmlDocument();

    /**
     * ݏ̃|CgL܂B
     */
    protected final Stack<BlancoXmlNode> fDocumentElementStack = new Stack<BlancoXmlNode>();

    /**
     * RegnhIuWFNgVK쐬܂B
     */
    public BlancoXmlUnmarshallerContentHandler() {
        fDocumentElementStack.push(fDocument);
    }

    /**
     * [ghLg擾܂B
     * 
     * @return XML hLgB
     */
    public BlancoXmlDocument getDocument() {
        return fDocument;
    }

    // ------------------------------------------------
    //  ContentHandler ̂߂̃\bhB
    // ------------------------------------------------

    /**
     * ContentHandler ̃hLgJnCxgB
     */
    public void startDocument() throws SAXException {
        // pushς݂łB
    }

    /**
     * ContentHandler ̃hLgICxgB
     */
    public void endDocument() throws SAXException {
        fDocumentElementStack.pop();
    }

    /**
     * ContentHandler ̃P[^CxgB
     * 
     * @param argLocator
     *            SAX hLgCxg̈ʒuB
     */
    public void setDocumentLocator(final Locator argLocator) {
        final BlancoXmlLocator locator = new BlancoXmlLocator();

        // ݏ̃IuWFNg擾܂B
        final BlancoXmlNode objCurrent = fDocumentElementStack.peek();
        if (objCurrent instanceof BlancoXmlDocument == false) {
            throw new IllegalArgumentException(
                    "BlancoXmlUnmarshallerContentHandler: Documentł͂Ȃ̂ɑ΂ LocatorZbg悤Ƃ܂B");
        }

        ((BlancoXmlDocument) objCurrent).setLocator(locator);

        locator.setPublicId(argLocator.getPublicId());
        locator.setSystemId(argLocator.getSystemId());
        locator.setLineNumber(argLocator.getLineNumber());
        locator.setColumnNumber(argLocator.getColumnNumber());
    }

    /**
     * ContentHandler  PrefixMapping JnCxgB
     * 
     * @param prefix
     *            OԃvtBbNXB
     * @param uri
     *            vtBbNX}bvꂽO URIB
     */
    public void startPrefixMapping(final String prefix, final String uri)
            throws SAXException {
        final BlancoXmlPrefixMapping prefixMapping = new BlancoXmlPrefixMapping();
        prefixMapping.setPrefix(prefix);
        prefixMapping.setUri(uri);

        // ݏ̃IuWFNg擾܂B
        final BlancoXmlNode objCurrent = fDocumentElementStack.peek();
        if (objCurrent instanceof BlancoXmlDocument) {
            ((BlancoXmlDocument) objCurrent).getPrefixMappings().add(
                    prefixMapping);
        } else if (objCurrent instanceof BlancoXmlElement) {
            // vf̏ꍇ startPrefixMapping ͖܂B
        } else {
            throw new IllegalArgumentException(
                    "BlancoXmlUnmarshallerContentHandler: Document ł Element łȂ̂ɑ΂ prefixMapping Zbg悤Ƃ܂B");
        }
    }

    /**
     * ContentHandler  PrefixMapping ICxgB
     * 
     * @param prefix
     *            OԃvtBbNXB
     */
    public void endPrefixMapping(final String prefix) throws SAXException {
    }

    /**
     * ContentHandler ̗vfJnCxgB
     * 
     * @param uri
     *            vtBbNX}bvꂽO URIB
     * @param localName
     *            [JB
     * @param qName
     *            vtBbNXtCB
     * @param atts
     *            Agr[gꗗB
     */
    public void startElement(final String uri, final String localName,
            final String qName, final Attributes atts) throws SAXException {
        final BlancoXmlElement element = new BlancoXmlElement();

        // ݏ̃IuWFNg擾܂B
        final BlancoXmlNode objCurrent = fDocumentElementStack.peek();
        if (objCurrent instanceof BlancoXmlElement) {
            final BlancoXmlElement elementParent = ((BlancoXmlElement) objCurrent);
            elementParent.getChildNodes().add(element);
        } else if (objCurrent instanceof BlancoXmlDocument) {
            ((BlancoXmlDocument) objCurrent).getChildNodes().add(element);
        } else {
            throw new IllegalArgumentException(
                    "BlancoXmlUnmarshallerContentHandler: z肳Ȃ^["
                            + objCurrent.getClass().getName()
                            + "]ɑ΂ Elementǉ悤Ƃ܂B");
        }

        // GgRs[܂B
        element.setUri(uri);
        element.setLocalName(localName);
        element.setQName(qName);

        // Agr[g̃Rs[s܂B
        copyAttributes(atts, element);

        fDocumentElementStack.push(element);
    }

    /**
     * Agr[g̃Rs[s܂B
     * 
     * @param atts
     *            Agr[gꗗB
     * @param element
     *            ʐ̃GgB
     */
    protected void copyAttributes(final Attributes atts,
            final BlancoXmlElement element) {
        final int attrLength = atts.getLength();
        for (int index = 0; index < attrLength; index++) {
            final BlancoXmlAttribute attribute = new BlancoXmlAttribute();
            element.getAtts().add(attribute);

            attribute.setUri(atts.getURI(index));
            attribute.setLocalName(atts.getLocalName(index));
            attribute.setQName(atts.getQName(index));
            attribute.setType(atts.getType(index));
            attribute.setValue(atts.getValue(index));
        }
    }

    /**
     * ContentHandler ̗vfICxgB
     * 
     * @param uri
     *            vtBbNX}bvꂽO URIB
     * @param localName
     *            [JB
     * @param qName
     *            vtBbNXtCB
     */
    public void endElement(final String uri, final String localName,
            final String qName) throws SAXException {
        fDocumentElementStack.pop();
    }

    /**
     * ContentHandler ̕CxgB
     * 
     * @param ch
     * @param start
     * @param length
     */
    public void characters(final char[] ch, final int start, final int length)
            throws SAXException {
        final BlancoXmlCharacters characters = new BlancoXmlCharacters();

        // ݏ̃IuWFNg擾܂B
        final BlancoXmlNode objCurrent = fDocumentElementStack.peek();
        if (objCurrent instanceof BlancoXmlElement) {
            ((BlancoXmlElement) objCurrent).getChildNodes().add(characters);
        } else if (objCurrent instanceof BlancoXmlCdata) {
            ((BlancoXmlCdata) objCurrent).getChildNodes().add(characters);
        } else if (objCurrent instanceof BlancoXmlDocument) {
            ((BlancoXmlDocument) objCurrent).getChildNodes().add(characters);
        } else {
            throw new IllegalArgumentException(
                    "BlancoXmlUnmarshallerContentHandler: z肳Ȃ^["
                            + objCurrent.getClass().getName()
                            + "]ɑ΂ Charactersǉ悤Ƃ܂B");
        }

        characters.setValue(new String(ch, start, length));
    }

    /**
     * ContentHandler ̖\CxgB
     * 
     * @param ch
     * @param start
     * @param length
     */
    public void ignorableWhitespace(final char[] ch, final int start,
            final int length) throws SAXException {
        final BlancoXmlIgnorableWhitespace ignorableWhitespace = new BlancoXmlIgnorableWhitespace();

        // ݏ̃IuWFNg擾܂B
        final BlancoXmlNode objCurrent = fDocumentElementStack.peek();
        if (objCurrent instanceof BlancoXmlElement) {
            ((BlancoXmlElement) objCurrent).getChildNodes().add(
                    ignorableWhitespace);
        } else if (objCurrent instanceof BlancoXmlCdata) {
            ((BlancoXmlDocument) objCurrent).getChildNodes().add(
                    ignorableWhitespace);
        } else if (objCurrent instanceof BlancoXmlDocument) {
            ((BlancoXmlDocument) objCurrent).getChildNodes().add(
                    ignorableWhitespace);
        } else {
            throw new IllegalArgumentException(
                    "BlancoXmlUnmarshallerContentHandler: z肳Ȃ^["
                            + objCurrent.getClass().getName()
                            + "]ɑ΂ BlancoXmlIgnorableWhitespaceǉ悤Ƃ܂B");
        }

        ignorableWhitespace.setValue(new String(ch, start, length));
    }

    /**
     * ContentHandler  processingInstruction CxgB
     * 
     * @param target
     * @param data
     */
    public void processingInstruction(final String target, final String data)
            throws SAXException {
        // ̃Cxg͌_ł̎dlł͖܂B
    }

    /**
     * ContentHandler  skippedEntity CxgB
     * 
     * @param name
     */
    public void skippedEntity(final String name) throws SAXException {
        // ̃Cxg͌_ł̎dlł͖܂B
    }

    // ------------------------------------------------
    //  LexicalHandler ̂߂̃\bhB
    // ------------------------------------------------

    /**
     * LexicalHandler  DTD JnCxgB
     * 
     * @param name
     * @param publicId
     * @param systemId
     */
    public void startDTD(final String name, final String publicId,
            final String systemId) throws SAXException {
        final BlancoXmlDtd dtd = new BlancoXmlDtd();

        // ݏ̃IuWFNg擾܂B
        final BlancoXmlNode objCurrent = fDocumentElementStack.peek();
        if (objCurrent instanceof BlancoXmlDocument) {
            ((BlancoXmlDocument) objCurrent).getChildNodes().add(dtd);
        } else {
            throw new IllegalArgumentException(
                    "BlancoXmlUnmarshallerContentHandler: z肳Ȃ^["
                            + objCurrent.getClass().getName()
                            + "]ɑ΂ BlancoXmlDtdǉ悤Ƃ܂B");
        }
    }

    /**
     * LexicalHandler  DTD ICxgB
     */
    public void endDTD() throws SAXException {
    }

    /**
     * LexicalHandler  Entity JnCxgB
     * 
     * @param name
     *            GeBeBB
     */
    public void startEntity(final String name) throws SAXException {
        // ݂̎dlł́AT|[gOłB
    }

    /**
     * LexicalHandler  Entity ICxgB
     * 
     * @param name
     *            GeBeBB
     */
    public void endEntity(final String name) throws SAXException {
        // ݂̎dlł́AT|[gOłB
    }

    /**
     * LexicalHandler  CDATA JnCxgB
     */
    public void startCDATA() throws SAXException {
        final BlancoXmlCdata cdata = new BlancoXmlCdata();

        // ݏ̃IuWFNg擾܂B
        final BlancoXmlNode objCurrent = fDocumentElementStack.peek();
        if (objCurrent instanceof BlancoXmlElement) {
            final BlancoXmlElement elementParent = ((BlancoXmlElement) objCurrent);
            elementParent.getChildNodes().add(cdata);
        } else if (objCurrent instanceof BlancoXmlDocument) {
            ((BlancoXmlDocument) objCurrent).getChildNodes().add(cdata);
        } else {
            throw new IllegalArgumentException(
                    "BlancoXmlUnmarshallerContentHandler: z肳Ȃ^["
                            + objCurrent.getClass().getName()
                            + "]ɑ΂ CDATAǉ悤Ƃ܂B");
        }

        fDocumentElementStack.push(cdata);
    }

    /**
     * LexicalHandler  CDATA ICxgB
     */
    public void endCDATA() throws SAXException {
        fDocumentElementStack.pop();
    }

    /**
     * LexicalHandler  RgCxgB
     * 
     * @param ch
     * @param start
     * @param length
     */
    public void comment(final char[] ch, final int start, final int length)
            throws SAXException {
        final BlancoXmlComment comment = new BlancoXmlComment();

        // ݏ̃IuWFNg擾܂B
        final BlancoXmlNode objCurrent = fDocumentElementStack.peek();
        if (objCurrent instanceof BlancoXmlElement) {
            ((BlancoXmlElement) objCurrent).getChildNodes().add(comment);
        } else if (objCurrent instanceof BlancoXmlDocument) {
            ((BlancoXmlDocument) objCurrent).getChildNodes().add(comment);
        } else {
            throw new IllegalArgumentException(
                    "BlancoXmlUnmarshallerContentHandler: z肳Ȃ^["
                            + objCurrent.getClass().getName()
                            + "]ɑ΂ BlancoXmlCommentǉ悤Ƃ܂B");
        }

        comment.setValue(new String(ch, start, length));
    }

    // ------------------------------------------------
    //  DTDHandler ̂߂̃\bhB
    // ------------------------------------------------

    public void notationDecl(final String name, final String publicId,
            final String systemId) throws SAXException {
        // TODO B
    }

    public void unparsedEntityDecl(final String name, final String publicId,
            final String systemId, final String notationName)
            throws SAXException {
        // TODO B
    }
}
