/*
 * blancoDb
 * Copyright (C) 2004-2006 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query.iterator;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.db.common.expander.BlancoDbAbstractClass;
import blanco.db.common.stringgroup.BlancoDbSqlInfoScrollStringGroup;
import blanco.db.common.util.BlancoDbUtil;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;
import blanco.db.expander.query.Finalize;
import blanco.db.expander.query.GetQueryMethod;
import blanco.db.expander.query.GetStatementMethod;
import blanco.db.expander.query.PrepareStatementMethod;
import blanco.db.expander.query.PrepareStatementMethod2;
import blanco.db.expander.query.QueryConstructor;
import blanco.db.expander.query.field.ConnectionField;
import blanco.db.expander.query.field.LogField;
import blanco.db.expander.query.field.ResultSetField;
import blanco.db.expander.query.field.StatementField;
import blanco.db.resourcebundle.BlancoDbResourceBundle;
import blanco.dbmetadata.valueobject.BlancoDbMetaDataColumnStructure;

/**
 * ʂ̃NXWJ邽߂̃NXB
 * 
 * @author Yasuo Nakanishi
 */
public class QueryIteratorClass extends BlancoDbAbstractClass {
    private final BlancoDbResourceBundle fBundle = new BlancoDbResourceBundle();

    public QueryIteratorClass(final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory) {
        super(argDbSetting, argSqlInfo, argCgFactory);
    }

    public BlancoCgSourceFile expand() {
        final String className = BlancoNameAdjuster.toClassName(fSqlInfo
                .getName())
                + "Iterator";

        fCgSourceFile = fCgFactory.createSourceFile(BlancoDbUtil
                .getBasePackage(fSqlInfo, fDbSetting)
                + ".query", "This code is generated by blanco Framework.");
        fCgClass = fCgFactory.createClass(className, className
                + "NX (QueryIterator)B");
        fCgSourceFile.getClassList().add(fCgClass);

        fCgClass.getLangDoc().getDescriptionList().add(
                "^SQLbsOĊeANZT񋟂܂B<br>");
        if (fSqlInfo.getSingle()) {
            fCgClass.getLangDoc().getDescriptionList().add(
                    "VO: L (҂鏈1)<br>");
        }
        fCgClass.getLangDoc().getDescriptionList()
                .add(
                        "XN[: "
                                + new BlancoDbSqlInfoScrollStringGroup()
                                        .convertToString(fSqlInfo.getScroll())
                                + "<br>");
        if (fSqlInfo.getUpdatable()) {
            fCgClass.getLangDoc().getDescriptionList().add("XV\: L<br>");
        }

        // BlancoDbUtil͏ɃC|[g܂B
        fCgSourceFile.getImportList().add(
                BlancoDbUtil.getRuntimePackage(fDbSetting)
                        + ".util.BlancoDbUtil");

        new ConnectionField(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                fCgClass).expand();
        new StatementField(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                fCgClass, false).expand();
        new ResultSetField(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                fCgClass).expand();

        new QueryConstructor(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                fCgClass).expand();

        new GetQueryMethod(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                fCgClass).expand();

        new PrepareStatementMethod(fDbSetting, fSqlInfo, fCgFactory,
                fCgSourceFile, fCgClass).expand();
        new PrepareStatementMethod2(fDbSetting, fSqlInfo, fCgFactory,
                fCgSourceFile, fCgClass).expand();

        // p[^ꍇɂ̂ bind\bh𐶐܂B
        if (fSqlInfo.getInParameterList().size() > 0) {
            new SetInputParameterMethod(fDbSetting, fSqlInfo, fCgFactory,
                    fCgSourceFile, fCgClass, false).expand();
        }

        new ExecuteQueryMethod(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                fCgClass).expand();

        new NextMethod(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                fCgClass).expand();

        // J[\true̍ۂɂ previous\bhȂǂ
        // XN[J[\֘A\bhǉ
        // O: J[\truȅꍇɂ̓VOfalse
        if (fSqlInfo.getScroll() == BlancoDbSqlInfoScrollStringGroup.TYPE_SCROLL_INSENSITIVE
                || fSqlInfo.getScroll() == BlancoDbSqlInfoScrollStringGroup.TYPE_SCROLL_SENSITIVE
                || fSqlInfo.getScroll() == BlancoDbSqlInfoScrollStringGroup.NOT_DEFINED) {
            // TODO 1.6.4Ƃ̌݊mۂ̂ BlancoDbSqlInfoScrollStringGroup.NOT_DEFINED
            // ̏ꍇɂXN[֘A\bh𐶐Ă܂B

            new PreviousMethod(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                    fCgClass).expand();
            new FirstMethod(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                    fCgClass).expand();
            new LastMethod(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                    fCgClass).expand();

            new AbsoluteMethod(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                    fCgClass).expand();
            new RelativeMethod(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                    fCgClass).expand();
        }

        new GetRowMethod(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                fCgClass).expand();

        if (fBundle.getExpanderDisableGetStatement().equals("true") == false) {
            // 1.6.8ȑOƌ݊Kvꍇɂ̂ getStatement𐶐܂B
            new GetStatementMethod(fDbSetting, fSqlInfo, fCgFactory,
                    fCgSourceFile, fCgClass, false).expand();
        }

        new GetResultSetMethod(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                fCgClass).expand();

        if (fSqlInfo.getSingle()) {
            new GetSingleRowMethod(fDbSetting, fSqlInfo, fCgFactory,
                    fCgSourceFile, fCgClass).expand();
        }

        if (fSqlInfo.getSingle() == false) {
            new GetListMethod(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                    fCgClass).expand();
        }

        // XV\̏ꍇɂ݂̂̐łB
        if (fSqlInfo.getUpdatable()) {
            // ʂ̗̐Aupdate\bh𐶐
            boolean isAllFieldReadOnly = true;
            for (int index = 0; index < fSqlInfo.getResultSetColumnList()
                    .size(); index++) {
                final BlancoDbMetaDataColumnStructure columnStructure = (BlancoDbMetaDataColumnStructure) fSqlInfo
                        .getResultSetColumnList().get(index);

                // ResultSetMetaData Writableł ȏ͏Ƀ\bh𐶐܂B
                if (columnStructure.getWritable()) {
                    new UpdateObjectMethod(fDbSetting, fSqlInfo, fCgFactory,
                            fCgSourceFile, fCgClass, columnStructure).expand();
                    isAllFieldReadOnly = false;
                }
            }
            if (isAllFieldReadOnly == false) {
                new UpdateRowMethod(fDbSetting, fSqlInfo, fCgFactory,
                        fCgSourceFile, fCgClass).expand();
            }
        }

        new CloseMethod(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                fCgClass).expand();

        new Finalize(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile, fCgClass)
                .expand();

        if (fDbSetting.getLogging()) {
            fCgSourceFile.getImportList().add(
                    "org.apache.commons.logging.LogFactory");
            new LogField(fDbSetting, fSqlInfo, fCgFactory, fCgSourceFile,
                    fCgClass).expand();
        }

        return fCgSourceFile;
    }
}