/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.util;

import blanco.cg.BlancoCgSupportedLang;
import blanco.commons.util.BlancoStringUtil;

/**
 * blancoCg̍sɊւ郆[eBeBłB
 * 
 * ̃NX̓vO~O𒴂ėp܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoCgLineUtil {
    /**
     * PsRg̊Jn\擾܂B
     * 
     * Rg̊Jn\ƁAɑ󔒂߂܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @return Rg̊Jn\B
     */
    public static final String getSingleLineCommentPrefix(
            final int argTargetLang) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.PHP:
            return "// ";
        case BlancoCgSupportedLang.VB:
            return "' ";
        case BlancoCgSupportedLang.RUBY:
        case BlancoCgSupportedLang.PYTHON:
            return "# ";
        default:
            throw new IllegalArgumentException(
                    "BlancoCgLineUtil: T|[gȂvO~O(" + argTargetLang
                            + ")^܂B");
        }
    }

    /**
     * 񃊃e͂ޕ擾܂B
     * 
     * o͑Ώۂ̃vO~OɉāA_uNI[g܂ VONI[g߂܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @return 񃊃e͂ޕ
     */
    public static final String getStringLiteralEnclosure(final int argTargetLang) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.VB:
            return "\"";
        case BlancoCgSupportedLang.PHP:
        case BlancoCgSupportedLang.RUBY:
        case BlancoCgSupportedLang.PYTHON:
            return "'";
        default:
            throw new IllegalArgumentException(
                    "BlancoCgLineUtil: T|[gȂvO~O(" + argTargetLang
                            + ")^܂B");
        }
    }

    /**
     * AIy[^擾܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @return AIy[^B
     */
    public static final String getStringConcatenationOperator(
            final int argTargetLang) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        case BlancoCgSupportedLang.CS:
        case BlancoCgSupportedLang.JS:
        case BlancoCgSupportedLang.VB:
        case BlancoCgSupportedLang.RUBY:
        case BlancoCgSupportedLang.PYTHON:
            return "+";
        case BlancoCgSupportedLang.PHP:
            return ".";
        default:
            throw new IllegalArgumentException(
                    "BlancoCgLineUtil: T|[gȂvO~O(" + argTargetLang
                            + ")^܂B");
        }
    }

    /**
     * ϐ̃vtBbNX擾܂B
     * 
     * @IɕϐɃvtBbNXKvȏꍇA̕߂܂BvtBbNXKvȂł́A0̕߂܂B
     * PHP̏ꍇA$߂܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @return [Jϐ̃vtBbNX
     */
    public static final String getVariablePrefix(final int argTargetLang) {
        switch (argTargetLang) {
        case BlancoCgSupportedLang.PHP:
            return "$";
        default:
            return "";
        }
    }

    /**
     * ϐ錾\擾܂B
     * 
     * ϐ錾Ps߂܂Bs̏I[\iJavȁꍇAZ~Rj ܂܂܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @param argVariableName
     *            ϐB
     * @param argTypeShortName
     *            Z^B
     * @param argInitialValue
     *            lBnull܂͒0̏ꍇAϐ̖Iȏ͍s܂B
     * @return ϐ錾\B
     */
    public static final String getVariableDeclaration(final int argTargetLang,
            final String argVariableName, final String argTypeShortName,
            final String argInitialValue) {
        String result = "";
        switch (argTargetLang) {
        case BlancoCgSupportedLang.JAVA:
        default:
            result = argTypeShortName + " " + argVariableName;
            break;
        case BlancoCgSupportedLang.CS:
            result = argTypeShortName + " " + argVariableName;
            break;
        case BlancoCgSupportedLang.JS:
            // ^͗p܂B
            result = "var " + argVariableName;
            break;
        case BlancoCgSupportedLang.VB:
            result = "Dim " + argVariableName + " As " + argTypeShortName;
            break;
        case BlancoCgSupportedLang.PHP:
            // ^͗p܂B
            result = BlancoCgLineUtil.getVariablePrefix(argTargetLang)
                    + argVariableName;
            break;
        case BlancoCgSupportedLang.RUBY:
        case BlancoCgSupportedLang.PYTHON:
            // ^͗p܂B
            result = argVariableName;
            break;
        }

        if (BlancoStringUtil.null2Blank(argInitialValue).length() > 0) {
            result += " = " + argInitialValue;
        }
        return result;
    }

    // ȍ~̓t@T[h\bhB

    /**
     * if̊Jn\擾܂B
     * 
     * ۂ̏́A{@link BlancoCgStatementUtil#getIfBegin(int, java.lang.String)}
     * ɈϏ܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @param argExpr
     *            B
     * @return if̊Jn\
     */
    public static final String getIfBegin(final int argTargetLang,
            final String argExpr) {
        return BlancoCgStatementUtil.getIfBegin(argTargetLang, argExpr);
    }

    /**
     * if̏I\擾܂B
     * 
     * ۂ̏́A{@link BlancoCgStatementUtil#getIfEnd(int)}ɈϏ܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @return if̏I\
     */
    public static final String getIfEnd(final int argTargetLang) {
        return BlancoCgStatementUtil.getIfEnd(argTargetLang);
    }

    /**
     * for̊Jn\擾܂B
     * 
     * Java, C#, JavaScript, PHPɑΉĂ܂B ۂ̏́A
     * {@link BlancoCgStatementUtil#getForBeginJava(int, java.lang.String, java.lang.String, java.lang.String)}
     * ɈϏ܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @param argExpr1
     *            B
     * @param argExpr2
     *            pB
     * @param argExpr3
     *            [v̂ǎ{鏈B
     * @return for̊Jn\
     */
    public static final String getForBeginJava(final int argTargetLang,
            final String argExpr1, final String argExpr2, final String argExpr3) {
        return BlancoCgStatementUtil.getForBeginJava(argTargetLang, argExpr1,
                argExpr2, argExpr3);
    }

    /**
     * for̊Jn\擾܂B
     * 
     * VB.NETɑΉĂ܂B ۂ̏́A
     * {@link BlancoCgStatementUtil#getForBeginVb(int, java.lang.String, java.lang.String, java.lang.String)}
     * ɈϏ܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @param argCounter
     *            \Bu: i As Integer = 1v
     * @param argTo
     *            IƂȂ邵l (ł͂܂)Bu: 10v
     * @return for̊Jn\B
     */
    public static final String getForBeginVb(final int argTargetLang,
            final String argCounter, final String argTo) {
        return BlancoCgStatementUtil.getForBeginVb(argTargetLang, argCounter,
                argTo, null);
    }

    /**
     * for̊Jn\擾܂B
     * 
     * VB.NETɑΉĂ܂B ۂ̏́A
     * {@link BlancoCgStatementUtil#getForBeginVb(int, java.lang.String, java.lang.String, java.lang.String)}
     * ɈϏ܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @param argCounter
     *            \Bu: i As Integer = 1v
     * @param argTo
     *            IƂȂ邵l (ł͂܂)Bu: 10v
     * @param argStep
     *            StepɗplBu: 2vBnull̏ꍇɂ Step͏ȗ܂B
     * @return for̊Jn̕
     */
    public static final String getForBeginVb(final int argTargetLang,
            final String argCounter, final String argTo, final String argStep) {
        return BlancoCgStatementUtil.getForBeginVb(argTargetLang, argCounter,
                argTo, argStep);
    }

    /**
     * for̊Jn\擾܂B
     * 
     * RubyɑΉĂ܂B ۂ̏́A
     * {@link BlancoCgStatementUtil#getForBeginRuby(int, java.lang.String, java.lang.String, java.lang.String)}
     * ɈϏ܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @param argCounter
     *            [vJE^B
     * @param argFrom
     *            Jnl (ł͂܂)Bu: 1v
     * @param argTo
     *            Il (ł͂܂)Bu: 10v
     * @return for̊Jn\B
     */
    public static final String getForBeginRuby(final int argTargetLang,
            final String argCounter, final String argFrom, final String argTo) {
        return BlancoCgStatementUtil.getForBeginRuby(argTargetLang, argCounter,
                argFrom, argTo);
    }

    /**
     * for̊Jn\擾܂B
     * 
     * PythonɑΉĂ܂B ۂ̏́A
     * {@link BlancoCgStatementUtil#getForBeginPython(int, java.lang.String, java.lang.String)}
     * ɈϏ܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @param argItem
     *            [vΏۂƂȂIuWFNǧݒlB
     * @param argItems
     *            [vΏۂƂȂIuWFNgB
     * @return for̊Jn\B
     */
    public static final String getForBeginPython(final int argTargetLang,
            final String argItem, final String argItems) {
        return BlancoCgStatementUtil.getForBeginPython(argTargetLang, argItem,
                argItems);
    }

    /**
     * eachubN̊Jn\擾܂B
     * 
     * RubyɑΉĂ܂B ۂ̏́A
     * {@link BlancoCgStatementUtil#getEachBeginRuby(int, java.lang.String, java.lang.String)}
     * ɈϏ܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @param argObject
     *            each\bhĂяoΏۂƂȂIuWFNgB
     * @param argVariable
     *            each\bȟݒlB
     * @return eachubN̊Jn\B
     */
    public static final String getEachBeginRuby(final int argTargetLang,
            final String argObject, final String argVariable) {
        return BlancoCgStatementUtil.getEachBeginRuby(argTargetLang, argObject,
                argVariable);
    }

    /**
     * eachubN̏I\擾܂B
     * 
     * RubyɑΉĂ܂B ۂ̏́A{@link BlancoCgStatementUtil#getEachEnd(int)}
     * ɈϏ܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @return eachubN̏I\B
     */
    public static final String getEachEnd(final int argTargetLang) {
        return BlancoCgStatementUtil.getEachEnd(argTargetLang);
    }

    /**
     * foȑI\擾܂B
     * 
     * ۂ̏́A{@link BlancoCgStatementUtil#getForEnd(int)}ɈϏ܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @return foȑI\B
     */
    public static final String getForEnd(final int argTargetLang) {
        return BlancoCgStatementUtil.getForEnd(argTargetLang);
    }

    /**
     * for𔲂镶\킷擾܂B
     * 
     * ۂ̏́A{@link BlancoCgStatementUtil#getForExit(int)}ɈϏ܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @return break܂ Exit For߂܂B
     */
    public static final String getForExit(final int argTargetLang) {
        return BlancoCgStatementUtil.getForExit(argTargetLang);
    }

    /**
     * ̏I擾܂B
     * 
     * ۂ̏́A{@link BlancoCgStatementUtil#getTerminator(int)}ɈϏ܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @return ̏IB
     */
    public static final String getTerminator(final int argTargetLang) {
        return BlancoCgStatementUtil.getTerminator(argTargetLang);
    }

    /**
     * while̊Jn\킷擾܂B
     * 
     * Ruby, PythonɑΉĂ܂B ۂ̏́A
     * {@link BlancoCgStatementUtil#getWhileBeginRuby(int, java.lang.String)}
     * ɈϏ܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @param argCon
     *            B
     * @return while̊Jn\킷B
     */
    public static final String getWhileBeginRuby(final int argTargetLang,
            final String argCon) {
        return BlancoCgStatementUtil.getWhileBeginRuby(argTargetLang, argCon);
    }

    /**
     * return\擾܂B
     * 
     * ۂ̏́A{@link BlancoCgStatementUtil#getReturn(int, java.lang.String)}
     * ɈϏ܂B
     * 
     * @param argTargetLang
     *            o͑Ώۂ̃vO~OB
     * @param argExpr
     *            return鎮B
     * @return return\B
     */
    public static final String getReturn(final int argTargetLang,
            final String argExpr) {
        return BlancoCgStatementUtil.getReturn(argTargetLang, argExpr);
    }
}