/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
/*******************************************************************************
 * Copyright (c) 2009 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
package blanco.commons.calc.parser;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;

import jxl.Cell;
import jxl.Sheet;
import jxl.Workbook;
import jxl.WorkbookSettings;
import jxl.read.biff.BiffException;

import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;

import blanco.commons.parser.ContentHandlerStream;

/**
 * Calcǂݎ邽߂SAX2p[TłB <br>
 * \vZt@Cǂݎ̍ۂ̔ėpIŒۓISAX2nh񋟂܂B
 * 
 * @author IGA Tosiki
 */
public abstract class AbstractBlancoCalcParser implements XMLReader {
    /**
     * RecnhL܂B
     */
    private ContentHandler contentHandler = null;

    private ContentHandlerStream chainedContentHandler = null;

    public static final String URI_PROPERTY_NAME_WORKBOOK = "http://blanco/commons/calc/parser/workbook";

    public static final String URI_PROPERTY_NAME_SHEET = "http://blanco/commons/calc/parser/sheet";

    private String _propertyNameWorkbook = "workbook";

    private String _propertyNameSheet = "sheet";

    /**
     * tB[`[擾܂B
     * 
     * @param arg0
     *            tB[`[B
     * @see org.xml.sax.XMLReader#getFeature(java.lang.String)
     */
    public final boolean getFeature(final String arg0)
            throws SAXNotRecognizedException, SAXNotSupportedException {
        return false;
    }

    /**
     * tB[`[ݒ肵܂B
     * 
     * @param name
     *            tB[`[B
     * @param value
     *            tB[`[̒lB
     * @see org.xml.sax.XMLReader#setFeature(java.lang.String, boolean)
     */
    public final void setFeature(final String name, boolean value)
            throws SAXNotRecognizedException, SAXNotSupportedException {
    }

    /**
     * vpeB擾܂B
     */
    public final Object getProperty(final String name)
            throws SAXNotRecognizedException, SAXNotSupportedException {

        if (name.equals(URI_PROPERTY_NAME_WORKBOOK)) {
            return _propertyNameWorkbook;
        } else if (name.equals(URI_PROPERTY_NAME_SHEET)) {
            return _propertyNameSheet;
        } else {
            throw new SAXNotRecognizedException("̖̂̓nhOł܂." + name);
        }
    }

    /**
     * vpeBݒ肵܂B
     */
    public final void setProperty(final String name, final Object value)
            throws SAXNotRecognizedException, SAXNotSupportedException {
        if (name.equals(URI_PROPERTY_NAME_WORKBOOK)) {
            _propertyNameWorkbook = (String) value;
        } else if (name.equals(URI_PROPERTY_NAME_SHEET)) {
            _propertyNameSheet = (String) value;
        } else {
            throw new SAXNotRecognizedException("̖̂̓nhOł܂." + name);
        }
    }

    /**
     * GeBeB]oݒ肵܂B
     * 
     * @param arg0
     *            GeBeB]õIuWFNgB
     * @see org.xml.sax.XMLReader#setEntityResolver(org.xml.sax.EntityResolver)
     */
    public final void setEntityResolver(final EntityResolver arg0) {
    }

    /**
     * GeBeB]o擾܂B
     * 
     * @return GeBeB]õIuWFNgB
     * @see org.xml.sax.XMLReader#getEntityResolver()
     */
    public final EntityResolver getEntityResolver() {
        return null;
    }

    /**
     * DTDnhݒ肵܂B
     * 
     * @param arg0
     *            DTDnh̃IuWFNgB
     * @see org.xml.sax.XMLReader#setDTDHandler(org.xml.sax.DTDHandler)
     */
    public final void setDTDHandler(final DTDHandler arg0) {
    }

    /**
     * DTDnh̃IuWFNg擾܂B
     * 
     * @return DTDnh̃IuWFNgB
     * @see org.xml.sax.XMLReader#getDTDHandler()
     */
    public final DTDHandler getDTDHandler() {
        return null;
    }

    /**
     * RecnhZbg܂B
     */
    public final void setContentHandler(ContentHandler arg0) {
        contentHandler = arg0;
        if (chainedContentHandler != null) {
            chainedContentHandler.setContentHandler(arg0);
        }
    }

    /**
     * Recnh擾܂B
     */
    public final ContentHandler getContentHandler() {
        if (chainedContentHandler == null) {
            return contentHandler;
        } else {
            return chainedContentHandler;
        }
    }

    public final void chainContentHandlerStream(ContentHandlerStream arg0) {
        chainedContentHandler = arg0;
    }

    /**
     * G[nh[ݒ肵܂B
     * 
     * @param arg0
     *            G[nh[IuWFNgB
     * @see org.xml.sax.XMLReader#setErrorHandler(org.xml.sax.ErrorHandler)
     */
    public final void setErrorHandler(ErrorHandler arg0) {
    }

    /**
     * G[nh[擾܂B
     * 
     * @return G[nh[IuWFNgB
     * @see org.xml.sax.XMLReader#getErrorHandler()
     */
    public final ErrorHandler getErrorHandler() {
        return null;
    }

    /**
     * p[Xs܂B
     * 
     * @param inputSource
     *            ͑ΏۂƂȂ̓\[XB
     * @see org.xml.sax.XMLReader#parse(org.xml.sax.InputSource)
     */
    public final void parse(final InputSource inputSource) throws IOException,
            SAXException {
        Workbook workbook = null;
        final WorkbookSettings settings = new WorkbookSettings();
        // JExcelApi̓gcĂяo𖳌܂B
        settings.setGCDisabled(true);
        // [jO̕Wo͂𖳌܂B
        settings.setSuppressWarnings(true);

        // 2006.09.29 t.iga
        // JExcelApi 2.6ł́u00??GȀɂāAIɎw肳ꂽGR[fBO𗘗pĂ܂B
        // A̎dl Excel̋Ƃ͈قȂ܂BExcelɍ킹 ISO8859_1 Œ̏Óƍl܂B
        // JExcelApi 2.6̃ftHgł́ÃZ u00??GA̕ (:~()) ͂ꂽꍇ
        // Excelǂݍݎɕ܂B
        settings.setEncoding("ISO8859_1");

        // ȊOɂlocaleݒȂǂA̗]n݂͑邪A̎dlƂĂ͂܂łƂBB

        InputStream inStream = null;
        try {
            if (inputSource.getByteStream() != null) {
                // OKłB̂܂܏i߂܂B
            } else if (inputSource.getSystemId() != null
                    && inputSource.getSystemId().length() > 0) {
                inStream = new FileInputStream(inputSource.getSystemId());
                inputSource.setByteStream(inStream);
            } else {
                throw new IOException("w肳ꂽInputSource͏ł܂.");
            }
            workbook = Workbook.getWorkbook(inputSource.getByteStream(),
                    settings);

            // {̃p[Xn܂܂B
            parseWorkbook(workbook);
        } catch (BiffException e) {
            e.printStackTrace();
            throw new IOException("\ʗO܂.: " + e.toString());
        } finally {
            if (workbook != null) {
                workbook.close();
            }

            // InputSourcẽN[Y͊Oōs܂B
            // ̒ł IɊJXg[̂ݏ܂B
            if (inStream != null) {
                inStream.close();
            }
        }
    }

    /**
     * ^ꂽt@Cp[X܂B
     * 
     * {Iɂ inputSourceł̃p[X𐄏܂B
     * 
     * @param arg0
     *            t@C̃pXB
     */
    public final void parse(final String arg0) throws IOException, SAXException {
        InputSource inputSource = new InputSource(arg0);
        inputSource.setByteStream(new FileInputStream(arg0));
        parse(inputSource);
    }

    /**
     * [NubNp[X܂
     * 
     * @param workbook
     *            [NubN
     * @throws SAXException
     *             SAXOꍇB
     */
    private void parseWorkbook(final Workbook workbook) throws SAXException {
        getContentHandler().startDocument();
        getContentHandler().startElement("",
                (String) getProperty(URI_PROPERTY_NAME_WORKBOOK),
                (String) getProperty(URI_PROPERTY_NAME_WORKBOOK),
                new AttributesImpl());

        for (int indexSheet = 0; indexSheet < workbook.getNumberOfSheets(); indexSheet++) {
            Sheet sheet = workbook.getSheet(indexSheet);
            parseSheet(sheet);
        }
        getContentHandler().endElement("",
                (String) getProperty(URI_PROPERTY_NAME_WORKBOOK),
                (String) getProperty(URI_PROPERTY_NAME_WORKBOOK));
        getContentHandler().endDocument();
    }

    /**
     * V[gp[X܂B
     * 
     * @param sheet
     *            V[gIuWFNgB
     * @throws SAXException
     *             SAXOꍇB
     */
    private final void parseSheet(final Sheet sheet) throws SAXException {
        // V[g̃Gg͏ʃNXŏ
        AttributesImpl attrImpl = new AttributesImpl();
        attrImpl.addAttribute("", "name", "name", "CDATA", sheet.getName());
        getContentHandler().startElement("",
                (String) getProperty(URI_PROPERTY_NAME_SHEET),
                (String) getProperty(URI_PROPERTY_NAME_SHEET), attrImpl);

        startSheet(sheet.getName());

        int maxRows = sheet.getRows();

        for (int row = 0; row < maxRows; row++) {
            startRow(row + 1);
            Cell[] cells = sheet.getRow(row);
            for (int column = 0; column < cells.length; column++) {
                startColumn(column + 1);
                // Rectrim()ɁÂ܂܂킽܂B
                String value = cells[column].getContents();
                fireCell(column + 1, row + 1, value);
                endColumn(column + 1);
            }
            endRow(row + 1);
        }

        endSheet(sheet);

        // V[g̃Gg͏ʃNXŏ
        getContentHandler().endElement("",
                (String) getProperty(URI_PROPERTY_NAME_SHEET),
                (String) getProperty(URI_PROPERTY_NAME_SHEET));
    }

    /**
     * V[gJnۂɌĂяo܂B
     * 
     * @param sheetName
     *            V[gB
     * @throws SAXException
     *             SAXOꍇB
     */
    protected abstract void startSheet(String sheetName) throws SAXException;

    /**
     * V[gIۂɌĂяo܂B
     * 
     * @param sheet
     *            V[gIuWFNgB
     * @throws SAXException
     *             SAXOꍇB
     */
    protected abstract void endSheet(final Sheet sheet) throws SAXException;

    protected abstract void startRow(int row) throws SAXException;

    protected abstract void endRow(int row) throws SAXException;

    protected abstract void startColumn(int column) throws SAXException;

    protected abstract void endColumn(int column) throws SAXException;

    /**
     * ZۂɌĂяo܂B
     * 
     * @param column
     * @param row
     * @param cellValue
     * @throws SAXException
     */
    protected abstract void fireCell(int column, int row, String cellValue)
            throws SAXException;

    /**
     * Transformer擾܂B
     * 
     * @return gXtH[܁[IuWFNgB
     * @throws TransformerFactoryConfigurationError
     *             gXtH[}[t@Ng[̃RtBO[V̗OꍇB
     * @throws TransformerConfigurationException
     *             gXtH[}[RtBO[V̗OꍇB
     */
    public static final Transformer getTransformer()
            throws TransformerFactoryConfigurationError,
            TransformerConfigurationException {
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("standalone", "yes");
        transformer.setOutputProperty("indent", "yes");
        return transformer;
    }
}
