/*
 * blanco Framework
 * Copyright (C) 2004-2009 IGA Tosiki
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.valueobject;

import java.util.List;

/**
 * \[Xt@C\邽߂̃o[IuWFNgB
 */
public class BlancoCgSourceFile {
    /**
     * ̃t@C̃t@CłB
     *
     * ȂA̒l͖IɎw肵ȂƂȀꍇ̓NXEC^tF[X疼̂o悤ɂȂĂ܂B
     * tB[h: [name]B
     */
    private String fName;

    /**
     * ̃t@C̐łB
     *
     * tB[h: [description]B
     */
    private String fDescription;

    /**
     * ̃t@CpbP[WłB
     *
     * tB[h: [package]B
     */
    private String fPackage;

    /**
     * ̃t@C̕GR[fBOłB
     *
     * tB[h: [encoding]B
     */
    private String fEncoding;

    /**
     * ̃t@CQƂ鑼̃pbP[W̃XgłBjava.lang.String̃XgB
     *
     * tB[h: [importList]B
     * ftHg: [new java.util.ArrayList<java.lang.String>()]B
     */
    private List<java.lang.String> fImportList = new java.util.ArrayList<java.lang.String>();

    /**
     * ̃t@CɊ܂܂񋓑̂̃XgłB
     *
     * tB[h: [enumList]B
     * ftHg: [new java.util.ArrayList<blanco.cg.valueobject.BlancoCgEnum>()]B
     */
    private List<blanco.cg.valueobject.BlancoCgEnum> fEnumList = new java.util.ArrayList<blanco.cg.valueobject.BlancoCgEnum>();

    /**
     * ̃t@CɊ܂܂C^tF[X̃XgłB
     *
     * tB[h: [interfaceList]B
     * ftHg: [new java.util.ArrayList<blanco.cg.valueobject.BlancoCgInterface>()]B
     */
    private List<blanco.cg.valueobject.BlancoCgInterface> fInterfaceList = new java.util.ArrayList<blanco.cg.valueobject.BlancoCgInterface>();

    /**
     * ̃t@CɊ܂܂NX̃XgłB
     *
     * tB[h: [classList]B
     * ftHg: [new java.util.ArrayList<blanco.cg.valueobject.BlancoCgClass>()]B
     */
    private List<blanco.cg.valueobject.BlancoCgClass> fClassList = new java.util.ArrayList<blanco.cg.valueobject.BlancoCgClass>();

    /**
     * hLg~܂BftHgȏ̕\ǉꍇɂ́ACX^X𐶐ĒlZbgĂ玩܂B
     *
     * ȂÃo[IuWFNg̓\[Xt@ČhLgɊY邽߁AŃZbglۂ̃\[XR[hɔfꍇ̉e͈͂͌肳Ă܂ꍇ܂B
     * tB[h: [langDoc]B
     */
    private BlancoCgLangDoc fLangDoc;

    /**
     * tB[h [name] ̒lݒ肵܂B
     *
     * tB[h̐: [̃t@C̃t@CłB]B
     * ȂA̒l͖IɎw肵ȂƂȀꍇ̓NXEC^tF[X疼̂o悤ɂȂĂ܂B
     *
     * @param argName tB[h[name]ɐݒ肷lB
     */
    public void setName(final String argName) {
        fName = argName;
    }

    /**
     * tB[h [name] ̒l擾܂B
     *
     * tB[h̐: [̃t@C̃t@CłB]B
     * ȂA̒l͖IɎw肵ȂƂȀꍇ̓NXEC^tF[X疼̂o悤ɂȂĂ܂B
     *
     * @return tB[h[name]擾lB
     */
    public String getName() {
        return fName;
    }

    /**
     * tB[h [description] ̒lݒ肵܂B
     *
     * tB[h̐: [̃t@C̐łB]B
     *
     * @param argDescription tB[h[description]ɐݒ肷lB
     */
    public void setDescription(final String argDescription) {
        fDescription = argDescription;
    }

    /**
     * tB[h [description] ̒l擾܂B
     *
     * tB[h̐: [̃t@C̐łB]B
     *
     * @return tB[h[description]擾lB
     */
    public String getDescription() {
        return fDescription;
    }

    /**
     * tB[h [package] ̒lݒ肵܂B
     *
     * tB[h̐: [̃t@CpbP[WłB]B
     *
     * @param argPackage tB[h[package]ɐݒ肷lB
     */
    public void setPackage(final String argPackage) {
        fPackage = argPackage;
    }

    /**
     * tB[h [package] ̒l擾܂B
     *
     * tB[h̐: [̃t@CpbP[WłB]B
     *
     * @return tB[h[package]擾lB
     */
    public String getPackage() {
        return fPackage;
    }

    /**
     * tB[h [encoding] ̒lݒ肵܂B
     *
     * tB[h̐: [̃t@C̕GR[fBOłB]B
     *
     * @param argEncoding tB[h[encoding]ɐݒ肷lB
     */
    public void setEncoding(final String argEncoding) {
        fEncoding = argEncoding;
    }

    /**
     * tB[h [encoding] ̒l擾܂B
     *
     * tB[h̐: [̃t@C̕GR[fBOłB]B
     *
     * @return tB[h[encoding]擾lB
     */
    public String getEncoding() {
        return fEncoding;
    }

    /**
     * tB[h [importList] ̒lݒ肵܂B
     *
     * tB[h̐: [̃t@CQƂ鑼̃pbP[W̃XgłBjava.lang.String̃XgB]B
     *
     * @param argImportList tB[h[importList]ɐݒ肷lB
     */
    public void setImportList(final List<java.lang.String> argImportList) {
        fImportList = argImportList;
    }

    /**
     * tB[h [importList] ̒l擾܂B
     *
     * tB[h̐: [̃t@CQƂ鑼̃pbP[W̃XgłBjava.lang.String̃XgB]B
     * ftHg: [new java.util.ArrayList<java.lang.String>()]B
     *
     * @return tB[h[importList]擾lB
     */
    public List<java.lang.String> getImportList() {
        return fImportList;
    }

    /**
     * tB[h [enumList] ̒lݒ肵܂B
     *
     * tB[h̐: [̃t@CɊ܂܂񋓑̂̃XgłB]B
     *
     * @param argEnumList tB[h[enumList]ɐݒ肷lB
     */
    public void setEnumList(final List<blanco.cg.valueobject.BlancoCgEnum> argEnumList) {
        fEnumList = argEnumList;
    }

    /**
     * tB[h [enumList] ̒l擾܂B
     *
     * tB[h̐: [̃t@CɊ܂܂񋓑̂̃XgłB]B
     * ftHg: [new java.util.ArrayList<blanco.cg.valueobject.BlancoCgEnum>()]B
     *
     * @return tB[h[enumList]擾lB
     */
    public List<blanco.cg.valueobject.BlancoCgEnum> getEnumList() {
        return fEnumList;
    }

    /**
     * tB[h [interfaceList] ̒lݒ肵܂B
     *
     * tB[h̐: [̃t@CɊ܂܂C^tF[X̃XgłB]B
     *
     * @param argInterfaceList tB[h[interfaceList]ɐݒ肷lB
     */
    public void setInterfaceList(final List<blanco.cg.valueobject.BlancoCgInterface> argInterfaceList) {
        fInterfaceList = argInterfaceList;
    }

    /**
     * tB[h [interfaceList] ̒l擾܂B
     *
     * tB[h̐: [̃t@CɊ܂܂C^tF[X̃XgłB]B
     * ftHg: [new java.util.ArrayList<blanco.cg.valueobject.BlancoCgInterface>()]B
     *
     * @return tB[h[interfaceList]擾lB
     */
    public List<blanco.cg.valueobject.BlancoCgInterface> getInterfaceList() {
        return fInterfaceList;
    }

    /**
     * tB[h [classList] ̒lݒ肵܂B
     *
     * tB[h̐: [̃t@CɊ܂܂NX̃XgłB]B
     *
     * @param argClassList tB[h[classList]ɐݒ肷lB
     */
    public void setClassList(final List<blanco.cg.valueobject.BlancoCgClass> argClassList) {
        fClassList = argClassList;
    }

    /**
     * tB[h [classList] ̒l擾܂B
     *
     * tB[h̐: [̃t@CɊ܂܂NX̃XgłB]B
     * ftHg: [new java.util.ArrayList<blanco.cg.valueobject.BlancoCgClass>()]B
     *
     * @return tB[h[classList]擾lB
     */
    public List<blanco.cg.valueobject.BlancoCgClass> getClassList() {
        return fClassList;
    }

    /**
     * tB[h [langDoc] ̒lݒ肵܂B
     *
     * tB[h̐: [hLg~܂BftHgȏ̕\ǉꍇɂ́ACX^X𐶐ĒlZbgĂ玩܂B]B
     * ȂÃo[IuWFNg̓\[Xt@ČhLgɊY邽߁AŃZbglۂ̃\[XR[hɔfꍇ̉e͈͂͌肳Ă܂ꍇ܂B
     *
     * @param argLangDoc tB[h[langDoc]ɐݒ肷lB
     */
    public void setLangDoc(final BlancoCgLangDoc argLangDoc) {
        fLangDoc = argLangDoc;
    }

    /**
     * tB[h [langDoc] ̒l擾܂B
     *
     * tB[h̐: [hLg~܂BftHgȏ̕\ǉꍇɂ́ACX^X𐶐ĒlZbgĂ玩܂B]B
     * ȂÃo[IuWFNg̓\[Xt@ČhLgɊY邽߁AŃZbglۂ̃\[XR[hɔfꍇ̉e͈͂͌肳Ă܂ꍇ܂B
     *
     * @return tB[h[langDoc]擾lB
     */
    public BlancoCgLangDoc getLangDoc() {
        return fLangDoc;
    }

    /**
     * ̃o[IuWFNg̕\擾܂B
     *
     * <P>gp̒</P>
     * <UL>
     * <LI>IuWFNg̃V[͈͂̂ݕ񉻂̏ΏۂƂȂ܂B
     * <LI>IuWFNgzQƂĂꍇɂ́Ã\bh͎gȂłB
     * </UL>
     *
     * @return o[IuWFNg̕\B
     */
    @Override
    public String toString() {
        final StringBuffer buf = new StringBuffer();
        buf.append("blanco.cg.valueobject.BlancoCgSourceFile[");
        buf.append("name=" + fName);
        buf.append(",description=" + fDescription);
        buf.append(",package=" + fPackage);
        buf.append(",encoding=" + fEncoding);
        buf.append(",importList=" + fImportList);
        buf.append(",enumList=" + fEnumList);
        buf.append(",interfaceList=" + fInterfaceList);
        buf.append(",classList=" + fClassList);
        buf.append(",langDoc=" + fLangDoc);
        buf.append("]");
        return buf.toString();
    }
}
