package blanco.sort.task;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

import blanco.commons.util.BlancoFileUtil;
import blanco.sort.task.valueobject.BlancoSortProcessInput;

public class BlancoSortProcessImpl implements BlancoSortProcess {
    private BlancoSortProcessInput fInput = null;

    public int execute(final BlancoSortProcessInput input) throws IOException,
            IllegalArgumentException {
        fInput = input;

        final File fileInput = new File(fInput.getInput());
        final File fileOutput = new File(fInput.getOutput());

        if (fileInput.exists() == false) {
            throw new IllegalArgumentException("w肳ꂽ̓t@C input["
                    + fileInput.getAbsolutePath() + "] ܂B");
        }
        if (fileInput.isFile() == false) {
            throw new IllegalArgumentException("w肳ꂽ̓t@C input["
                    + fileInput.getAbsolutePath() + "] ̓t@Cł͂܂B");
        }

        if (fileOutput.exists()) {
            if (fileOutput.isFile() == false) {
                throw new IllegalArgumentException("w肳ꂽo̓t@C output["
                        + fileOutput.getAbsolutePath() + "] ̓t@Cł͂܂B");
            }
            if (fileOutput.canWrite() == false)
                throw new IllegalArgumentException("w肳ꂽo̓t@C output["
                        + fileOutput.getAbsolutePath() + "] ͏ނƂł܂B");
        }

        // t@C͗p\

        process(fileInput, fileOutput);

        return 0;
    }

    private void process(final File fileInput, final File fileOutput)
            throws IOException {
        final List<String> list = new ArrayList<String>();
        final BufferedReader reader = new BufferedReader(new InputStreamReader(
                new FileInputStream(fileInput), fInput.getEncoding()));
        for (;;) {
            final String line = reader.readLine();
            if (line == null) {
                break;
            }
            list.add(line);
        }

        Collections.sort(list, new Comparator<String>() {
            public int compare(final String arg1, final String arg2) {
                // ŏɑ啶ʂɔr܂B
                final int first = arg1.compareToIgnoreCase(arg2);
                if (first != 0) {
                    return first;
                }
                // 啶ʂĔr܂B
                return arg1.compareTo(arg2);
            }
        });

        final ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        final BufferedWriter writer = new BufferedWriter(
                new OutputStreamWriter(outStream, fInput.getEncoding()));
        for (int index = 0; index < list.size(); index++) {
            writer.write(list.get(index));
            writer.newLine();
        }
        writer.close();

        switch (BlancoFileUtil.bytes2FileIfNecessary(outStream.toByteArray(),
                fileOutput)) {
        case 1:
            if (fInput.getVerbose()) {
                System.out.println("sort: create: " + fInput.getOutput());
            }
            break;
        case 2:
            if (fInput.getVerbose()) {
                System.out.println("sort: update: " + fInput.getOutput());
            }
            break;
        case 0:
            if (fInput.getVerbose()) {
                System.out.println("sort: none  : " + fInput.getOutput());
            }
            break;
        }
    }
}
