/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.xliff.util.task;

import java.io.File;
import java.io.IOException;

import blanco.xliff.BlancoXliffUtil;
import blanco.xliff.util.task.valueobject.BlancoXliffUtilExtractStateProcessInput;
import blanco.xliff.valueobject.BlancoXliff;
import blanco.xliff.valueobject.BlancoXliffFile;
import blanco.xliff.valueobject.BlancoXliffTransUnit;

public class BlancoXliffUtilExtractStateProcessImpl implements
        BlancoXliffUtilExtractStateProcess {
    private BlancoXliffUtilExtractStateProcessInput fInput = null;

    private BlancoXliff fXliffTarget = new BlancoXliff();

    public int execute(final BlancoXliffUtilExtractStateProcessInput input)
            throws IOException, IllegalArgumentException {
        fInput = input;

        final File fileXliffdir = new File(input.getXliffdir());
        final File[] files = fileXliffdir.listFiles();
        if (files == null) {
            return 0;
        }
        for (int index = 0; index < files.length; index++) {
            if (files[index].isFile() == false) {
                continue;
            }
            if (files[index].getName().endsWith(".xlf")) {
                process(fileXliffdir, files[index]);
            }
        }

        final File fileTargetfile = new File(fInput.getTargetfile());
        if (fileTargetfile.getParentFile().exists() == false) {
            fileTargetfile.getParentFile().mkdirs();
        }
        BlancoXliffUtil.saveXliffInstance(fXliffTarget, new File(fileTargetfile
                .getParentFile().getAbsolutePath()), fileTargetfile.getName()
                .substring(0,
                        fileTargetfile.getName().length() - ".xlf".length()));

        return 0;
    }

    private void process(final File fileXliffdir, final File fileTarget)
            throws IOException {

        final String bundleSymbolicName = fileTarget.getName().substring(0,
                fileTarget.getName().length() - ".xlf".length());

        final BlancoXliff fXliff = BlancoXliffUtil.getXliffInstance(
                fileXliffdir, bundleSymbolicName);

        for (int indexFile = 0; indexFile < fXliff.getFileList().size(); indexFile++) {
            final BlancoXliffFile file = fXliff.getFileList().get(indexFile);
            processFile(file);
        }
    }

    private void processFile(final BlancoXliffFile file) {
        for (int index = 0; index < file.getBody().getTransUnitList().size(); index++) {
            final BlancoXliffTransUnit transUnit = file.getBody()
                    .getTransUnitList().get(index);

            if (transUnit.getTarget() == null) {
                continue;
            }
            if (fInput.getState().equals(transUnit.getTarget().getState()) == false) {
                continue;
            }

            // state v܂BΏۂ trans-unit łB
            processTransUnit(transUnit);
        }
    }

    private void processTransUnit(final BlancoXliffTransUnit transUnit) {
        if (fXliffTarget.getFileList().size() == 0) {
            final BlancoXliffFile xliffFile = new BlancoXliffFile();
            fXliffTarget.getFileList().add(xliffFile);
        }

        final BlancoXliffFile xliffFile = fXliffTarget.getFileList().get(0);
        xliffFile.getBody().getTransUnitList().add(transUnit);
    }
}
