/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.nlpack.generator.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.Properties;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

import blanco.nlpack.generator.csv.io.BlancoCsvIOException;
import blanco.nlpack.generator.csv.io.BlancoNLpackGeneratorResultDetailCsvWriter;
import blanco.nlpack.generator.csv.record.BlancoNLpackGeneratorResultDetailCsvRecord;
import blanco.nlpack.generator.message.BlancoNLpackGeneratorMessage;
import blanco.nlpack.generator.resourcebundle.BlancoNLpackGeneratorResourceBundle;
import blanco.nlpack.generator.task.valueobject.BlancoNLpackGeneratorParsePropertiesProcessInput;
import blanco.properties.BlancoPropertiesUtil;
import blanco.properties.manifest.BlancoPropertiesManifestReader;
import blanco.properties.manifest.valueobject.BlancoPropertiesManifest;

/**
 * vpeBt@Cp[X郆[eBeBB
 * 
 * @author IGA Tosiki
 */
public class BlancoNLpackGeneratorParseProperties {
    /**
     * bZ[WIuWFNgB
     */
    private final BlancoNLpackGeneratorMessage fMsg = new BlancoNLpackGeneratorMessage();

    private final BlancoNLpackGeneratorResourceBundle fBundle = new BlancoNLpackGeneratorResourceBundle();

    private BlancoNLpackGeneratorParsePropertiesProcessInput fInput;

    private BlancoNLpackGeneratorResultDetailCsvWriter fWriter;

    /**
     * Java^CmĂ郍P[ꗗB
     */
    private String[] fKnownLocale = null;

    /**
     * w肳ꂽfBNg̃vOCɂĊeꉻs܂B
     * 
     * @param argInput
     *            ւ̓̓p[^B
     * @throws IOException
     *             o͗OꍇB
     */
    public void process(
            final BlancoNLpackGeneratorParsePropertiesProcessInput input)
            throws IOException {
        fInput = input;

        if (new File(fInput.getSourcedir()).exists() == false) {
            throw new IllegalArgumentException(fMsg.getMbebi001(fInput
                    .getSourcedir()));
        }

        fWriter = new BlancoNLpackGeneratorResultDetailCsvWriter(
                new BufferedWriter(new FileWriter(fInput.getTargetfile(), true)));
        fWriter.writeTitle();

        final File[] files = new File(fInput.getSourcedir()).listFiles();
        if (files != null) {
            for (int index = 0; index < files.length; index++) {
                if (files[index].isDirectory()) {
                    // WJꂽvOCfBNgB
                    processPluginExpandedDir(files[index].getName());
                } else {
                    if (files[index].getName().endsWith(".jar")) {
                        // jart@C`̃vOCB
                        processPluginJarFile(files[index].getName());
                    }
                }
            }
        }

        fWriter.close();
        fWriter = null;
    }

    /**
     * vOCjart@C܂B
     * 
     * TODO ͂ String  File ɕύX邱ƂB
     * 
     * @param targetPluginFullPlusJar
     * @throws IOException
     */
    private void processPluginJarFile(final String targetPluginFullPlusJar)
            throws IOException {
        final BlancoPropertiesManifest manifest = new BlancoPropertiesManifestReader()
                .readPluginJar(new File(fInput.getSourcedir() + "/"
                        + targetPluginFullPlusJar));

        String actualTargetPluginFull = targetPluginFullPlusJar;
        if (actualTargetPluginFull.endsWith(".jar")) {
            // .jar ̎wӏ܂B
            actualTargetPluginFull = actualTargetPluginFull.substring(0,
                    actualTargetPluginFull.length() - ".jar".length());
        } else {
            throw new IllegalArgumentException(fMsg
                    .getMbebi003(targetPluginFullPlusJar));
        }

        final InputStream inStream = new BufferedInputStream(
                new FileInputStream(fInput.getSourcedir() + "/"
                        + actualTargetPluginFull + ".jar"));
        processJarFileInternal(manifest, inStream);
        inStream.close();
    }

    /**
     * vOC̓WJfBNg܂B
     * 
     * @param targetPluginFullPlus
     * @throws IOException
     */
    private void processPluginExpandedDir(final String targetPluginFullPlus)
            throws IOException {
        final BlancoPropertiesManifest manifest = new BlancoPropertiesManifestReader()
                .readPluginDirectory(new File(fInput.getSourcedir() + "/"
                        + targetPluginFullPlus));

        final File[] files = new File(fInput.getSourcedir() + "/"
                + targetPluginFullPlus).listFiles();
        if (files != null) {
            for (int index = 0; index < files.length; index++) {
                if (files[index].isDirectory()) {
                } else {
                    if (files[index].getName().endsWith(".jar")) {
                        final InputStream inStream = new BufferedInputStream(
                                new FileInputStream(fInput.getSourcedir() + "/"
                                        + targetPluginFullPlus + "/"
                                        + files[index].getName()));
                        if (processJarFileInternal(manifest, inStream)) {
                            // u܂B
                        }
                        inStream.close();
                    } else if (checkFilenameForTarget(files[index].getName())) {
                        final InputStream inStream = new BufferedInputStream(
                                new FileInputStream(files[index]));

                        // 񍐗px[XfBNg:begin
                        final String wrkBase = new File(fInput.getSourcedir()
                                + "/" + targetPluginFullPlus)
                                .getCanonicalPath();
                        final String strPropertyFilePath = files[index]
                                .getCanonicalPath().substring(
                                        wrkBase.length() + 1);
                        // 񍐗px[XfBNg:end

                        if (processPropertiesFile(manifest,
                                BlancoPropertiesUtil.getBabelURI(manifest,
                                        strPropertyFilePath), inStream)) {
                            // u܂B
                        }

                        inStream.close();
                    }
                }
            }
        }
    }

    /**
     * jart@Ĉ߂̓\bhłB
     * 
     * @param manifest
     *            }jtFXgB
     * @param inStreamJarTarget
     *            jart@C̓̓Xg[B
     * @return ǂB
     * @throws IOException
     *             o͗OꍇB
     */
    private boolean processJarFileInternal(
            final BlancoPropertiesManifest manifest,
            final InputStream inStreamJarTarget) throws IOException {
        boolean isReplaced = false;
        final JarInputStream jarInStream = new JarInputStream(
                new BufferedInputStream(inStreamJarTarget));
        for (;;) {
            final JarEntry entry = jarInStream.getNextJarEntry();
            if (entry == null) {
                break;
            }

            if (entry.isDirectory()) {
            } else {
                if (entry.getName().endsWith(".jar")) {
                    if (processJarFileInternal(manifest, jarInStream)) {
                        isReplaced = true;
                    }
                } else {
                    if (checkFilenameForTarget(entry.getName()) == false) {
                        continue;
                    }

                    if (processPropertiesFile(manifest, BlancoPropertiesUtil
                            .getBabelURI(manifest, entry.getName()),
                            jarInStream)) {
                        isReplaced = true;
                    }
                }
            }
            jarInStream.closeEntry();
        }
        return isReplaced;

        // \B̓Xg[(jarInStream)́AăN[Y܂I Java
        // API̓lŕKvȑ[ułB
    }

    /**
     * vpeBt@C܂B
     * 
     * @param bundleURI
     * @param jarInStream
     * @param fileTarget
     * @return ǂB
     * @throws IOException
     */
    private boolean processPropertiesFile(
            final BlancoPropertiesManifest manifest, final String bundleURI,
            final InputStream jarInStream) throws IOException {
        // oCgƂēǂݍ
        final byte[] bytesProperties = BlancoPropertiesUtil
                .readBytes(jarInStream);

        final Properties props = new Properties();
        props.load(new ByteArrayInputStream(bytesProperties));

        final BufferedReader reader = new BufferedReader(new InputStreamReader(
                new ByteArrayInputStream(bytesProperties)));

        final boolean isReplaced = parseProperties(bundleURI, props, reader);

        // final BlancoNLpackGeneratorResultCsvRecord record = new
        // BlancoNLpackGeneratorResultCsvRecord();
        // record.setBundleSymbolicName(manifest.getBundleSymbolicName());
        // record.setBundleUri(bundleURI);

        return isReplaced;
    }

    /**
     * ^ꂽt@CׂvpeBt@Cł邩ǂ𔻒肵܂B
     * 
     * @param argFilename
     * @return
     */
    private boolean checkFilenameForTarget(final String argFilename) {
        if (argFilename.endsWith(".properties") == false) {
            // t@C .propertiesŏIĂȂ̂͏ΏۊOłB
            return false;
        }

        if (fKnownLocale == null) {
            fKnownLocale = BlancoPropertiesUtil.getAvailableLocaleStrings();
        }

        if (argFilename.endsWith("_" + fBundle.getTargetLocale()
                + ".properties")) {
            // ݂̃^[QbgP[Ȃ珈ΏۂłB
            return true;
        }

        for (int index = 0; index < fKnownLocale.length; index++) {
            if (argFilename.endsWith("_" + fKnownLocale[index] + ".properties")) {
                // t@C _(P[).propertiesŏIĂ̂͏ΏۊOłB
                return false;
            }
        }

        return true;
    }

    private boolean parseProperties(final String bundleURI,
            final Properties props, final BufferedReader reader)
            throws IOException {
        boolean isReplaced = false;
        for (;;) {
            outerLoop: {
                final String line = reader.readLine();
                if (line == null) {
                    break;
                }

                if (line.trim().startsWith("#") || line.trim().startsWith("!")
                        || line.trim().length() == 0) {
                    continue;
                }

                final StringBuffer strbufKey = new StringBuffer();

                StringReader readerLine = new StringReader(line);
                for (;;) {
                    final int iRead = readerLine.read();
                    if (iRead < 0) {
                        break outerLoop;
                    }
                    if (iRead == '\\') {
                        // GXP[vJnB
                        final int iRead2 = readerLine.read();
                        if (iRead2 < 0) {
                            // ͔Ă͍܂B
                            throw new IllegalArgumentException(
                                    "ʉ߂Ă͂ȂȂӏʉ߁BGXP[vɍsɓBB");
                        }
                        switch ((char) iRead2) {
                        case 'n':
                            strbufKey.append('\n');
                            break;
                        default:
                            strbufKey.append((char) iRead2);
                            break;
                        }
                    } else {

                        // ڏB
                        if (iRead == '=') {
                            // ӒlI
                            break;
                        }
                        strbufKey.append((char) iRead);
                    }
                }

                // ͉EӒl

                boolean isEscapeStarted = false;
                for (boolean isValueStarted = false;;) {
                    final int iRead = readerLine.read();
                    if (iRead < 0) {
                        if (isEscapeStarted) {
                            // GXP[vȂ̂ɍsɗĂ܂܂B
                            final String line2 = reader.readLine();
                            if (line2 == null) {
                                break;
                            }
                            isEscapeStarted = false;
                            readerLine = new StringReader(line2);
                            continue;
                        }
                        break;
                    }
                    if (isValueStarted == false && iRead == ' ') {
                        continue;
                    }
                    isValueStarted = true;

                    if (iRead == '\\') {
                        if (isEscapeStarted == false) {
                            isEscapeStarted = true;
                        } else {
                            isEscapeStarted = false;
                        }
                    } else {
                        if (isEscapeStarted) {
                            isEscapeStarted = false;
                        }
                    }
                }

                readerLine.close();

                // 擾ꂽL[ƂɎЂ܂B

                final String strKey = strbufKey.toString().trim();
                final String inputValue = (String) props.get(strKey);
                if (inputValue == null) {
                    System.out.println("̃vpeBt@C(Javaɂ鏈)");
                    final Iterator<?> ite = props.entrySet().iterator();
                    for (; ite.hasNext();) {
                        final Object obj = ite.next();
                        System.out.println("  " + obj.toString());
                    }

                    throw new IllegalArgumentException(fMsg.getMbebc002(
                            bundleURI, strKey));
                }

                final BlancoNLpackGeneratorResultDetailCsvRecord record = new BlancoNLpackGeneratorResultDetailCsvRecord();
                record.setBundleUri(bundleURI + "?key=" + strKey);
                record.setKey(strKey);
                record.setInput(inputValue);

                try {
                    fWriter.writeRecord(record);
                } catch (BlancoCsvIOException e) {
                    throw new IOException("CSVo͂ŗO: " + e.toString());
                }
            }
        }
        return isReplaced;
    }
}
