/*
 * blancoCsv Copyright (C) 2005 Tosiki Iga
 * 
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 */
package blanco.csv.expand;

import java.io.File;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoStringUtil;
import blanco.csv.resourcebundle.BlancoCsvResourceBundle;
import blanco.csv.resourcebundle.BlancoCsvWriterResourceBundle;
import blanco.csv.valueobject.BlancoCsvFieldStructure;
import blanco.csv.valueobject.BlancoCsvStructure;

public class BlancoCsvExpandWriter {
    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    final BlancoCsvResourceBundle bundle = new BlancoCsvResourceBundle();

    final BlancoCsvWriterResourceBundle writerBundle = new BlancoCsvWriterResourceBundle();

    /**
     * \[Xt@C̕GR[fBOB
     */
    private String fEncoding = null;

    public void setEncoding(final String argEncoding) {
        fEncoding = argEncoding;
    }

    public void expand(final BlancoCsvStructure processStructure,
            final File directoryTarget) {

        final String className = BlancoNameAdjuster
                .toClassName(processStructure.getFileDefinitionId())
                + writerBundle.getClassNameSuffix();

        final String classNameblancoCsvIOException = processStructure
                .getRuntimePackage()
                + ".io.BlancoCsvIOException";

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(directoryTarget.getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(processStructure
                .getPackageName()
                + writerBundle.getPackagePrefix(),
                "̃\[XR[h blanco FrameworkɂĎĂ܂B");
        fCgSourceFile.setEncoding(fEncoding);
        fCgClass = fCgFactory
                .createClass(
                        className,
                        BlancoStringUtil
                                .null2Blank(writerBundle
                                        .getClasscomment01(processStructure
                                                .getFileDefinitionId()
                                                + (processStructure
                                                        .getFileDescription() == null ? ""
                                                        : "/"
                                                                + processStructure
                                                                        .getFileDescription()))));
        fCgSourceFile.getClassList().add(fCgClass);
        fCgClass.getLangDoc().getDescriptionList().add(
                writerBundle.getClasscomment02());

        if (processStructure.getEncoding() == null) {
            fCgClass.getLangDoc().getDescriptionList().add(
                    writerBundle.getClasscomment03Case01());
        } else {
            fCgClass.getLangDoc().getDescriptionList().add(
                    writerBundle.getClasscomment03Case02(processStructure
                            .getEncoding()));
        }
        fCgClass.getLangDoc().getDescriptionList().add(
                writerBundle.getClasscomment04());

        // tB[hǉ
        {
            final BlancoCgField field = fCgFactory.createField(writerBundle
                    .getFieldWriterName(), writerBundle.getFieldWriterType(),
                    writerBundle.getFieldWriterJavadoc01());
            fCgClass.getFieldList().add(field);
            field.getLangDoc().getDescriptionList().add(
                    writerBundle.getFieldWriterJavadoc02());
        }

        {
            final BlancoCgField field = fCgFactory.createField(writerBundle
                    .getFieldLineCounterName(), writerBundle
                    .getFieldLineCounterType(), writerBundle
                    .getFieldLineCounterJavadoc01());
            fCgClass.getFieldList().add(field);
            field.getLangDoc().getDescriptionList().add(
                    writerBundle.getFieldLineCounterJavadoc02());
            field.setDefault(writerBundle.getFieldLineCounterDefault());
        }

        // uvΉ
        for (int indexField = 0; indexField < processStructure.getFieldList()
                .size(); indexField++) {
            final BlancoCsvFieldStructure fieldStructure = (BlancoCsvFieldStructure) processStructure
                    .getFieldList().get(indexField);

            if (fieldStructure.getType().equals("java.util.Date")) {
                final BlancoCgField field = fCgFactory
                        .createField(
                                writerBundle
                                        .getFieldSimpleDateFormatNamePrefix()
                                        + BlancoNameAdjuster
                                                .toClassName(fieldStructure
                                                        .getName()),
                                "java.text.SimpleDateFormat",
                                writerBundle
                                        .getFieldSimpleDateFormatJavadoc01(fieldStructure
                                                .getName()));
                fCgClass.getFieldList().add(field);
                field.getLangDoc().getDescriptionList().add(
                        writerBundle.getFieldSimpleDateFormatJavadoc02());
            }
        }

        {
            final BlancoCgMethod method = fCgFactory.createMethod(className,
                    writerBundle.getConstructor01Javadoc01());
            fCgClass.getMethodList().add(method);
            method.setConstructor(true);
            method.getLangDoc().getDescriptionList().add(
                    writerBundle.getConstructor01Javadoc02());
            method.getParameterList().add(
                    fCgFactory.createParameter("arg", writerBundle
                            .getConstructor01Arg01Type(), writerBundle
                            .getConstructor01Arg01Javadoc01()));

            // \bh̎
            method.getLineList().add("fWriter = arg;");

            // uvΉ
            for (int indexField = 0; indexField < processStructure
                    .getFieldList().size(); indexField++) {
                final BlancoCsvFieldStructure field = (BlancoCsvFieldStructure) processStructure
                        .getFieldList().get(indexField);

                if (field.getType().equals("java.util.Date")) {
                    method
                            .getLineList()
                            .add(
                                    "fSimpleDateFormat"
                                            + BlancoNameAdjuster
                                                    .toClassName(field
                                                            .getName())
                                            + " = new SimpleDateFormat("
                                            + (field.getFormat() == null ? "\"yyyy/MM/dd\""
                                                    : "\"" + field.getFormat()
                                                            + "\"") + ");");

                }
            }
        }

        if (processStructure.getTitleRow().equals("title with quote")
                || processStructure.getTitleRow().equals("title without quote")) {
            final BlancoCgMethod method = fCgFactory.createMethod("writeTitle",
                    writerBundle.getWritetitleJavadoc01());
            fCgClass.getMethodList().add(method);

            method.getLangDoc().getDescriptionList().add(
                    writerBundle.getWritetitleJavadoc02());
            if (processStructure.getTitleRow().equals("title with quote")) {
                method.getLangDoc().getDescriptionList().add(
                        writerBundle.getWritetitleJavadoc03());
            }
            method.getThrowList().add(
                    fCgFactory.createException(writerBundle
                            .getWritetitleThrows01Type(), writerBundle
                            .getWritetitleThrows01Javadoc()));
            for (int indexField = 0; indexField < processStructure
                    .getFieldList().size(); indexField++) {
                final BlancoCsvFieldStructure field = (BlancoCsvFieldStructure) processStructure
                        .getFieldList().get(indexField);
                final String delimiter = (indexField != 0 ? processStructure
                        .getDelimiter() : "");
                final String quote = (processStructure.getTitleRow().equals(
                        "title with quote") ? BlancoJavaSourceUtil
                        .escapeStringAsJavaSource("\"") : "");
                method.getLineList().add(
                        "fWriter.write(\""
                                + delimiter
                                + quote
                                + BlancoJavaSourceUtil
                                        .escapeStringAsJavaSource(field
                                                .getDescription()) + quote
                                + "\");");
            }
            method.getLineList().add("fWriter.newLine();");
        }

        final String recordClassName = processStructure.getPackageName()
                + ".record."
                + BlancoNameAdjuster.toClassName(processStructure
                        .getFileDefinitionId()) + "CsvRecord";

        // \bh̃VOj`w
        {
            final BlancoCgMethod method = fCgFactory.createMethod(
                    "writeRecord", writerBundle.getWriterecordJavadoc01());
            fCgClass.getMethodList().add(method);
            method.getLangDoc().getDescriptionList().add(
                    writerBundle.getWriterecordJavadoc02());
            method.getParameterList().add(
                    fCgFactory.createParameter("record", recordClassName,
                            writerBundle.getWriterecordArg01Javadoc()));
            method.getThrowList().add(
                    fCgFactory.createException(classNameblancoCsvIOException,
                            writerBundle.getWriterecordThrows01Javadoc()));
            method.getThrowList().add(
                    fCgFactory.createException(writerBundle
                            .getWriterecordThrows02Type(), writerBundle
                            .getWriterecordThrows02Javadoc()));

            // \bh̎
            // public void implement() {
            method.getLineList().add("String writeToken = null;");
            for (int indexField = 0; indexField < processStructure
                    .getFieldList().size(); indexField++) {
                final BlancoCsvFieldStructure fieldStructure = (BlancoCsvFieldStructure) processStructure
                        .getFieldList().get(indexField);

                if (indexField != 0) {
                    // f~^óB
                    method.getLineList().add(
                            "fWriter.write('" + processStructure.getDelimiter()
                                    + "');");
                }

                method.getLineList().add("");
                method
                        .getLineList()
                        .add(
                                writerBundle
                                        .getWriterecordLine01(
                                                (fieldStructure.getNo() == null ? ""
                                                        : bundle
                                                                .getFieldNo(fieldStructure
                                                                        .getNo())
                                                                + " "),
                                                fieldStructure.getName()
                                                        + (fieldStructure
                                                                .getDescription() == null ? ""
                                                                : "/"
                                                                        + fieldStructure
                                                                                .getDescription())));

                if (fieldStructure.getType().equals("java.lang.String")
                        || fieldStructure.getType().equals(
                                "java.lang.String(quote)")) {
                    if (fieldStructure.getRequired()) {
                        // K{ځB
                        method.getLineList().add(
                                "if (record.get"
                                        + BlancoNameAdjuster
                                                .toClassName(fieldStructure
                                                        .getName())
                                        + "() == null) {");
                        method
                                .getLineList()
                                .add(
                                        "throw new BlancoCsvIOException(\""
                                                + bundle
                                                        .getCsvWriterErr004(getLocationString(
                                                                indexField,
                                                                fieldStructure
                                                                        .getNo(),
                                                                fieldStructure
                                                                        .getName(),
                                                                fieldStructure
                                                                        .getDescription()))
                                                + "\");");
                        method.getLineList().add("}");
                        method.getLineList().add(
                                "if (record.get"
                                        + BlancoNameAdjuster
                                                .toClassName(fieldStructure
                                                        .getName())
                                        + "().length() == 0) {");
                        method
                                .getLineList()
                                .add(
                                        "throw new BlancoCsvIOException(\""
                                                + bundle
                                                        .getCsvWriterErr005(getLocationString(
                                                                indexField,
                                                                fieldStructure
                                                                        .getNo(),
                                                                fieldStructure
                                                                        .getName(),
                                                                fieldStructure
                                                                        .getDescription()))
                                                + "\");");
                        method.getLineList().add("}");
                        method.getLineList().add(
                                "writeToken = record.get"
                                        + BlancoNameAdjuster
                                                .toClassName(fieldStructure
                                                        .getName()) + "();");
                    } else {
                        // CӍڂł̂ null͒0̕ւƓǂݑւ܂B
                        method
                                .getLineList()
                                .add(
                                        "// CӍڂŕ̍ڂ null܂͒0̕񂪗^ꂽꍇɂ́AlĂȂ̂Ƃ݂Ȃ܂B");
                        method.getLineList().add("// ̏ꍇɂ͒`FbN͍s܂B");
                        method.getLineList().add(
                                "writeToken = record.get"
                                        + BlancoNameAdjuster
                                                .toClassName(fieldStructure
                                                        .getName())
                                        + "() == null ? \"\" : record.get"
                                        + BlancoNameAdjuster
                                                .toClassName(fieldStructure
                                                        .getName()) + "();");
                        // ifJnԂ̂܂܂ɂ܂B
                        method.getLineList().add(
                                "if (writeToken.length() > 0) {");
                    }
                } else if (fieldStructure.getType().equals("int")
                        || fieldStructure.getType().equals("long")) {
                    if (fieldStructure.getRequired()) {
                        // K{ځB
                        // int, long̓v~eBu^Ȃ̂null`FbN͕svB
                        method.getLineList().add(
                                "writeToken = String.valueOf(record.get"
                                        + BlancoNameAdjuster
                                                .toClassName(fieldStructure
                                                        .getName()) + "());");
                    } else {
                        // CӍځB
                        method.getLineList().add(
                                "if (record.get"
                                        + BlancoNameAdjuster
                                                .toClassName(fieldStructure
                                                        .getName())
                                        + "() == null) {");
                        method.getLineList().add("writeToken = \"\";");
                        method.getLineList().add("} else {");
                        // ifJnԂ̂܂܂ɂ܂B
                        method.getLineList().add(
                                "writeToken = String.valueOf(record.get"
                                        + BlancoNameAdjuster
                                                .toClassName(fieldStructure
                                                        .getName()) + "());");
                    }
                } else if (fieldStructure.getType().equals("java.util.Date")) {
                    fCgSourceFile.getImportList().add("java.io.IOException");
                    if (fieldStructure.getRequired()) {
                        // K{ځB
                        method.getLineList().add(
                                "if (record.get"
                                        + BlancoNameAdjuster
                                                .toClassName(fieldStructure
                                                        .getName())
                                        + "() == null) {");
                        method
                                .getLineList()
                                .add(
                                        "throw new BlancoCsvIOException(\""
                                                + bundle
                                                        .getCsvWriterErr004(getLocationString(
                                                                indexField,
                                                                fieldStructure
                                                                        .getNo(),
                                                                fieldStructure
                                                                        .getName(),
                                                                fieldStructure
                                                                        .getDescription()))
                                                + "\");");
                        method.getLineList().add("}");
                        method.getLineList().add(
                                "writeToken = fSimpleDateFormat"
                                        + BlancoNameAdjuster
                                                .toClassName(fieldStructure
                                                        .getName())
                                        + ".format(record.get"
                                        + BlancoNameAdjuster
                                                .toClassName(fieldStructure
                                                        .getName()) + "());");
                    } else {
                        // CӍځB
                        // CӍڂł̂ null͒0̕ւƓǂݑւ܂B
                        method.getLineList().add(
                                "if (record.get"
                                        + BlancoNameAdjuster
                                                .toClassName(fieldStructure
                                                        .getName())
                                        + "() == null) {");
                        method.getLineList().add("writeToken = \"\";");
                        method.getLineList().add("} else {");
                        // ifJnԂ̂܂܂ɂ܂B
                        method.getLineList().add(
                                "writeToken = fSimpleDateFormat"
                                        + BlancoNameAdjuster
                                                .toClassName(fieldStructure
                                                        .getName())
                                        + ".format(record.get"
                                        + BlancoNameAdjuster
                                                .toClassName(fieldStructure
                                                        .getName()) + "());");
                    }
                } else if (fieldStructure.getType().equals(
                        "java.math.BigDecimal")) {
                    // java.math.BigDecimal̃C|[g͕svB
                    if (fieldStructure.getRequired()) {
                        // K{ځB
                        method.getLineList().add(
                                "if (record.get"
                                        + BlancoNameAdjuster
                                                .toClassName(fieldStructure
                                                        .getName())
                                        + "() == null) {");
                        method
                                .getLineList()
                                .add(
                                        "throw new BlancoCsvIOException(\""
                                                + bundle
                                                        .getCsvWriterErr004(getLocationString(
                                                                indexField,
                                                                fieldStructure
                                                                        .getNo(),
                                                                fieldStructure
                                                                        .getName(),
                                                                fieldStructure
                                                                        .getDescription()))
                                                + "\");");
                        method.getLineList().add("}");
                        method.getLineList().add(
                                "writeToken = record.get"
                                        + BlancoNameAdjuster
                                                .toClassName(fieldStructure
                                                        .getName())
                                        + "().toString();");
                    } else {
                        // CӍڂł̂ null͒0̕ւƓǂݑւ܂B
                        method.getLineList().add(
                                "if (record.get"
                                        + BlancoNameAdjuster
                                                .toClassName(fieldStructure
                                                        .getName())
                                        + "() == null) {");
                        method.getLineList().add("writeToken = \"\";");
                        method.getLineList().add("} else {");
                        // ifJnԂ̂܂܂ɂ܂B
                        method.getLineList().add(
                                "writeToken = record.get"
                                        + BlancoNameAdjuster
                                                .toClassName(fieldStructure
                                                        .getName())
                                        + "() == null ? \"\" : record.get"
                                        + BlancoNameAdjuster
                                                .toClassName(fieldStructure
                                                        .getName())
                                        + "().toString();");
                    }
                } else {
                    method.getLineList().add(
                            bundle
                                    .getNotSupportedType(fieldStructure
                                            .getType()));
                    method.getLineList().add("writeToken = \"\";");
                }

                if (fieldStructure.getRequired()) {
                    // K{ځB
                    method.getLineList().add("if (writeToken == null) {");
                    method
                            .getLineList()
                            .add(
                                    "throw new BlancoCsvIOException(\""
                                            + bundle
                                                    .getCsvWriterErr004(getLocationString(
                                                            indexField,
                                                            fieldStructure
                                                                    .getNo(),
                                                            fieldStructure
                                                                    .getName(),
                                                            fieldStructure
                                                                    .getDescription()))
                                            + "\");");
                    method.getLineList().add("}");
                }

                final String encodingString = (processStructure.getEncoding() == null ? ""
                        : "\"" + processStructure.getEncoding() + "\"");
                if (fieldStructure.getMinLength() != null) {
                    method.getLineList().add(
                            "if (writeToken.getBytes(" + encodingString
                                    + ").length < "
                                    + fieldStructure.getMinLength() + ") {");
                    method.getLineList().add(
                            "throw new BlancoCsvIOException(\""
                                    + bundle.getCsvWriterErr001(
                                            getLocationString(indexField,
                                                    fieldStructure.getNo(),
                                                    fieldStructure.getName(),
                                                    fieldStructure
                                                            .getDescription()),
                                            fieldStructure.getMinLength())
                                    + "\");");
                    method.getLineList().add("}");
                }
                if (fieldStructure.getMaxLength() != null) {
                    method.getLineList().add(
                            "if (writeToken.getBytes(" + encodingString
                                    + ").length > "
                                    + fieldStructure.getMaxLength() + ") {");
                    method.getLineList().add(
                            "throw new BlancoCsvIOException(\""
                                    + bundle.getCsvWriterErr002(
                                            getLocationString(indexField,
                                                    fieldStructure.getNo(),
                                                    fieldStructure.getName(),
                                                    fieldStructure
                                                            .getDescription()),
                                            fieldStructure.getMaxLength())
                                    + "\");");
                    method.getLineList().add("}");
                }

                if (fieldStructure.getRequired()) {
                } else {
                    // CӍڂ̓JbRJςȂł̂ŁAŕ܂B
                    method.getLineList().add("}");
                }

                if (fieldStructure.getType().equals("java.lang.String")) {
                    method.getLineList().add(
                            "if (writeToken.indexOf(\""
                                    + processStructure.getDelimiter()
                                    + "\") >= 0) {");
                    method.getLineList().add(
                            "throw new BlancoCsvIOException(\""
                                    + bundle.getCsvWriterErr003(
                                            getLocationString(indexField,
                                                    fieldStructure.getNo(),
                                                    fieldStructure.getName(),
                                                    fieldStructure
                                                            .getDescription()),
                                            processStructure.getDelimiter())
                                    + "\");");
                    method.getLineList().add("}");
                    method.getLineList().add("fWriter.write(writeToken);");
                } else if (fieldStructure.getType().equals(
                        "java.lang.String(quote)")) {
                    // ^̗pǉ܂B
                    fCgSourceFile.getImportList().add(
                            processStructure.getRuntimePackage()
                                    + ".util.BlancoCsvRuntimeUtil");

                    method.getLineList().add(
                            writerBundle.getWriterecordLine02());
                    method
                            .getLineList()
                            .add(
                                    "fWriter.write(BlancoCsvRuntimeUtil.getTokenWithQuote(writeToken));");
                } else {
                    method.getLineList().add("fWriter.write(writeToken);");
                }
            }
            method.getLineList().add("");
            method.getLineList().add(writerBundle.getWriterecordLine03());
            method.getLineList().add("fWriter.newLine();");
            method.getLineList().add("fLineCounter++;");
        }

        {
            final BlancoCgMethod method = fCgFactory.createMethod("getWriter",
                    "IɕێĂ郉C^Ԃ܂B");
            fCgClass.getMethodList().add(method);
            method.setReturn(fCgFactory.createReturn("java.io.BufferedWriter",
                    "IɕێĂ郉C^B"));

            method.getLineList().add("return fWriter;");
        }

        {
            final BlancoCgMethod method = fCgFactory.createMethod(
                    "getLineCounter", "ݏ̍sJE^Ԃ܂B");
            fCgClass.getMethodList().add(method);
            method.setReturn(fCgFactory.createReturn("long", "ݏ̍sJE^B"));

            // \bh̎
            // public void implement() {
            method.getLineList().add("return fLineCounter;");
        }

        {
            final BlancoCgMethod method = fCgFactory.createMethod("flush",
                    writerBundle.getFlushJavadoc01());
            fCgClass.getMethodList().add(method);
            method.getLangDoc().getDescriptionList().add(
                    writerBundle.getFlushJavadoc02());
            method.getThrowList().add(
                    fCgFactory.createException(writerBundle
                            .getFlushThrows01Type(), writerBundle
                            .getFlushThrows01Javadoc()));

            // \bh̎
            method.getLineList().add("fWriter.flush();");
        }

        {
            final BlancoCgMethod method = fCgFactory.createMethod("close",
                    writerBundle.getCloseJavadoc01());
            fCgClass.getMethodList().add(method);
            method.getLangDoc().getDescriptionList().add(
                    writerBundle.getCloseJavadoc02());
            method.getThrowList().add(
                    fCgFactory.createException(writerBundle
                            .getCloseThrows01Type(), writerBundle
                            .getCloseThrows01Javadoc()));

            // \bh̎
            method.getLineList().add("fWriter.close();");
        }

        BlancoCgTransformerFactory.getJavaSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }

    private String getLocationString(int indexField, String fieldNo,
            String fieldName, String fieldDescription) {
        return writerBundle.getGetlocationstringLine01("" + (indexField + 1),
                (fieldNo == null ? "" : bundle.getFieldNo(fieldNo) + " "),
                fieldName
                        + (fieldDescription == null ? "" : "/"
                                + fieldDescription));
    }
}
