/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 */
package blanco.nlpack.generator.task;

import java.io.IOException;

import blanco.nlpack.generator.task.valueobject.BlancoNLpackGeneratorValidateResultDetailProcessInput;

/**
 * ob`NX [BlancoNLpackGeneratorValidateResultDetailBatchProcess]B
 *
 * <P>ob`̌ĂяoB</P>
 * <code>
 * java -classpath (NXpX) blanco.nlpack.generator.task.BlancoNLpackGeneratorValidateResultDetailBatchProcess -help
 * </code>
 */
public class BlancoNLpackGeneratorValidateResultDetailBatchProcess {
    /**
     * IB
     */
    public static final int END_SUCCESS = 0;

    /**
     * ُ͈IBIjava.lang.IllegalArgumentExceptionꍇB
     */
    public static final int END_ILLEGAL_ARGUMENT_EXCEPTION = 7;

    /**
     * o͗OIBIjava.io.IOExceptionꍇB
     */
    public static final int END_IO_EXCEPTION = 8;

    /**
     * ُIBob`̏JnɎsꍇAѓIjava.lang.Error܂java.lang.RuntimeExceptionꍇB
     */
    public static final int END_ERROR = 9;

    /**
     * R}hCsꂽۂ̃Gg|CgłB
     *
     * @param args R\[pꂽB
     */
    public static final void main(final String[] args) {
        final BlancoNLpackGeneratorValidateResultDetailBatchProcess batchProcess = new BlancoNLpackGeneratorValidateResultDetailBatchProcess();

        // ob`̈B
        final BlancoNLpackGeneratorValidateResultDetailProcessInput input = new BlancoNLpackGeneratorValidateResultDetailProcessInput();

        boolean isNeedUsage = false;
        boolean isFieldSourcefileProcessed = false;
        boolean isFieldTargetfileProcessed = false;

        // R}hC̉͂Ȃ܂B
        for (int index = 0; index < args.length; index++) {
            String arg = args[index];
            if (arg.startsWith("-verbose=")) {
                input.setVerbose(Boolean.valueOf(arg.substring(9)).booleanValue());
            } else if (arg.startsWith("-sourcefile=")) {
                input.setSourcefile(arg.substring(12));
                isFieldSourcefileProcessed = true;
            } else if (arg.startsWith("-targetfile=")) {
                input.setTargetfile(arg.substring(12));
                isFieldTargetfileProcessed = true;
            } else if (arg.startsWith("-checkendoflineperiod=")) {
                input.setCheckendoflineperiod(Boolean.valueOf(arg.substring(22)).booleanValue());
            } else if (arg.startsWith("-checkcolon=")) {
                input.setCheckcolon(Boolean.valueOf(arg.substring(12)).booleanValue());
            } else if (arg.equals("-?") || arg.equals("-help")) {
                usage();
                System.exit(END_SUCCESS);
            } else {
                System.out.println("BlancoNLpackGeneratorValidateResultDetailBatchProcess: ̓p[^[" + arg + "]͖܂B");
                isNeedUsage = true;
            }
        }

        if (isNeedUsage) {
            usage();
        }

        if( isFieldSourcefileProcessed == false) {
            System.out.println("BlancoNLpackGeneratorValidateResultDetailBatchProcess: JnsB̓p[^[input]̕K{tB[hl[sourcefile]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }
        if( isFieldTargetfileProcessed == false) {
            System.out.println("BlancoNLpackGeneratorValidateResultDetailBatchProcess: JnsB̓p[^[input]̕K{tB[hl[targetfile]ɒlݒ肳Ă܂B");
            System.exit(END_ILLEGAL_ARGUMENT_EXCEPTION);
        }

        int retCode = batchProcess.execute(input);

        // IR[h߂܂B
        // ӁFSystem.exit()ĂяoĂ_ɒӂĂB
        System.exit(retCode);
    }

    /**
     * ̓Iȃob`eLq邽߂̃\bhłB
     *
     * ̃\bhɎۂ̏eLq܂B
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IOException o͗OꍇB
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public int process(final BlancoNLpackGeneratorValidateResultDetailProcessInput input) throws IOException, IllegalArgumentException {
        // ̓p[^`FbN܂B
        validateInput(input);

        // ̉ӏŃRpCG[ꍇABlancoNLpackGeneratorValidateResultDetailProcessC^tF[X blanco.nlpack.generator.taskpbP[W BlancoNLpackGeneratorValidateResultDetailProcessImplNX쐬邱Ƃɂłꍇ܂B
        final BlancoNLpackGeneratorValidateResultDetailProcess process = new BlancoNLpackGeneratorValidateResultDetailProcessImpl();

        // ̖{̂s܂B
        final int retCode = process.execute(input);

        return retCode;
    }

    /**
     * NXCX^Xăob`sۂ̃Gg|CgłB
     *
     * ̃\bh͉L̎dl񋟂܂B
     * <ul>
     * <li>\bh̓̓p[^̓e`FbNB
     * <li>IllegalArgumentException, RuntimeException, ErrorȂǂ̗OcatchĖ߂lւƕϊB
     * </ul>
     *
     * @param input ob`̓̓p[^B
     * @return ob`̏IR[hBEND_SUCCESS, END_ILLEGAL_ARGUMENT_EXCEPTION, END_IO_EXCEPTION, END_ERROR ̂ꂩ̒l߂܂B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public final int execute(final BlancoNLpackGeneratorValidateResultDetailProcessInput input) throws IllegalArgumentException {
        try {
            // ob`̖{̂s܂B
            int retCode = process(input);

            return retCode;
        } catch (IllegalArgumentException ex) {
            System.out.println("BlancoNLpackGeneratorValidateResultDetailBatchProcess: ͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_ILLEGAL_ARGUMENT_EXCEPTION;
        } catch (IOException ex) {
            System.out.println("BlancoNLpackGeneratorValidateResultDetailBatchProcess: o͗O܂Bob`𒆒f܂B:" + ex.toString());
            // ُ͈IB
            return END_IO_EXCEPTION;
        } catch (RuntimeException ex) {
            System.out.println("BlancoNLpackGeneratorValidateResultDetailBatchProcess: ^CO܂Bob`𒆒f܂B:" + ex.toString());
            ex.printStackTrace();
            // ُIB
            return END_ERROR;
        } catch (Error er) {
            System.out.println("BlancoNLpackGeneratorValidateResultDetailBatchProcess: ^CG[܂Bob`𒆒f܂B:" + er.toString());
            er.printStackTrace();
            // ُIB
            return END_ERROR;
        }
    }

    /**
     * ̃ob`NX̎g̐Wo͂Ɏ߂̃\bhłB
     */
    public static final void usage() {
        System.out.println("BlancoNLpackGeneratorValidateResultDetailBatchProcess: Usage:");
        System.out.println("  java blanco.nlpack.generator.task.BlancoNLpackGeneratorValidateResultDetailBatchProcess -verbose=l1 -sourcefile=l2 -targetfile=l3 -checkendoflineperiod=l4 -checkcolon=l5");
        System.out.println("    -verbose");
        System.out.println("      [verbose[hœ삳邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[false]");
        System.out.println("    -sourcefile");
        System.out.println("      [̓t@CB: conf/BlancoNLpackGeneratorTranslationFragment.csv]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -targetfile");
        System.out.println("      [o̓t@CB: tmp/validate/BlancoNLpackGeneratorTranslationFragmentValidateLog.csv]");
        System.out.println("      ^[]");
        System.out.println("      K{p[^");
        System.out.println("    -checkendoflineperiod");
        System.out.println("      [̃sIh`FbN邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[true]");
        System.out.println("    -checkcolon");
        System.out.println("      [R(:)`FbN邩ǂB]");
        System.out.println("      ^[^U]");
        System.out.println("      ftHgl[true]");
        System.out.println("    -? , -help");
        System.out.println("      [g\܂B]");
    }

    /**
     * ̃ob`NX̓̓p[^̑Ó`FbN{邽߂̃\bhłB
     *
     * @param input ob`̓̓p[^B
     * @throws IllegalArgumentException ͒lɕsꍇB
     */
    public void validateInput(final BlancoNLpackGeneratorValidateResultDetailProcessInput input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException("BlancoBatchProcessBatchProcess: JnsB̓p[^[input]null^܂B");
        }
        if (input.getSourcefile() == null) {
            throw new IllegalArgumentException("BlancoNLpackGeneratorValidateResultDetailBatchProcess: JnsB̓p[^[input]̕K{tB[hl[sourcefile]ɒlݒ肳Ă܂B");
        }
        if (input.getTargetfile() == null) {
            throw new IllegalArgumentException("BlancoNLpackGeneratorValidateResultDetailBatchProcess: JnsB̓p[^[input]̕K{tB[hl[targetfile]ɒlݒ肳Ă܂B");
        }
    }
}
