/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * \[Xoh`쐬ꂽ\[XohNXB
 */
package blanco.report.resourcebundle;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

/**
 * \[Xoh`[BlancoUno]̃\[XohNXB
 *
 * ̃NX̓\[Xoh`玩ꂽ\[XohNXłB<BR>
 * m̃P[<BR>
 * <UL>
 * <LI>ja
 * </UL>
 */
public class BlancoUnoResourceBundle {
    /**
     * \[XohIuWFNgB
     *
     * IɎۂɓ͂s\[XohL܂B
     */
    private ResourceBundle fResourceBundle;

    /**
     * BlancoUnoResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoUno]AftHg̃P[AĂяõNX[_gpāA\[Xoh擾܂B
     */
    public BlancoUnoResourceBundle() {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoUno");
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BlancoUnoResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoUno]Aw肳ꂽP[AĂяõNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     */
    public BlancoUnoResourceBundle(final Locale locale) {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoUno", locale);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * BlancoUnoResourceBundleNX̃RXgN^B
     *
     * ꖼ[BlancoUno]Aw肳ꂽP[Aw肳ꂽNX[_gpāA\[Xoh擾܂B
     *
     * @param locale P[̎w
     * @param loader NX[_̎w
     */
    public BlancoUnoResourceBundle(final Locale locale, final ClassLoader loader) {
        try {
            fResourceBundle = ResourceBundle.getBundle("BlancoUno", locale, loader);
        } catch (MissingResourceException ex) {
        }
    }

    /**
     * IɕێĂ郊\[XohIuWFNg擾܂B
     *
     * @return IɕێĂ郊\[XohIuWFNgB
     */
    public ResourceBundle getResourceBundle() {
        return fResourceBundle;
    }

    /**
     * bundle[BlancoUno], key[UNO.CONNECTION.STRING]
     *
     * [socket,host=localhost,port=8100,tcpNoDelay=1] (ja)<br>
     *
     * @return key[UNO.CONNECTION.STRING]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getUnoConnectionString() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "socket,host=localhost,port=8100,tcpNoDelay=1";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("UNO.CONNECTION.STRING");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoUno], key[UNO.CONVERTER.SHOWOPENOFFICEWINDOW]
     *
     * [true] (ja)<br>
     *
     * @return key[UNO.CONVERTER.SHOWOPENOFFICEWINDOW]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getUnoConverterShowopenofficewindow() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "true";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("UNO.CONVERTER.SHOWOPENOFFICEWINDOW");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoUno], key[UNO.LAUNCHER.OPENOFFICE.LOADMODULE]
     *
     * [C:\Program Files\OpenOffice.org 2.3\program\soffice.exe] (ja)<br>
     *
     * @return key[UNO.LAUNCHER.OPENOFFICE.LOADMODULE]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getUnoLauncherOpenofficeLoadmodule() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "C:\\Program Files\\OpenOffice.org 2.3\\program\\soffice.exe";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("UNO.LAUNCHER.OPENOFFICE.LOADMODULE");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoUno], key[UNO.LAUNCHER.OPENOFFICE.EXECPARAM]
     *
     * [-accept=socket,port=8100;urp;] (ja)<br>
     *
     * @return key[UNO.LAUNCHER.OPENOFFICE.EXECPARAM]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getUnoLauncherOpenofficeExecparam() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "-accept=socket,port=8100;urp;";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("UNO.LAUNCHER.OPENOFFICE.EXECPARAM");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoUno], key[UNO.LAUNCHER.OPENOFFICE.KILLCMD1]
     *
     * [taskkill.exe] (ja)<br>
     *
     * @return key[UNO.LAUNCHER.OPENOFFICE.KILLCMD1]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getUnoLauncherOpenofficeKillcmd1() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "taskkill.exe";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("UNO.LAUNCHER.OPENOFFICE.KILLCMD1");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoUno], key[UNO.LAUNCHER.OPENOFFICE.KILLCMD2]
     *
     * [/f] (ja)<br>
     *
     * @return key[UNO.LAUNCHER.OPENOFFICE.KILLCMD2]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getUnoLauncherOpenofficeKillcmd2() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "/f";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("UNO.LAUNCHER.OPENOFFICE.KILLCMD2");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoUno], key[UNO.LAUNCHER.OPENOFFICE.KILLCMD3]
     *
     * [/im] (ja)<br>
     *
     * @return key[UNO.LAUNCHER.OPENOFFICE.KILLCMD3]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getUnoLauncherOpenofficeKillcmd3() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "/im";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("UNO.LAUNCHER.OPENOFFICE.KILLCMD3");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoUno], key[UNO.LAUNCHER.OPENOFFICE.KILLCMD4]
     *
     * [soffice.bin] (ja)<br>
     *
     * @return key[UNO.LAUNCHER.OPENOFFICE.KILLCMD4]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getUnoLauncherOpenofficeKillcmd4() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "soffice.bin";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("UNO.LAUNCHER.OPENOFFICE.KILLCMD4");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }

    /**
     * bundle[BlancoUno], key[UNO.LAUNCHER.OPENOFFICE.WAIT.END]
     *
     * [10] (ja)<br>
     *
     * @return key[UNO.LAUNCHER.OPENOFFICE.WAIT.END]ɑΉlBOǂݍ݂łȂꍇɂ́A`̒l߂܂BKnullȊO̒l߂܂B
     */
    public String getUnoLauncherOpenofficeWaitEnd() {
        // lƂĒ`̒l𗘗p܂B
        String strFormat = "10";
        try {
            if (fResourceBundle != null) {
                strFormat = fResourceBundle.getString("UNO.LAUNCHER.OPENOFFICE.WAIT.END");
            }
        } catch (MissingResourceException ex) {
        }
        // u͂ЂƂ܂B
        return strFormat;
    }
}
