/*
 * ̃\[XR[h blanco FrameworkɂĎĂ܂B
 * Apache Ant^XN [BlancoUnoLauncherStart]̃NX
 */
package blanco.uno.launcher.task;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

import blanco.uno.launcher.task.valueobject.BlancoUnoLauncherStartProcessInput;

/**
 * Apache Ant^XN [BlancoUnoLauncherStart]̃NXB
 *
 * OpenOffice.org 3 ̃W[UNO|[gtŐVKɃvZXN܂B<br>
 * ̃NXł́AApache Ant^XNňʓIɕKvȃ`FbNȂǂ̃R[fBO肵܂B
 * ۂ̏ pbP[W[blanco.uno.launcher.task]BlancoUnoLauncherStartBatchProcessNX쐬ċLqĂB<br>
 * <br>
 * Ant^XNւ̑gݍݗ<br>
 * <pre>
 * &lt;taskdef name=&quot;blancounolauncherstart&quot; classname=&quot;blanco.uno.launcher.task.BlancoUnoLauncherStartTask">
 *     &lt;classpath&gt;
 *         &lt;fileset dir=&quot;lib&quot; includes=&quot;*.jar&quot; /&gt;
 *         &lt;fileset dir=&quot;lib.ant&quot; includes=&quot;*.jar&quot; /&gt;
 *     &lt;/classpath&gt;
 * &lt;/taskdef&gt;
 * </pre>
 */
public class BlancoUnoLauncherStartTask extends Task {
    /**
     * OpenOffice.org 3 ̃W[UNO|[gtŐVKɃvZXN܂B
     */
    protected BlancoUnoLauncherStartProcessInput fInput = new BlancoUnoLauncherStartProcessInput();

    /**
     * tB[h [loadmodule] ɒlZbgꂽǂB
     */
    protected boolean fIsFieldLoadmoduleProcessed = false;

    /**
     * verbose[hœ삳邩ǂB
     *
     * @param arg verbose[hœ삳邩ǂB
     */
    public void setVerbose(final boolean arg) {
        fInput.setVerbose(arg);
    }

    /**
     * verbose[hœ삳邩ǂB
     *
     * @return verbose[hœ삳邩ǂB
     */
    public boolean getVerbose() {
        return fInput.getVerbose();
    }

    /**
     * Ant^XN[loadmodule]Agr[g̃Zb^[\bhB
     *
     * ڔԍ: 1<br>
     * OpenOffice.org ̃[hW[w肵܂Bw肪Ȃꍇ̓vpeBt@CɋLڂ̂lp܂B<br>
     *
     * @param arg Zbgl
     */
    public void setLoadmodule(final String arg) {
        fInput.setLoadmodule(arg);
        fIsFieldLoadmoduleProcessed = true;
    }

    /**
     * Ant^XN[loadmodule]Agr[g̃Qb^[\bhB
     *
     * ڔԍ: 1<br>
     * OpenOffice.org ̃[hW[w肵܂Bw肪Ȃꍇ̓vpeBt@CɋLڂ̂lp܂B<br>
     *
     * @return ̃tB[h̒l
     */
    public String getLoadmodule() {
        return fInput.getLoadmodule();
    }

    /**
     * Ant^XÑCBApache Ant ̃\bhĂяo܂B
     *
     * @throws BuildException ^XNƂĂ̗OꍇB
     */
    @Override
    public final void execute() throws BuildException {
        System.out.println("BlancoUnoLauncherStartTask begin.");

        if (getVerbose()) {
            System.out.println("- verbose:[true]");
            System.out.println("- loadmodule:[" + getLoadmodule() + "]");
        }

        try {
            // ۂAnt^XN̎又s܂B
            // ̉ӏŃRpCG[ꍇABlancoUnoLauncherStartProcessC^tF[X blanco.uno.launcher.taskpbP[W BlancoUnoLauncherStartProcessImplNX쐬邱Ƃɂłꍇ܂B
            final BlancoUnoLauncherStartProcess proc = new BlancoUnoLauncherStartProcessImpl();
            if (proc.execute(fInput) != BlancoUnoLauncherStartBatchProcess.END_SUCCESS) {
                throw new BuildException("^XNُ͈I܂B");
            }
        } catch (IllegalArgumentException e) {
            if (getVerbose()) {
                e.printStackTrace();
            }
            throw new BuildException(e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            throw new BuildException("^XNɗO܂B𒆒f܂B" + e.toString());
        } catch (Error e) {
            e.printStackTrace();
            throw new BuildException("^XNɃG[܂B𒆒f܂B" + e.toString());
        }
    }
}
