/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.plugin.constants.actions;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

import javax.xml.transform.TransformerException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

import blanco.constants.BlancoConstantsConstants;
import blanco.constants.BlancoConstantsMeta2Xml;
import blanco.constants.BlancoConstantsXml2JavaClass;
import blanco.constants.resourcebundle.BlancoConstantsResourceBundle;
import blanco.doclisting.BlancoDocListingXml2CombinedXmlValueObject;
import blanco.plugin.constants.BlancoConstantsPlugin;
import blanco.plugin.constants.editors.BlancoConstantsPluginUtil;

/**
 * ANV̏łB
 * 
 * TODO ʉFۉNX̎ĂB
 * 
 * @author IGA Tosiki
 */
public class BlancoConstantsGenerateAction {
    /**
     * \[Xohւ̃ANZTNX̃IuWFNgB
     */
    private final BlancoConstantsResourceBundle fBundle = new BlancoConstantsResourceBundle();

    /**
     * blancoConstants Java\[XR[hs܂B
     * 
     * @param ifile
     *            Ώۂ̃t@CB
     * @param shell
     *            ẽVFB
     * @param workbenchMonitor
     *            [Nx`j^B
     * @param metaDir
     *            ^fBNgB
     * @throws InvocationTargetException
     *             s̗OB
     * @throws InterruptedException
     *             荞ݗOB
     */
    public final void process(final IFile ifile, final Shell shell,
            IProgressMonitor workbenchMonitor, final String metaDir)
            throws InvocationTargetException, InterruptedException {
        if (ifile.getProject().getFolder(metaDir).exists() == false) {
            MessageDialog.openWarning(shell, "\[XR[h", "^fBNg (" + metaDir
                    + ") ݂܂B𒆒f܂B");
            return;
        }

        // Eclipse 3.3 ΍: begin
        // workbenchMonitor𗘗p邱Ƃ~܂B
        // org.eclipse.swt.SWTException: Invalid thread access Ă܂܂B
        // Eclipse 3.3 ΍: end

        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(
                    new IRunnableWithProgress() {
                        public void run(final IProgressMonitor monitor)
                                throws InvocationTargetException,
                                InterruptedException {
                            try {
                                processInternal(ifile, monitor, metaDir,
                                        monitor);
                                return;
                            } catch (Exception e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } catch (Error e) {
                                // ŏIhqC
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } finally {
                                // Ō̍Ōł doneƂ܂B
                                monitor.done();
                            }
                        }
                    });
        } catch (InvocationTargetException ex) {
            BlancoConstantsPlugin.log(ex);
            // O̒{̌oƂ|CgłB
            MessageDialog.openWarning(shell, "\[XR[h",
                    "O܂B𒆒f܂B\n" + ex.getCause().toString());
            ex.printStackTrace();
        } catch (InterruptedException ex) {
            BlancoConstantsPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "荞ݒfO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Exception ex) {
            BlancoConstantsPlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʗO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Error er) {
            BlancoConstantsPlugin.log(er);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʃG[܂B𒆒f܂B\n" + er.toString());
            er.printStackTrace();
        }
    }

    /**
     * ۂ̃ANVeB
     * 
     * @param ifile
     * @param workbenchMonitor
     * @param metaDir
     * @param monitor
     * @throws CoreException
     * @throws IOException
     * @throws TransformerException
     */
    protected void processInternal(final IFile ifile,
            final IProgressMonitor workbenchMonitor, final String metaDir,
            final IProgressMonitor monitor) throws CoreException, IOException,
            TransformerException {
        monitor.beginTask(BlancoConstantsConstants.PRODUCT_NAME + "\[XR[h",
                10);

        if (monitor.isCanceled()) {
            return;
        }

        monitor.subTask("fBNg: e|tH_̒B");

        // e|tH_U폜܂B
        BlancoConstantsPluginUtil.deleteFolder(ifile, workbenchMonitor, "tmp"
                + BlancoConstantsConstants.TARGET_SUBDIRECTORY);
        BlancoConstantsPluginUtil.createFolder(ifile, workbenchMonitor, "tmp"
                + BlancoConstantsConstants.TARGET_SUBDIRECTORY);
        final IFolder tempFolder = BlancoConstantsPluginUtil.findFolder(ifile,
                workbenchMonitor, "tmp"
                        + BlancoConstantsConstants.TARGET_SUBDIRECTORY);

        // hLgꗗ̂߂̒ԃt@CpfBNgB
        final File blancoTempDirectoryDocListing = ifile.getProject()
                .getFolder("tmp/doclisting").getLocation().toFile();
        blancoTempDirectoryDocListing.mkdirs();

        if (monitor.isCanceled()) {
            return;
        }

        monitor.subTask(fBundle.getMetafileDisplayname() + " (*.xls)܂");
        monitor.worked(1);

        final IFolder findFolder = BlancoConstantsPluginUtil.findFolder(ifile,
                workbenchMonitor, metaDir);
        findFolder.refreshLocal(IResource.DEPTH_INFINITE, workbenchMonitor);

        new BlancoConstantsMeta2Xml() {
            protected boolean progress(final int progressCurrent,
                    final int progressTotal, final String progressItem) {
                if (monitor.isCanceled()) {
                    // f܂B
                    return false;
                }

                monitor.subTask("^t@C: t@C[" + progressItem + "]܂ ("
                        + progressCurrent + "/" + progressTotal + ")");

                return true;
            }
        }.processDirectory(findFolder.getLocation().toFile(), tempFolder
                .getLocation().toFile().getAbsolutePath());

        if (monitor.isCanceled()) {
            return;
        }

        monitor.subTask("tH_XV: tmptH_");
        monitor.worked(1);

        tempFolder.refreshLocal(IResource.DEPTH_INFINITE, workbenchMonitor);

        monitor.subTask("tH_쐬: blancotH_");

        IFolder folderTargetDirectory = ifile.getProject().getFolder("blanco");
        if (ifile.getProject().getFolder(metaDir).exists() == false) {
            folderTargetDirectory.create(true, true, workbenchMonitor);
        }

        monitor.subTask("tH_쐬: blanco/maintH_");
        final IFolder folderTargetDirectoryWithMain = folderTargetDirectory
                .getFolder("main");
        if (ifile.getProject().getFolder(metaDir).exists() == false) {
            folderTargetDirectoryWithMain.create(true, true, workbenchMonitor);
        }

        File blancoTargetDirectory = folderTargetDirectory.getLocation()
                .toFile();

        monitor.subTask("Java\[XR[h쐬");
        monitor.worked(1);

        IResource[] resourcesXml2 = tempFolder.members();
        for (int index = 0; index < resourcesXml2.length; index++) {
            if (monitor.isCanceled()) {
                return;
            }
            if (resourcesXml2[index] instanceof IFile) {
                IFile fileLook = (IFile) resourcesXml2[index];
                if (fileLook.getFileExtension().equals("xml") == false) {
                    // gqxmlȊÕt@C̓XLbv܂B
                    continue;
                }

                monitor.subTask("Java\[XR[h쐬: t@C[" + fileLook.getName()
                        + "]܂ (" + (index + 1) + "/"
                        + resourcesXml2.length + ")");

                try {
                    new BlancoConstantsXml2JavaClass().process(fileLook
                            .getLocation().toFile(), blancoTargetDirectory);
                } catch (IllegalArgumentException ex) {
                    throw new IllegalArgumentException(

                    "t@C[" + fileLook.getName()
                            + "]̏ɃG[܂B𒆒f܂B\n\n" + ex.toString());
                }
            }
        }

        if (monitor.isCanceled()) {
            return;
        }

        monitor.subTask("hLgꗗ̂߂̒ԃt@C쐬B");
        monitor.worked(1);

        // hLgꗗ̂߂̒ԃt@C쐬B
        final BlancoDocListingXml2CombinedXmlValueObject doclistingCombine = new BlancoDocListingXml2CombinedXmlValueObject();
        doclistingCombine.process(tempFolder.getLocation().toFile(),
                blancoTempDirectoryDocListing);

        monitor.subTask("tH_XV: blancotH_XV");
        monitor.worked(1);

        if (monitor.isCanceled()) {
            return;
        }

        folderTargetDirectory.refreshLocal(IResource.DEPTH_INFINITE,
                workbenchMonitor);
        return;
    }
}