/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.plugin.resourcebundle.actions;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;

import javax.xml.transform.TransformerException;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

import blanco.constants.BlancoConstantsXml2JavaClass;
import blanco.doclisting.BlancoDocListingXml2CombinedXmlResourceBundle;
import blanco.plugin.resourcebundle.BlancoResourceBundlePlugin;
import blanco.plugin.resourcebundle.editors.BlancoResourceBundlePluginUtil;
import blanco.resourcebundle.BlancoResourceBundleConstants;
import blanco.resourcebundle.BlancoResourceBundleMeta2Xml;
import blanco.resourcebundle.BlancoResourceBundleXml2CombinedXml;
import blanco.resourcebundle.BlancoResourceBundleXml2ConstantsXml;
import blanco.resourcebundle.BlancoResourceBundleXml2JavaClass;
import blanco.resourcebundle.BlancoResourceBundleXml2Properties;
import blanco.resourcebundle.BlancoResourceBundleXmlValidator;
import blanco.resourcebundle.resourcebundle.BlancoResourceBundleResourceBundle;

/**
 * \[Xoh`vpeBt@CуANZTJava\[XR[h𐶐 EclipseANVłB
 * 
 * ̃\[XR[hblancoResourceBundlëꕔłB<br>
 * 
 * @author IGA Tosiki
 */
public class BlancoResourceBundleGenerateAction {
    /**
     * \[XohANZT̃CX^XB
     */
    private static final BlancoResourceBundleResourceBundle fBundle = new BlancoResourceBundleResourceBundle();

    /**
     * GUIfobOp̒ᑬ[hBʏfalseŉ^p܂B
     */
    private static final boolean IS_DEBUG_SLOW = false;

    /**
     * \[Xoh`vpeBt@CуANZTJava\[XR[h𐶐 EclipseANVłB
     * 
     * @param ifile
     *            Ώۂ̃t@CIuWFNgB
     * @param shell
     *            eVFB
     * @param workbenchMonitor
     *            [Nx`j^[B
     * @param metaDir
     *            ^t@Ci[ĂfBNgB
     * @param isFailOnMessageFormatError
     *            \[XohMessageFormatɂp[XsۂɁAO珈𒆒f邩ǂ̃tOB
     * @param isLog
     *            Oo͂\[XR[hɊ܂߂邩ǂB
     * @throws InvocationTargetException
     *             sOꍇB
     * @throws InterruptedException
     *             荞ݗOꍇB
     */
    public static final void processBlancoResourceBundle(final IFile ifile,
            final Shell shell, IProgressMonitor workbenchMonitor,
            final String metaDir, final boolean isFailOnMessageFormatError,
            final boolean isLog, final boolean propertiesWithDirectory)
            throws InvocationTargetException, InterruptedException {
        if (ifile.getProject().getFolder(metaDir).exists() == false) {
            MessageDialog.openWarning(shell, "\[XR[h", "^fBNg (" + metaDir
                    + ") ݂܂B𒆒f܂B");
            return;
        }

        // Eclipse 3.3 ΍: begin
        // workbenchMonitor𗘗p邱Ƃ~܂B
        // org.eclipse.swt.SWTException: Invalid thread access Ă܂܂B
        // Eclipse 3.3 ΍: end

        try {
            // PlatformUI.getWorkbench().getProgressService()LvƔfB
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(
                    new IRunnableWithProgress() {
                        public void run(IProgressMonitor monitor)
                                throws InvocationTargetException,
                                InterruptedException {
                            try {
                                monitor
                                        .beginTask(
                                                BlancoResourceBundleConstants.PRODUCT_NAME
                                                        + "\[XR[h", 10);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("fBNg: e|tH_̒B");

                                // e|tH_U폜܂B
                                BlancoResourceBundlePluginUtil
                                        .deleteFolder(
                                                ifile,
                                                monitor,
                                                "tmp"
                                                        + BlancoResourceBundleConstants.TARGET_SUBDIRECTORY);
                                BlancoResourceBundlePluginUtil
                                        .createFolder(
                                                ifile,
                                                monitor,
                                                "tmp"
                                                        + BlancoResourceBundleConstants.TARGET_SUBDIRECTORY);
                                final IFolder tempFolder = BlancoResourceBundlePluginUtil
                                        .findFolder(
                                                ifile,
                                                monitor,
                                                "tmp"
                                                        + BlancoResourceBundleConstants.TARGET_SUBDIRECTORY);

                                // hLgꗗ̂߂̒ԃt@CpfBNgB
                                final File blancoTempDirectoryDocListing = ifile
                                        .getProject().getFolder(
                                                "tmp/doclisting").getLocation()
                                        .toFile();
                                blancoTempDirectoryDocListing.mkdirs();

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask(fBundle
                                        .getMetafileDisplayname()
                                        + " (*.xls)܂");
                                monitor.worked(1);

                                final IFolder findFolder = BlancoResourceBundlePluginUtil
                                        .findFolder(ifile, monitor, metaDir);
                                findFolder.refreshLocal(
                                        IResource.DEPTH_INFINITE, monitor);
                                IResource[] resourcesMeta = findFolder
                                        .members();
                                for (int index = 0; index < resourcesMeta.length; index++) {
                                    if (monitor.isCanceled()) {
                                        return;
                                    }

                                    if (resourcesMeta[index] instanceof IFile) {
                                        IFile fileLook = (IFile) resourcesMeta[index];
                                        if (fileLook.getFileExtension().equals(
                                                "xls") == false) {
                                            // xlsȊO̊gq̃t@C̓XLbv
                                            continue;
                                        }

                                        IFile fileTarget = tempFolder
                                                .getFile(fileLook.getName()
                                                        + ".xml");
                                        IFile fileTargetCombined = tempFolder
                                                .getFile(fileLook.getName()
                                                        + ".combinedxml");
                                        monitor.subTask("^t@C: t@C["
                                                + fileLook.getName()
                                                + "]܂ (" + (index + 1)
                                                + "/" + resourcesMeta.length
                                                + ")");
                                        InputStream inStream = null;
                                        OutputStream outStream = null;
                                        try {
                                            inStream = fileLook.getContents();
                                            outStream = new FileOutputStream(
                                                    fileTarget.getLocation()
                                                            .toFile());
                                            new BlancoResourceBundleMeta2Xml()
                                                    .process(inStream,
                                                            outStream);
                                            outStream.flush();
                                        } finally {
                                            if (inStream != null) {
                                                inStream.close();
                                            }
                                            if (outStream != null) {
                                                outStream.close();
                                            }
                                        }

                                        fileTarget.refreshLocal(
                                                IResource.DEPTH_INFINITE,
                                                monitor);
                                        // XMLt@Cgݑւ܂B
                                        new BlancoResourceBundleXml2CombinedXml()
                                                .process(
                                                        fileTarget
                                                                .getLocation()
                                                                .toFile(),
                                                        fileTargetCombined
                                                                .getLocation()
                                                                .toFile());

                                        if (IS_DEBUG_SLOW) {
                                            Thread.sleep(1000);
                                        }
                                    }
                                }

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("tH_XV: tmptH_");
                                monitor.worked(1);

                                tempFolder.refreshLocal(
                                        IResource.DEPTH_INFINITE, monitor);

                                monitor.subTask("tH_쐬: blancotH_");

                                IFolder folderTargetDirectory = ifile
                                        .getProject().getFolder("blanco");
                                if (ifile.getProject().getFolder(metaDir)
                                        .exists() == false) {
                                    folderTargetDirectory.create(true, true,
                                            monitor);
                                }

                                monitor.subTask("tH_쐬: blanco/maintH_");
                                final IFolder folderTargetDirectoryWithMain = folderTargetDirectory
                                        .getFolder("main");
                                if (ifile.getProject().getFolder(metaDir)
                                        .exists() == false) {
                                    folderTargetDirectoryWithMain.create(true,
                                            true, monitor);
                                }

                                final File blancoTargetDirectory = folderTargetDirectory
                                        .getLocation().toFile();

                                monitor.subTask("Java\[XR[h쐬");
                                monitor.worked(1);

                                IResource[] resourcesXml2 = tempFolder
                                        .members();
                                for (int index = 0; index < resourcesXml2.length; index++) {
                                    if (monitor.isCanceled()) {
                                        return;
                                    }
                                    if (resourcesXml2[index] instanceof IFile) {
                                        IFile fileLook = (IFile) resourcesXml2[index];
                                        if (fileLook.getFileExtension().equals(
                                                "combinedxml") == false) {
                                            // gqcombinedxmlȊÕt@C̓XLbv܂B
                                            continue;
                                        }

                                        monitor.subTask("Java\[XR[h쐬: t@C["
                                                + fileLook.getName()
                                                + "]܂ (" + (index + 1)
                                                + "/" + resourcesXml2.length
                                                + ")");

                                        try {
                                            // ŏɑÓ`FbNs܂B
                                            final BlancoResourceBundleXmlValidator xmlValidator = new BlancoResourceBundleXmlValidator();
                                            xmlValidator
                                                    .setFailOnMessageFormatError(isFailOnMessageFormatError);
                                            xmlValidator.process(fileLook
                                                    .getLocation().toFile(),
                                                    blancoTargetDirectory);

                                            if ("true".equals(fBundle
                                                    .getGenerateBundleSource())) {
                                                final BlancoResourceBundleXml2JavaClass xml2javaclass = new BlancoResourceBundleXml2JavaClass();
                                                xml2javaclass
                                                        .setFailOnMessageFormatError(isFailOnMessageFormatError);
                                                xml2javaclass.setLog(isLog);
                                                xml2javaclass
                                                        .setPropertieswithdirectory(propertiesWithDirectory);
                                                xml2javaclass.process(
                                                        fileLook.getLocation()
                                                                .toFile(),
                                                        blancoTargetDirectory);
                                            }

                                            if ("true"
                                                    .equals(fBundle
                                                            .getGenerateConstantsSource())) {
                                                new BlancoResourceBundleXml2ConstantsXml()
                                                        .process(
                                                                fileLook
                                                                        .getLocation()
                                                                        .toFile(),
                                                                tempFolder
                                                                        .getLocation()
                                                                        .toFile());
                                            }
                                        } catch (IllegalArgumentException ex) {
                                            throw new IllegalArgumentException(

                                                    "t@C["
                                                            + fileLook
                                                                    .getName()
                                                            + "]̏ɃG[܂B𒆒f܂B\n\n"
                                                            + ex.getMessage());
                                        }

                                        if (IS_DEBUG_SLOW) {
                                            Thread.sleep(1000);
                                        }

                                    }
                                }

                                if (fBundle.getGenerateConstantsSource()
                                        .equals("true")) {
                                    monitor.subTask("萔NX쐬");
                                    monitor.worked(1);

                                    final File[] filesConstantsXml = new File(
                                            tempFolder.getLocation().toFile()
                                                    .getAbsolutePath()
                                                    + "/constants").listFiles();
                                    if (filesConstantsXml != null) {
                                        for (int index = 0; index < filesConstantsXml.length; index++) {
                                            if (filesConstantsXml[index]
                                                    .getName().endsWith(
                                                            ".constantsxml")) {
                                                new BlancoConstantsXml2JavaClass()
                                                        .process(
                                                                filesConstantsXml[index],
                                                                folderTargetDirectory
                                                                        .getLocation()
                                                                        .toFile());
                                            }
                                        }
                                    }
                                }

                                monitor.subTask("vpeBt@C쐬");
                                monitor.worked(1);

                                IResource[] resourcesXml = tempFolder.members();
                                for (int index = 0; index < resourcesXml.length; index++) {
                                    if (monitor.isCanceled()) {
                                        return;
                                    }
                                    if (resourcesXml[index] instanceof IFile) {
                                        IFile fileLook = (IFile) resourcesXml[index];
                                        if (fileLook.getFileExtension().equals(
                                                "xml") == false) {
                                            // gqxmlȊÕt@C̓XLbv܂B
                                            continue;
                                        }

                                        monitor.subTask("vpeBt@C쐬: t@C["
                                                + fileLook.getName()
                                                + "]܂ (" + (index + 1)
                                                + "/" + resourcesXml.length
                                                + ")");

                                        // blanco/mainĂɏo͂܂B
                                        final BlancoResourceBundleXml2Properties xml2Properties = new BlancoResourceBundleXml2Properties();
                                        xml2Properties
                                                .setPropertieswithdirectory(propertiesWithDirectory);
                                        xml2Properties
                                                .process(fileLook.getLocation()
                                                        .toFile(),
                                                        folderTargetDirectoryWithMain
                                                                .getLocation()
                                                                .toFile());
                                    }

                                    if (IS_DEBUG_SLOW) {
                                        Thread.sleep(1000);
                                    }
                                }

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                monitor.subTask("hLgꗗ̂߂̒ԃt@C쐬B");
                                monitor.worked(1);

                                // hLgꗗ̂߂̒ԃt@C쐬B
                                final BlancoDocListingXml2CombinedXmlResourceBundle doclistingResourceBundle = new BlancoDocListingXml2CombinedXmlResourceBundle();
                                doclistingResourceBundle.process(tempFolder
                                        .getLocation().toFile(),
                                        blancoTempDirectoryDocListing);

                                monitor.subTask("tH_XV: blancotH_XV");
                                monitor.worked(1);

                                if (monitor.isCanceled()) {
                                    return;
                                }

                                folderTargetDirectory.refreshLocal(
                                        IResource.DEPTH_INFINITE, monitor);

                                if (IS_DEBUG_SLOW) {
                                    Thread.sleep(1000);
                                }
                            } catch (CoreException e) {
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } catch (IOException e) {
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } catch (TransformerException e) {
                                e.printStackTrace();
                                throw new InvocationTargetException(e, e
                                        .toString());
                            } finally {
                                // Ō̍Ōł doneƂ܂B
                                monitor.done();
                            }
                        }
                    });
        } catch (InvocationTargetException ex) {
            BlancoResourceBundlePlugin.log(ex);
            // O̒{̌oƂ|CgłB
            MessageDialog.openWarning(shell, "\[XR[h",
                    "O܂B𒆒f܂B\n" + ex.getCause().toString());
            ex.printStackTrace();
        } catch (InterruptedException ex) {
            BlancoResourceBundlePlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "荞ݒfO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Exception ex) {
            BlancoResourceBundlePlugin.log(ex);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʗO܂B𒆒f܂B\n" + ex.toString());
            ex.printStackTrace();
        } catch (Error er) {
            BlancoResourceBundlePlugin.log(er);
            MessageDialog.openWarning(shell, "\[XR[h",
                    "\ʃG[܂B𒆒f܂B\n" + er.toString());
            er.printStackTrace();
        }
    }
}