/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.eclipseplugingen.expand;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoStringUtil;
import blanco.commons.util.BlancoXmlUtil;

/**
 * plugin.xmlt@CWJ܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoEclipsePluginGenExpandManifest {
    private String fPluginName = null;

    private String fPluginDisplayName = null;

    private String fPackageName = null;

    /**
     * plugin.xmlt@CWJ܂B
     * 
     * @param elementCommon
     * @param listList
     * @param directoryRoot
     *            [gfBNgB̃fBNgplugin.xmlt@Co͂܂B
     */
    public final void expand(final Element elementCommon,
            final NodeList listList, final File directoryRoot) {
        fPluginName = BlancoXmlUtil.getTextContent(elementCommon, "name");
        fPluginDisplayName = BlancoXmlUtil.getTextContent(elementCommon,
                "displayName");
        fPackageName = BlancoXmlUtil.getTextContent(elementCommon,
                "packageName");

        // fBNg̎O`FbN쐬
        final File fileSourceRoot = new File(directoryRoot.getAbsolutePath()
                + "/src/" + BlancoStringUtil.replaceAll(fPackageName, ".", "/"));
        if (fileSourceRoot.exists() == false) {
            // fBNg݂Ȃꍇɂ͐VK쐬܂B
            System.out.println("ep: create: "
                    + fileSourceRoot.getAbsolutePath());
            fileSourceRoot.mkdirs();
        }
        final File fileSourceActions = new File(fileSourceRoot
                .getAbsolutePath()
                + "/actions");
        if (fileSourceActions.exists() == false) {
            System.out.println("ep: create: "
                    + fileSourceActions.getAbsolutePath());
            fileSourceActions.mkdirs();
        }
        final File fileSourceEditors = new File(fileSourceRoot
                .getAbsolutePath()
                + "/editors");
        if (fileSourceEditors.exists() == false) {
            System.out.println("ep: create: "
                    + fileSourceEditors.getAbsolutePath());
            fileSourceEditors.mkdirs();
        }
        final File fileSourceWizards = new File(fileSourceRoot
                .getAbsolutePath()
                + "/wizards");
        if (fileSourceWizards.exists() == false) {
            System.out.println("ep: create: "
                    + fileSourceWizards.getAbsolutePath());
            fileSourceWizards.mkdirs();
        }

        final File fileMetaInf = new File(directoryRoot.getAbsolutePath()
                + "/META-INF");
        if (fileMetaInf.exists() == false) {
            // fBNg݂Ȃꍇɂ͐VK쐬܂B
            System.out.println("ep: create: " + fileMetaInf.getAbsolutePath());
            fileMetaInf.mkdirs();
        }

        final File fileTarget = new File(directoryRoot.getAbsolutePath()
                + "/META-INF/MANIFEST.MF");
        if (fileTarget.exists()) {
            System.out.println("ep: skip  : MANIFEST.MF: file already exist.");
        } else {
            System.out.println("ep: create: MANIFEST.MF");
            try {
                expandManifestMf(fileTarget);
            } catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /**
     * MANIFEST.MFt@C𐶐܂B
     * 
     * @param fileTarget
     *            o͐t@CB
     * @throws IOException
     */
    private void expandManifestMf(final File fileTarget) throws IOException {
        final BufferedWriter writer = new BufferedWriter(
                new OutputStreamWriter(new FileOutputStream(fileTarget)));
        try {
            writer.write("Manifest-Version: 1.0");
            writer.newLine();
            writer.write("Bundle-ManifestVersion: 2");
            writer.newLine();
            // |CgFoh vOC\̂擪啶܂B
            writer.write("Bundle-Name: "
                    + BlancoNameAdjuster.toUpperCaseTitle(fPluginDisplayName)
                    + " Plug-in");
            writer.newLine();
            writer.write("Bundle-SymbolicName: " + fPackageName
                    + ";singleton:=true");
            writer.newLine();
            writer.write("Bundle-Version: 0.0.1");
            writer.newLine();

            writer.write("Bundle-Activator: " + fPackageName + "."
                    + fPluginName + "Plugin");
            writer.newLine();
            // writer.write("Bundle-Localization: plugin");
            // writer.newLine();
            writer.write("Require-Bundle: org.eclipse.ui,");
            writer.newLine();
            writer.write(" org.eclipse.core.runtime,");
            writer.newLine();
            writer.write(" org.eclipse.jface.text,");
            writer.newLine();
            writer.write(" org.eclipse.ui.editors,");
            writer.newLine();
            writer.write(" org.eclipse.ui.workbench.texteditor,");
            writer.newLine();
            writer.write(" org.eclipse.core.resources,");
            writer.newLine();
            writer.write(" org.eclipse.ui.ide");
            writer.newLine();

            // writer.write("Eclipse-AutoStart: true");
            // writer.newLine();
            writer.write("Bundle-ActivationPolicy: lazy");
            writer.newLine();
            // o[WΉ
            writer.write("Eclipse-LazyStart: true");
            writer.newLine();
            writer.write("Bundle-RequiredExecutionEnvironment: J2SE-1.5");
            writer.newLine();

            writer.write("Bundle-ClassPath: lib/" + fPluginName.toLowerCase()
                    + "plugin.jar,");
            writer.newLine();
            writer.write(" lib/blancocg-1.0.6.jar,");
            writer.newLine();
            writer.write(" lib/blancocommons-1.0.1.jar,");
            writer.newLine();
            writer.write(" lib/blancodoclisting-0.1.6.jar,");
            writer.newLine();
            writer.write(" lib/blancoxmlbinding-0.0.5.jar,");
            writer.newLine();
            writer.write(" lib/" + fPluginName.toLowerCase() + "-0.0.1.jar,");
            writer.newLine();
            writer.write(" lib/jxl-2.6blanco.jar");
            writer.newLine();
            writer.write("Bundle-Vendor: Blanco Framework");
            writer.newLine();
        } finally {
            writer.close();
        }
    }
}
