package blanco.xliff.util.task;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import blanco.commons.util.BlancoStringUtil;
import blanco.xliff.BlancoXliffUtil;
import blanco.xliff.util.task.valueobject.BlancoXliffUtilCleanProcessInput;
import blanco.xliff.valueobject.BlancoXliff;
import blanco.xliff.valueobject.BlancoXliffAltTrans;
import blanco.xliff.valueobject.BlancoXliffFile;
import blanco.xliff.valueobject.BlancoXliffNote;
import blanco.xliff.valueobject.BlancoXliffTransUnit;

public class BlancoXliffUtilCleanProcessImpl implements
        BlancoXliffUtilCleanProcess {

    private BlancoXliff fXliff = null;

    private BlancoXliffUtilCleanProcessInput fInput = null;

    public int execute(final BlancoXliffUtilCleanProcessInput input)
            throws IOException, IllegalArgumentException {
        fInput = input;

        final File fileXliffdir = new File(input.getXliffdir());
        final File[] files = fileXliffdir.listFiles();
        if (files == null) {
            return 0;
        }
        for (int index = 0; index < files.length; index++) {
            if (files[index].isFile() == false) {
                continue;
            }
            if (files[index].getName().endsWith(".xlf")) {
                process(fileXliffdir, files[index]);
            }
        }

        return 0;
    }

    private void process(final File fileXliffdir, final File fileTarget)
            throws IOException {

        final String bundleSymbolicName = fileTarget.getName().substring(0,
                fileTarget.getName().length() - ".xlf".length());

        fXliff = BlancoXliffUtil.getXliffInstance(fileXliffdir,
                bundleSymbolicName);

        for (int indexFile = 0; indexFile < fXliff.getFileList().size(); indexFile++) {
            final BlancoXliffFile file = (BlancoXliffFile) fXliff.getFileList()
                    .get(indexFile);
            processFile(file);
        }

        switch (BlancoXliffUtil.saveXliffInstance(fXliff, fileXliffdir,
                bundleSymbolicName)) {
        case 1:
            // {IɁAɂ͓Ȃ݁B
            if (fInput.getVerbose()) {
                System.out.println("xliff: clean: create: "
                        + bundleSymbolicName);
            }
            break;
        case 2:
            if (fInput.getVerbose()) {
                System.out.println("xliff: clean: update: "
                        + bundleSymbolicName);
            }
            break;
        }
    }

    private void processFile(final BlancoXliffFile file) {
        for (int index = 0; index < file.getBody().getTransUnitList().size(); index++) {
            final BlancoXliffTransUnit transUnit = (BlancoXliffTransUnit) file
                    .getBody().getTransUnitList().get(index);

            if (transUnit.getTranslate() == false) {
                // OځB
                continue;
            }

            // ŃN[ibv{B

            cleanAction(transUnit);
            cleanAltTrans(transUnit);
        }
    }

    /**
     *  tool-id ŕ alt-trans ݂ꍇAŌ(Ƃɂ)̂cA͍폜܂B
     * 
     * @param transUnit
     */
    private void cleanAltTrans(final BlancoXliffTransUnit transUnit) {
        // tool-idd alt-trans B
        final Map<String, String> mapPrev = new HashMap<String, String>();
        final Map<String, BlancoXliffAltTrans> mapDup = new HashMap<String, BlancoXliffAltTrans>();
        for (int indexAltTrans = 0; indexAltTrans < transUnit.getAltTransList()
                .size(); indexAltTrans++) {
            final BlancoXliffAltTrans altTrans = (BlancoXliffAltTrans) transUnit
                    .getAltTransList().get(indexAltTrans);
            if (BlancoStringUtil.null2Blank(altTrans.getToolId()).length() == 0) {
                // tool-idݒ肳ĂȂ̂̓XLbv܂B
                continue;
            }

            if (mapPrev.get(altTrans.getToolId()) != null) {
                // dĂ܂B
                mapDup.put(mapPrev.get(altTrans.getToolId()), altTrans);
            }
            mapPrev.put(altTrans.getToolId(), String.valueOf(indexAltTrans));
        }

        // d폜
        for (int indexAltTrans = transUnit.getAltTransList().size() - 1; indexAltTrans >= 0; indexAltTrans--) {
            if (mapDup.get(String.valueOf(indexAltTrans)) != null) {
                // dĂ̂łB
                transUnit.getAltTransList().remove(indexAltTrans);
            }
        }

        // omegat |󕪂폜
        for (int indexAltTrans = transUnit.getAltTransList().size() - 1; indexAltTrans >= 0; indexAltTrans--) {
            final BlancoXliffAltTrans altTrans = (BlancoXliffAltTrans) transUnit
                    .getAltTransList().get(indexAltTrans);
            if (BlancoStringUtil.null2Blank(altTrans.getToolId()).equals(
                    "omegat")) {
                // OmegaToalt-trans ͍폜܂B
                transUnit.getAltTransList().remove(indexAltTrans);
            }
        }
    }

    /**
     * blancoNLpackGenerator [NIɕt^ action폜܂B
     * 
     * @param transUnit
     */
    private void cleanAction(final BlancoXliffTransUnit transUnit) {
        // blanconlpackgenerator.actionB
        for (int indexNote = transUnit.getNoteList().size() - 1; indexNote >= 0; indexNote--) {
            final BlancoXliffNote note = (BlancoXliffNote) transUnit
                    .getNoteList().get(indexNote);
            if (BlancoStringUtil.null2Blank(note.getFrom()).length() == 0) {
                // fromݒ肳ĂȂ̂̓XLbv܂B
                continue;
            }

            if (note.getFrom().equals("blanconlpackgenerator.action")) {
                transUnit.getNoteList().remove(indexNote);
            }
        }
    }
}
