package blanco.xml.bind;

import javax.xml.transform.sax.TransformerHandler;

import org.xml.sax.Locator;
import org.xml.sax.SAXException;

import blanco.commons.util.BlancoStringUtil;
import blanco.xml.bind.valueobject.BlancoXmlAttribute;
import blanco.xml.bind.valueobject.BlancoXmlCharacters;
import blanco.xml.bind.valueobject.BlancoXmlComment;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlDtd;
import blanco.xml.bind.valueobject.BlancoXmlElement;
import blanco.xml.bind.valueobject.BlancoXmlIgnorableWhitespace;

/**
 * 񉻎łB
 * 
 * ̃NX XML/o[IuWFNg}bsO (X/O}bsO) blancoXmlBinding ̈ꕔłB<br>
 * ̃NX̓pbP[Wł̂ݗp\łB
 * 
 * @author IGA Tosiki
 */
class BlancoXmlMarshallerSerializer {
    /**
     * Iɗpo͗pSAXnh<br>
     * ÃXg[͊OcloseKv܂B
     */
    private TransformerHandler fSaxHandler;

    /**
     * SAXVACUp񉻃NX𐶐܂B
     * 
     * @param argHandler
     *            SAXVACŨnhB
     */
    public BlancoXmlMarshallerSerializer(final TransformerHandler argHandler) {
        fSaxHandler = argHandler;
    }

    /**
     * ^ꂽDocumentSAXVACUւƓWJ܂B
     * 
     * @param document
     *            hLgIuWFNgB
     * @throws SAXException
     *             SAXOꍇB
     */
    public void serialize(final BlancoXmlDocument document) throws SAXException {
        expandLocator(document);

        fSaxHandler.startDocument();

        // TODO fSaxHandler.startPrefixMapping(prefix, uri);
        // TODO fSaxHandler.endPrefixMapping(prefix);

        final int sizeChildNodes = document.getChildNodes().size();
        for (int index = 0; index < sizeChildNodes; index++) {
            final Object objLook = document.getChildNodes().get(index);
            if (objLook instanceof BlancoXmlDtd) {
                expandDtd((BlancoXmlDtd) objLook);
            } else if (objLook instanceof BlancoXmlElement) {
                expandElement((BlancoXmlElement) objLook);
            } else {
                throw new IllegalArgumentException(
                        "BlancoXmlMarshallerSerializer: z肵Ȃӏʉ߂܂B");
            }
        }

        fSaxHandler.endDocument();
    }

    /**
     * P[^WJ܂B
     * 
     * @param document
     *            hLgIuWFNgB
     */
    private void expandLocator(final BlancoXmlDocument document) {
        if (document.getLocator() != null) {
            fSaxHandler.setDocumentLocator(new Locator() {
                public String getPublicId() {
                    // Locator̊e\bhnull߂\܂B
                    return document.getLocator().getPublicId();
                }

                public String getSystemId() {
                    // Locator̊e\bhnull߂\܂B
                    return document.getLocator().getSystemId();
                }

                public int getLineNumber() {
                    return document.getLocator().getLineNumber();
                }

                public int getColumnNumber() {
                    return document.getLocator().getColumnNumber();
                }
            });
        }
    }

    /**
     * DTDWJ܂B
     * 
     * @param argDtd
     *            DTDB
     * @throws SAXException
     *             SAXOꍇB
     */
    private void expandDtd(final BlancoXmlDtd argDtd) throws SAXException {
        fSaxHandler.startDTD(argDtd.getName(), argDtd.getPublicId(), argDtd
                .getSystemId());
        fSaxHandler.endDTD();
    }

    /**
     * GgWJ܂B
     * 
     * @param element
     *            GgB
     * @throws SAXException
     *             SAXOꍇB
     */
    private void expandElement(final BlancoXmlElement element)
            throws SAXException {
        if (BlancoStringUtil.null2Blank(element.getLocalName()).length() == 0
                && BlancoStringUtil.null2Blank(element.getQName()).length() == 0) {
            throw new IllegalArgumentException(
                    "localNameQNamew肳ĂȂElement܂Bf܂B");
        }

        String qName = element.getQName();
        if (BlancoStringUtil.null2Blank(qName).length() == 0) {
            // QNameɉw肳ĂȂꍇɂlocalName̒lZbg܂B
            qName = element.getLocalName();
        }

        // Agr[gɂĂ QNamew̏ꍇɂ localName𕡎ʂȂnull΍قǂ܂B
        for (int index = 0; index < element.getAtts().size(); index++) {
            final BlancoXmlAttribute attrLook = (BlancoXmlAttribute) element
                    .getAtts().get(index);
            attrLook.setLocalName(BlancoStringUtil.null2Blank(attrLook
                    .getLocalName()));
            attrLook.setType(BlancoStringUtil.null2Blank(attrLook.getType()));
            attrLook.setValue(BlancoStringUtil.null2Blank(attrLook.getValue()));

            if (BlancoStringUtil.null2Blank(attrLook.getQName()).length() == 0) {
                // QNameɉw肳ĂȂꍇɂlocalName̒lZbg܂B
                attrLook.setQName(attrLook.getLocalName());
            }
            if (attrLook.getQName().length() == 0) {
                // łQNameuN̏ꍇB
                throw new IllegalArgumentException(
                        "Agr[gQNamenull̂܂ܗ^܂BlocalNameoł܂łB:"
                                + element.toString());
            }
        }

        // w肪ꍇɂnullł͂Ȃ̕nKv_ɒӁB
        fSaxHandler.startElement(BlancoStringUtil.null2Blank(element.getUri()),
                BlancoStringUtil.null2Blank(element.getLocalName()), qName,
                new BlancoXmlMarshallerAttributesImpl(element.getAtts()));

        // qm[hWJ܂B
        final int sizeChildNodes = element.getChildNodes().size();
        for (int index = 0; index < sizeChildNodes; index++) {
            final Object objLook = element.getChildNodes().get(index);
            if (objLook instanceof BlancoXmlElement) {
                expandElement((BlancoXmlElement) objLook);
            } else if (objLook instanceof BlancoXmlCharacters) {
                expandCharacters((BlancoXmlCharacters) objLook);
            } else if (objLook instanceof BlancoXmlIgnorableWhitespace) {
                expandIgnorableWhitespace((BlancoXmlIgnorableWhitespace) objLook);
            } else if (objLook instanceof BlancoXmlComment) {
                expandComment((BlancoXmlComment) objLook);
            } else {
                throw new IllegalArgumentException(
                        "BlancoXmlMarshallerSerializer: z肵Ȃӏʉ߂܂B");
            }
        }

        // w肪ꍇɂnullł͂Ȃ̕nKv_ɒӁB
        fSaxHandler.endElement(BlancoStringUtil.null2Blank(element.getUri()),
                BlancoStringUtil.null2Blank(element.getLocalName()), qName);
    }

    /**
     * f[^WJ܂B
     * 
     * @param argCharacters
     *            f[^B
     * @throws SAXException
     *             SAXOꍇB
     */
    private void expandCharacters(final BlancoXmlCharacters argCharacters)
            throws SAXException {
        if (argCharacters == null) {
            throw new IllegalArgumentException(
                    "expandCharacters̈null^܂B");
        }
        if (argCharacters.getValue() == null) {
            // nullw肳Ăꍇɂ "" ėOȂ悤ɂ܂B
            argCharacters.setValue("");
        }

        if (argCharacters.getCdata()) {
            fSaxHandler.startCDATA();
        }

        final char[] buf = argCharacters.getValue().toCharArray();
        fSaxHandler.characters(buf, 0, buf.length);

        if (argCharacters.getCdata()) {
            fSaxHandler.endCDATA();
        }
    }

    /**
     * \ȋ󔒃f[^WJ܂B
     * 
     * @param argIgnorableWhitespace
     *            \ȋ󔒃f[^B
     * @throws SAXException
     *             SAXOꍇB
     */
    private void expandIgnorableWhitespace(
            final BlancoXmlIgnorableWhitespace argIgnorableWhitespace)
            throws SAXException {
        if (argIgnorableWhitespace.getCdata()) {
            fSaxHandler.startCDATA();
        }

        final char[] buf = argIgnorableWhitespace.getValue().toCharArray();
        fSaxHandler.ignorableWhitespace(buf, 0, buf.length);

        if (argIgnorableWhitespace.getCdata()) {
            fSaxHandler.endCDATA();
        }
    }

    /**
     * RgWJ܂B
     * 
     * @param argComment
     *            RgIuWFNgB
     * @throws SAXException
     *             SAXOꍇB
     */
    private void expandComment(final BlancoXmlComment argComment)
            throws SAXException {
        final char[] buf = argComment.getValue().toCharArray();
        fSaxHandler.comment(buf, 0, buf.length);
    }
}
