/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.resourcebundle.expand;

import java.io.File;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoBigDecimalUtil;
import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoStringUtil;
import blanco.commons.util.BlancoXmlUtil;
import blanco.resourcebundle.BlancoResourceBundleConstants;
import blanco.resourcebundle.resourcebundle.BlancoResourceBundleResourceBundle;

/**
 * XMLt@C vpeBt@C𐶐鏈̓łB
 * 
 * ̃\[XR[hblancoResourceBundlëꕔłB<br>
 * XMLDOMGg͂Ƃăt@Co͂܂B <br>
 * 
 * ̑O:BlancoResourceBundleXmlValidatorNXŎOɃ`FbNĂ̂Ƒz肵܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoResourceBundleExpandResourceBundle {
    /**
     * \[XohANZT̃CX^XB
     */
    private final BlancoResourceBundleResourceBundle fBundle = new BlancoResourceBundleResourceBundle();

    /**
     * IɗpblancoCgpt@NgB
     */
    private BlancoCgObjectFactory fCgFactory = null;

    /**
     * IɗpblancoCgp\[Xt@CB
     */
    private BlancoCgSourceFile fCgSourceFile = null;

    /**
     * IɗpblancoCgpNXB
     */
    private BlancoCgClass fCgClass = null;

    /**
     * w̏\[XR[hɓWJ܂B
     * 
     * \[XR[ho̓tOɂāA\[XR[ho͂邩ǂ؂ւ܂B
     * 
     * @param elementSheet
     *            V[g̃GgB
     * @param elementCommon
     *            ʏ̃GgB
     * @param directoryTarget
     *            o͐̃^[QbgfBNgB
     * @param isFailOnMessageFormatError
     *            bZ[WMessageFormatɂp[Xsۂ̗O珈𒆒f邩ǂ̃tOݒ肵܂B
     * @param isLog
     *            Oo͂\[XR[hɊ܂߂邩ǂB
     */
    public void expand(final Element elementSheet, final Element elementCommon,
            final File directoryTarget,
            final boolean isFailOnMessageFormatError, final boolean argIsLog) {
        final String baseName = BlancoXmlUtil.getTextContent(elementCommon,
                BlancoResourceBundleConstants.BASE_NAME);
        final String suffix = BlancoXmlUtil.getTextContent(elementCommon,
                BlancoResourceBundleConstants.SUFFIX);
        // NX͖Oό`܂B
        final String className = BlancoNameAdjuster.toClassName(baseName)
                + (suffix == null ? "" : suffix);
        final String packageName = BlancoXmlUtil.getTextContent(elementCommon,
                BlancoResourceBundleConstants.PACKAGE_NAME);
        final String description = BlancoXmlUtil.getTextContent(elementCommon,
                BlancoResourceBundleConstants.DESCRIPTION);

        final ArrayList listKnownLocale = new ArrayList();
        final HashMap mapBundle = new HashMap();

        // ]ƌ݊邽߁A/mainTutH_ɏo͂܂B
        final File fileBlancoMain = new File(directoryTarget.getAbsolutePath()
                + "/main");

        fCgFactory = BlancoCgObjectFactory.getInstance();
        fCgSourceFile = fCgFactory.createSourceFile(packageName,
                "̃\[XR[h blanco FrameworkɂĎĂ܂B");
        fCgSourceFile.getLangDoc().getDescriptionList().add(
                fBundle.getExpandresourceSrc001());

        fCgClass = fCgFactory.createClass(className, fBundle
                .getExpandresourceSrc011(baseName
                        + (description == null ? "" : "/" + description)));
        fCgSourceFile.getClassList().add(fCgClass);

        fCgClass.getLangDoc().getDescriptionList().add(
                fBundle.getExpandresourceSrc012());

        {
            final NodeList listCommonList = elementSheet
                    .getElementsByTagName(fBundle.getMeta2xmlElementCommon());
            if (listCommonList == null || listCommonList.getLength() == 0) {
                // commonꍇɂ̓XLbv܂B
                return;
            }

            final NodeList listLocale = ((Element) listCommonList.item(0))
                    .getElementsByTagName("locale");
            if (listLocale == null || listLocale.getLength() == 0) {
                return;
            }

            final int sizeListLocale = listLocale.getLength();
            if (sizeListLocale > 0) {
                fCgClass.getLangDoc().getDescriptionList().add(
                        fBundle.getExpandresourceSrc013());
                fCgClass.getLangDoc().getDescriptionList().add("<UL>");
                for (int indexLocale = 0; indexLocale < sizeListLocale; indexLocale++) {
                    final Element elementLocale = (Element) listLocale
                            .item(indexLocale);
                    final String locale = BlancoStringUtil
                            .null2Blank(BlancoXmlUtil
                                    .getTextContent(elementLocale));
                    listKnownLocale.add(locale);
                    fCgClass.getLangDoc().getDescriptionList().add(
                            "<LI>" + locale);
                }
                fCgClass.getLangDoc().getDescriptionList().add("</UL>");
            }

            final BlancoCgField field1 = fCgFactory.createField(
                    "fResourceBundle", "java.util.ResourceBundle", fBundle
                            .getExpandresourceSrc014());
            fCgClass.getFieldList().add(field1);
            field1.getLangDoc().getDescriptionList().add(
                    fBundle.getExpandresourceSrc015());

            {
                final BlancoCgMethod method = fCgFactory.createMethod(
                        className, fBundle.getExpandresourceSrc021(className));
                fCgClass.getMethodList().add(method);
                method.setConstructor(true);
                method.getLangDoc().getDescriptionList().add(
                        fBundle.getExpandresourceSrc022(baseName));

                // ɃC|[gKvłB
                fCgSourceFile.getImportList().add(
                        "java.util.MissingResourceException");

                final List listLine = method.getLineList();

                listLine.add("try {");
                listLine.add("fResourceBundle = ResourceBundle.getBundle(\""
                        + baseName + "\");");
                listLine.add("} catch (MissingResourceException ex) {");
                if (argIsLog) {
                    listLine.add("final String message = \""
                            + fBundle.getExpandresourceSrc023(baseName)
                            + "\" + ex.toString();");
                    listLine.add("System.out.println(message);");
                }
                listLine.add("}");
            }

            {
                final BlancoCgMethod method = fCgFactory.createMethod(
                        className, fBundle.getExpandresourceSrc031(className));
                fCgClass.getMethodList().add(method);
                method.setConstructor(true);
                method.getLangDoc().getDescriptionList().add(
                        fBundle.getExpandresourceSrc032(baseName));
                method.getParameterList().add(
                        fCgFactory.createParameter("locale",
                                "java.util.Locale", fBundle
                                        .getExpandresourceSrc033()));

                final List listLine = method.getLineList();

                listLine.add("try {");
                listLine.add("fResourceBundle = ResourceBundle.getBundle(\""
                        + baseName + "\", locale);");
                listLine.add("} catch (MissingResourceException ex) {");
                if (argIsLog) {
                    listLine.add("final String message = \""
                            + fBundle.getExpandresourceSrc034(baseName)
                            + "\" + ex.toString();");
                    listLine.add("System.out.println(message);");
                }
                listLine.add("}");
            }

            {
                final BlancoCgMethod method = fCgFactory.createMethod(
                        className, fBundle.getExpandresourceSrc041(className));
                fCgClass.getMethodList().add(method);
                method.setConstructor(true);
                method.getLangDoc().getDescriptionList().add(
                        fBundle.getExpandresourceSrc042(baseName));

                method.getParameterList().add(
                        fCgFactory.createParameter("locale",
                                "java.util.Locale", fBundle
                                        .getExpandresourceSrc043()));
                method.getParameterList().add(
                        fCgFactory.createParameter("loader",
                                "java.lang.ClassLoader", fBundle
                                        .getExpandresourceSrc044()));

                final List listLine = method.getLineList();

                listLine.add("try {");
                listLine.add("fResourceBundle = ResourceBundle.getBundle(\""
                        + baseName + "\", locale, loader);");
                listLine.add("} catch (MissingResourceException ex) {");
                if (argIsLog) {
                    listLine.add("final String message = \""
                            + fBundle.getExpandresourceSrc045(baseName)
                            + "\" + ex.toString();");
                    listLine.add("System.out.println(message);");
                }
                listLine.add("}");
            }

            {
                // getResourceBundle\bh
                final BlancoCgMethod method = fCgFactory.createMethod(
                        "getResourceBundle", "IɕێĂ郊\[XohIuWFNg擾܂B");
                fCgClass.getMethodList().add(method);

                method.setReturn(fCgFactory
                        .createReturn("java.util.ResourceBundle",
                                "IɕێĂ郊\[XohIuWFNgB"));

                final List listLine = method.getLineList();

                listLine.add("return fResourceBundle;");
            }

            final NodeList listResourceList = elementSheet
                    .getElementsByTagName(fBundle.getMeta2xmlElementList());
            if (listResourceList == null || listResourceList.getLength() == 0) {
                // commonꍇɂ̓XLbv܂B
                return;
            }

            final NodeList listResource = ((Element) listResourceList.item(0))
                    .getElementsByTagName("resource");
            if (listResource == null || listResource.getLength() == 0) {
                return;
            }

            final int sizeListResource = listResource.getLength();
            for (int indexResource = 0; indexResource < sizeListResource; indexResource++) {
                final Element elementResource = (Element) listResource
                        .item(indexResource);

                final String fieldResourceId = BlancoStringUtil
                        .null2Blank(BlancoXmlUtil.getTextContent(
                                elementResource,
                                BlancoResourceBundleConstants.RESOURCE_KEY));

                final BlancoCgMethod methodGet = fCgFactory.createMethod("get"
                        + BlancoNameAdjuster.toClassName(fieldResourceId),
                        "bundle[" + baseName + "], key[" + fieldResourceId
                                + "]");
                fCgClass.getMethodList().add(methodGet);

                final NodeList nodeListResourceString = elementResource
                        .getElementsByTagName(BlancoResourceBundleConstants.RESOURCE_STRING);
                if (nodeListResourceString == null
                        || nodeListResourceString.getLength() == 0) {
                    return;
                }

                final HashMap mapProcessedLocale = new HashMap();
                for (int indexResourceString = 0; indexResourceString < nodeListResourceString
                        .getLength(); indexResourceString++) {
                    if (nodeListResourceString.item(indexResourceString) instanceof Element == false) {
                        continue;
                    }

                    final Element elementResourceString = (Element) nodeListResourceString
                            .item(indexResourceString);
                    final String resourceString = BlancoStringUtil
                            .null2Blank(BlancoXmlUtil
                                    .getTextContent(elementResourceString));
                    final String locale = BlancoStringUtil
                            .null2Blank(elementResourceString
                                    .getAttribute("locale"));
                    methodGet
                            .getLangDoc()
                            .getDescriptionList()
                            .add(
                                    "["
                                            + BlancoJavaSourceUtil
                                                    .escapeStringAsJavaDoc(resourceString)
                                            + "] (" + locale + ")<br>");

                    // ς݂̃P[ł邱ƂL܂B
                    mapProcessedLocale.put(locale, locale);
                    if (mapBundle.get(fieldResourceId) == null) {
                        mapBundle.put(fieldResourceId, resourceString);
                    }

                    // tH[}bgO͔邱Ƃ͑z肵܂BȂȂ玖O`FbNɂɉĂ邩łB
                    final Format[] formatList = getFormatsByArgumentIndex(
                            resourceString, isFailOnMessageFormatError);
                    for (int indexFormat = 0; indexFormat < formatList.length; indexFormat++) {
                        String strArgType = "java.lang.String";
                        if (formatList[indexFormat] == null) {
                            // tH[}bgȂ:
                            // java.lang.Stringւ̃}bvÓ
                            strArgType = "java.lang.String";
                        } else if (formatList[indexFormat] instanceof java.text.NumberFormat) {
                            // java.math.BigDecimalւ̃}bvÓ
                            strArgType = "java.math.BigDecimal";
                        } else if (formatList[indexFormat] instanceof java.text.DateFormat) {
                            // java.util.Dateւ̃}bvÓ
                            strArgType = "java.util.Date";
                        } else if (formatList[indexFormat] instanceof java.text.ChoiceFormat) {
                            // intւ̃}bvÓ
                            strArgType = "int";
                        } else {
                            strArgType = "java.lang.String";
                        }
                        if (indexResourceString == 0) {
                            // ̂݃\bh𐶐
                            methodGet
                                    .getParameterList()
                                    .add(
                                            fCgFactory
                                                    .createParameter(
                                                            "arg" + indexFormat,
                                                            strArgType,
                                                            fBundle
                                                                    .getExpandresourceSrc101(
                                                                            BlancoBigDecimalUtil
                                                                                    .toBigDecimal(indexFormat),
                                                                            strArgType)));
                        }
                    }
                    methodGet.setReturn(fCgFactory.createReturn(
                            "java.lang.String", fBundle
                                    .getExpandresourceSrc102(fieldResourceId)));
                }

                // P[SđĂ邩ǂ̃`FbNs܂B
                for (int indexCheck = 0; indexCheck < listKnownLocale.size(); indexCheck++) {
                    final String localeCheck = (String) listKnownLocale
                            .get(indexCheck);
                    final Object objCheck = mapProcessedLocale.get(localeCheck);
                    if (objCheck == null) {
                        // ĂȂꍇłĂAJavaDocւ̌xo͂ɂƂǂ߂܂B
                        methodGet.getLangDoc().getDescriptionList().add(
                                fBundle.getExpandresourceSrc103(localeCheck));
                    }
                }

                final String resourceString = (String) mapBundle
                        .get(fieldResourceId);

                final List listLine = methodGet.getLineList();

                listLine.add("// " + fBundle.getExpandresourceSrc104());
                listLine.add("String strFormat = \""
                        + BlancoJavaSourceUtil
                                .escapeStringAsJavaSource(resourceString)
                        + "\";");
                listLine.add("try {");
                listLine.add("if (fResourceBundle != null) {");
                listLine.add("strFormat = fResourceBundle.getString(\""
                        + BlancoJavaSourceUtil.escapeStringAsJavaSource(fBundle
                                .getKeyPrefix()
                                + fieldResourceId) + "\");");
                listLine.add("}");
                listLine.add("} catch (MissingResourceException ex) {");
                if (argIsLog) {
                    listLine.add("final String message = \""
                            + fBundle.getExpandresourceSrc105(baseName, fBundle
                                    .getKeyPrefix()
                                    + fieldResourceId) + "\" + ex.toString();");
                    listLine.add("System.out.println(message);");
                }
                listLine.add("}");

                final Format[] formatList = getFormatsByArgumentIndex(
                        resourceString, isFailOnMessageFormatError);
                if (formatList.length > 0) {
                    String strArgForFormat = "";
                    for (int index = 0; index < formatList.length; index++) {
                        if (index != 0) {
                            strArgForFormat += ", ";
                        }
                        strArgForFormat += ("arg" + index);
                    }

                    fCgSourceFile.getImportList()
                            .add("java.text.MessageFormat");

                    listLine
                            .add("final MessageFormat messageFormat = new MessageFormat(strFormat);");
                    listLine
                            .add("final StringBuffer strbuf = new StringBuffer();");
                    listLine.add("// " + fBundle.getExpandresourceSrc106());
                    listLine.add("messageFormat.format(new Object[] {"
                            + strArgForFormat + "}, strbuf, null);");

                    listLine.add("return strbuf.toString();");
                } else {
                    listLine.add("// " + fBundle.getExpandresourceSrc107());
                    listLine.add("return strFormat;");
                }

            }
        }

        // \[XR[hۂɐ܂B
        BlancoCgTransformerFactory.getJavaSourceTransformer().transform(
                fCgSourceFile, fileBlancoMain);
    }

    /**
     * MessageFormattH[}bg擾܂B
     * 
     * ̃\bh blancoResourceBundleIɂ̂ݗp邱Ƃz肵Ă܂B
     * 
     * @param resourceString
     *            \[X
     * @param isFailOnMessageFormatError
     *            MessageFormatƂăp[XꍇɃG[ƂĈǂB
     * @return ͌̃tH[}bgzB
     */
    public static final Format[] getFormatsByArgumentIndex(
            final String resourceString,
            final boolean isFailOnMessageFormatError) {
        try {
            final MessageFormat messageFormat = new MessageFormat(
                    resourceString);
            return messageFormat.getFormatsByArgumentIndex();

        } catch (IllegalArgumentException ex) {
            if (isFailOnMessageFormatError) {
                throw ex;
            }

            // G[𖳎āAȂ̂ƂU܂B
            return new Format[0];
        }
    }
}