/*******************************************************************************
 * Copyright (c) 2008 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2008 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.xliff;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;

import blanco.commons.util.BlancoFileUtil;
import blanco.xliff.valueobject.BlancoXliff;
import blanco.xliff.valueobject.BlancoXliffAltTrans;
import blanco.xliff.valueobject.BlancoXliffFile;
import blanco.xliff.valueobject.BlancoXliffHeader;
import blanco.xliff.valueobject.BlancoXliffTool;
import blanco.xliff.valueobject.BlancoXliffTransUnit;

/**
 * XLIFF𑀍삷邽߂̃[eBeB[B
 * 
 * @author IGA Tosiki
 */
public class BlancoXliffUtil {
    /**
     * XLIFF̃CX^X擾܂B
     * 
     * w肳ꂽfBNgXLIFFɂ΂𗘗p܂BXLIFF܂ꍇɂ̓CX^XVKɍ쐬܂B(t@C쐬͔܂)
     * 
     * @param argXliffdir
     * @param argBundleSymbolicName
     * @return
     */
    public static BlancoXliff getXliffInstance(final File fileXliffdir,
            final String argBundleSymbolicName) {
        BlancoXliff xliff;
        final File fileXliff = new File(fileXliffdir.getAbsolutePath() + "/"
                + argBundleSymbolicName + ".xlf");
        if (fileXliff.exists()) {
            // ݂ꍇɂ͓ǂݍ݂܂B
            xliff = new BlancoXliffParser().parse(fileXliff);
        } else {
            // ݂Ȃꍇɂ͐VK쐬܂B
            xliff = new BlancoXliff();
        }
        return xliff;
    }

    /**
     * XLIFFۑ܂B
     * 
     * @param xliff
     * @param argXliffdir
     * @param argBundleSymbolicName
     * @return
     * @throws IOException
     */
    public static int saveXliffInstance(final BlancoXliff xliff,
            final File fileXliffdir, final String argBundleSymbolicName)
            throws IOException {
        final File fileXliff = new File(fileXliffdir.getAbsolutePath() + "/"
                + argBundleSymbolicName + ".xlf");
        final ByteArrayOutputStream outStream = new ByteArrayOutputStream(8192);

        new BlancoXliffSerializer().serialize(xliff, outStream);

        return BlancoFileUtil.bytes2FileIfNecessary(outStream.toByteArray(),
                fileXliff);
    }

    /**
     * XLIFF tool o^Zbg܂B
     * 
     * ΒǉAɑ݂ĂΓeXV܂B
     * 
     * @param xliff
     * @param tool
     */
    public static void setTool(final BlancoXliffHeader header,
            final BlancoXliffTool tool) {
        for (int index = 0; index < header.getToolList().size(); index++) {
            final BlancoXliffTool toolLook = (BlancoXliffTool) header
                    .getToolList().get(index);
            if (toolLook.getToolId().equals(tool.getToolId())) {
                // ɑ݂B㏑B
                toolLook.setToolName(tool.getToolName());

                return;
            }
        }

        // ̃c[͖o^Beǉ܂B
        header.getToolList().add(tool);
    }

    /**
     * file擾܂Bnull߂܂B
     * 
     * @param xliff
     * @param path
     * @return
     */
    public static BlancoXliffFile getFile(final BlancoXliff xliff,
            final String path) {
        for (int indexFile = 0; indexFile < xliff.getFileList().size(); indexFile++) {
            final BlancoXliffFile file = (BlancoXliffFile) xliff.getFileList()
                    .get(indexFile);
            if (path.equals(file.getOriginal())) {
                // ꂾI
                return file;
            }
        }
        // ܂łB
        return null;
    }

    /**
     * w肳ꂽ id  trans-unit 擾܂B
     * 
     * @param xliff
     * @param id
     * @return ΂̃IuWFNgB nullB
     */
    public static BlancoXliffTransUnit getTransUnit(final BlancoXliff xliff,
            final String id) {
        for (int indexFile = 0; indexFile < xliff.getFileList().size(); indexFile++) {
            final BlancoXliffFile file = (BlancoXliffFile) xliff.getFileList()
                    .get(indexFile);
            for (int index = 0; index < file.getBody().getTransUnitList()
                    .size(); index++) {
                final BlancoXliffTransUnit transUnit = (BlancoXliffTransUnit) file
                        .getBody().getTransUnitList().get(index);
                if (transUnit.getId().equals(id)) {
                    // ɂ΂̗pB
                    return transUnit;
                }
            }
        }
        return null;
    }

    /**
     * w肳ꂽtool-id, source, targetɍv alt-trans o[IuWFNg擾܂B
     * 
     * ݂Ȃꍇɂ null ߂܂B
     * 
     * @param transUnit
     * @param toolId
     * @param sourceString
     * @param targetString
     * @return
     */
    public static BlancoXliffAltTrans getAltTrans(
            final BlancoXliffTransUnit transUnit, final String toolId,
            final String sourceString, final String targetString) {
        for (int index = 0; index < transUnit.getAltTransList().size(); index++) {
            final BlancoXliffAltTrans altTrans = (BlancoXliffAltTrans) transUnit
                    .getAltTransList().get(index);
            if (toolId.equals(altTrans.getToolId()) == false) {
                // tool-id̂̂̓XLbv܂B
                continue;
            }
            if (sourceString.equals(altTrans.getSource())
                    && targetString.equals(altTrans.getTarget().getTarget())) {
                // tool-id, source, target ̑SĂv܂B
                // ꂪ߂ׂ alt-trans o[IuWFNgłB
                return altTrans;
            }
        }

        return null;
    }
}
