/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.plugin.resourcebundle.editors;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;

import javax.xml.transform.dom.DOMResult;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorInput;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import blanco.commons.util.BlancoXmlUtil;
import blanco.plugin.resourcebundle.BlancoResourceBundlePlugin;
import blanco.plugin.resourcebundle.BlancoResourceBundlePluginConstants;
import blanco.plugin.resourcebundle.actions.BlancoResourceBundleGenerateAction;
import blanco.resourcebundle.BlancoResourceBundleConstants;
import blanco.resourcebundle.resourcebundle.BlancoResourceBundleResourceBundle;

/**
 * \[Xoh`vpeBt@CуANZTJava\[XR[h𐶐 EclipseGfB^łB
 * 
 * ̃\[XR[hblancoResourceBundlëꕔłB<br>
 * 
 * @author IGA Tosiki
 */
public class BlancoResourceBundleEditor extends
        AbstractBlancoResourceBundleEditor {
    /**
     * \[XohANZT̃CX^XB
     */
    private static final BlancoResourceBundleResourceBundle fBundle = new BlancoResourceBundleResourceBundle();

    /**
     * gbvIuWFNgB
     */
    private Composite top = null;

    // rWÄ
    private Label labelBlancoResourceBundleTitle = null;

    private Label labelBlancoResourceBundleSettingId = null;

    private Text textBlancoResourceBundleSettingId = null;

    private Label labelMetadir = null;

    private Combo comboMetadir = null;

    private Label labelMetadirComment = null;

    private Label labelSettingComment = null;

    private Button checkBoxFailOnMessageFormatError = null;

    private Button checkBoxIsLog = null;

    private Button buttonExecute = null;

    private Button buttonCreateMetafile = null;

    /**
     * PartRg[쐬܂B
     * 
     * @param parent
     *            eRg[B
     */
    public void createPartControl(Composite parent) {
        top = parent;
        top.setSize(new org.eclipse.swt.graphics.Point(1000, 400));

        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        top.setLayout(layout);

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelBlancoResourceBundleTitle = new Label(top, SWT.NONE);
        labelBlancoResourceBundleTitle
                .setText(BlancoResourceBundleConstants.PRODUCT_NAME
                        + "ݒt@C GfB^ ("
                        + BlancoResourceBundleConstants.VERSION + ")");

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelBlancoResourceBundleSettingId = new Label(top, SWT.NONE);
        labelBlancoResourceBundleSettingId.setText("ݒID");
        textBlancoResourceBundleSettingId = new Text(top, SWT.BORDER);
        textBlancoResourceBundleSettingId
                .setText(BlancoResourceBundleConstants.PRODUCT_NAME);
        textBlancoResourceBundleSettingId.setEditable(false);

        labelMetadir = new Label(top, SWT.NONE);
        labelMetadir.setText("^fBNg");
        createComboMetadir();

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelMetadirComment = new Label(top, SWT.NONE);
        labelMetadirComment.setText("^fBNg͒ʏύXɗp܂B");
        labelMetadirComment.setSize(new org.eclipse.swt.graphics.Point(500,
                30 + 20));

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        buttonCreateMetafile = new Button(top, SWT.NONE);
        buttonCreateMetafile
                .setText(fBundle.getMetafileDisplayname() + " VK쐬");
        buttonCreateMetafile
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        // ^t@C쐬̍ۂɂ́A̍ڂ̃`FbN͍s܂B
                        saveToTextEditor();

                        if (comboMetadir.getText().length() == 0) {
                            MessageDialog
                                    .openWarning(
                                            top.getShell(),
                                            fBundle.getMetafileDisplayname()
                                                    + " VK쐬",
                                            "^fBNgw肵ĂB\n"
                                                    + "^fBNg̈ʓIȐݒl 'meta/resourcebundle' łB");
                            return;
                        }

                        final IFileEditorInput input = (IFileEditorInput) getEditorInput();

                        try {
                            if (BlancoResourceBundlePluginUtil.findFolder(
                                    input.getFile(), getProgressMonitor(),
                                    comboMetadir.getText()).exists() == false) {
                                BlancoResourceBundlePluginUtil.createFolder(
                                        input.getFile(), getProgressMonitor(),
                                        comboMetadir.getText());

                                MessageDialog.openInformation(top.getShell(),
                                        "^fBNg̍쐬", "^fBNg ["
                                                + comboMetadir.getText()
                                                + "] VKɍ쐬܂B\n"
                                                + "ɂ̂ݕKvȓłB");
                            }
                        } catch (CoreException e3) {
                            MessageDialog.openWarning(top.getShell(), fBundle
                                    .getMetafileDisplayname()
                                    + " VK쐬", "^fBNg쐬Ɏs܂Bf܂B:"
                                    + e3.toString());
                            e3.printStackTrace();
                            return;
                        }

                        try {
                            URL localURL = BlancoResourceBundlePlugin
                                    .getPluginRoot();

                            InputDialog inputDialog = new InputDialog(top
                                    .getShell(), fBundle
                                    .getMetafileDisplayname()
                                    + " VK쐬", fBundle.getMetafileDisplayname()
                                    + "(^t@C)^fBNg["
                                    + comboMetadir.getText() + "]ɍ쐬܂B"
                                    + fBundle.getMetafileDisplayname()
                                    + "̐VKt@C͂ĂB",
                                    BlancoResourceBundleConstants.PRODUCT_NAME
                                            + "Meta.xls",
                                    new IInputValidator() {
                                        public String isValid(String newText) {
                                            if (newText.endsWith(".xls") == false) {
                                                return "t@C .xlsŏI悤Ɏw肵ĂB";
                                            }
                                            if (newText.indexOf('/') >= 0
                                                    || newText.indexOf('\\') >= 0
                                                    || newText.indexOf(':') >= 0
                                                    || newText.indexOf(';') >= 0
                                                    || newText.indexOf('*') >= 0
                                                    || newText.indexOf('?') >= 0
                                                    || newText.indexOf('\"') >= 0
                                                    || newText.indexOf('>') >= 0
                                                    || newText.indexOf('<') >= 0
                                                    || newText.indexOf('|') >= 0) {
                                                return "t@Cɂ / \\ : ; * ? \" > < | ͗pȂłB";
                                            }
                                            // ɂ̃t@C݂Ȃǂ`FbN
                                            IFile newFileMeta = input.getFile()
                                                    .getProject().getFolder(
                                                            comboMetadir
                                                                    .getText())
                                                    .getFile(newText);
                                            if (newFileMeta.exists()) {
                                                return "w̃t@C͊ɑ݂Ă܂B"
                                                        + "ʂ̃t@Cw肵ĂB";
                                            }
                                            return null;
                                        }
                                    });
                            if (inputDialog.open() == InputDialog.CANCEL) {
                                inputDialog.close();
                                return;
                            }
                            final String newMetaFilename = inputDialog
                                    .getValue();
                            inputDialog.close();

                            // vOC̃[Jev[gǂݍ݂܂B
                            InputStream inStream = new FileInputStream(
                                    localURL.getPath()
                                            + BlancoResourceBundlePluginConstants.TEMPLATE_FILENAME_WITHOUT_EXT
                                            + ".xls");
                            IFile newFileMeta = input.getFile().getProject()
                                    .getFolder(comboMetadir.getText()).getFile(
                                            newMetaFilename);
                            newFileMeta.create(inStream, true,
                                    getProgressMonitor());
                            inStream.close();
                            MessageDialog
                                    .openInformation(
                                            top.getShell(),
                                            fBundle.getMetafileDisplayname()
                                                    + " VK쐬",
                                            fBundle.getMetafileDisplayname()
                                                    + "(^t@C ["
                                                    + newMetaFilename
                                                    + "] ^fBNg["
                                                    + comboMetadir.getText()
                                                    + "]ɐVK쐬܂B\n"
                                                    + "̃t@CҏWāA\[Xoh֘Aݒ肵ĂB");
                        } catch (CoreException e1) {
                            e1.printStackTrace();
                            return;
                        } catch (IOException e2) {
                            MessageDialog.openWarning(top.getShell(), "^t@C",
                                    "^t@C̃Rs[Ɏs܂B:" + e2.toString());
                            e2.printStackTrace();
                        }

                    }
                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        buttonExecute = new Button(top, SWT.NONE);
        buttonExecute.setText("\[XR[h");
        buttonExecute
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        if (checkInputField() == false) {
                            return;
                        }

                        try {
                            if (checkInputField() == false) {
                                return;
                            }

                            final IFileEditorInput input = (IFileEditorInput) getEditorInput();
                            if (input.getFile().getProject().getFolder(
                                    comboMetadir.getText()).exists() == false) {
                                MessageDialog.openWarning(top.getShell(),
                                        "\[XR[h", "^fBNg ("
                                                + comboMetadir.getText()
                                                + ") ݂܂B𒆒f܂B");
                                return;
                            }

                            showBusy(true);
                            // ēh~邽߂ɕKvłB
                            buttonExecute.setEnabled(false);

                            BlancoResourceBundleGenerateAction
                                    .processBlancoResourceBundle(input
                                            .getFile(), top.getShell(),
                                            getProgressMonitor(), comboMetadir
                                                    .getText(),
                                            checkBoxFailOnMessageFormatError
                                                    .getSelection(),
                                            checkBoxIsLog.getSelection());

                            // blancotH_𓯊
                            BlancoResourceBundlePluginUtil.refreshFolder(input
                                    .getFile(), getProgressMonitor(), "blanco");

                            // tmptH_𓯊
                            BlancoResourceBundlePluginUtil.refreshFolder(input
                                    .getFile(), getProgressMonitor(), "tmp");

                            // resourcebundletH_𓯊
                            // ܂łیƂē܂B
                            BlancoResourceBundlePluginUtil.refreshFolder(input
                                    .getFile(), getProgressMonitor(),
                                    comboMetadir.getText());
                        } catch (Exception ex) {
                            ex.printStackTrace();
                            StringWriter writer = new StringWriter();
                            ex.printStackTrace(new PrintWriter(writer));
                            writer.flush();
                            MessageDialog.openError(top.getShell(), "\[XR[h",
                                    "񕜕s\ȃG[.:" + ex.toString() + ": "
                                            + writer.toString());
                        } finally {
                            showBusy(false);
                            // ēh~邽߂ɕKvłB
                            buttonExecute.setEnabled(true);
                        }
                    }

                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        checkBoxFailOnMessageFormatError = new Button(top, SWT.CHECK);
        checkBoxFailOnMessageFormatError
                .setText("MessageFormatŉ͂ۂɗO珈fB");
        checkBoxFailOnMessageFormatError.setSelection(true);

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        checkBoxIsLog = new Button(top, SWT.CHECK);
        checkBoxIsLog.setText("Oo͂\[XR[hɊ܂߂B");
        checkBoxIsLog.setSelection(true);

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelSettingComment = new Label(top, SWT.NONE);
        labelSettingComment.setText("eX̐ݒl "
                + BlancoResourceBundlePluginConstants.TARGET_FILENAME
                + "t@CɕŊi[܂B");
        labelSettingComment
                .setSize(new org.eclipse.swt.graphics.Point(500, 20));

        loadFromTextEditor();

        setFocusLostHandler(comboMetadir);
        setFocusLostHandler(checkBoxFailOnMessageFormatError);
        setFocusLostHandler(checkBoxIsLog);
    }

    /**
     * Ǎs܂B
     * 
     * ̃\bh͏ɖč쐬܂B <br>
     */
    protected void loadFromTextEditorInternal(final DOMResult argResult) {
        final Node nodeRoot = argResult.getNode();
        if (nodeRoot == null) {
            return;
        }
        final Element elementBlancoResourceBundle = BlancoXmlUtil.getElement(
                nodeRoot, "blanco/target/"
                        + BlancoResourceBundleConstants.PRODUCT_NAME_LOWER);
        if (elementBlancoResourceBundle == null) {
            return;
        }

        final String metadir = elementBlancoResourceBundle
                .getAttribute("metadir");
        if (metadir != null) {
            comboMetadir.setText(metadir);
        }

        final String failonmessageformaterror = elementBlancoResourceBundle
                .getAttribute("failonmessageformaterror");
        if (failonmessageformaterror != null) {
            checkBoxFailOnMessageFormatError.setSelection("true"
                    .equals(failonmessageformaterror));
        }

        final String log = elementBlancoResourceBundle.getAttribute("log");
        if (log != null) {
            checkBoxIsLog.setSelection("true".equals(log));
        }
    }

    /**
     * eLXgGfB^ƂĂ̕ۑs܂B
     */
    protected Document saveToTextEditorInternal() {
        final Document document = BlancoXmlUtil.newDocument();
        final Element eleBlanco = document.createElement("blanco");
        document.appendChild(eleBlanco);

        final Element eleTarget = document.createElement("target");
        eleTarget.setAttribute("name", textBlancoResourceBundleSettingId
                .getText());
        eleBlanco.appendChild(eleTarget);

        final Element eleBlancoDb = document
                .createElement(BlancoResourceBundleConstants.PRODUCT_NAME_LOWER);
        eleTarget.appendChild(eleBlancoDb);

        eleBlancoDb.setAttribute("metadir", comboMetadir.getText());
        eleBlancoDb.setAttribute("failonmessageformaterror",
                checkBoxFailOnMessageFormatError.getSelection() ? "true"
                        : "false");
        eleBlancoDb.setAttribute("log", checkBoxIsLog.getSelection() ? "true"
                : "false");
        return document;
    }

    /**
     * ͍ڂ̃`FbN{܂B
     * 
     * G[_CAO͂̃\bhŕ\܂B
     * 
     * @return G[falseBG[trueB
     */
    private final boolean checkInputField() {
        boolean isError = false;
        if (comboMetadir.getText().length() == 0) {
            comboMetadir.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_YELLOW));
            isError = true;
        } else {
            comboMetadir.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_INFO_BACKGROUND));
        }

        if (isError) {
            MessageDialog.openWarning(top.getShell(), "K{ڂւ̓͂܂",
                    "K{ڂւ̓͂܂B\nnCCg\ĂK{ڂɒl͂Ă");
        }

        return !isError;
    }

    /**
     * comboMetadir̂߂̏
     */
    private void createComboMetadir() {
        comboMetadir = new Combo(top, SWT.NONE);
        comboMetadir.add("meta/resourcebundle");
        comboMetadir.select(0);
    }
}