/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.resourcebundle;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;

import blanco.commons.io.Native2AsciiWriter;
import blanco.commons.util.BlancoFileUtil;
import blanco.commons.util.BlancoStringUtil;
import blanco.resourcebundle.resourcebundle.BlancoResourceBundleResourceBundle;
import blanco.resourcebundle.valueobject.BlancoResourceBundleBundleItemStructure;
import blanco.resourcebundle.valueobject.BlancoResourceBundleBundleResourceStringStructure;
import blanco.resourcebundle.valueobject.BlancoResourceBundleBundleStructure;
import blanco.xml.bind.BlancoXmlBindingUtil;
import blanco.xml.bind.BlancoXmlUnmarshaller;
import blanco.xml.bind.valueobject.BlancoXmlDocument;
import blanco.xml.bind.valueobject.BlancoXmlElement;

/**
 * XMLt@C vpeBt@C𐶐܂B
 * 
 * ̃\[XR[hblancoResourceBundlëꕔłB<br>
 * XML͂ăvpeBt@Cɏo͂s܂B<br>
 * vpeBt@CdlƂĎQƂ񌹂͉LPropertiesNXłB<br>
 * http://java.sun.com/j2se/1.5.0/docs/api/java/util/Properties.html#store(java.io.OutputStream,%20java.lang.String)
 * 
 * @author IGA Tosiki
 */
public class BlancoResourceBundleXml2Properties {
    /**
     * R}hCɏo͂ۂ̃vtBbNXB
     */
    private static final String CMDLINE_PREFIX = "rb: ";

    /**
     * \[XohANZT̃CX^XB
     */
    private BlancoResourceBundleResourceBundle fBundle = new BlancoResourceBundleResourceBundle();

    /**
     * ^CX^vvpeBt@C̃Rgɏo͂邩ǂB
     */
    private boolean fCommentTimestamp = true;

    /**
     * vpeBt@CɃRgƂď𖄂ߍނǂ̃tOZbg܂B
     * 
     * @param isCommentTimestamp
     *            𖄂ߍނǂBtrueȂ疄ߍ݁B
     */
    public void setCommentTimestamp(final boolean isCommentTimestamp) {
        fCommentTimestamp = isCommentTimestamp;
    }

    /**
     * XMLt@C vpeBt@C𐶐܂B
     * 
     * @param fileSource
     *            XMLt@CB
     * @param directoryTarget
     *            o͐fBNgB
     */
    public void process(final File fileSource, final File directoryTarget) {
        if (directoryTarget.exists() == false) {
            // fBNĝŐVK쐬܂B
            directoryTarget.mkdirs();
        }

        final BlancoXmlDocument documentMeta = new BlancoXmlUnmarshaller()
                .unmarshal(fileSource);
        if (documentMeta == null) {
            return;
        }

        // [gGg擾܂B
        final BlancoXmlElement elementRoot = BlancoXmlBindingUtil
                .getDocumentElement(documentMeta);
        if (elementRoot == null) {
            // [gGgꍇɂ͏f܂B
            return;
        }

        // sheet(ExcelV[g)̃Xg擾܂B
        final List listSheet = BlancoXmlBindingUtil.getElementsByTagName(
                elementRoot, "sheet");
        {
            // ꂪnBhLg[g擾
            final int sizeListSheet = listSheet.size();
            final HashMap mapProcessedBaseName = new HashMap(64);
            for (int index = 0; index < sizeListSheet; index++) {
                final BlancoXmlElement elementSheet = (BlancoXmlElement) listSheet
                        .get(index);

                final BlancoResourceBundleBundleStructure resourceBase = new BlancoResourceBundleXmlParser()
                        .parseElementSheet(elementSheet);
                if (resourceBase == null) {
                    // XLbv܂B
                    continue;
                }

                if (mapProcessedBaseName.get(resourceBase.getName()) == null) {
                    // System.out.println("ꖼ[" + baseName + "]
                    // ߂ēoꂵ܂BP[["
                    // + locale + "]̓P[w肳ĂȂꍇ̃\[XƂĂp܂B");
                    expandSheet(resourceBase, null, directoryTarget);
                    mapProcessedBaseName.put(resourceBase.getName(),
                            resourceBase.getCurrentLocale());
                }
                expandSheet(resourceBase, resourceBase.getCurrentLocale(),
                        directoryTarget);
            }
        }
    }

    /**
     * V[gWJ܂B
     * 
     * @param elementSheet
     *            V[gGgB
     * @param elementCommon
     *            ʃGgB
     * @param locale
     *            P[B
     * @param directoryTarget
     *            o͐fBNgB
     */
    private void expandSheet(
            final BlancoResourceBundleBundleStructure resourceBase,
            final String locale, final File directoryTarget) {
        final String resourceDefinitionId = resourceBase.getName();

        // t@Cm肵܂B
        final String fileName = (locale == null ? directoryTarget
                .getAbsolutePath()
                + "/" + resourceDefinitionId + ".properties" : directoryTarget
                .getAbsolutePath()
                + "/" + resourceDefinitionId + "_" + locale + ".properties");

        final File fileTarget = new File(fileName);

        final ByteArrayOutputStream outStream = new ByteArrayOutputStream();
        Native2AsciiWriter writer = null;
        try {

            // vpeBt@C 8859_1ŃGR[hĂ܂B
            writer = new Native2AsciiWriter(new BufferedWriter(
                    new OutputStreamWriter(outStream, "8859_1")));

            writer
                    .writeComment(" blancoResourceBundle properties file for locale ["
                            + (locale == null ? "default" : locale) + "]");

            if (fCommentTimestamp) {
                writer.writeComment(" generated at "
                        + DateFormat.getDateInstance().format(new Date()) + " "
                        + DateFormat.getTimeInstance().format(new Date()));
            }

            final List listResource = resourceBase.getItemList();
            // w肪ꍇłĂAt@C͐܂B

            final int sizeListRow = listResource.size();
            for (int indexField = 0; indexField < sizeListRow; indexField++) {
                final BlancoResourceBundleBundleItemStructure elementResource = (BlancoResourceBundleBundleItemStructure) listResource
                        .get(indexField);

                final String fieldResourceId = elementResource.getKey();
                String fieldResourceString = null;
                if (elementResource.getResourceStringList().size() > 0) {
                    fieldResourceString = ((BlancoResourceBundleBundleResourceStringStructure) elementResource
                            .getResourceStringList().get(0))
                            .getResourceString();
                }

                if (BlancoStringUtil.null2Blank(fieldResourceId).length() == 0) {
                    // \[XIDnull̏ꍇ vpeBł͂܂B
                    if (fieldResourceString != null) {
                        // \[XIDnullȂ̂ǂ񂪎w肳Ăꍇɂ
                        // RgƂĈ܂B
                        writer.writeComment(fieldResourceString);
                    }
                } else {
                    writer.writeProperty(fBundle.getKeyPrefix()
                            + fieldResourceId,
                            (fieldResourceString == null ? ""
                                    : fieldResourceString));
                }
            }
            writer.flush();
            outStream.flush();

            // Kvꍇɂ̂݃t@C̍쐬XVs܂B
            switch (BlancoFileUtil.bytes2FileIfNecessary(outStream
                    .toByteArray(), fileTarget)) {
            case 0:
                // System.out.println(CMDLINE_PREFIX + "skip : "
                // + fileTarget.getAbsolutePath());
                break;
            case 1:
                System.out.println(CMDLINE_PREFIX + "create: "
                        + fileTarget.getAbsolutePath());
                break;
            case 2:
                System.out.println(CMDLINE_PREFIX + "update: "
                        + fileTarget.getAbsolutePath());
                break;
            }

        } catch (IOException e) {
            throw new IllegalArgumentException("vpeBt@C[" + fileName
                    + "]̏o͎ɓo͗O܂B" + e.toString());
        } finally {
            if (writer != null) {
                try {
                    writer.close();
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}