/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.hashtable.task;

import java.io.File;
import java.io.IOException;

import javax.xml.transform.TransformerException;

import blanco.hashtable.BlancoHashtableConstants;
import blanco.hashtable.BlancoHashtableMeta2Xml;
import blanco.hashtable.BlancoHashtableXml2SourceFile;
import blanco.hashtable.resourcebundle.BlancoHashtableResourceBundle;

/**
 * unbVe[u`vExcell HashMapNXE\[XR[h𐶐B
 * 
 * ̃NX́AApache Ant^XN܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoHashtableTask extends AbstractBlancoHashtableTask {
    /**
     * ̃v_Ng̃\[Xohւ̃ANZXIuWFNgB
     */
    private final BlancoHashtableResourceBundle fBundle = new BlancoHashtableResourceBundle();

    /**
     * `(XLS)\[XR[hApache Ant^XÑGg|CgłB
     */
    protected void process() throws IllegalArgumentException {
        System.out.println("- " + BlancoHashtableConstants.PRODUCT_NAME + " ("
                + BlancoHashtableConstants.VERSION + ")");

        try {
            final File fileMetadir = new File(getMetadir());
            if (fileMetadir.exists() == false) {
                throw new IllegalArgumentException(fBundle
                        .getAnttaskErr001(getMetadir()));
            }

            if ("true".equals(fBundle
                    .getXml2sourceFileNoGenerateConstantIfFormatElementExist())) {
                System.out
                        .println(fBundle
                                .getXml2sourceFileNoGenerateConstantIfFormatElementExistMsg());
            }

            // e|fBNg쐬B
            new File(getTmpdir() + BlancoHashtableConstants.TARGET_SUBDIRECTORY)
                    .mkdirs();

            // w肳ꂽ^fBNg܂B
            new BlancoHashtableMeta2Xml().processDirectory(fileMetadir,
                    getTmpdir() + BlancoHashtableConstants.TARGET_SUBDIRECTORY);

            // XMLꂽԃt@C\[XR[h𐶐
            final File[] fileMeta2 = new File(getTmpdir()
                    + BlancoHashtableConstants.TARGET_SUBDIRECTORY).listFiles();
            for (int index = 0; index < fileMeta2.length; index++) {
                if (fileMeta2[index].getName().endsWith(".xml") == false) {
                    continue;
                }

                new BlancoHashtableXml2SourceFile().process(fileMeta2[index],
                        getTargetlang(), new File(getTargetdir()));
            }
        } catch (IOException ex) {
            throw new IllegalArgumentException(ex.toString());
        } catch (TransformerException ex) {
            throw new IllegalArgumentException(ex.toString());
        } catch (IllegalArgumentException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }
}
