/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.plugin.filemanager.views;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class BlancoFileManagerLabelProvider extends LabelProvider {
    public String getText(final Object element) {
        if (element instanceof FileObject) {
            final FileObject fileLook = (FileObject) element;
            String name = fileLook.getName().getBaseName();
            if (name.trim().length() == 0) {
                try {
                    name = fileLook.getURL().toString();
                } catch (FileSystemException e) {
                    // TODO ꂽ catch ubN
                    e.printStackTrace();
                }
            }

            return name;
        }

        return element.toString();
    }

    public Image getImage(final Object element) {
        String imageKey = ISharedImages.IMG_OBJ_ELEMENT;

        // Jakarta Commons VFS
        if (element instanceof FileObject) {
            final FileObject fileLook = (FileObject) element;
            try {
                {
                    // EclipseɂăC[WĂ\ł΁A𗘗pB
                    final IWorkbench workbench = PlatformUI.getWorkbench();
                    final IEditorDescriptor descriptor = workbench
                            .getEditorRegistry().getDefaultEditor(
                                    fileLook.getName().getBaseName());
                    if (descriptor != null) {
                        // fXNv^𔭌̂ŁÃC[W̗pB
                        return descriptor.getImageDescriptor().createImage();
                    }
                }

                if (fileLook.getType() == FileType.FOLDER) {
                    imageKey = ISharedImages.IMG_OBJ_FOLDER;
                } else if (fileLook.getType() == FileType.FILE) {
                    imageKey = ISharedImages.IMG_OBJ_FILE;
                } else if (fileLook.getType() == FileType.IMAGINARY) {
                    // C[Wt@C̓GgƂĕ\܂B
                    imageKey = ISharedImages.IMG_OBJ_ELEMENT;
                }
            } catch (FileSystemException e) {
                // TODO ꂽ catch ubN
                e.printStackTrace();
            }
        }

        // ContentProvider
        if (element instanceof IStructuredContentProvider) {
            imageKey = ISharedImages.IMG_OBJ_FOLDER;
        }

        return PlatformUI.getWorkbench().getSharedImages().getImage(imageKey);
    }
}
