/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.plugin.filemanager.vfs;

import java.io.InputStream;

import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

/**
 * Jakarta Commons VFS  Eclipse Ƃ̃C^tF[X邽߂̃NXB
 * 
 * Jakarta Commons VFS ̂߂ StorageNXBCommons VFS߂ IStorageKvȂƂɗp܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoVfsFileObjectStorage implements IStorage {
    /**
     * ̃NXΏۂƂ Commons VFS FileObjectCX^XB
     */
    private FileObject fVfsFileObject;

    /**
     * pX̃CX^XB
     */
    private IPath fPath;

    public BlancoVfsFileObjectStorage(final FileObject argFileObject) {
        fVfsFileObject = argFileObject;
    }

    public InputStream getContents() throws CoreException {
        try {
            return fVfsFileObject.getContent().getInputStream();
        } catch (FileSystemException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e.toString());
        }
    }

    public IPath getFullPath() {
        if (fPath == null) {
            try {
                if (fVfsFileObject.getURL().toString().startsWith("file://") == false) {
                    // [Jt@Ĉ݂ΏۂƂ܂B
                    return null;
                }

                fPath = new Path(fVfsFileObject.getURL().getFile());
            } catch (FileSystemException e) {
                e.printStackTrace();
                throw new IllegalArgumentException(e.toString());
            }
        }
        return fPath;
    }

    public String getName() {
        try {
            return fVfsFileObject.getURL().getFile();
        } catch (FileSystemException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e.toString());
        }
    }

    public boolean isReadOnly() {
        try {
            return (fVfsFileObject.isWriteable() == false);
        } catch (FileSystemException e) {
            e.printStackTrace();
            throw new IllegalArgumentException(e.toString());
        }
    }

    public Object getAdapter(final Class adapter) {
        return null;
    }
}
