/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.transformer;

import blanco.cg.BlancoCgSupportedLang;
import blanco.cg.BlancoCgTransformer;
import blanco.cg.transformer.cs.BlancoCgCsSourceTransformer;
import blanco.cg.transformer.java.BlancoCgJavaSourceTransformer;
import blanco.cg.transformer.js.BlancoCgJsSourceTransformer;
import blanco.cg.transformer.php.BlancoCgPhpSourceTransformer;
import blanco.cg.transformer.vb.BlancoCgVbSourceTransformer;

/**
 * blancoCg̃o[IuWFNg\[XR[hgXtH[}[t@Ng[łB
 * 
 * blancoCg̃o[IuWFNg\ẑABlancoCgTransformerĕϊ邱Ƃɂ\[XR[h邱Ƃł܂B
 * ȂABlancoCgTransformer\[XR[hϊɂāA݂̎dlł 1xs邱ƂłȂ悤ɂȂĂ܂B
 * o[IuWFNg̓e̓sxXV悤ɂȂĂ邩łB̓_ɂӂB
 * 
 * @author IGA Tosiki
 */
public class BlancoCgTransformerFactory {
    /**
     * \[XR[hւ̃gXtH[}[擾܂B
     * 
     * @param targetLang
     *            擾gXtH[}̃vO~OBBlancoCgSupportedLangŎw肵܂B
     * @return \[XR[hϊ̂߂̃gXtH[}[B
     */
    public static final BlancoCgTransformer getSourceTransformer(
            final int targetLang) {
        switch (targetLang) {
        case BlancoCgSupportedLang.JAVA:
            return BlancoCgTransformerFactory.getJavaSourceTransformer();
        case BlancoCgSupportedLang.CS:
            return BlancoCgTransformerFactory.getCsSourceTransformer();
        case BlancoCgSupportedLang.JS:
            return BlancoCgTransformerFactory.getJsSourceTransformer();
        case BlancoCgSupportedLang.VB:
            return BlancoCgTransformerFactory.getVbSourceTransformer();
        case BlancoCgSupportedLang.PHP:
            return BlancoCgTransformerFactory.getPhpSourceTransformer();
        default:
            throw new IllegalArgumentException(
                    "BlancoCgTransformerFactory.getSourceTransformer: ΉȂvO~O("
                            + targetLang + ")w肳܂B");
        }
    }

    /**
     * Java\[XR[hւ̃gXtH[}[擾܂B
     * 
     * @return Java\[XR[ĥ߂̃gXtH[}[B
     */
    public static BlancoCgTransformer getJavaSourceTransformer() {
        return new BlancoCgJavaSourceTransformer();
    }

    /**
     * C#.NET\[XR[hւ̃gXtH[}[擾܂B
     * 
     * @return C#.NET\[XR[ĥ߂̃gXtH[}[B
     */
    public static BlancoCgTransformer getCsSourceTransformer() {
        return new BlancoCgCsSourceTransformer();
    }

    /**
     * JavaScript\[XR[hւ̃gXtH[}[擾܂B
     * 
     * @return JavaScript\[XR[ĥ߂̃gXtH[}[B
     */
    public static BlancoCgTransformer getJsSourceTransformer() {
        return new BlancoCgJsSourceTransformer();
    }

    /**
     * VB.NET\[XR[hւ̃gXtH[}[擾܂B
     * 
     * @return VB.NET\[XR[ĥ߂̃gXtH[}[B
     */
    public static BlancoCgTransformer getVbSourceTransformer() {
        return new BlancoCgVbSourceTransformer();
    }

    /**
     * PHP\[XR[hւ̃gXtH[}[擾܂B
     * 
     * @return PHP\[XR[ĥ߂̃gXtH[}[B
     */
    public static BlancoCgTransformer getPhpSourceTransformer() {
        return new BlancoCgPhpSourceTransformer();
    }
}