/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.cg;

import java.io.File;
import java.util.ArrayList;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.transformer.BlancoCgTransformerFactory;
import blanco.cg.valueobject.BlancoCgInterface;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;

/**
 * blancoCgBlancoCgTransformer邽߂̃NXłB
 * 
 * \[XR[hCu blancoCg ̂̂̈ꕔ܂B
 * 
 * @author IGA Tosiki
 */
public class BlancoCgTransformerCg {
    /**
     * blancoCg̃IuWFNg𐶐邽߂̃t@NgB
     */
    private final BlancoCgObjectFactory cgFactory = BlancoCgObjectFactory
            .getInstance();

    /**
     * \[XR[h̓WJs܂B
     * 
     * @param targetDirectory
     *            \[XR[ho͐惋[gfBNgB
     */
    public void process(final File targetDirectory) {
        // \[Xt@Cwb_WJ܂B
        final BlancoCgSourceFile cgSourceFile = expandSourceFileHeader("blanco.cg");

        // C^tF[XWJ܂B
        final BlancoCgInterface cgInterface = expandInterface(cgSourceFile);

        // \bhWJ܂B
        cgInterface.getMethodList().add(expandTransformMethod());
        cgInterface.getMethodList().add(expandTransform2Method());

        // o[IuWFNg͂ƂāA\[XR[ho͂܂B
        BlancoCgTransformerFactory.getJavaSourceTransformer().transform(
                cgSourceFile, targetDirectory);
    }

    /**
     * \[Xt@Cwb_[WJ܂B
     * 
     * @param argPackage
     *            \[XR[hpbP[WB
     * @return \[Xt@CIuWFNgB
     */
    public BlancoCgSourceFile expandSourceFileHeader(final String argPackage) {
        final BlancoCgSourceFile cgSourceFile = cgFactory.createSourceFile(
                argPackage, "blanco Framework");

        final ArrayList sourceDesc = cgSourceFile.getLangDoc()
                .getDescriptionList();

        sourceDesc.add("Copyright (C) 2004-2006 IGA Tosiki");
        sourceDesc.add("");
        sourceDesc
                .add("This library is free software; you can redistribute it and/or");
        sourceDesc
                .add("modify it under the terms of the GNU Lesser General Public");
        sourceDesc
                .add("License as published by the Free Software Foundation; either");
        sourceDesc
                .add("version 2.1 of the License, or (at your option) any later version.");

        return cgSourceFile;
    }

    /**
     * C^tF[XWJ܂B
     * 
     * @param cgSourceFile
     *            \[Xt@CIuWFNgB
     * @return C^tF[XIuWFNgB
     */
    private BlancoCgInterface expandInterface(
            final BlancoCgSourceFile cgSourceFile) {
        final BlancoCgInterface cgInterface = cgFactory.createInterface(
                "BlancoCgTransformer",
                "blancoCg̃o[IuWFNg\[XR[hgXtH[}[̃C^tF[XłB");
        cgSourceFile.getInterfaceList().add(cgInterface);

        cgInterface.getLangDoc().getTagList().add(
                cgFactory.createLangDocTag("author", null, "IGA Tosiki"));
        cgInterface.getLangDoc().getDescriptionList().add(
                "ʂ̌p̃\[XR[h́ÃC^tF[XĎ܂B");

        return cgInterface;
    }

    /**
     * transform\bhWJ܂B
     * 
     * @return \bhIuWFNgB
     */
    private BlancoCgMethod expandTransformMethod() {
        final BlancoCgMethod cgMethod = cgFactory.createMethod("transform",
                "\[Xt@CEo[IuWFNgJava\[XR[hɕϊďo͐fBNgɏo͂܂B");

        cgMethod.getLangDoc().getDescriptionList().add(
                "APIł̓pbP[W\fBNg\Ƃčl܂B");
        cgMethod.getParameterList().add(
                cgFactory.createParameter("sourceFile",
                        "blanco.cg.valueobject.BlancoCgSourceFile",
                        "\[Xt@CEo[IuWFNgB"));
        cgMethod.getParameterList().add(
                cgFactory.createParameter("outputDirectory", "java.io.File",
                        "o͐惋[gfBNgB"));

        return cgMethod;
    }

    /**
     * transform\bhWJ܂B
     * 
     * @return \bhIuWFNgB
     */
    public BlancoCgMethod expandTransform2Method() {
        final BlancoCgMethod cgMethod = cgFactory.createMethod("transform",
                "\[Xt@CEo[IuWFNg\[XR[hɕϊăC^[ɏo͂܂B");

        cgMethod.getLangDoc().getDescriptionList().add(
                "APIł̓pbP[W\fBNg\Ƃ͍l܂B");
        cgMethod.getParameterList().add(
                cgFactory.createParameter("sourceFile",
                        "blanco.cg.valueobject.BlancoCgSourceFile",
                        "\[Xt@CEo[IuWFNgB"));
        cgMethod.getParameterList().add(
                cgFactory.createParameter("writer", "java.io.BufferedWriter",
                        "o͐̃C^[B"));
        cgMethod.getThrowList().add(
                cgFactory.createException("java.io.IOException",
                        "o͗OꍇB"));

        return cgMethod;
    }
}
