/*
 * blancoDb
 * Copyright (C) 2004-2006 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.common.expander;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;

/**
 * blancoDb  BlancoCgMethodWJɂ ʓIȏW߂́B
 * 
 * @author IGA Tosiki
 */
public abstract class BlancoDbAbstractMethod {
    /**
     * blancoDbɊւݒB
     */
    protected BlancoDbSetting fDbSetting = null;

    /**
     * ̃\bhΏۂƂĂSQL̍\́B
     */
    protected BlancoDbSqlInfoStructure fSqlInfo = null;

    /**
     * o͐ blancoCg IuWFNgt@NgB
     */
    protected BlancoCgObjectFactory fCgFactory = null;

    /**
     * o͐\[XR[hIuWFNgBimportǉꍇɗp܂B
     */
    protected BlancoCgSourceFile fCgSourceFile = null;

    /**
     * o͐ blancoCgClassB
     */
    protected BlancoCgClass fCgClass = null;

    protected BlancoDbAbstractMethod(final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory,
            final BlancoCgSourceFile argCgSourceFile,
            final BlancoCgClass argCgClass) {
        fDbSetting = argDbSetting;
        fSqlInfo = argSqlInfo;
        fCgFactory = argCgFactory;
        fCgSourceFile = argCgSourceFile;
        fCgClass = argCgClass;
    }

    public abstract void expand();
}
