/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.transformer.js;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoNameUtil;

/**
 * BlancoCgSourceFilêȂ importWJ܂B
 * 
 * ̃NXblancoCg̃o[IuWFNg\[XR[hgXtH[}[̌ʂ̓WJ@\łB<br>
 * importWJ͈ӊOɂGȏłB
 * 
 * @author IGA Tosiki
 */
class BlancoCgImportJsSourceExpander {
    /**
     * \[gɗD悵ďpbP[WꗗB
     */
    private static final String[] PREFERRED_PACKAGE = { "java.", "javax.",
            "org.", "blanco.", "com." };

    /**
     * vO~O̗\ꗗB
     */
    private static final String[] LANGUAGE_RESERVED_KEYWORD = { "void", "byte",
            "short", "int", "long", "char", "float", "double", "boolean" };

    /**
     * importWJ邽߂̃AJ[B
     */
    private static final String REPLACE_IMPORT_HERE = "/*replace import here*/";

    /**
     * ꂽAJ[̃CfbNXB
     * 
     * ̃NX̏̉ߒ importҏW܂A̓sx ̒lXV܂B
     */
    private int fFindReplaceImport = -1;

    /**
     * importWJ܂B
     * 
     * ̃\bh̓NXWJE\bhWJȂǈꎮIɌĂяo悤ɂ܂B
     * 
     * @param argSourceFile
     *            \[Xt@CCX^XB
     * @param argSourceLines
     *            \[XsC[WB(java.lang.Stringi[܂)
     */
    public void transformImport(final BlancoCgSourceFile argSourceFile,
            final ArrayList argSourceLines) {
        // ŏimport\[gďs₷܂B
        sortImport(argSourceFile.getImportList());

        // dimport܂B
        trimRepeatedImport(argSourceFile.getImportList());

        // importKv̂ȂNX܂
        trimUnnecessaryImport(argSourceFile.getImportList());

        // NXpbP[Wɑ΂import}܂B
        trimMyselfImport(argSourceFile, argSourceFile.getImportList());

        // AJ[܂B
        fFindReplaceImport = findAnchorString(argSourceLines);
        if (fFindReplaceImport < 0) {
            throw new IllegalArgumentException("import̒u𔭌邱Ƃł܂łB");
        }

        for (int indexPreferredPackage = 0; indexPreferredPackage < PREFERRED_PACKAGE.length; indexPreferredPackage++) {
            // DpbP[WŏɓWJ܂B
            expandImportWithTarget(argSourceFile,
                    PREFERRED_PACKAGE[indexPreferredPackage], argSourceLines);
        }

        // ŌɗDpbP[WȊO (ujava.vujavax.vȂǈȊO)̃pbP[WWJ܂B
        expandImportWithTarget(argSourceFile, null, argSourceLines);

        // AJ[܂B
        removeAnchorString(argSourceLines);
    }

    /**
     * WJΏۂƂȂ^[QbgӎăC|[gWJ܂B
     * 
     * @param argSourceFile
     * @param argTarget
     *            java. ܂ javax. ܂ nullw肵܂B
     * @param argSourceLines
     *            \[XR[hsXgB
     */
    private void expandImportWithTarget(final BlancoCgSourceFile argSourceFile,
            final String argTarget, final ArrayList argSourceLines) {
        boolean isProcessed = false;
        for (int index = 0; index < argSourceFile.getImportList().size(); index++) {
            final Object objImport = argSourceFile.getImportList().get(index);
            if (objImport instanceof String == false) {
                throw new IllegalArgumentException("import̃Xg̒lłA["
                        + objImport + "]ł java.lang.StringȊǑ^["
                        + objImport.getClass().getName() + "]ɂȂĂ܂B");
            }

            final String strImport = (String) objImport;

            if (argTarget == null) {
                // DpbP[WȊO (java. javax. ȊO) WJ܂B
                if (isPreferredPackage(strImport)) {
                    // ΏۂƂpbP[WȊOł̂ŁAXLbv܂B
                    // java.  javax. ̓n[hR[hĂ_ɒӂĂB
                    continue;
                }
            } else {
                if (strImport.startsWith(argTarget) == false) {
                    // ΏۂƂpbP[WȊOł̂ŁAXLbv܂B
                    continue;
                }
            }

            isProcessed = true;
            argSourceLines.add(fFindReplaceImport++, "/* import " + strImport
                    + "; */");
        }

        if (isProcessed) {
            // importWJ݂ꍇɂ̂݋󔒂t^܂B
            argSourceLines.add(fFindReplaceImport++, "");
        }
    }

    /**
     * uAJ[̍s(0IW)܂B
     * 
     * @return AJ[̈ʒu(0IW)BłȂꍇɂ-1B
     * @param argSourceLines
     *            \[XXgB
     */
    private static final int findAnchorString(final ArrayList argSourceLines) {
        for (int index = 0; index < argSourceLines.size(); index++) {
            final String line = (String) argSourceLines.get(index);
            if (line.equals(REPLACE_IMPORT_HERE)) {
                // ܂B
                return index;
            }
        }

        // ł܂łBłȂƂ -1 ߂܂B
        return -1;
    }

    /**
     * AJ[}܂B
     * 
     * ̌㔼ŃC|[gҐȂ܂A̍ۂɎQƂAJ[ǉĂ܂B<br>
     * ̃\bh͑̃NXĂяo܂B
     * 
     * @param argSourceLines
     *            \[XXgB
     */
    public static final void insertAnchorString(final ArrayList argSourceLines) {
        argSourceLines.add(BlancoCgImportJsSourceExpander.REPLACE_IMPORT_HERE);
    }

    /**
     * AJ[܂B
     * 
     * @param argSourceLines
     *            \[XXgB
     */
    private static final void removeAnchorString(final ArrayList argSourceLines) {
        // ŌɃAJ[񂻂̂̂B
        int findReplaceImport2 = findAnchorString(argSourceLines);
        if (findReplaceImport2 < 0) {
            throw new IllegalArgumentException("import̒u𔭌邱Ƃł܂łB");
        }
        argSourceLines.remove(findReplaceImport2);
    }

    /**
     * ^ꂽimport\[g܂B
     * 
     * z肳m[ȟ^(java.lang.String)ȊO^ƁAO܂B
     * 
     * @param argImport
     *            C|[gXgB
     */
    private static final void sortImport(final ArrayList argImport) {
        Collections.sort(argImport, new Comparator() {
            public int compare(final Object arg0, final Object arg1) {
                if (arg0 instanceof String == false) {
                    throw new IllegalArgumentException("import̃Xg̒lłA["
                            + arg0 + "]ł java.lang.StringȊǑ^["
                            + arg0.getClass().getName() + "]ɂȂĂ܂B");
                }
                if (arg1 instanceof String == false) {
                    throw new IllegalArgumentException("import̃Xg̒lłA["
                            + arg1 + "]ł java.lang.StringȊǑ^["
                            + arg1.getClass().getName() + "]ɂȂĂ܂B");
                }
                final String str0 = (String) arg0;
                final String str1 = (String) arg1;
                return str0.compareTo(str1);
            }
        });
    }

    /**
     * dsvimport܂B
     * 
     * ̃\bh́A^ꂽArrayListɃ\[gς݂ł邱ƂOƂ܂B
     * 
     * @param argImport
     *            C|[gXgB
     */
    private void trimRepeatedImport(final ArrayList argImport) {
        // dimportB
        String pastImport = "";
        for (int index = argImport.size() - 1; index >= 0; index--) {
            final String strImport = (String) argImport.get(index);
            if (pastImport.equals(strImport)) {
                // ɏĂdimportłBsvȂ̂ł܂B
                argImport.remove(index);
            }
            // importOimportƂċL܂B
            pastImport = strImport;
        }
    }

    /**
     * importKv̂ȂNX܂B
     * 
     * ̓Iɂ java.lang  v~eBu^svƔfΏۂłB
     * 
     * @param argImport
     *            C|[gXgB
     */
    private void trimUnnecessaryImport(final ArrayList argImport) {
        // ܂̓v~eBu^܂B
        for (int index = argImport.size() - 1; index >= 0; index--) {
            // \[g_Ō^`FbN͎{ς݂łB
            final String strImport = (String) argImport.get(index);

            if (isLanguageReservedKeyword(strImport)) {
                argImport.remove(index);
            }
        }
    }

    /**
     * ^ꂽ񂪗DpbP[Wł邩ǂ`FbN܂B
     * 
     * @param argCheck
     *            `FbNB
     * @return DpbP[WɊYǂB
     */
    private boolean isPreferredPackage(final String argCheck) {
        for (int index = 0; index < PREFERRED_PACKAGE.length; index++) {
            if (argCheck.startsWith(PREFERRED_PACKAGE[index])) {
                // ͗̕DpbP[WɊY܂B
                return true;
            }
        }

        // L[[hɃqbg܂łB̓̕vO~O̗\ł͂܂B
        return false;
    }

    /**
     * ^ꂽ񂪃vO~O̗\ł邩ǂ`FbN܂B
     * 
     * @param argCheck
     *            `FbNB
     * @return vO~O̗\ɊYǂB
     * @see http://java.sun.com/docs/books/jls/second_edition/html/typesValues.doc.html#85587
     */
    private boolean isLanguageReservedKeyword(final String argCheck) {
        for (int index = 0; index < LANGUAGE_RESERVED_KEYWORD.length; index++) {
            if (LANGUAGE_RESERVED_KEYWORD[index].equals(argCheck)) {
                // ̓̕vO~O̗\łB
                return true;
            }
        }

        // L[[hɃqbg܂łB̓̕vO~O̗\ł͂܂B
        return false;
    }

    /**
     * gpbP[Wimport܂B
     * 
     * @param argSourceFile
     *            \[Xt@CCX^XB
     * @param argImport
     *            C|[gXgB
     */
    private void trimMyselfImport(final BlancoCgSourceFile argSourceFile,
            final ArrayList argImport) {
        trimSpecificPackage(argSourceFile.getPackage(), argImport);
    }

    /**
     * ̃pbP[WɂāAXg珜܂B
     * 
     * java.lang̏юNXpbP[W̏ɗp܂B
     * 
     * @param argSpecificPackage
     *            ΏۂƂpbP[WB
     * @param argImport
     *            C|[g̃XgB
     */
    private static void trimSpecificPackage(final String argSpecificPackage,
            final ArrayList argImport) {
        for (int index = argImport.size() - 1; index >= 0; index--) {
            // \[g_Ō^`FbN͎{ς݂łB
            final String strImport = (String) argImport.get(index);

            if (strImport.indexOf(".") < 0) {
                // pbP[W\Ȃ߁A폜₩͂܂B
                continue;
            }

            // importɂẮAblancoCgTypeɊւ鋤ʏ𗘗p邱Ƃ͂ł܂B
            // ʂɋLqs܂B
            final String strImportWithoutPackage = BlancoNameUtil
                    .trimJavaPackage(strImport);
            final String strPackage = strImport.substring(0, strImport.length()
                    - strImportWithoutPackage.length());

            if ((argSpecificPackage + ".").equals(strPackage)) {
                // java.lang.StringȂǂ͏܂B
                argImport.remove(index);
            }
        }
    }
}
