/*
 * blanco Framework
 * Copyright (C) 2004-2006 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.cg.transformer.js;

import java.util.ArrayList;

import blanco.cg.valueobject.BlancoCgField;
import blanco.cg.valueobject.BlancoCgLangDoc;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.commons.util.BlancoStringUtil;

/**
 * BlancoCgField\[XR[hւƓWJ܂B
 * 
 * ̃NXblancoCg̃o[IuWFNg\[XR[hgXtH[}[̌ʂ̓WJ@\łB
 * 
 * @author IGA Tosiki
 */
class BlancoCgFieldJsSourceExpander {
    /**
     * ŃtB[hWJ܂B
     * 
     * @param cgField
     *            ΏۂƂȂtB[hB
     * @param argSourceFile
     *            \[Xt@CB
     * @param argSourceLines
     *            o͐sXgB
     */
    public void transformField(final BlancoCgField cgField,
            final BlancoCgSourceFile argSourceFile,
            final ArrayList argSourceLines) {
        if (BlancoStringUtil.null2Blank(cgField.getName()).length() == 0) {
            throw new IllegalArgumentException("tB[h̖OɓK؂Ȓlݒ肳Ă܂B");
        }
        if (BlancoStringUtil.null2Blank(cgField.getType().getName()).length() == 0) {
            throw new IllegalArgumentException("tB[h[" + cgField.getName()
                    + "]̌^K؂Ȓlݒ肳Ă܂B");
        }

        // L킳st^܂B
        argSourceLines.add("");

        // ŏɃtB[hLangDocɓWJB
        if (cgField.getLangDoc() == null) {
            // LangDocw̏ꍇɂ͂瑤ŃCX^X𐶐B
            cgField.setLangDoc(new BlancoCgLangDoc());
        }
        if (cgField.getLangDoc().getTitle() == null) {
            cgField.getLangDoc().setTitle(cgField.getDescription());
        }

        //  LangDoc\[XR[h`ɓWJB
        new BlancoCgLangDocJsSourceExpander().transformLangDoc(cgField
                .getLangDoc(), argSourceLines);

        final StringBuffer buf = new StringBuffer();

        buf.append("this.");
        if (BlancoStringUtil.null2Blank(cgField.getAccess()).equals("private")
                || BlancoStringUtil.null2Blank(cgField.getAccess()).equals(
                        "protected")) {
            buf.append("_" + cgField.getAccess() + " = {");
            argSourceLines.add(buf.toString());

            argSourceLines.add(cgField.getName()
                    + " : "
                    + (cgField.getDefault() == null ? "null" : cgField
                            .getDefault()));
        } else {
            // tB[h̖{̕WJ܂B
            buf.append(cgField.getName());

            // ftHgl̎w肪ꍇɂ͂WJ܂B
            if (BlancoStringUtil.null2Blank(cgField.getDefault()).length() > 0) {
                buf.append(" = " + cgField.getDefault() + ";");
            } else {
                buf.append(" = null;");
            }

            argSourceLines.add(buf.toString());
        }

        // JavaScriptł static, final̓WJ͍s܂B
        // NXtB[h̓T|[g܂B̂static͖Ă܂B

        // importɌ^ǉB
        argSourceFile.getImportList().add(cgField.getType().getName());

        if (BlancoStringUtil.null2Blank(cgField.getAccess()).equals("private")
                || BlancoStringUtil.null2Blank(cgField.getAccess()).equals(
                        "protected")) {
            argSourceLines.add("};");
        }
    }
}
