/*
 * blancoDb
 * Copyright (C) 2004-2006 Yasuo Nakanishi
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.db.expander.query;

import java.util.List;

import blanco.cg.BlancoCgObjectFactory;
import blanco.cg.valueobject.BlancoCgClass;
import blanco.cg.valueobject.BlancoCgMethod;
import blanco.cg.valueobject.BlancoCgSourceFile;
import blanco.db.common.expander.BlancoDbAbstractMethod;
import blanco.db.common.valueobject.BlancoDbSetting;
import blanco.db.common.valueobject.BlancoDbSqlInfoStructure;

/**
 * ʂ̃\bhWJ邽߂̃NXB
 * 
 * @author Yasuo Nakanishi
 */
public class QueryConstructor extends BlancoDbAbstractMethod {
    public QueryConstructor(final BlancoDbSetting argDbSetting,
            final BlancoDbSqlInfoStructure argSqlInfo,
            final BlancoCgObjectFactory argCgFactory,
            final BlancoCgSourceFile argCgSourceFile,
            final BlancoCgClass argCgClass) {
        super(argDbSetting, argSqlInfo, argCgFactory, argCgSourceFile,
                argCgClass);
    }

    public void expand() {
        final BlancoCgMethod cgMethod = fCgFactory.createMethod(fCgClass
                .getName(), fCgClass.getName() + "NX̃RXgN^B");
        fCgClass.getMethodList().add(cgMethod);

        cgMethod.getParameterList().add(
                fCgFactory.createParameter("connection", "java.sql.Connection",
                        "f[^x[Xڑ"));

        cgMethod.getLangDoc().getDescriptionList().add(
                "f[^x[XRlNVIuWFNgƂăNGNX쐬܂B<br>");
        cgMethod.getLangDoc().getDescriptionList().add(
                "̃NX̗ṕAK close()\bhĂяoKv܂B<br>");

        cgMethod.setConstructor(true);

        final List listLine = cgMethod.getLineList();

        listLine.add("fConnection = connection;");
    }
}