package blanco.plugin.stringconverter.editors;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;

import javax.xml.transform.dom.DOMResult;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorInput;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

import blanco.commons.util.BlancoNameUtil;
import blanco.commons.util.BlancoXmlUtil;
import blanco.plugin.stringconverter.BlancoStringConverterPlugin;
import blanco.plugin.stringconverter.BlancoStringConverterPluginConstants;
import blanco.plugin.stringconverter.actions.BlancoStringConverterGenerateAction;
import blanco.stringconverter.BlancoStringConverterConstants;
import blanco.stringconverter.resourcebundle.BlancoStringConverterResourceBundle;

/**
 * GfB^ <br>
 * 
 * @author iga
 */
public class BlancoStringConverterEditor extends
        AbstractBlancoStringConverterEditor {
    private static final BlancoStringConverterResourceBundle fBundle = new BlancoStringConverterResourceBundle();

    private Composite top = null;

    // rWÄ
    private Label labelBlancoTitle = null;

    private Label labelBlancoSettingId = null;

    private Text textBlancoSettingId = null;

    private Label labelMetadir = null;

    private Combo comboMetadir = null;

    private Label labelMetadirComment = null;

    private Label labelSettingComment = null;

    private Button buttonExecuteJavaSource = null;

    private Button buttonExecuteCsSource = null;

    private Button buttonExecuteJsSource = null;

    private Button buttonExecuteVbSource = null;

    private Button buttonExecutePhpSource = null;

    private Button buttonCreateMetafile = null;

    public void createPartControl(Composite parent) {
        top = parent;
        top.setSize(new org.eclipse.swt.graphics.Point(1000, 400));

        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        top.setLayout(layout);

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelBlancoTitle = new Label(top, SWT.NONE);
        labelBlancoTitle.setText(BlancoStringConverterConstants.PRODUCT_NAME
                + " ݒt@C GfB^ (" + BlancoStringConverterConstants.VERSION
                + ")");

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelBlancoSettingId = new Label(top, SWT.NONE);
        labelBlancoSettingId.setText("ݒID");
        textBlancoSettingId = new Text(top, SWT.BORDER);
        textBlancoSettingId
                .setText(BlancoStringConverterConstants.PRODUCT_NAME);
        textBlancoSettingId.setEditable(false);

        labelMetadir = new Label(top, SWT.NONE);
        labelMetadir.setText("^fBNg");
        createComboMetadir();

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelMetadirComment = new Label(top, SWT.NONE);
        labelMetadirComment.setText("^fBNg͒ʏύXɗp܂B");
        labelMetadirComment.setSize(new org.eclipse.swt.graphics.Point(500,
                30 + 20));

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        buttonCreateMetafile = new Button(top, SWT.NONE);
        buttonCreateMetafile
                .setText(fBundle.getMetafileDisplayname() + " VK쐬");
        buttonCreateMetafile
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        // ^t@C쐬̍ۂɂ́A̍ڂ̃`FbN͍s܂B
                        saveToTextEditor();

                        if (comboMetadir.getText().length() == 0) {
                            MessageDialog
                                    .openWarning(
                                            top.getShell(),
                                            fBundle.getMetafileDisplayname()
                                                    + " VK쐬",
                                            "^fBNgw肵ĂB\n"
                                                    + "^fBNg̈ʓIȐݒl 'meta"
                                                    + BlancoStringConverterConstants.TARGET_SUBDIRECTORY
                                                    + "' łB");
                            return;
                        }

                        final IFileEditorInput input = (IFileEditorInput) getEditorInput();

                        try {
                            if (BlancoStringConverterPluginUtil.findFolder(
                                    input.getFile(), getProgressMonitor(),
                                    comboMetadir.getText()).exists() == false) {
                                BlancoStringConverterPluginUtil.createFolder(
                                        input.getFile(), getProgressMonitor(),
                                        comboMetadir.getText());

                                MessageDialog.openInformation(top.getShell(),
                                        "^fBNg̍쐬", "^fBNg ["
                                                + comboMetadir.getText()
                                                + "] VKɍ쐬܂B\n"
                                                + "ɂ̂ݕKvȓłB");
                            }
                        } catch (CoreException e3) {
                            MessageDialog.openWarning(top.getShell(), fBundle
                                    .getMetafileDisplayname()
                                    + " VK쐬", "^fBNg쐬Ɏs܂Bf܂B:"
                                    + e3.toString());
                            e3.printStackTrace();
                            return;
                        }

                        InputStream inStream = null;
                        try {
                            final URL localURL = BlancoStringConverterPlugin
                                    .getPluginRoot();

                            InputDialog inputDialog = new InputDialog(top
                                    .getShell(), fBundle
                                    .getMetafileDisplayname()
                                    + " VK쐬", fBundle.getMetafileDisplayname()
                                    + "^fBNg[" + comboMetadir.getText()
                                    + "]ɍ쐬܂B"
                                    + fBundle.getMetafileDisplayname()
                                    + "̐VKt@C͂ĂB",
                                    BlancoStringConverterConstants.PRODUCT_NAME
                                            + "Meta.xls",
                                    new IInputValidator() {
                                        public String isValid(String newText) {
                                            if (newText.endsWith(".xls") == false) {
                                                return "t@C .xlsŏI悤Ɏw肵ĂB";
                                            }
                                            if (BlancoNameUtil
                                                    .isValidFileName(newText) == false) {
                                                return "t@Cɂ "
                                                        + BlancoNameUtil
                                                                .invalidFileNameChar()
                                                        + " ͗pȂłB";
                                            }
                                            // ɂ̃t@C݂Ȃǂ`FbN
                                            IFile newFileMeta = input.getFile()
                                                    .getProject().getFolder(
                                                            comboMetadir
                                                                    .getText())
                                                    .getFile(newText);
                                            if (newFileMeta.exists()) {
                                                return "w̃t@C͊ɑ݂Ă܂B"
                                                        + "ʂ̃t@Cw肵ĂB";
                                            }
                                            return null;
                                        }
                                    });
                            if (inputDialog.open() == InputDialog.CANCEL) {
                                inputDialog.close();
                                return;
                            }
                            final String newMetaFilename = inputDialog
                                    .getValue();
                            inputDialog.close();

                            // vOC̃[Jev[gǂݍ݂܂B
                            inStream = new FileInputStream(
                                    localURL.getPath()
                                            + BlancoStringConverterPluginConstants.TEMPLATE_FILENAME_WITHOUT_EXT
                                            + ".xls");
                            IFile newFileMeta = input.getFile().getProject()
                                    .getFolder(comboMetadir.getText()).getFile(
                                            newMetaFilename);
                            newFileMeta.create(inStream, true,
                                    getProgressMonitor());
                            MessageDialog.openInformation(top.getShell(),
                                    fBundle.getMetafileDisplayname() + " VK쐬",
                                    fBundle.getMetafileDisplayname() + " ["
                                            + newMetaFilename + "] ^fBNg["
                                            + comboMetadir.getText()
                                            + "]ɐVK쐬܂B\n"
                                            + "̃t@CҏWāA֘Aݒ肵ĂB");
                        } catch (CoreException e1) {
                            e1.printStackTrace();
                            return;
                        } catch (IOException e2) {
                            MessageDialog.openWarning(top.getShell(), "^t@C",
                                    "^t@C̃Rs[Ɏs܂B:" + e2.toString());
                            e2.printStackTrace();
                        } finally {
                            if (inStream != null) {
                                try {
                                    inStream.close();
                                } catch (IOException e1) {
                                    e1.printStackTrace();
                                }
                            }
                        }

                    }
                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        buttonExecuteJavaSource = new Button(top, SWT.NONE);
        buttonExecuteJavaSource.setText("Java\[XR[h");
        buttonExecuteJavaSource
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        if (checkInputField() == false) {
                            return;
                        }

                        try {
                            if (checkInputField() == false) {
                                return;
                            }

                            final IFileEditorInput input = (IFileEditorInput) getEditorInput();
                            if (input.getFile().getProject().getFolder(
                                    comboMetadir.getText()).exists() == false) {
                                MessageDialog.openWarning(top.getShell(),
                                        "Java\[XR[h", "^fBNg ("
                                                + comboMetadir.getText()
                                                + ") ݂܂B𒆒f܂B");
                                return;
                            }

                            showBusy(true);
                            // ēh~邽߂ɕKvłB
                            buttonExecuteJavaSource.setEnabled(false);

                            String metaDir = comboMetadir.getText();
                            if (metaDir.trim().length() == 0) {
                                metaDir = null;
                            }
                            BlancoStringConverterGenerateAction
                                    .processBlancoStringConverterSource(input
                                            .getFile(), top.getShell(),
                                            getProgressMonitor(), "java",
                                            metaDir);

                            // blancotH_𓯊
                            BlancoStringConverterPluginUtil.refreshFolder(input
                                    .getFile(), getProgressMonitor(), "blanco");

                            // tmptH_𓯊
                            BlancoStringConverterPluginUtil.refreshFolder(input
                                    .getFile(), getProgressMonitor(), "tmp");

                            // tH_𓯊
                            // ܂łیƂē܂B
                            BlancoStringConverterPluginUtil.refreshFolder(input
                                    .getFile(), getProgressMonitor(),
                                    comboMetadir.getText());
                        } catch (Exception ex) {
                            ex.printStackTrace();
                            StringWriter writer = new StringWriter();
                            ex.printStackTrace(new PrintWriter(writer));
                            writer.flush();
                            MessageDialog.openError(top.getShell(),
                                    "Java\[XR[h", "񕜕s\ȃG[.:"
                                            + ex.toString() + ": "
                                            + writer.toString());
                        } finally {
                            showBusy(false);
                            // ēh~邽߂ɕKvłB
                            buttonExecuteJavaSource.setEnabled(true);
                        }
                    }

                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        buttonExecuteCsSource = new Button(top, SWT.NONE);
        buttonExecuteCsSource.setText("C#.NET\[XR[h");
        buttonExecuteCsSource
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        if (checkInputField() == false) {
                            return;
                        }

                        try {
                            if (checkInputField() == false) {
                                return;
                            }

                            final IFileEditorInput input = (IFileEditorInput) getEditorInput();
                            if (input.getFile().getProject().getFolder(
                                    comboMetadir.getText()).exists() == false) {
                                MessageDialog.openWarning(top.getShell(),
                                        "C#.NET\[XR[h", "^fBNg ("
                                                + comboMetadir.getText()
                                                + ") ݂܂B𒆒f܂B");
                                return;
                            }

                            showBusy(true);
                            // ēh~邽߂ɕKvłB
                            buttonExecuteCsSource.setEnabled(false);

                            String metaDir = comboMetadir.getText();
                            if (metaDir.trim().length() == 0) {
                                metaDir = null;
                            }
                            BlancoStringConverterGenerateAction
                                    .processBlancoStringConverterSource(input
                                            .getFile(), top.getShell(),
                                            getProgressMonitor(), "cs", metaDir);

                            // blanco.cstH_𓯊
                            BlancoStringConverterPluginUtil.refreshFolder(input
                                    .getFile(), getProgressMonitor(),
                                    "blanco.cs");

                            // tmptH_𓯊
                            BlancoStringConverterPluginUtil.refreshFolder(input
                                    .getFile(), getProgressMonitor(), "tmp");

                            // tH_𓯊
                            // ܂łیƂē܂B
                            BlancoStringConverterPluginUtil.refreshFolder(input
                                    .getFile(), getProgressMonitor(),
                                    comboMetadir.getText());
                        } catch (Exception ex) {
                            ex.printStackTrace();
                            StringWriter writer = new StringWriter();
                            ex.printStackTrace(new PrintWriter(writer));
                            writer.flush();
                            MessageDialog.openError(top.getShell(),
                                    "C#.NET\[XR[h", "񕜕s\ȃG[.:"
                                            + ex.toString() + ": "
                                            + writer.toString());
                        } finally {
                            showBusy(false);
                            // ēh~邽߂ɕKvłB
                            buttonExecuteCsSource.setEnabled(true);
                        }
                    }

                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        buttonExecuteJsSource = new Button(top, SWT.NONE);
        buttonExecuteJsSource.setText("JavaScript\[XR[h");
        buttonExecuteJsSource
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        if (checkInputField() == false) {
                            return;
                        }

                        try {
                            if (checkInputField() == false) {
                                return;
                            }

                            final IFileEditorInput input = (IFileEditorInput) getEditorInput();
                            if (input.getFile().getProject().getFolder(
                                    comboMetadir.getText()).exists() == false) {
                                MessageDialog.openWarning(top.getShell(),
                                        "JavaScript\[XR[h", "^fBNg ("
                                                + comboMetadir.getText()
                                                + ") ݂܂B𒆒f܂B");
                                return;
                            }

                            showBusy(true);
                            // ēh~邽߂ɕKvłB
                            buttonExecuteJsSource.setEnabled(false);

                            String metaDir = comboMetadir.getText();
                            if (metaDir.trim().length() == 0) {
                                metaDir = null;
                            }
                            BlancoStringConverterGenerateAction
                                    .processBlancoStringConverterSource(input
                                            .getFile(), top.getShell(),
                                            getProgressMonitor(), "js", metaDir);

                            // blanco.jstH_𓯊
                            BlancoStringConverterPluginUtil.refreshFolder(input
                                    .getFile(), getProgressMonitor(),
                                    "blanco.js");

                            // tmptH_𓯊
                            BlancoStringConverterPluginUtil.refreshFolder(input
                                    .getFile(), getProgressMonitor(), "tmp");

                            // tH_𓯊
                            // ܂łیƂē܂B
                            BlancoStringConverterPluginUtil.refreshFolder(input
                                    .getFile(), getProgressMonitor(),
                                    comboMetadir.getText());
                        } catch (Exception ex) {
                            ex.printStackTrace();
                            StringWriter writer = new StringWriter();
                            ex.printStackTrace(new PrintWriter(writer));
                            writer.flush();
                            MessageDialog.openError(top.getShell(),
                                    "JavaScript\[XR[h", "񕜕s\ȃG[.:"
                                            + ex.toString() + ": "
                                            + writer.toString());
                        } finally {
                            showBusy(false);
                            // ēh~邽߂ɕKvłB
                            buttonExecuteJsSource.setEnabled(true);
                        }
                    }

                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        buttonExecuteVbSource = new Button(top, SWT.NONE);
        buttonExecuteVbSource.setText("VB.NET\[XR[h");
        buttonExecuteVbSource
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        if (checkInputField() == false) {
                            return;
                        }

                        try {
                            if (checkInputField() == false) {
                                return;
                            }

                            final IFileEditorInput input = (IFileEditorInput) getEditorInput();
                            if (input.getFile().getProject().getFolder(
                                    comboMetadir.getText()).exists() == false) {
                                MessageDialog.openWarning(top.getShell(),
                                        "VB.NET\[XR[h", "^fBNg ("
                                                + comboMetadir.getText()
                                                + ") ݂܂B𒆒f܂B");
                                return;
                            }

                            showBusy(true);
                            // ēh~邽߂ɕKvłB
                            buttonExecuteVbSource.setEnabled(false);

                            String metaDir = comboMetadir.getText();
                            if (metaDir.trim().length() == 0) {
                                metaDir = null;
                            }
                            BlancoStringConverterGenerateAction
                                    .processBlancoStringConverterSource(input
                                            .getFile(), top.getShell(),
                                            getProgressMonitor(), "vb", metaDir);

                            // blanco.vbtH_𓯊
                            BlancoStringConverterPluginUtil.refreshFolder(input
                                    .getFile(), getProgressMonitor(),
                                    "blanco.vb");

                            // tmptH_𓯊
                            BlancoStringConverterPluginUtil.refreshFolder(input
                                    .getFile(), getProgressMonitor(), "tmp");

                            // tH_𓯊
                            // ܂łیƂē܂B
                            BlancoStringConverterPluginUtil.refreshFolder(input
                                    .getFile(), getProgressMonitor(),
                                    comboMetadir.getText());
                        } catch (Exception ex) {
                            ex.printStackTrace();
                            StringWriter writer = new StringWriter();
                            ex.printStackTrace(new PrintWriter(writer));
                            writer.flush();
                            MessageDialog.openError(top.getShell(),
                                    "VB.NET\[XR[h", "񕜕s\ȃG[.:"
                                            + ex.toString() + ": "
                                            + writer.toString());
                        } finally {
                            showBusy(false);
                            // ēh~邽߂ɕKvłB
                            buttonExecuteVbSource.setEnabled(true);
                        }
                    }

                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        buttonExecutePhpSource = new Button(top, SWT.NONE);
        buttonExecutePhpSource.setText("PHP\[XR[h");
        buttonExecutePhpSource
                .addSelectionListener(new org.eclipse.swt.events.SelectionAdapter() {
                    public void widgetSelected(
                            org.eclipse.swt.events.SelectionEvent e) {
                        if (checkInputField() == false) {
                            return;
                        }

                        try {
                            if (checkInputField() == false) {
                                return;
                            }

                            final IFileEditorInput input = (IFileEditorInput) getEditorInput();
                            if (input.getFile().getProject().getFolder(
                                    comboMetadir.getText()).exists() == false) {
                                MessageDialog.openWarning(top.getShell(),
                                        "PHP\[XR[h", "^fBNg ("
                                                + comboMetadir.getText()
                                                + ") ݂܂B𒆒f܂B");
                                return;
                            }

                            showBusy(true);
                            // ēh~邽߂ɕKvłB
                            buttonExecutePhpSource.setEnabled(false);

                            String metaDir = comboMetadir.getText();
                            if (metaDir.trim().length() == 0) {
                                metaDir = null;
                            }
                            BlancoStringConverterGenerateAction
                                    .processBlancoStringConverterSource(input
                                            .getFile(), top.getShell(),
                                            getProgressMonitor(), "php",
                                            metaDir);

                            // blanco.phptH_𓯊
                            BlancoStringConverterPluginUtil.refreshFolder(input
                                    .getFile(), getProgressMonitor(),
                                    "blanco.php");

                            // tmptH_𓯊
                            BlancoStringConverterPluginUtil.refreshFolder(input
                                    .getFile(), getProgressMonitor(), "tmp");

                            // tH_𓯊
                            // ܂łیƂē܂B
                            BlancoStringConverterPluginUtil.refreshFolder(input
                                    .getFile(), getProgressMonitor(),
                                    comboMetadir.getText());
                        } catch (Exception ex) {
                            ex.printStackTrace();
                            StringWriter writer = new StringWriter();
                            ex.printStackTrace(new PrintWriter(writer));
                            writer.flush();
                            MessageDialog.openError(top.getShell(),
                                    "PHP\[XR[h", "񕜕s\ȃG[.:"
                                            + ex.toString() + ": "
                                            + writer.toString());
                        } finally {
                            showBusy(false);
                            // ēh~邽߂ɕKvłB
                            buttonExecutePhpSource.setEnabled(true);
                        }
                    }

                });

        // Xy[T[
        new Label(top, SWT.NONE).setText("");

        labelSettingComment = new Label(top, SWT.NONE);
        labelSettingComment.setText("eX̐ݒl "
                + BlancoStringConverterPluginConstants.TARGET_FILENAME
                + "t@CɕŊi[܂B");
        labelSettingComment
                .setSize(new org.eclipse.swt.graphics.Point(500, 20));

        loadFromTextEditor();

        setFocusLostHandler(comboMetadir);
    }

    /**
     * ͍ڂ̃`FbN{܂B <br>
     * G[_CAO͂̃\bhŕ\܂B
     * 
     * @return
     */
    private final boolean checkInputField() {
        boolean isError = false;
        if (comboMetadir.getText().length() == 0) {
            comboMetadir.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_YELLOW));
            isError = true;
        } else {
            comboMetadir.setBackground(top.getDisplay().getSystemColor(
                    SWT.COLOR_INFO_BACKGROUND));
        }

        if (isError) {
            MessageDialog.openWarning(top.getShell(), "K{ڂւ̓͂܂",
                    "K{ڂւ̓͂܂B\nnCCg\ĂK{ڂɒl͂Ă");
        }

        return !isError;
    }

    /**
     * This method initializes comboMetadir
     * 
     */
    private void createComboMetadir() {
        comboMetadir = new Combo(top, SWT.NONE);
        comboMetadir.add("meta"
                + BlancoStringConverterConstants.TARGET_SUBDIRECTORY);
        comboMetadir.select(0);
    }

    protected void loadFromTextEditorInternal(DOMResult argResult) {
        final Node nodeRoot = argResult.getNode();
        if (nodeRoot == null) {
            return;
        }
        final Element elementBlancoDb = BlancoXmlUtil.getElement(nodeRoot,
                "blanco/target/"
                        + BlancoStringConverterConstants.PRODUCT_NAME_LOWER);
        if (elementBlancoDb == null) {
            return;
        }

        final String metadir = elementBlancoDb.getAttribute("metadir");
        if (metadir != null) {
            comboMetadir.setText(metadir);
        }
    }

    /**
     * ۑs܂B
     */
    public Document saveToTextEditorInternal() {
        String metadir = null;
        if (comboMetadir.getText().trim().length() > 0) {
            metadir = comboMetadir.getText();
        }

        final Document document = BlancoXmlUtil.newDocument();
        final Element eleBlanco = document.createElement("blanco");
        document.appendChild(eleBlanco);

        final Element eleTarget = document.createElement("target");
        eleTarget.setAttribute("name", textBlancoSettingId.getText());
        eleBlanco.appendChild(eleTarget);

        final Element eleBlancoStringConverter = document
                .createElement(BlancoStringConverterConstants.PRODUCT_NAME_LOWER);
        eleTarget.appendChild(eleBlancoStringConverter);

        if (metadir != null) {
            eleBlancoStringConverter.setAttribute("metadir", metadir);
        }

        return document;
    }
}