/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.eclipseplugingen.expand;

import java.io.File;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoXmlUtil;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.IgType;
import blanco.ig.expander.IgValue;
import blanco.ig.expander.Type;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.method.IgConstructor;
import blanco.ig.expander.method.MethodExpander;

public class BlancoEclipsePluginGenExpandWizardPage {
    public static final void expand(final Element elementCommon,
            final NodeList listList, final File directoryTarget) {
        final String pluginName = BlancoXmlUtil.getTextContent(elementCommon,
                "name");
        final String displayName = BlancoXmlUtil.getTextContent(elementCommon,
                "displayName");

        final String packageName = BlancoXmlUtil.getTextContent(elementCommon,
                "packageName");
        final String description = BlancoXmlUtil.getTextContent(elementCommon,
                "description");

        final String className = "Abstract"
                + BlancoNameAdjuster.toClassName(pluginName) + "WizardPage";
        final ClassExpander classExpander = new ClassExpander(new Type(
                packageName + ".wizards", className)) {
            protected boolean isAbstract() {
                return true;
            }

            protected void expandClassStruct() {
                setSuperClass(new IgType("org.eclipse.jface.wizard.WizardPage"));

                addImport(new IgType("org.eclipse.swt.SWT"));
                addImport(new IgType("org.eclipse.swt.layout.GridLayout"));
                addImport(new IgType("org.eclipse.core.resources.IProject"));
                addImport(new IgType("org.eclipse.core.resources.IFile"));

                addImport(new IgType(packageName + "."
                        + BlancoNameAdjuster.toClassName(pluginName)
                        + "PluginConstants"));

                final FieldExpander field1 = new FieldExpander(new IgType(
                        "org.eclipse.swt.widgets.Label"), "labelMessage1");
                addField(field1);

                final FieldExpander field2 = new FieldExpander(new IgType(
                        "org.eclipse.swt.widgets.Label"), "labelMessage2");
                addField(field2);

                final FieldExpander fieldSelection = new FieldExpander(
                        new IgType("org.eclipse.jface.viewers.ISelection"),
                        "selection");
                addField(fieldSelection);

                addMethod(new IgConstructor(className) {
                    public void setupSignature() {
                        addArgument(new IgValue(new IgType(
                                "org.eclipse.jface.viewers.ISelection"),
                                "selection"));
                    }

                    public void implement() {
                        getData().addLine("super(\"wizardPage\");");
                        getData().addLine(
                                "setTitle(\"" + displayName
                                        + " vOC pxEBU[h\");");
                        getData().addLine("this.selection = selection;");
                    }
                });

                addMethod(new MethodExpander("createControl") {
                    public void setupSignature() {
                        addArgument(new IgValue(new IgType(
                                "org.eclipse.swt.widgets.Composite"), "parent"));
                    }

                    public void implement() {
                        getData().addLine(
                                "GridLayout gridLayout = new GridLayout();");
                        getData().addLine("gridLayout.numColumns = 1;");
                        getData().addLine("");
                        getData()
                                .addLine(
                                        "Composite container = new Composite(parent, SWT.NULL);");
                        getData().addLine("container.setLayout(gridLayout);");
                        getData().addLine("");
                        getData().addLine(
                                "new Label(container, SWT.NONE).setText(\""
                                        + displayName + " Wizardւ悤I\");");
                        getData().addLine(
                                "new Label(container, SWT.NONE).setText(\"̃EBU[h"
                                        + displayName
                                        + "vOCp\ɂȂ܂ł̎菇`܂B\");");
                        getData()
                                .addLine(
                                        "new Label(container, SWT.NONE).setText(\"\");");
                        getData()
                                .addLine(
                                        "new Label(container, SWT.NONE).setText(\"̃EBU[h̎傽ړÍAݒt@C(\" + "
                                                + BlancoNameAdjuster
                                                        .toClassName(pluginName)
                                                + "PluginConstants.TARGET_FILENAME + \")vWFNg̃[gtH_ɍ쐬邱ƂłB\");");
                        getData()
                                .addLine(
                                        "new Label(container, SWT.NONE).setText(\"ݒt@C(\" + "
                                                + BlancoNameAdjuster
                                                        .toClassName(pluginName)
                                                + "PluginConstants.TARGET_FILENAME + \")Ɋւ󋵂͉L̂悤ɂȂĂ܂B\");");
                        getData().addLine("");
                        getData()
                                .addLine(
                                        "labelMessage1 = new Label(container, SWT.NONE);");
                        getData()
                                .addLine(
                                        "labelMessage1.setText(\"  1.vWFNg̃[gtH_ \" + "
                                                + BlancoNameAdjuster
                                                        .toClassName(pluginName)
                                                + "PluginConstants.TARGET_FILENAME + \"t@CVKɍ쐬܂B\");");
                        getData()
                                .addLine(
                                        "labelMessage2 = new Label(container, SWT.NONE);");
                        getData()
                                .addLine(
                                        "labelMessage2.setText(\"  2.EBU[h(Finish)sƂɂVK\" + "
                                                + BlancoNameAdjuster
                                                        .toClassName(pluginName)
                                                + "PluginConstants.TARGET_FILENAME + \"t@C쐬ĕҏWsƂł܂B\");");
                        getData().addLine("");
                        getData().addLine("setControl(container);");
                        getData().addLine("");
                        getData().addLine(
                                "IProject proj = "
                                        + BlancoNameAdjuster
                                                .toClassName(pluginName)
                                        + "Wizard.getProject(selection);");
                        getData().addLine("if (proj == null) {");
                        getData().addLine(
                                "setErrorMessage(\"vWFNgIł\");");
                        getData().addLine("setPageComplete(false);");
                        getData()
                                .addLine(
                                        "labelMessage1.setText(\"  1.vWFNgIĂ܂B\");");
                        getData()
                                .addLine(
                                        "labelMessage2.setText(\"  2.vWFNg̒ɂ \" + "
                                                + BlancoNameAdjuster
                                                        .toClassName(pluginName)
                                                + "PluginConstants.TARGET_FILENAME + \"t@C͍쐬ł܂B\");");
                        getData().addLine("return;");
                        getData().addLine("}");
                        getData().addLine("");
                        getData().addLine("if (proj.isOpen() == false) {");
                        getData().addLine("setPageComplete(false);");
                        getData()
                                .addLine(
                                        "setErrorMessage(\"JĂvWFNgIĂAēxEBU[hsĂB\");");
                        getData()
                                .addLine(
                                        "labelMessage1.setText(\"  1.IꂽvWFNg͊JĂ܂B\");");
                        getData()
                                .addLine(
                                        "labelMessage2.setText(\"  2.vWFNg̒ɂ \" + "
                                                + BlancoNameAdjuster
                                                        .toClassName(pluginName)
                                                + "PluginConstants.TARGET_FILENAME + \"t@C͍쐬ł܂B\");");
                        getData().addLine("return;");
                        getData().addLine("}");
                        getData().addLine("");
                        getData().addLine(
                                "IFile file = proj.getFile("
                                        + BlancoNameAdjuster
                                                .toClassName(pluginName)
                                        + "PluginConstants.TARGET_FILENAME);");
                        getData().addLine("if (file.exists()) {");
                        getData()
                                .addLine(
                                        "labelMessage1.setText(\"  1.ɃvWFNg̃[g \" + "
                                                + BlancoNameAdjuster
                                                        .toClassName(pluginName)
                                                + "PluginConstants.TARGET_FILENAME + \"t@C݂Ă܂B\");");
                        getData()
                                .addLine(
                                        "labelMessage2.setText(\"  2.EBU[h(Finish)sƂɂ\" + "
                                                + BlancoNameAdjuster
                                                        .toClassName(pluginName)
                                                + "PluginConstants.TARGET_FILENAME + \"t@C̕ҏWsƂł܂B\");");
                        getData().addLine("}");
                    }
                });
            }
        };

        ClassExpander.generateJavaSource(classExpander, directoryTarget);
    }
}
