/*
 * blanco Framework
 * Copyright (C) 2004-2005 IGA Tosiki
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.eclipseplugingen.expand;

import java.io.File;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

import blanco.cg.BlancoCgObjectFactory;
import blanco.commons.util.BlancoJavaSourceUtil;
import blanco.commons.util.BlancoNameAdjuster;
import blanco.commons.util.BlancoXmlUtil;
import blanco.ig.expander.ClassExpander;
import blanco.ig.expander.IgType;
import blanco.ig.expander.IgValue;
import blanco.ig.expander.Scope;
import blanco.ig.expander.Type;
import blanco.ig.expander.field.FieldExpander;
import blanco.ig.expander.method.IgConstructor;
import blanco.ig.expander.method.MethodExpander;

public class BlancoEclipsePluginGenExpandWizard {
    public static final void expand(final Element elementCommon,
            final NodeList listList, final File directoryTarget) {
        final String pluginName = BlancoXmlUtil.getTextContent(elementCommon,
                "name");
        final String displayName = BlancoXmlUtil.getTextContent(elementCommon,
                "displayName");

        final String packageName = BlancoXmlUtil.getTextContent(elementCommon,
                "packageName");
        final String description = BlancoXmlUtil.getTextContent(elementCommon,
                "description");

        final ClassExpander classExpander = new ClassExpander(
                new Type(packageName + ".wizards", "Abstract"
                        + BlancoNameAdjuster.toClassName(pluginName) + "Wizard")) {
            protected boolean isAbstract() {
                return true;
            }

            protected void expandClassStruct() {
                addFileComment("EclipsevOC [" + pluginName + "]̃EBU[hNX");

                addImport(new IgType("java.io.ByteArrayInputStream"));
                addImport(new IgType("java.io.IOException"));

                addImport(new IgType("org.eclipse.ui.IWorkbenchPage"));
                addImport(new IgType("org.eclipse.core.runtime.CoreException"));
                addImport(new IgType("org.eclipse.ui.PlatformUI"));
                addImport(new IgType("org.eclipse.ui.ide.IDE"));
                addImport(new IgType("org.eclipse.ui.PartInitException"));
                addImport(new IgType(
                        "org.eclipse.core.resources.IProjectNature"));
                addImport(new IgType("org.eclipse.core.resources.IResource"));

                addImport(new IgType(packageName + "."
                        + BlancoNameAdjuster.toClassName(pluginName)
                        + "PluginConstants"));

                getJavaDoc().addLine(
                        "EclipsevOC [" + pluginName + "]̃EBU[hNXB");
                getJavaDoc().addLine("");
                if (description != null) {
                    getJavaDoc().addLine(
                            BlancoJavaSourceUtil
                                    .escapeStringAsJavaDoc(description)
                                    + "<br>");
                }

                setSuperClass(new Type("org.eclipse.jface.wizard.Wizard"));
                getCgClass().getImplementInterfaceList().add(
                        BlancoCgObjectFactory.getInstance().createType(
                                "org.eclipse.ui.INewWizard"));

                final FieldExpander fieldSelection = new FieldExpander(
                        new IgType("org.eclipse.jface.viewers.ISelection"),
                        "selection");
                addField(fieldSelection);

                addMethod(new IgConstructor("Abstract"
                        + BlancoNameAdjuster.toClassName(pluginName) + "Wizard") {
                    public void setupSignature() {
                    }

                    public void implement() {
                        getData().addLine("super();");
                        getData().addLine("setNeedsProgressMonitor(true);");
                        getData().addLine(
                                "setWindowTitle(\"" + displayName
                                        + " Wizard\");");
                    }
                });

                addMethod(new MethodExpander("init") {
                    public void setupSignature() {
                        addArgument(new IgValue(new IgType(
                                "org.eclipse.ui.IWorkbench"), "workbench"));
                        addArgument(new IgValue(
                                new IgType(
                                        "org.eclipse.jface.viewers.IStructuredSelection"),
                                "selection"));
                    }

                    public void implement() {
                        getData().addLine("this.selection = selection;");
                    }
                });

                addMethod(new MethodExpander("performFinish") {
                    public void setupSignature() {
                        setReturnType(new IgType("boolean"));
                    }

                    public void implement() {
                        getData().addLine("// {IɃ`FbN̓EBU[hŏIĂƉ肵܂B");
                        getData().addLine(
                                "IProject proj = getProject(selection);");
                        getData().addLine("if (proj == null) {");
                        getData().addLine("return false;");
                        getData().addLine("}");
                        getData().addLine("");
                        getData().addLine("//  t@CVK쐬܂B");
                        getData().addLine(
                                "IFile file = proj.getFile("
                                        + BlancoNameAdjuster
                                                .toClassName(pluginName)
                                        + "PluginConstants"
                                        + ".TARGET_FILENAME);");
                        getData().addLine("doFinish(file);");
                        getData().addLine("");
                        getData()
                                .addLine(
                                        "IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();");
                        getData().addLine("try {");
                        getData().addLine("// GfB^J܂B");
                        getData().addLine(
                                "IDE.openEditor(page, file, \"" + packageName
                                        + ".editors\");");
                        getData().addLine("} catch (PartInitException e) {");
                        getData().addLine("// O͖܂B");
                        getData().addLine("}");
                        getData().addLine("");
                        getData().addLine("return true;");
                    }
                });

                addMethod(new MethodExpander("addPages") {
                    public void setupSignature() {
                    }

                    public void implement() {
                        final String classNameBase = BlancoNameAdjuster
                                .toClassName(pluginName);
                        getData().addLine(
                                "final Abstract" + classNameBase
                                        + "WizardPage page = new "
                                        + classNameBase
                                        + "WizardPage(selection);");
                        getData().addLine("addPage(page);");

                        getData().addLine(
                                "final " + classNameBase
                                        + "WizardPage2 page2 = new "
                                        + classNameBase
                                        + "WizardPage2(selection);");
                        getData().addLine("addPage(page2);");

                        getData().addLine(
                                "final " + classNameBase
                                        + "WizardPage3 page3 = new "
                                        + classNameBase
                                        + "WizardPage3(selection);");
                        getData().addLine("addPage(page3);");

                        getData().addLine(
                                "final " + classNameBase
                                        + "WizardPage4 page4 = new "
                                        + classNameBase
                                        + "WizardPage4(selection);");
                        getData().addLine("addPage(page4);");

                        getData().addLine(
                                "final Abstract" + classNameBase
                                        + "WizardPage99 page99 = new "
                                        + classNameBase
                                        + "WizardPage99(selection);");
                        getData().addLine("addPage(page99);");
                    }
                });

                addMethod(new MethodExpander("getProject") {
                    protected boolean isStatic() {
                        return true;
                    }

                    public void setupSignature() {
                        getJavaDoc().addLine(
                                "ISelection IProject(vWFNg)擾܂B");
                        addArgument(new IgValue(new IgType(
                                "org.eclipse.jface.viewers.ISelection"),
                                "selection"));
                        setReturnType(new IgType(
                                "org.eclipse.core.resources.IProject"));
                    }

                    public void implement() {
                        getData().addLine("IProject proj = null;");
                        getData()
                                .addLine(
                                        "IStructuredSelection ssel = (IStructuredSelection) selection;");
                        getData().addLine("if (ssel.isEmpty()) {");
                        getData().addLine("return null;");
                        getData().addLine("}");
                        getData().addLine(
                                "Object obj = ssel.getFirstElement();");
                        getData().addLine(
                                "if (obj instanceof IProjectNature) {");
                        getData().addLine("// vWFNg̏ꍇɂ́AꂪĂ܂B");
                        getData()
                                .addLine(
                                        "IProjectNature nature = (IProjectNature) obj;");
                        getData().addLine("proj = nature.getProject();");
                        getData().addLine(
                                "} else if (obj instanceof IResource) {");
                        getData().addLine("IResource res = (IResource) obj;");
                        getData().addLine("proj = res.getProject();");
                        getData().addLine("} else {");
                        getData()
                                .addLine("System.out.println(obj.getClass());");
                        getData().addLine("return null;");
                        getData().addLine("}");
                        getData().addLine("return proj;");
                    }
                });

                addMethod(new MethodExpander("doFinish") {
                    protected Scope getScope() {
                        return Scope.PRIVATE;
                    }

                    public void setupSignature() {
                        addArgument(new IgValue(new IgType(
                                "org.eclipse.core.resources.IFile"), "file"));
                    }

                    public void implement() {
                        getData().addLine("try {");
                        getData().addLine(
                                "InputStream stream = openContentStream();");
                        getData().addLine("if (file.exists()) {");
                        getData().addLine("// Ȃɂ܂B");
                        getData().addLine("} else {");
                        getData().addLine("file.create(stream, false, null);");
                        getData().addLine("}");
                        getData().addLine("stream.close();");
                        getData().addLine("} catch (IOException e) {");
                        getData().addLine("} catch (CoreException e) {");
                        getData().addLine("e.printStackTrace();");
                        getData().addLine("}");
                    }
                });

                addMethod(new MethodExpander("openContentStream") {
                    protected Scope getScope() {
                        return Scope.PRIVATE;
                    }

                    public void setupSignature() {
                        setReturnType(new IgType("java.io.InputStream"));
                    }

                    public void implement() {
                        getData()
                                .addLine(
                                        "String contents = \""
                                                + BlancoJavaSourceUtil
                                                        .escapeStringAsJavaSource("<?xml version=\"1.0\" encoding=\"UTF-8\"?><blanco/>")
                                                + "\";");
                        getData()
                                .addLine(
                                        "return new ByteArrayInputStream(contents.getBytes());");
                    }
                });
            }
        };

        ClassExpander.generateJavaSource(classExpander, directoryTarget);
    }
}
